/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.matching;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.MsrcVulnerabilitiesByProductEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.MsrcAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcKbChainIndexQuery;
import com.metaeffekt.mirror.query.MsrcProductIndexQuery;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="MSRC Vulnerabilities by Products", phase=InventoryEnrichmentPhase.VULNERABILITY_MATCHING, intermediateFileSuffix="msrc-cve-from-product", mavenPropertyName="msVulnerabilitiesByProductEnrichment")
public class MsrcVulnerabilitiesByProductEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcVulnerabilitiesByProductEnrichment.class);
    private final LazySupplier<MsrcProductIndexQuery> msrcProductQuery;
    private final LazySupplier<MsrcAdvisorIndexQuery> msrcAdvisorQuery;
    private final LazySupplier<MsrcKbChainIndexQuery> msrcKbChainQuery;
    private MsrcVulnerabilitiesByProductEnrichmentConfiguration configuration = new MsrcVulnerabilitiesByProductEnrichmentConfiguration();

    public MsrcVulnerabilitiesByProductEnrichment(File baseMirrorDirectory) {
        this.msrcProductQuery = new LazySupplier<MsrcProductIndexQuery>(() -> new MsrcProductIndexQuery(baseMirrorDirectory));
        this.msrcAdvisorQuery = new LazySupplier<MsrcAdvisorIndexQuery>(() -> new MsrcAdvisorIndexQuery(baseMirrorDirectory));
        this.msrcKbChainQuery = new LazySupplier<MsrcKbChainIndexQuery>(() -> new MsrcKbChainIndexQuery(baseMirrorDirectory));
    }

    public void setConfiguration(MsrcVulnerabilitiesByProductEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public MsrcVulnerabilitiesByProductEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        MsrcAdvisorIndexQuery msrcAdvisorQuery = (MsrcAdvisorIndexQuery)this.msrcAdvisorQuery.get();
        MsrcKbChainIndexQuery msrcKbChainQuery = (MsrcKbChainIndexQuery)this.msrcKbChainQuery.get();
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        for (Artifact artifact : inventory.getArtifacts()) {
            String artifactMsProductIdOrName = artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey());
            if (artifactMsProductIdOrName == null) continue;
            List productList = Arrays.stream(artifactMsProductIdOrName.split(", ")).map(String::trim).collect(Collectors.toList());
            if (productList.size() >= 2) {
                LOG.warn("Multiple products found for artifact [{}], usually an artifact is only affected by a single product. Products: [{}]", (Object)artifact.getId(), (Object)artifactMsProductIdOrName);
            }
            for (String msProductIdOrName : productList) {
                MsrcProduct msrcProduct = this.findProductFromIdOrName(msProductIdOrName);
                if (msrcProduct == null) {
                    LOG.error("Skipping over MS Product ID [{}] from Artifact [{}] as it cannot be found in local index, make sure that the ID is correct", (Object)msProductIdOrName, (Object)artifact.getId());
                    continue;
                }
                Set<String> appliedMsKbIdentifiers = this.extractKbIdentifiers(artifact);
                List msVulnerabilitiesOnProductFromAdvisors = msrcAdvisorQuery.findByProduct(msrcProduct).stream().map(AmbDataClass::getId).map(id -> id.replace("MSRC-", "")).collect(Collectors.toList());
                List<String> msVulnerabilitiesOnProductFromKbChains = msrcKbChainQuery.findVulnerabilitiesByProductId(msrcProduct.getId());
                HashSet<String> allPotentialVulnerabilities = new HashSet<String>();
                allPotentialVulnerabilities.addAll(msVulnerabilitiesOnProductFromAdvisors);
                allPotentialVulnerabilities.addAll(msVulnerabilitiesOnProductFromKbChains);
                msrcKbChainQuery.collectSupersedingKbIdentifiers(allPotentialVulnerabilities, msProductIdOrName, appliedMsKbIdentifiers);
                HashSet<String> msVulnerabilitiesNotFixed = new HashSet<String>();
                HashSet<String> msAdvisoriesNotFixed = new HashSet<String>();
                HashSet<String> msVulnerabilitiesAndAdvisoriesFixed = new HashSet<String>();
                for (String vulnerabilityId : allPotentialVulnerabilities) {
                    boolean isFixed = msrcKbChainQuery.isVulnerabilityFixed(vulnerabilityId, msrcProduct.getId(), appliedMsKbIdentifiers);
                    if (isFixed) {
                        msVulnerabilitiesAndAdvisoriesFixed.add(vulnerabilityId);
                        continue;
                    }
                    if (vulnerabilityId.startsWith("ADV")) {
                        msAdvisoriesNotFixed.add(vulnerabilityId);
                        continue;
                    }
                    msVulnerabilitiesNotFixed.add(vulnerabilityId);
                }
                DataSourceIndicator msrcProductDataSourceIndicator = DataSourceIndicator.msrcProduct(artifact, msrcProduct, appliedMsKbIdentifiers);
                for (String v : msVulnerabilitiesNotFixed) {
                    vInventory.findOrCreateVulnerabilityByName(v).addMatchingSource(msrcProductDataSourceIndicator);
                }
                for (String v : msAdvisoriesNotFixed) {
                    vInventory.findOrCreateAdvisoryEntryByName(v, MsrcAdvisorEntry::new).addMatchingSource(msrcProductDataSourceIndicator);
                }
                for (String v : msVulnerabilitiesAndAdvisoriesFixed) {
                    vInventory.findOrCreateWithoutAddingVulnerabilityByName(v).manuallyAffectsArtifact(InventoryAttribute.VULNERABILITIES_FIXED_BY_KB, artifact);
                }
                artifact.set(InventoryAttribute.MS_SUPERSEDED_KB_IDENTIFIER.getKey(), String.join((CharSequence)", ", appliedMsKbIdentifiers));
                LOG.info("Artifact [{}] with product [{}] ([{}]) and [{}] KB has [{} vulnerabilities] [{} advisories] [{} fixed by KB] from [{} & {} -> {}] vulnerabilities/advisories", new Object[]{artifact.getId(), msProductIdOrName, msrcProduct.getId(), appliedMsKbIdentifiers.size(), msVulnerabilitiesNotFixed.size(), msAdvisoriesNotFixed.size(), msVulnerabilitiesAndAdvisoriesFixed.size(), msVulnerabilitiesOnProductFromAdvisors.size(), msVulnerabilitiesOnProductFromKbChains.size(), allPotentialVulnerabilities.size()});
            }
        }
        vInventory.writeBack();
    }

    private Set<String> extractKbIdentifiers(Artifact artifact) {
        if (StringUtils.hasText(artifact.get(InventoryAttribute.MS_KB_IDENTIFIER.getKey()))) {
            return Arrays.stream(artifact.get(InventoryAttribute.MS_KB_IDENTIFIER.getKey()).split(", ")).map(e -> e.replace("KB", "")).filter(StringUtils::hasText).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private MsrcProduct findProductFromIdOrName(String idOrName) {
        if (StringUtils.isEmpty(idOrName)) {
            return null;
        }
        MsrcProductIndexQuery msrcProductQuery = (MsrcProductIndexQuery)this.msrcProductQuery.get();
        MsrcProduct msrcProduct = msrcProductQuery.findProductById(idOrName);
        if (msrcProduct == null) {
            return msrcProductQuery.findProductByName(idOrName);
        }
        return msrcProduct;
    }
}

