/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other;

import com.metaeffekt.artifact.analysis.vulnerability.correlation.ArtifactCorrelationUtil;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.ArtifactCorrelationEnrichmentConfiguration;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Artifact Correlation YAML", phase=InventoryEnrichmentPhase.PRODUCT_IDENTIFICATION, intermediateFileSuffix="correlation", mavenPropertyName="correlationYamlEnrichment")
public class ArtifactCorrelationEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactCorrelationEnrichment.class);
    private ArtifactCorrelationEnrichmentConfiguration configuration = new ArtifactCorrelationEnrichmentConfiguration();

    public void setConfiguration(ArtifactCorrelationEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ArtifactCorrelationEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @DocRelevantMethods(value={"ArtifactCorrelationUtil#addYamlToInventory(Inventory, List)"})
    protected void performEnrichment(Inventory inventory) {
        LOG.info("Performing enrichment using [{}] yaml file{} or director{}", new Object[]{this.configuration.getYamlFiles().size(), this.configuration.getYamlFiles().size() == 1 ? "" : "s", this.configuration.getYamlFiles().size() == 1 ? "y" : "ies"});
        for (File file : this.configuration.getYamlFiles()) {
            ArtifactCorrelationUtil.addYamlToInventory(inventory, file, super.getSecurityPolicyConfiguration().getJsonSchemaValidationErrorsHandling());
        }
    }
}

