/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other;

import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.EpssConfiguration;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.epss.EpssData;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.EpssIndexQuery;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="EPSS Enrichment", phase=InventoryEnrichmentPhase.VULNERABILITY_PRIORITIZATION, intermediateFileSuffix="epss", mavenPropertyName="epssEnrichment")
public class EpssEnrichment
extends InventoryEnricher {
    private static final Logger log = LoggerFactory.getLogger(EpssEnrichment.class);
    private final EpssIndexQuery epssIndexQuery;
    private EpssConfiguration configuration = new EpssConfiguration();

    public EpssEnrichment(File baseMirrorDirectory) {
        this.epssIndexQuery = new EpssIndexQuery(baseMirrorDirectory);
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        log.info("Enriching inventory with EPSS data for [{}] vulnerabilities.", (Object)vInventory.getVulnerabilities().size());
        AtomicInteger amountEpss = new AtomicInteger(0);
        for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
            Optional<EpssData> epssData = this.epssIndexQuery.getEpssData(vulnerability);
            if (!epssData.isPresent()) {
                log.info("No EPSS data found for vulnerability: {}", (Object)vulnerability.getId());
                continue;
            }
            vulnerability.setEpssData(epssData.get());
            amountEpss.incrementAndGet();
        }
        log.info("[{}] vulnerabilities enriched with EPSS data.", (Object)amountEpss.get());
        vInventory.writeBack();
    }

    @Override
    public ProcessConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EpssConfiguration configuration) {
        this.configuration = configuration;
    }
}

