/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other;

import com.metaeffekt.artifact.analysis.utils.JFreeChartUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.enrichment.other.vad.VulnerabilityAssessmentDashboard;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import de.yanwittmann.j2chartjs.chart.Chart;
import de.yanwittmann.j2chartjs.chart.DoughnutChart;
import de.yanwittmann.j2chartjs.data.ChartData;
import de.yanwittmann.j2chartjs.data.DoughnutPieChartData;
import de.yanwittmann.j2chartjs.dataset.ChartDataset;
import de.yanwittmann.j2chartjs.dataset.DoughnutPieChartDataset;
import de.yanwittmann.j2chartjs.options.ChartOptions;
import de.yanwittmann.j2chartjs.options.plugins.legend.LegendOption;
import de.yanwittmann.j2chartjs.options.plugins.title.TitleOption;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.CanvasTag;
import j2html.tags.specialized.SpanTag;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.report.StatisticsOverviewTable;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityOverviewChartGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityOverviewChartGenerator.class);
    private final CentralSecurityPolicyConfiguration securityPolicy;
    private final VulnerabilityContextInventory vInventory;
    private final List<Vulnerability> effectiveVulnerabilities;
    private final Map<Artifact, List<Vulnerability>> vulnerabilitiesPerArtifact;
    public static final Map<String, Color> STATUS_CATEGORY_COLOR_MAPPING = new HashMap<String, Color>(){
        {
            this.put("in review", ColorScheme.PASTEL_BLUE.getColor());
            this.put("reviewed", ColorScheme.STRONG_DARK_BLUE.getColor());
            this.put("applicable", ColorScheme.STRONG_DARK_BLUE.getColor());
            this.put("not applicable", ColorScheme.STRONG_LIGHT_GREEN.getColor());
            this.put("insignificant", ColorScheme.PASTEL_GRAY.getColor());
            this.put("void", ColorScheme.PASTEL_WHITE.getColor());
            this.put("ineffective", ColorScheme.STRONG_GRAY.getColor());
            this.put("affected", ColorScheme.STRONG_DARK_BLUE.getColor());
            this.put("potentially affected", ColorScheme.PASTEL_BLUE.getColor());
            this.put("potentially vulnerability", ColorScheme.PASTEL_BLUE.getColor());
            this.put("not affected", ColorScheme.PASTEL_GRAY.getColor());
        }
    };

    public VulnerabilityOverviewChartGenerator(VulnerabilityContextInventory vInventory, CentralSecurityPolicyConfiguration securityPolicy, boolean applyEffectiveCalculations) {
        this.securityPolicy = securityPolicy;
        this.vInventory = vInventory;
        if (applyEffectiveCalculations) {
            LOG.info("Baking effective CVSS vectors");
            vInventory.calculateEffectiveCvssVectorsForVulnerabilities(securityPolicy);
            LOG.info("Applying effective vulnerability status");
            vInventory.applyEffectiveVulnerabilityStatus(securityPolicy);
        }
        LOG.info("Using calculated values for potential vulnerability filtering");
        this.effectiveVulnerabilities = VulnerabilityAssessmentDashboard.getEffectiveVulnerabilitiesAll(vInventory, securityPolicy);
        LOG.info("Mapping artifacts to matched vulnerabilities");
        this.vulnerabilitiesPerArtifact = Vulnerability.groupVulnerabilitiesByArtifact(this.effectiveVulnerabilities);
    }

    public VulnerabilityOverviewChartGenerator(VulnerabilityContextInventory vInventory, CentralSecurityPolicyConfiguration securityPolicy, List<Vulnerability> effectiveVulnerabilities, Map<Artifact, List<Vulnerability>> vulnerabilitiesPerArtifact) {
        this.securityPolicy = securityPolicy;
        this.vInventory = vInventory;
        this.effectiveVulnerabilities = effectiveVulnerabilities;
        this.vulnerabilitiesPerArtifact = vulnerabilitiesPerArtifact;
    }

    public List<VulnerabilityAssessmentDashboard.GeneratedChart> generateOverviewCharts() {
        ArrayList<VulnerabilityAssessmentDashboard.GeneratedChart> generatedCharts = new ArrayList<VulnerabilityAssessmentDashboard.GeneratedChart>();
        HashMap<Vulnerability, CvssSeverityRanges.SeverityRange> initialSeverityCategories = new HashMap<Vulnerability, CvssSeverityRanges.SeverityRange>();
        HashMap<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories = new HashMap<Vulnerability, CvssSeverityRanges.SeverityRange>();
        HashMap<Vulnerability, String> statusPerVulnerability = new HashMap<Vulnerability, String>();
        for (Vulnerability vulnerability : this.effectiveVulnerabilities) {
            VulnerabilityStatusHistoryEntry latestStatusHistoryEntry = vulnerability.getOrCreateNewVulnerabilityStatus().getLatestActiveStatusHistoryEntry();
            String baseStatus = latestStatusHistoryEntry != null ? latestStatusHistoryEntry.getStatus() : null;
            String mappedStatus = (String)CentralSecurityPolicyConfiguration.VULNERABILITY_STATUS_DISPLAY_MAPPER_UNMODIFIED.getMapper().apply(baseStatus);
            statusPerVulnerability.put(vulnerability, mappedStatus);
            initialSeverityCategories.put(vulnerability, this.securityPolicy.getCvssSeverityRanges().getRange(this.getOverallScore(vulnerability.getCvssSelectionResult().getSelectedInitialCvss(), 0.0)));
            if ("not applicable".equals(baseStatus) || "void".equals(baseStatus)) {
                contextSeverityCategories.put(vulnerability, this.securityPolicy.getCvssSeverityRanges().getRange(0.0));
                continue;
            }
            contextSeverityCategories.put(vulnerability, this.securityPolicy.getCvssSeverityRanges().getRange(this.getOverallScore(vulnerability.getCvssSelectionResult().getSelectedContextIfAvailableOtherwiseInitial(), 0.0)));
        }
        List<Vulnerability> vulnerabilitiesPotentiallyAffected = this.filterVulnerabilitiesForStatus(statusPerVulnerability, "in review");
        List<Vulnerability> vulnerabilitiesReviewed = this.filterVulnerabilitiesForStatus(statusPerVulnerability, "reviewed");
        Map<String, List<Vulnerability>> vulnerabilitiesByComponent = this.groupVulnerabilitiesByComponent(this.vulnerabilitiesPerArtifact);
        generatedCharts.add(this.generateOverviewChartCvssSeverityInitial(initialSeverityCategories));
        generatedCharts.add(this.generateOverviewChartVulnerabilityAssessmentStatus(statusPerVulnerability));
        generatedCharts.add(this.generateOverviewChartCvssSeverityContext(contextSeverityCategories));
        generatedCharts.add(this.generateOverviewChartCvssSeverityContextByStatusInReview(contextSeverityCategories, vulnerabilitiesPotentiallyAffected));
        generatedCharts.add(this.generateOverviewChartCvssSeverityContextByStatusApplicable(contextSeverityCategories, vulnerabilitiesReviewed));
        generatedCharts.add(this.generateOverviewChartCvssSeverityContextByComponent(contextSeverityCategories, vulnerabilitiesByComponent));
        return generatedCharts;
    }

    private Map<String, List<Vulnerability>> groupVulnerabilitiesByComponent(Map<Artifact, List<Vulnerability>> vulnerabilitiesPerArtifact) {
        HashMap<String, List<Vulnerability>> vulnerabilitiesByComponent = new HashMap<String, List<Vulnerability>>();
        for (Map.Entry<Artifact, List<Vulnerability>> entry : vulnerabilitiesPerArtifact.entrySet()) {
            Artifact artifact = entry.getKey();
            List<Vulnerability> vulnerabilities = entry.getValue();
            String component = artifact.getComponent();
            String effectiveComponent = StringUtils.hasText(component) ? component : (StringUtils.hasText(artifact.getId()) ? artifact.getId() : UUID.randomUUID().toString());
            vulnerabilitiesByComponent.computeIfAbsent(effectiveComponent, c -> new ArrayList()).addAll(vulnerabilities);
        }
        return vulnerabilitiesByComponent;
    }

    private List<Vulnerability> filterVulnerabilitiesForStatus(Map<Vulnerability, String> statusPerVulnerability, String status) {
        ArrayList<Vulnerability> filteredVulnerabilities = new ArrayList<Vulnerability>();
        for (Map.Entry<Vulnerability, String> entry : statusPerVulnerability.entrySet()) {
            if (!entry.getValue().equals(status)) continue;
            filteredVulnerabilities.add(entry.getKey());
        }
        return filteredVulnerabilities;
    }

    private double getOverallScore(CvssVector vector, double defaultValue) {
        if (vector == null) {
            return defaultValue;
        }
        return vector.getBakedScores().getOverallScore();
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityInitial(Map<Vulnerability, CvssSeverityRanges.SeverityRange> initialSeverityCategories) {
        return this.generateOverviewChartCvssSeverity(initialSeverityCategories, "vulnerabilityOverviewChartCvssSeverityInitial", "vulnerability-overview-chart-cvss-severity-initial", "Initial CVSS Severity");
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityContext(Map<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories) {
        return this.generateOverviewChartCvssSeverity(contextSeverityCategories, "vulnerabilityOverviewChartCvssSeverityContext", "vulnerability-overview-chart-cvss-severity-context", "Context CVSS Severity");
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartVulnerabilityAssessmentStatus(Map<Vulnerability, String> statusPerVulnerability) {
        LinkedHashMap<String, Integer> countsPerStatus = new LinkedHashMap<String, Integer>();
        for (String string : CentralSecurityPolicyConfiguration.VULNERABILITY_STATUS_DISPLAY_MAPPER_UNMODIFIED.getStatusNames()) {
            countsPerStatus.put(string, 0);
        }
        for (Map.Entry entry : statusPerVulnerability.entrySet()) {
            countsPerStatus.put((String)entry.getValue(), countsPerStatus.getOrDefault(entry.getValue(), 0) + 1);
        }
        DefaultPieDataset jFreeChartDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)jFreeChartDataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot jFreeChartPlot = (PiePlot)jFreeChart.getPlot();
        JFreeChartUtils.applyDefaultForPieChartPlot(jFreeChartPlot);
        jFreeChartPlot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        jFreeChart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        for (Map.Entry entry : countsPerStatus.entrySet()) {
            JFreeChartUtils.addPieChartData(jFreeChartDataset, jFreeChartPlot, StatisticsOverviewTable.capitalizeWords((String)((String)entry.getKey())), (Number)entry.getValue(), VulnerabilityOverviewChartGenerator.getStatusCategoryColor(((String)entry.getKey()).toLowerCase()));
        }
        DoughnutPieChartDataset chartJsChartDataset = new DoughnutPieChartDataset().addHoverOffset(new Number[]{3}).setCutout("35%");
        DoughnutPieChartData chartJsChartData = (DoughnutPieChartData)new DoughnutPieChartData().addDataset(new ChartDataset[]{chartJsChartDataset});
        DoughnutChart chartJsChart = (DoughnutChart)((DoughnutChart)new DoughnutChart().setChartData((ChartData)chartJsChartData)).setChartOptions(this.createChartOptionsForOverviewCharts("Vulnerability Assessment Status"));
        for (Map.Entry entry : countsPerStatus.entrySet()) {
            ((DoughnutPieChartDataset)chartJsChartDataset.addData((Object[])new Number[]{(Number)entry.getValue()})).addBackgroundColor(new Color[]{VulnerabilityOverviewChartGenerator.getStatusCategoryColor(((String)entry.getKey()).toLowerCase())});
            chartJsChartData.addLabels(new String[]{StatisticsOverviewTable.capitalizeWords((String)((String)entry.getKey()))});
        }
        return new VulnerabilityAssessmentDashboard.GeneratedChartBuilder().setjFreeChart(jFreeChart).setjFreeChartName("vulnerability-overview-chart-vulnerability-status").setChartJsChart((Chart<?, ?, ?, ?>)chartJsChart).setChartJsChartId("vulnerabilityOverviewChartVulnerabilityStatus").setCanvasOrParentTag(((SpanTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().attr("width", (Object)"300")).attr("height", (Object)"300")).withStyle("width:300px;height:300px;display:inline-block;")).withClass("overview-chart-filterable")).with((DomContent)TagCreator.canvas().withClass("chart-js-remove-display-block"))).setCharJsChartJsVarName("vulnerabilityOverviewChartVulnerabilityStatus").createGeneratedChart();
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityContextByStatusInReview(Map<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories, List<Vulnerability> vulnerabilitiesPotentiallyAffected) {
        return this.generateOverviewChartCvssSeverityContextByStatus(contextSeverityCategories, vulnerabilitiesPotentiallyAffected, "vulnerabilityOverviewChartCvssSeverityContextByStatusInReview", "vulnerability-overview-chart-cvss-severity-context-by-status-in-review", "Context CVSS Severity (by vulnerabilities in review)", ColorScheme.PASTEL_BLUE);
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityContextByStatusApplicable(Map<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories, List<Vulnerability> vulnerabilitiesReviewed) {
        return this.generateOverviewChartCvssSeverityContextByStatus(contextSeverityCategories, vulnerabilitiesReviewed, "vulnerabilityOverviewChartCvssSeverityContextByStatusApplicable", "vulnerability-overview-chart-cvss-severity-context-by-status-applicable", "Context CVSS Severity (by applicable vulnerabilities)", ColorScheme.STRONG_DARK_BLUE);
    }

    /*
     * WARNING - void declaration
     */
    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityContextByComponent(Map<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories, Map<String, List<Vulnerability>> vulnerabilitiesByComponent) {
        LinkedHashMap<void, Integer> countsPerSeverityCategory = new LinkedHashMap<void, Integer>();
        for (Map.Entry<String, List<Vulnerability>> entry : vulnerabilitiesByComponent.entrySet()) {
            void var8_8;
            String component = entry.getKey();
            List<Vulnerability> vulnerabilities = entry.getValue();
            Object var8_9 = null;
            Iterator<Vulnerability> iterator = vulnerabilities.iterator();
            while (iterator.hasNext()) {
                Vulnerability vulnerability = iterator.next();
                CvssSeverityRanges.SeverityRange severityCategory = contextSeverityCategories.get(vulnerability);
                if (var8_8 != null && severityCategory.getIndex() <= var8_8.getIndex()) continue;
                CvssSeverityRanges.SeverityRange severityRange = severityCategory;
            }
            countsPerSeverityCategory.put(var8_8, countsPerSeverityCategory.getOrDefault(var8_8, 0) + 1);
        }
        DefaultPieDataset jFreeChartDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)jFreeChartDataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot jFreeChartPlot = (PiePlot)jFreeChart.getPlot();
        JFreeChartUtils.applyDefaultForPieChartPlot(jFreeChartPlot);
        jFreeChartPlot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        jFreeChart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            JFreeChartUtils.addPieChartData(jFreeChartDataset, jFreeChartPlot, ((CvssSeverityRanges.SeverityRange)entry.getKey()).getName(), (Number)entry.getValue(), ((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor());
        }
        DoughnutPieChartDataset chartJsChartDataset = new DoughnutPieChartDataset().addHoverOffset(new Number[]{3}).setCutout("35%");
        DoughnutPieChartData doughnutPieChartData = (DoughnutPieChartData)new DoughnutPieChartData().addDataset(new ChartDataset[]{chartJsChartDataset});
        DoughnutChart chartJsChart = (DoughnutChart)((DoughnutChart)new DoughnutChart().setChartData((ChartData)doughnutPieChartData)).setChartOptions(this.createChartOptionsForOverviewCharts("Context CVSS Severity (by component)"));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            ((DoughnutPieChartDataset)chartJsChartDataset.addData((Object[])new Number[]{(Number)entry.getValue()})).addBackgroundColor(new Color[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor()});
            doughnutPieChartData.addLabels(new String[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getName()});
        }
        return new VulnerabilityAssessmentDashboard.GeneratedChartBuilder().setjFreeChart(jFreeChart).setjFreeChartName("vulnerability-overview-chart-cvss-severity-context-by-component").setChartJsChart((Chart<?, ?, ?, ?>)chartJsChart).setChartJsChartId("vulnerabilityOverviewChartCvssSeverityContextByComponent").setCanvasOrParentTag(((SpanTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().attr("width", (Object)"300")).attr("height", (Object)"300")).withStyle("width:300px;height:300px;display:inline-block;")).withClass("overview-chart-filterable")).with((DomContent)TagCreator.canvas().withClass("chart-js-remove-display-block"))).setCharJsChartJsVarName("vulnerabilityOverviewChartCvssSeverityContextByComponent").createGeneratedChart();
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverity(Map<Vulnerability, CvssSeverityRanges.SeverityRange> severityCategories, String chartId, String filename, String title) {
        LinkedHashMap<Object, Integer> countsPerSeverityCategory = new LinkedHashMap<Object, Integer>();
        for (CvssSeverityRanges.SeverityRange range : this.securityPolicy.getCvssSeverityRanges().getRanges()) {
            countsPerSeverityCategory.put(range, 0);
        }
        for (Map.Entry entry : severityCategories.entrySet()) {
            countsPerSeverityCategory.put(entry.getValue(), countsPerSeverityCategory.getOrDefault(entry.getValue(), 0) + 1);
        }
        DefaultPieDataset jFreeChartDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)jFreeChartDataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot jFreeChartPlot = (PiePlot)jFreeChart.getPlot();
        JFreeChartUtils.applyDefaultForPieChartPlot(jFreeChartPlot);
        jFreeChartPlot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        jFreeChart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            JFreeChartUtils.addPieChartData(jFreeChartDataset, jFreeChartPlot, ((CvssSeverityRanges.SeverityRange)entry.getKey()).getName(), (Number)entry.getValue(), ((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor());
        }
        DoughnutPieChartDataset chartJsChartDataset = new DoughnutPieChartDataset().addHoverOffset(new Number[]{3}).setCutout("35%");
        DoughnutPieChartData doughnutPieChartData = (DoughnutPieChartData)new DoughnutPieChartData().addDataset(new ChartDataset[]{chartJsChartDataset});
        DoughnutChart chartJsChart = (DoughnutChart)((DoughnutChart)new DoughnutChart().setChartData((ChartData)doughnutPieChartData)).setChartOptions(this.createChartOptionsForOverviewCharts(title));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            ((DoughnutPieChartDataset)chartJsChartDataset.addData((Object[])new Number[]{(Number)entry.getValue()})).addBackgroundColor(new Color[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor()});
            doughnutPieChartData.addLabels(new String[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getName()});
        }
        return new VulnerabilityAssessmentDashboard.GeneratedChartBuilder().setjFreeChart(jFreeChart).setjFreeChartName(filename).setChartJsChart((Chart<?, ?, ?, ?>)chartJsChart).setChartJsChartId(chartId).setCanvasOrParentTag(((SpanTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().attr("width", (Object)"300")).attr("height", (Object)"300")).withStyle("width:300px;height:300px;display:inline-block;")).withClass("overview-chart-filterable")).with((DomContent)TagCreator.canvas().withClass("chart-js-remove-display-block"))).setCharJsChartJsVarName(chartId).createGeneratedChart();
    }

    private VulnerabilityAssessmentDashboard.GeneratedChart generateOverviewChartCvssSeverityContextByStatus(Map<Vulnerability, CvssSeverityRanges.SeverityRange> contextSeverityCategories, List<Vulnerability> filteredVulnerabilities, String chartId, String filename, String title, ColorScheme centerDotColor) {
        LinkedHashMap<CvssSeverityRanges.SeverityRange, Integer> countsPerSeverityCategory = new LinkedHashMap<CvssSeverityRanges.SeverityRange, Integer>();
        for (CvssSeverityRanges.SeverityRange range : this.securityPolicy.getCvssSeverityRanges().getRanges()) {
            countsPerSeverityCategory.put(range, 0);
        }
        for (Vulnerability vulnerability : filteredVulnerabilities) {
            countsPerSeverityCategory.put(contextSeverityCategories.get(vulnerability), countsPerSeverityCategory.getOrDefault(contextSeverityCategories.get(vulnerability), 0) + 1);
        }
        DefaultPieDataset jFreeChartDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)jFreeChartDataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot jFreeChartPlot = (PiePlot)jFreeChart.getPlot();
        JFreeChartUtils.applyDefaultForPieChartPlot(jFreeChartPlot);
        jFreeChartPlot.setBackgroundPaint((Paint)new Color(255, 255, 255));
        jFreeChart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            JFreeChartUtils.addPieChartData(jFreeChartDataset, jFreeChartPlot, ((CvssSeverityRanges.SeverityRange)entry.getKey()).getName(), (Number)entry.getValue(), ((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor());
        }
        DoughnutPieChartDataset chartJsChartDataset = new DoughnutPieChartDataset().addHoverOffset(new Number[]{3}).setCutout("35%");
        DoughnutPieChartData doughnutPieChartData = (DoughnutPieChartData)new DoughnutPieChartData().addDataset(new ChartDataset[]{chartJsChartDataset});
        DoughnutChart chartJsChart = (DoughnutChart)((DoughnutChart)new DoughnutChart().setChartData((ChartData)doughnutPieChartData)).setChartOptions(this.createChartOptionsForOverviewCharts(title));
        for (Map.Entry entry : countsPerSeverityCategory.entrySet()) {
            ((DoughnutPieChartDataset)chartJsChartDataset.addData((Object[])new Number[]{(Number)entry.getValue()})).addBackgroundColor(new Color[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getColor().getColor()});
            doughnutPieChartData.addLabels(new String[]{((CvssSeverityRanges.SeverityRange)entry.getKey()).getName()});
        }
        return new VulnerabilityAssessmentDashboard.GeneratedChartBuilder().setjFreeChart(jFreeChart).setjFreeChartName(filename).setChartJsChart((Chart<?, ?, ?, ?>)chartJsChart).setChartJsChartId(chartId).setCanvasOrParentTag(((SpanTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().attr("width", (Object)"300")).attr("height", (Object)"300")).withStyle("width:300px;height:300px;display:inline-block;position:relative;")).withClass("overview-chart-filterable")).with(new DomContent[]{((CanvasTag)TagCreator.canvas().withClass("chart-js-remove-display-block")).withStyle("z-index: 2;position: inherit;"), TagCreator.span().withClasses(new String[]{"overview-chart-circle", centerDotColor.getCssRootName()})})).setCharJsChartJsVarName(chartId).createGeneratedChart();
    }

    private ChartOptions createChartOptionsForOverviewCharts(String title) {
        return new ChartOptions().setResponsive(Boolean.valueOf(false)).setMaintainAspectRatio(Boolean.valueOf(false)).setLegend(new LegendOption().setAlign("top")).setTitle(new TitleOption().setDisplay(Boolean.valueOf(true)).setText(title));
    }

    private static Color getStatusCategoryColor(String statusCategory) {
        return STATUS_CATEGORY_COLOR_MAPPING.getOrDefault(statusCategory.toLowerCase(), ColorScheme.PASTEL_WHITE.getColor());
    }
}

