/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.periodic;

import com.metaeffekt.artifact.analysis.cert.PeriodicDataSourcesOperations;
import com.metaeffekt.artifact.analysis.diffmerge.InventoryMerger;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.AdvisorPeriodicEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Advisor periodic", phase=InventoryEnrichmentPhase.STANDALONE, intermediateFileSuffix="advisor-periodic", mavenPropertyName="advisorPeriodicEnrichment")
public class AdvisorPeriodicEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisorPeriodicEnrichment.class);
    public static final String ADVISOR_PERIODIC_QUERY_KEY = "cert-periodic-query";
    public static final String ADVISOR_PERIODIC_QUERY_RANGE_START_KEY = "Range Start";
    public static final String ADVISOR_PERIODIC_QUERY_RANGE_END_KEY = "Range End";
    private AdvisorPeriodicEnrichmentConfiguration configuration = new AdvisorPeriodicEnrichmentConfiguration();
    private final File baseMirrorDirectory;

    public AdvisorPeriodicEnrichment(File baseMirrorDirectory) {
        this.baseMirrorDirectory = baseMirrorDirectory;
    }

    @Override
    public AdvisorPeriodicEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        LinkedHashMap<String, Inventory> parsedReferenceInventories = new LinkedHashMap<String, Inventory>();
        if (this.configuration.hasInitialInventoryContextName()) {
            parsedReferenceInventories.put(this.configuration.getInitialInventoryContextName(), inventory);
        }
        parsedReferenceInventories.putAll(this.configuration.parseReferenceInventories());
        if (parsedReferenceInventories.isEmpty()) {
            LOG.warn("No reference inventories have been provided.");
        } else if (parsedReferenceInventories.size() == 1) {
            LOG.info("Using [{}] as the only reference inventory", parsedReferenceInventories.keySet().iterator().next());
        } else {
            LOG.info("Using [{}] as the reference inventories", parsedReferenceInventories.keySet());
        }
        Map<String, VulnerabilityContextInventory> vParsedReferenceInventories = VulnerabilityContextInventory.fromInventories(parsedReferenceInventories);
        Inventory outputInventory = new Inventory();
        outputInventory.setAssetMetaData(inventory.getAssetMetaData());
        VulnerabilityContextInventory vOutputInventory = VulnerabilityContextInventory.fromInventory(outputInventory);
        PeriodicDataSourcesOperations.QueryTimePeriod queryTimePeriod = this.configuration.getAdvisoryQueryPeriod();
        LOG.info("Listing all advisories for changed entries of {} in period {}", this.configuration.getAdvisoryProviders(), (Object)queryTimePeriod);
        InventoryInfo info = outputInventory.findOrCreateInventoryInfo(ADVISOR_PERIODIC_QUERY_KEY);
        info.set(ADVISOR_PERIODIC_QUERY_RANGE_START_KEY, new SimpleDateFormat("yyyy-MM-dd").format(queryTimePeriod.getStart()));
        info.set(ADVISOR_PERIODIC_QUERY_RANGE_END_KEY, new SimpleDateFormat("yyyy-MM-dd").format(queryTimePeriod.getEnd()));
        PeriodicDataSourcesOperations periodicDataSourcesOperations = new PeriodicDataSourcesOperations();
        periodicDataSourcesOperations.addAdvisorIndexQueriesForContentIdentifiers(this.baseMirrorDirectory, this.configuration.getAdvisoryProviders());
        List<AdvisoryEntry> securityAdvisoriesUpdatedOrModifiedSince = periodicDataSourcesOperations.findSecurityAdvisoriesUpdatedOrModifiedSince(queryTimePeriod, this.configuration.getAdvisoryProviders(), this.configuration.getIncludeAdvisoryTypes());
        vOutputInventory.addAllAdvisories(securityAdvisoriesUpdatedOrModifiedSince);
        periodicDataSourcesOperations.setSecurityAdvisoryReviewedStatusFromReferenceInventories(vOutputInventory.getSecurityAdvisories(), vParsedReferenceInventories.values());
        this.filterInventoryDataPreMerge(vOutputInventory, periodicDataSourcesOperations);
        this.mergeReferenceInventoriesToSourceInventory(vOutputInventory, parsedReferenceInventories, outputInventory);
        for (AdvisoryEntry securityAdvisory : vOutputInventory.getShallowCopySecurityAdvisories()) {
            if (securityAdvisory.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS) != null) continue;
            securityAdvisory.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "unclassified");
        }
        this.filterInventoryDataPostMerge(vOutputInventory, periodicDataSourcesOperations);
        vOutputInventory.writeBack(true);
        this.logReviewStateCounts(vOutputInventory.getSecurityAdvisories());
        super.moveInventoryData(outputInventory, inventory);
    }

    private void mergeReferenceInventoriesToSourceInventory(VulnerabilityContextInventory vOutputInventory, Map<String, Inventory> parsedReferenceInventories, Inventory outputInventory) {
        vOutputInventory.writeBack(true);
        int initialAdvisoryCount = vOutputInventory.getSecurityAdvisories().size();
        if (!parsedReferenceInventories.isEmpty()) {
            InventoryMerger merger = new InventoryMerger(outputInventory, this.getSecurityPolicyConfiguration());
            for (Map.Entry<String, Inventory> reference : parsedReferenceInventories.entrySet()) {
                merger.addReferenceInventory(reference.getValue(), reference.getKey());
            }
            merger.includeArtifacts();
            merger.includeVulnerabilities();
            merger.includeAdvisories();
        }
        vOutputInventory.parse();
        int finalAdvisoryCount = vOutputInventory.getSecurityAdvisories().size();
        int addedAdvisories = finalAdvisoryCount - initialAdvisoryCount;
        LOG.info(" --> Added [{} - {} = {}] security advisories from [{}] reference inventories", new Object[]{finalAdvisoryCount, initialAdvisoryCount, addedAdvisories, parsedReferenceInventories.size()});
    }

    private void filterInventoryDataPreMerge(VulnerabilityContextInventory vOutputInventory, PeriodicDataSourcesOperations periodicDataSourcesOperations) {
        if (this.configuration.isFilterUnaffected()) {
            this.filterSecurityAdvisoriesIfStatus(vOutputInventory, periodicDataSourcesOperations, "unaffected");
        }
    }

    private void filterInventoryDataPostMerge(VulnerabilityContextInventory vOutputInventory, PeriodicDataSourcesOperations periodicDataSourcesOperations) {
        Set<Vulnerability> unfilteredVulnerabilities = vOutputInventory.getShallowCopyVulnerabilities();
        int unfilteredSecurityAdvisoriesCount = vOutputInventory.getSecurityAdvisories().size();
        if (this.configuration.isFilterUnclassified()) {
            this.filterSecurityAdvisoriesIfStatus(vOutputInventory, periodicDataSourcesOperations, "unclassified");
        }
        if (this.configuration.isFilterVulnerabilitiesWithoutSpecifiedAdvisory()) {
            if (!this.configuration.getVulnerabilityAdvisoryFilter().isEmpty()) {
                LOG.info("Removing all vulnerabilities that do not contain at least one vulnerability with a specified advisory provider of {}", this.configuration.getVulnerabilityAdvisoryFilter());
                int initialVulnerabilityCount = vOutputInventory.getVulnerabilities().size();
                periodicDataSourcesOperations.filterVulnerabilitiesByAdvisoryFilter(vOutputInventory, this.configuration.getVulnerabilityAdvisoryFilter());
                int finalVulnerabilityCount = vOutputInventory.getVulnerabilities().size();
                int removedVulnerabilities = initialVulnerabilityCount - finalVulnerabilityCount;
                LOG.info(" --> Removed [{} - {} = {}] vulnerabilities that do not contain at least one vulnerability with a specified advisory provider", new Object[]{initialVulnerabilityCount, removedVulnerabilities, finalVulnerabilityCount});
            } else {
                LOG.warn("Filtering vulnerabilities without specified advisory is enabled, but no advisory providers are specified. No vulnerabilities will be removed.");
            }
        }
        if (this.configuration.isFilterUnaffectedVulnerabilities()) {
            LOG.info("Removing all vulnerabilities that are not affected by any advisory");
            HashSet allAffectedVulnerabilities = new HashSet();
            for (AdvisoryEntry securityAdvisory : vOutputInventory.getShallowCopySecurityAdvisories()) {
                Map<VulnerabilityTypeIdentifier<?>, Set<String>> referencedIds = securityAdvisory.getReferencedVulnerabilities();
                for (Map.Entry entry : referencedIds.entrySet()) {
                    for (String referencedVulnerability : (Set)entry.getValue()) {
                        vOutputInventory.findVulnerabilityByName(referencedVulnerability).ifPresent(allAffectedVulnerabilities::add);
                    }
                }
            }
            LOG.info(" --> Found [{}] vulnerabilities that are affected by at least one advisory", (Object)allAffectedVulnerabilities.size());
            int initialVulnerabilityCount = vOutputInventory.getVulnerabilities().size();
            for (Vulnerability vulnerability : vOutputInventory.getShallowCopyVulnerabilities()) {
                if (allAffectedVulnerabilities.contains(vulnerability)) continue;
                vOutputInventory.remove(vulnerability);
            }
            int finalVulnerabilityCount = vOutputInventory.getVulnerabilities().size();
            int removedVulnerabilities = initialVulnerabilityCount - finalVulnerabilityCount;
            LOG.info(" --> Removed [{} - {} = {}] vulnerabilities that are not affected by any advisory", new Object[]{initialVulnerabilityCount, removedVulnerabilities, finalVulnerabilityCount});
        }
        long forceVulnerabilitiesToBeIncludedChangedSinceTime = this.configuration.getIncludeVulnerabilitiesChangedSinceTimestamp();
        Date forceVulnerabilitiesToBeIncludedChangedSinceDate = new Date(forceVulnerabilitiesToBeIncludedChangedSinceTime);
        if (forceVulnerabilitiesToBeIncludedChangedSinceTime != 0L) {
            int reAddedVulnerabilities = 0;
            for (Vulnerability vulnerability : unfilteredVulnerabilities) {
                if (!vulnerability.isCreatedAfter(forceVulnerabilitiesToBeIncludedChangedSinceDate) && !vulnerability.isUpdatedAfter(forceVulnerabilitiesToBeIncludedChangedSinceDate) || vOutputInventory.contains(vulnerability)) continue;
                vOutputInventory.add(vulnerability);
                ++reAddedVulnerabilities;
            }
            if (reAddedVulnerabilities > 0) {
                LOG.info(" --> Re-added [{}] previously removed vulnerabilities that were created or updated after [{}]", (Object)reAddedVulnerabilities, (Object)TimeUtils.formatNormalizedDate(forceVulnerabilitiesToBeIncludedChangedSinceDate));
            } else {
                LOG.info(" --> No vulnerabilities were re-added, as none were removed that were created or updated after [{}]", (Object)TimeUtils.formatNormalizedDate(forceVulnerabilitiesToBeIncludedChangedSinceDate));
            }
        }
        LOG.info("Counts after applying filtering: [vulnerabilities {} -> {}] [advisories {} -> {}]", new Object[]{unfilteredVulnerabilities.size(), vOutputInventory.getVulnerabilities().size(), unfilteredSecurityAdvisoriesCount, vOutputInventory.getSecurityAdvisories().size()});
    }

    private void filterSecurityAdvisoriesIfStatus(VulnerabilityContextInventory vOutputInventory, PeriodicDataSourcesOperations periodicDataSourcesOperations, String statusValueUnclassified) {
        LOG.info("Removing all security advisories that are marked as [{}]", (Object)statusValueUnclassified);
        int initialAdvisoryCount = vOutputInventory.getSecurityAdvisories().size();
        periodicDataSourcesOperations.removeSecurityAdvisoryIfStatus(vOutputInventory, statusValueUnclassified);
        int finalAdvisoryCount = vOutputInventory.getSecurityAdvisories().size();
        int removedAdvisories = initialAdvisoryCount - finalAdvisoryCount;
        LOG.info(" --> Removed [{} - {} = {}] security advisories that are marked as [{}]", new Object[]{initialAdvisoryCount, removedAdvisories, finalAdvisoryCount, statusValueUnclassified});
    }

    private void logReviewStateCounts(Collection<AdvisoryEntry> securityAdvisories) {
        Map<String, Long> reviewStatusCounts = securityAdvisories.stream().collect(Collectors.groupingBy(a -> a.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS) == null ? "null" : a.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS), Collectors.counting()));
        LOG.info("");
        LOG.info("Inventory review status state summary:");
        for (Map.Entry<String, Long> reviewStatusCount : reviewStatusCounts.entrySet()) {
            LOG.info("  {}: {}", (Object)reviewStatusCount.getKey(), (Object)reviewStatusCount.getValue());
            StringJoiner matchingEntries = new StringJoiner(", ");
            for (AdvisoryEntry securityAdvisory : securityAdvisories) {
                String value;
                String string = value = securityAdvisory.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS) == null ? "null" : securityAdvisory.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS);
                if (!reviewStatusCount.getKey().equals(value)) continue;
                matchingEntries.add(securityAdvisory.getId());
            }
            LOG.info("    {}", (Object)matchingEntries);
        }
        LOG.info("");
    }

    public void setConfiguration(AdvisorPeriodicEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

