/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.timeline;

import com.metaeffekt.artifact.analysis.utils.CountdownTimer;
import com.metaeffekt.artifact.analysis.utils.LruLinkedHashMap;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import com.metaeffekt.artifact.enrichment.matching.VulnerabilitiesFromCpeEnrichment;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimelineGenerator;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class VulnerabilityTimeline {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityTimeline.class);
    private static final Cvss2 DUMMY_CVSS = new Cvss2();
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9a-zA-Z]+)(?:[.:]+)?([0-9a-zA-Z]+)?(?:[.:]+)?((?:(?:[0-9a-zA-Z]+)?(?:[.:]+)?)+)");
    private final String vendor;
    private final String product;
    private final VulnerabilityTimelineGenerator configuration;
    private final List<TimelineVersion> versions;
    private final List<String> relevantTimelineVulnerabilities;
    private static final LruLinkedHashMap<String, TimelineVersion> timelineVersionCache = new LruLinkedHashMap(1000);

    public VulnerabilityTimeline(String vendor, String product, VulnerabilityTimelineGenerator configuration) {
        this.vendor = vendor;
        this.product = product;
        this.configuration = configuration;
        this.versions = this.generateTimelineVersions(vendor, product);
        this.relevantTimelineVulnerabilities = this.findVulnerabilitiesForAnyVersion(vendor, product).stream().map(AmbDataClass::getId).filter(v -> configuration.getRelevantVulnerabilities().contains(v)).collect(Collectors.toList());
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TimelineVersion> generateTimelineVersions(String vendor, String product) {
        ArrayList<TimelineVersion> versions = new ArrayList<TimelineVersion>();
        CountdownTimer perTimelineTimer = new CountdownTimer((long)this.configuration.getVadConfiguration().getMaximumTimeSpentPerTimeline() * 1000L);
        perTimelineTimer.start();
        this.configuration.getTimelineGenerationTime().start();
        try {
            List<Cpe> unsortedCpeSet = this.configuration.getCpeDictionaryQuery().findCpeByVendorProduct(vendor, product);
            if (unsortedCpeSet == null || unsortedCpeSet.isEmpty()) {
                LOG.error("NVD mirror did not contain any CPE for vendor/product [{} {}]", (Object)vendor, (Object)product);
                ArrayList<TimelineVersion> arrayList = versions;
                return arrayList;
            }
            LOG.info("Generating vulnerability timeline for [{} {}] with [~{}] versions", new Object[]{vendor, product, unsortedCpeSet.size()});
            List cpeList = unsortedCpeSet.stream().sorted((o1, o2) -> VersionComparator.INSTANCE.compare(o1.getVersion(), o2.getVersion())).distinct().collect(Collectors.toList());
            int totalVulnerabilities = 0;
            long startTime = System.currentTimeMillis();
            long lastLogTime = 0L;
            for (int i = cpeList.size() - 1; i >= 0; --i) {
                Cpe cpe;
                TimelineVersion version;
                long passedTime;
                if (this.configuration.getVadConfiguration().getMaximumVersionsPerTimeline() != -1 && versions.size() > this.configuration.getVadConfiguration().getMaximumVersionsPerTimeline()) {
                    LOG.info("Configured limit of [{}] versions has been reached for vulnerability timeline [{} {}], skipping [{}/{}]", new Object[]{this.configuration.getVadConfiguration().getMaximumVersionsPerTimeline(), vendor, product, i, cpeList.size()});
                    break;
                }
                if (i % 100 == 0 && (passedTime = System.currentTimeMillis() - startTime) - lastLogTime > 10000L) {
                    lastLogTime = passedTime;
                    int progressI = cpeList.size() - i;
                    long estimatedTime = passedTime / (long)progressI * (long)(cpeList.size() - progressI);
                    LOG.info("Generating vulnerability timeline for [{} {}] with [{}] versions, currently at [{}/{}] ({}s passed, ~{}s remaining)", new Object[]{vendor, product, cpeList.size(), progressI, cpeList.size(), passedTime / 1000L, estimatedTime / 1000L});
                    if (this.configuration.getTimelineGenerationTime().isEndReached()) {
                        LOG.info("Timeline generation time limit of [{}]s has been reached, skipping [{}/{}]", new Object[]{this.configuration.getVadConfiguration().getMaximumTimeSpentOnTimelines(), i, cpeList.size()});
                        break;
                    }
                    if (perTimelineTimer.isEndReached()) {
                        LOG.info("Timeline generation time limit of [{}]s has been reached for timeline [{} {}], skipping [{}/{}]", new Object[]{this.configuration.getVadConfiguration().getMaximumTimeSpentPerTimeline(), vendor, product, i, cpeList.size()});
                        break;
                    }
                }
                if ((version = this.generateTimelineVersion(null, cpe = (Cpe)cpeList.get(i))) == null) continue;
                versions.add(version);
                if ((totalVulnerabilities += version.getVulnerabilityCount()) <= this.configuration.getVadConfiguration().getMaximumVulnerabilitiesPerTimeline()) continue;
                LOG.info("Configured limit of [{}] vulnerabilities has been reached for vulnerability timeline [{} {}], skipping [{}/{}]", new Object[]{this.configuration.getVadConfiguration().getMaximumVulnerabilitiesPerTimeline(), vendor, product, i, cpeList.size()});
                break;
            }
            Collections.reverse(versions);
            LOG.info("Generated vulnerability timeline for [{} {}] with [{}] versions and [{}] vulnerabilities", new Object[]{vendor, product, versions.size(), totalVulnerabilities});
        }
        catch (Exception e) {
            LOG.error("Failed to generate vulnerability timeline for [{} {}]", new Object[]{vendor, product, e});
        }
        finally {
            this.configuration.getTimelineGenerationTime().stop();
            perTimelineTimer.stop();
        }
        return versions;
    }

    private List<Vulnerability> findVulnerabilitiesForAnyVersion(String vendor, String product) {
        Cpe checkCpe;
        try {
            checkCpe = CommonEnumerationUtil.builder().part(Part.ANY).vendor(vendor).product(product).version("*").build();
        }
        catch (CpeValidationException e) {
            LOG.warn("Failed to generate CPE for vendor/product [{} {}]", new Object[]{vendor, product, e});
            return new ArrayList<Vulnerability>();
        }
        return this.configuration.getVulnerabilityQuery().findVulnerabilitiesByFlatAffectedConfiguration(checkCpe);
    }

    private TimelineVersion generateTimelineVersion(Artifact artifact, Cpe cpe) {
        TimelineVersion version;
        Cpe queryCpe;
        if ((artifact == null || StringUtils.isEmpty(artifact.getVersion()) || artifact.getVersion().equals("*") || artifact.getVersion().equals("-")) && (cpe.getVersion().equals("*") || cpe.getVersion().equals("-"))) {
            return null;
        }
        if (artifact != null) {
            queryCpe = VulnerabilitiesFromCpeEnrichment.deriveQueryCpe(null, null, artifact, cpe).orElse(cpe);
            version = new TimelineVersion(Version.of(artifact.getVersion(), VersionContext.fromArtifact(artifact)));
        } else {
            queryCpe = cpe;
            version = new TimelineVersion(Version.of(queryCpe.getVersion(), queryCpe.getUpdate(), VersionContext.fromCpe(queryCpe)));
        }
        String cacheKey = CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(queryCpe);
        if (timelineVersionCache.containsKey(cacheKey)) {
            return (TimelineVersion)timelineVersionCache.get(cacheKey);
        }
        List<Vulnerability> vulnerabilities = this.configuration.getVulnerabilityQuery().findVulnerabilitiesByFlatAffectedConfiguration(queryCpe);
        for (Vulnerability vulnerability : vulnerabilities) {
            vulnerability.selectEffectiveCvssVectors(this.configuration.getCentralSecurityPolicyConfiguration());
            CvssSeverityRanges.SeverityRange severity = this.configuration.getCentralSecurityPolicyConfiguration().getCvssSeverityRanges().getRange(((CvssVector)ObjectUtils.firstNonNull((Object[])new CvssVector[]{vulnerability.getCvssSelectionResult().getSelectedInitialCvss(), new Cvss2()})).getBakedScores().getNormalizedBaseScore());
            if (this.configuration.getRelevantVulnerabilities().contains(vulnerability.getId())) {
                version.putSeverityWithVulnerabilityIdentifier(severity, vulnerability.getId());
                continue;
            }
            version.putSeverity(severity);
        }
        timelineVersionCache.put(cacheKey, version);
        return version;
    }

    public boolean containsVulnerability(String vulnerabilityId) {
        return this.relevantTimelineVulnerabilities.contains(vulnerabilityId);
    }

    public boolean containsVulnerability(Vulnerability vulnerability) {
        return this.relevantTimelineVulnerabilities.contains(vulnerability.getId());
    }

    public List<TimelineVersion> getVersions() {
        return this.versions;
    }

    public String toString() {
        return new JSONObject().put("vendor", (Object)this.vendor).put("product", (Object)this.product).put("versions", this.versions.size()).toString();
    }

    public List<TimelineVersion> generateCustomVersionsFromArtifacts(Collection<Artifact> artifacts) {
        HashSet<Cpe> artifactCpes = new HashSet<Cpe>();
        LinkedHashMap<String, Artifact> distinctArtifactVersions = new LinkedHashMap<String, Artifact>();
        for (Artifact artifact : artifacts) {
            try {
                artifactCpes.add(CommonEnumerationUtil.builder().part(Part.APPLICATION).vendor(this.vendor).product(this.product).build());
            }
            catch (CpeValidationException e) {
                LOG.warn("Cannot create CPE from artifact [{}] for vulnerability timeline [{} {}]: {}", new Object[]{artifact.getId(), this.vendor, this.product, e.getMessage()});
            }
            if (!StringUtils.hasText(artifact.getVersion()) || distinctArtifactVersions.containsKey(artifact.getVersion())) continue;
            distinctArtifactVersions.put(artifact.getVersion(), artifact);
        }
        ArrayList<TimelineVersion> versions = new ArrayList<TimelineVersion>();
        for (Cpe artifactCpe : artifactCpes) {
            for (Artifact artifact : distinctArtifactVersions.values()) {
                TimelineVersion version = this.generateTimelineVersion(artifact, artifactCpe);
                if (version == null) continue;
                versions.add(version);
            }
        }
        return versions;
    }

    public List<TimelineVersion> getOfficialAndArtifactMergedVersions(Collection<TimelineVersion> additionalTimelineVersions) {
        ArrayList<TimelineVersion> mergedVersions = new ArrayList<TimelineVersion>(this.versions);
        for (TimelineVersion addVersion : additionalTimelineVersions) {
            if (!mergedVersions.stream().noneMatch(v -> v.getVersion().matchesVersionOf(addVersion.getVersion()))) continue;
            mergedVersions.add(addVersion);
        }
        mergedVersions.sort((o1, o2) -> VersionComparator.INSTANCE.compare(o1.getVersionUpdate(), o2.getVersionUpdate()));
        return mergedVersions;
    }

    public List<TimelineVersion> getReducedOfficialAndArtifactMergedCpeVersions(Set<Artifact> artifacts, List<TimelineVersion> additionalTimelineVersions) {
        int i;
        List<TimelineVersion> versions = this.getOfficialAndArtifactMergedVersions(additionalTimelineVersions);
        if (versions.size() <= 10) {
            return versions;
        }
        HashSet<TimelineVersion> requiredCpeVersions = new HashSet<TimelineVersion>(this.createVersionsForArtifactVersion(artifacts, additionalTimelineVersions));
        requiredCpeVersions.add(versions.get(versions.size() - 1));
        requiredCpeVersions.addAll(additionalTimelineVersions);
        ArrayList<TimelineVersion> reducedCpeVersions = new ArrayList<TimelineVersion>();
        String majorVersion = null;
        int amountVulnerabilities = -1;
        for (i = 0; i < versions.size(); ++i) {
            if (requiredCpeVersions.contains(versions.get(i))) {
                reducedCpeVersions.add(versions.get(i));
                continue;
            }
            Matcher versionMatcher = VERSION_PATTERN.matcher(versions.get(i).getVersionUpdate());
            if (versionMatcher.find()) {
                if (majorVersion == null) {
                    reducedCpeVersions.add(versions.get(i));
                } else if (!majorVersion.equals(versionMatcher.group(1)) || amountVulnerabilities != versions.get(i).getVulnerabilityCount()) {
                    reducedCpeVersions.add(versions.get(i - 1));
                }
                majorVersion = versionMatcher.group(1);
                amountVulnerabilities = versions.get(i).getVulnerabilityCount();
                continue;
            }
            reducedCpeVersions.add(versions.get(i));
            majorVersion = versions.get(i).getVersion().getVersion();
        }
        if (reducedCpeVersions.size() <= 10 && versions.size() <= 20) {
            return versions;
        }
        this.removeDoubles(reducedCpeVersions);
        for (i = 2; i < reducedCpeVersions.size() - 2; ++i) {
            boolean outsideThresholdAfter;
            int currentVulnerabilityCount;
            if (requiredCpeVersions.contains(reducedCpeVersions.get(i)) || (currentVulnerabilityCount = ((TimelineVersion)reducedCpeVersions.get(i)).getVulnerabilityCount()) >= 4) continue;
            double averageBefore = 0.0;
            int count = 0;
            for (int j = Math.max(0, i - 2); j < i; ++j) {
                averageBefore += (double)((TimelineVersion)reducedCpeVersions.get(j)).getVulnerabilityCount();
                ++count;
            }
            averageBefore /= Math.max(1.0, (double)count);
            double averageAfter = 0.0;
            count = 0;
            for (int j = i + 1; j < Math.min(reducedCpeVersions.size() - 1, i + 3); ++j) {
                averageAfter += (double)((TimelineVersion)reducedCpeVersions.get(j)).getVulnerabilityCount();
                ++count;
            }
            boolean isPatchVersion = StringUtils.hasText(((TimelineVersion)reducedCpeVersions.get(i)).getVersion().getUpdate());
            double threshold = Math.max(5.0, (averageBefore + (averageAfter /= Math.max(1.0, (double)count))) / 2.0 * 0.2);
            int distanceToBefore = (int)Math.abs((double)currentVulnerabilityCount - averageBefore);
            int distanceToAfter = (int)Math.abs((double)currentVulnerabilityCount - averageAfter);
            boolean outsideThresholdBefore = (double)distanceToBefore > threshold;
            boolean bl = outsideThresholdAfter = (double)distanceToAfter > threshold;
            if ((!outsideThresholdBefore || !outsideThresholdAfter) && (!isPatchVersion || !outsideThresholdBefore && !outsideThresholdAfter)) continue;
            reducedCpeVersions.remove(i);
            --i;
        }
        return reducedCpeVersions;
    }

    public List<TimelineVersion> createVersionsForArtifactVersion(Collection<Artifact> artifacts, Collection<TimelineVersion> artifactCpeVersions) {
        List artifactVersions = artifacts.stream().map(artifact -> Version.of(artifact.getVersion(), VersionContext.fromArtifact(artifact))).collect(Collectors.toList());
        List<TimelineVersion> mergedVersions = this.getOfficialAndArtifactMergedVersions(artifactCpeVersions);
        ArrayList<TimelineVersion> filteredVersions = new ArrayList<TimelineVersion>();
        block0: for (TimelineVersion cpe : mergedVersions) {
            for (Version artifactVersion : artifactVersions) {
                if (!cpe.getVersion().matchesVersionOf(artifactVersion)) continue;
                filteredVersions.add(cpe);
                continue block0;
            }
        }
        return filteredVersions;
    }

    private void removeDoubles(List<TimelineVersion> versions) {
        block0: for (int i = versions.size() - 1; i >= 0; --i) {
            for (int j = versions.size() - 1; j >= 0; --j) {
                if (i == j) continue;
                if (i >= versions.size()) continue block0;
                if (j >= versions.size() || !versions.get(i).getVersionUpdate().equals(versions.get(j).getVersionUpdate())) continue;
                if (versions.get(i).getVulnerabilityCount() >= versions.get(j).getVulnerabilityCount()) {
                    versions.remove(j);
                    continue;
                }
                versions.remove(i);
            }
        }
    }

    public static class TimelineVersion {
        private final Version version;
        private final Map<CvssSeverityRanges.SeverityRange, Integer> vulnerabilitiesPerSeverity = new HashMap<CvssSeverityRanges.SeverityRange, Integer>();
        private final List<String> vulnerabilityIdentifiers = new ArrayList<String>();

        private TimelineVersion(Version version) {
            this.version = version;
        }

        public int getCountForSeverity(CvssSeverityRanges.SeverityRange severity) {
            return this.vulnerabilitiesPerSeverity.getOrDefault(severity, 0);
        }

        public boolean containsVulnerability(String vulnerabilityId) {
            return this.vulnerabilityIdentifiers.contains(vulnerabilityId);
        }

        public boolean containsVulnerability(Vulnerability vulnerability) {
            return this.vulnerabilityIdentifiers.contains(vulnerability.getId());
        }

        public int getVulnerabilityCount() {
            int count = 0;
            for (Integer value : this.vulnerabilitiesPerSeverity.values()) {
                count += value.intValue();
            }
            return count;
        }

        public void putSeverityWithVulnerabilityIdentifier(CvssSeverityRanges.SeverityRange severity, String vulnerabilityId) {
            this.putSeverity(severity);
            this.vulnerabilityIdentifiers.add(vulnerabilityId);
        }

        public void putSeverity(CvssSeverityRanges.SeverityRange severity) {
            if (this.vulnerabilitiesPerSeverity.containsKey(severity)) {
                this.vulnerabilitiesPerSeverity.put(severity, this.vulnerabilitiesPerSeverity.get(severity) + 1);
            } else {
                this.vulnerabilitiesPerSeverity.put(severity, 1);
            }
        }

        public String getVersionUpdate() {
            return this.version.getVersion() + (this.shouldUpdatePartBeIncludedInLabel(this.version.getUpdate()) ? ":" + this.version.getUpdate() : "");
        }

        private boolean shouldUpdatePartBeIncludedInLabel(String updatePart) {
            return StringUtils.hasText(updatePart) && !"*".equals(updatePart) && !"-".equals(updatePart);
        }

        public String toString() {
            return "[" + this.getVersionUpdate() + ": " + this.vulnerabilitiesPerSeverity + "]";
        }

        public Version getVersion() {
            return this.version;
        }

        public Map<CvssSeverityRanges.SeverityRange, Integer> getVulnerabilitiesPerSeverity() {
            return this.vulnerabilitiesPerSeverity;
        }

        public List<String> getVulnerabilityIdentifiers() {
            return this.vulnerabilityIdentifiers;
        }
    }
}

