/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.timeline;

import com.metaeffekt.artifact.analysis.utils.CountdownTimer;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityAssessmentDashboardEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimeline;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimelineGeneratorResult;
import com.metaeffekt.mirror.concurrency.ScheduledDelayedThreadPoolExecutor;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.query.NvdCpeApiIndexQuery;
import com.metaeffekt.mirror.query.NvdCveIndexQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class VulnerabilityTimelineGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityTimelineGenerator.class);
    private final Set<String> relevantVulnerabilities = new HashSet<String>();
    private final Set<Pair<String, String>> generateForVendorProducts = new HashSet<Pair<String, String>>();
    private final NvdCveIndexQuery vulnerabilityQuery;
    private final NvdCpeApiIndexQuery cpeDictionaryQuery;
    private final VulnerabilityAssessmentDashboardEnrichmentConfiguration vadConfiguration;
    private final CentralSecurityPolicyConfiguration centralSecurityPolicyConfiguration;
    private final CountdownTimer timelineGenerationTime;

    public VulnerabilityTimelineGenerator(NvdCveIndexQuery vulnerabilityQuery, NvdCpeApiIndexQuery cpeDictionaryQuery, VulnerabilityAssessmentDashboardEnrichmentConfiguration vadConfiguration, CentralSecurityPolicyConfiguration centralSecurityPolicyConfiguration) {
        this.vulnerabilityQuery = vulnerabilityQuery;
        this.cpeDictionaryQuery = cpeDictionaryQuery;
        this.vadConfiguration = vadConfiguration;
        this.centralSecurityPolicyConfiguration = centralSecurityPolicyConfiguration;
        this.timelineGenerationTime = new CountdownTimer((long)vadConfiguration.getMaximumTimeSpentOnTimelines() * 1000L);
    }

    public void addRelevantVulnerability(String vulnerabilityId) {
        this.relevantVulnerabilities.add(vulnerabilityId);
    }

    public void addRelevantVulnerabilities(Collection<Vulnerability> vulnerabilities) {
        for (Vulnerability vulnerability : vulnerabilities) {
            this.addRelevantVulnerability(vulnerability.getId());
        }
    }

    public void removeRelevantVulnerability(String vulnerabilityId) {
        this.relevantVulnerabilities.remove(vulnerabilityId);
    }

    public void addCpe(Cpe cpe) {
        this.generateForVendorProducts.add((Pair<String, String>)Pair.of((Object)cpe.getVendor(), (Object)cpe.getProduct()));
    }

    public void addCpe(Collection<Cpe> cpe) {
        cpe.forEach(this::addCpe);
    }

    public void addVendorProduct(String vendor, String product) {
        this.generateForVendorProducts.add((Pair<String, String>)Pair.of((Object)vendor, (Object)product));
    }

    public Set<String> getRelevantVulnerabilities() {
        return this.relevantVulnerabilities;
    }

    public Set<Pair<String, String>> getGenerateForVendorProducts() {
        return this.generateForVendorProducts;
    }

    public NvdCveIndexQuery getVulnerabilityQuery() {
        return this.vulnerabilityQuery;
    }

    public NvdCpeApiIndexQuery getCpeDictionaryQuery() {
        return this.cpeDictionaryQuery;
    }

    public VulnerabilityAssessmentDashboardEnrichmentConfiguration getVadConfiguration() {
        return this.vadConfiguration;
    }

    public CentralSecurityPolicyConfiguration getCentralSecurityPolicyConfiguration() {
        return this.centralSecurityPolicyConfiguration;
    }

    public CountdownTimer getTimelineGenerationTime() {
        return this.timelineGenerationTime;
    }

    public VulnerabilityTimelineGeneratorResult generate() {
        LOG.info("Generating [{}] timelines for [{}] relevant vulnerabilities", (Object)this.generateForVendorProducts.size(), (Object)this.relevantVulnerabilities.size());
        ArrayList<VulnerabilityTimeline> timelines = new ArrayList<VulnerabilityTimeline>();
        for (Pair<String, String> vendorProduct : this.generateForVendorProducts) {
            if (this.timelineGenerationTime.isEndReached()) {
                LOG.info("Maximum time spent on timeline generation reached. Skipping remaining timelines.");
                break;
            }
            if (vendorProduct.getLeft() == null || vendorProduct.getRight() == null) continue;
            timelines.add(new VulnerabilityTimeline((String)vendorProduct.getLeft(), (String)vendorProduct.getRight(), this));
        }
        return new VulnerabilityTimelineGeneratorResult(timelines);
    }

    public VulnerabilityTimelineGeneratorResult generate(ScheduledDelayedThreadPoolExecutor executor) {
        LOG.info("Generating [{}] timelines for [{}] relevant vulnerabilities", (Object)this.generateForVendorProducts.size(), (Object)this.relevantVulnerabilities.size());
        ArrayList<VulnerabilityTimeline> timelines = new ArrayList<VulnerabilityTimeline>();
        for (Pair<String, String> vendorProduct : this.generateForVendorProducts) {
            executor.submit(() -> {
                if (this.timelineGenerationTime.isEndReached()) {
                    LOG.info("Maximum time spent on timeline generation reached. Skipping timeline generation for [{}] [{}].", vendorProduct.getLeft(), vendorProduct.getRight());
                    return;
                }
                if (vendorProduct.getLeft() != null && vendorProduct.getRight() != null) {
                    VulnerabilityTimeline timeline = new VulnerabilityTimeline((String)vendorProduct.getLeft(), (String)vendorProduct.getRight(), this);
                    List list = timelines;
                    synchronized (list) {
                        timelines.add(timeline);
                    }
                }
            });
        }
        executor.start();
        try {
            executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread execution interrupted.", e);
        }
        return new VulnerabilityTimelineGeneratorResult(timelines);
    }
}

