/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation.validators;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.validation.ArtifactInventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import us.springett.parsers.cpe.Cpe;

public class AdditionalCpeIsNotEffectiveInventoryValidator
extends ArtifactInventoryValidator {
    @Override
    public List<InventoryValidationReason> validate(Inventory inventory, Artifact artifact) {
        ArrayList<InventoryValidationReason> validationFailReasons = new ArrayList<InventoryValidationReason>();
        List<Cpe> effectiveCpe = CommonEnumerationUtil.parseEffectiveCpe(artifact);
        List<Cpe> additionalCpe = CommonEnumerationUtil.parseCpes(artifact.get(InventoryAttribute.ADDITIONAL_CPE.getKey()));
        for (Cpe addCpe : additionalCpe) {
            boolean found = false;
            for (Cpe effCpe : effectiveCpe) {
                if (!CommonEnumerationUtil.compareCpeUsingWildcards(addCpe, effCpe)) continue;
                found = true;
                break;
            }
            if (found) continue;
            validationFailReasons.add(new InventoryValidationReason((AbstractModelBase)artifact, ReasonIdentifier.ADDITIONAL_CPE_NOT_EFFECTIVE, "Additional CPE URI '" + CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(addCpe) + "' is not contained in the effective CPE list."));
        }
        return validationFailReasons;
    }

    @Override
    public String getValidatorName() {
        return "Additional CPE is not effective";
    }

    @Override
    public LinkedHashMap<String, Object> getProperties() {
        return super.getProperties();
    }

    @Override
    public void setProperties(LinkedHashMap<String, Object> properties) {
    }
}

