/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityFilterEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Vulnerability Filtering", phase=InventoryEnrichmentPhase.INVENTORY_POST_PROCESSING, intermediateFileSuffix="vulnerability-filter", mavenPropertyName="vulnerabilityFilterEnrichment")
public class VulnerabilityFilterEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityFilterEnrichment.class);
    private VulnerabilityFilterEnrichmentConfiguration configuration = new VulnerabilityFilterEnrichmentConfiguration();

    public VulnerabilityFilterEnrichment(File baseMirrorDirectory) {
    }

    public VulnerabilityFilterEnrichment() {
    }

    public void setConfiguration(VulnerabilityFilterEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public VulnerabilityFilterEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        FilterAttribute filter = this.configuration.getVulnerabilityIncludeFilterAttribute();
        if (filter == null) {
            LOG.warn("No vulnerability filter configured, skipping enrichment [{}]", (Object)this.getEnrichmentName());
            return;
        }
        LOG.info("");
        LOG.info("Filtering vulnerabilities using {}", (Object)this.configuration.getVulnerabilityIncludeFilter());
        LOG.info("Parsed vulnerability filter: {}", (Object)filter);
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        vInventory.calculateEffectiveCvssVectorsForVulnerabilities(super.getSecurityPolicyConfiguration());
        int size = vInventory.getVulnerabilities().size();
        for (Vulnerability vulnerability : vInventory.getShallowCopyVulnerabilities()) {
            if (filter.matches(vulnerability)) continue;
            vInventory.remove(vulnerability);
        }
        vInventory.writeBack(true);
        LOG.info("Filtered vulnerabilities [{} - {} = {}]", new Object[]{size, size - inventory.getVulnerabilityMetaData().size(), inventory.getVulnerabilityMetaData().size()});
    }
}

