/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FunctionCallFilterAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcProductIndexQuery;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.SpanTag;
import j2html.tags.specialized.UlTag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityStatusPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityStatusPostProcessor.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[a-zA-Z0-9.]+}");
    private LazySupplier<GhsaAdvisorIndexQuery> ghsaAdvisorIndexQuery;
    private LazySupplier<MsrcProductIndexQuery> msrcProductIndexQuery;

    public void resolveVariablesHandler(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String string, Consumer<String> writeToConsumer) {
        this.resolveVariablesHandler(vInventory, vulnerability, string, writeToConsumer, null);
    }

    public void resolveVariablesHandler(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String string, Consumer<String> writeToConsumer, Function<String, String> variableContentEscapeFunction) {
        String resolvedString;
        if (string != null && (resolvedString = this.resolveVariables(vInventory, vulnerability, string, variableContentEscapeFunction)) != null && !resolvedString.equals(string)) {
            writeToConsumer.accept(resolvedString);
        }
    }

    private String resolveVariables(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String variableString, Function<String, String> variableContentEscapeFunction) {
        Set<String> variables = VulnerabilityStatusPostProcessor.extractVariables(variableString);
        Map<String, String> resolvedVariables = this.resolveVariableValues(vInventory, vulnerability, variables);
        return this.replaceVariables(variableString, resolvedVariables, variableContentEscapeFunction);
    }

    private Map<String, String> resolveVariableValues(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, Set<String> variables) {
        HashMap<String, String> resolvedVariables = new HashMap<String, String>();
        for (String variable : variables) {
            String resolvedValue = this.resolveVariable(vInventory, vulnerability, variable);
            if (resolvedValue == null) {
                log.warn("Unable to resolve variable: {}", (Object)variable);
                resolvedVariables.put(variable, "");
                continue;
            }
            resolvedVariables.put(variable, resolvedValue);
        }
        return resolvedVariables;
    }

    private String resolveVariable(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String variable) {
        String segment;
        String variableName = variable.substring(2, variable.length() - 1);
        String[] variableAccessPath = variableName.split("\\.");
        switch (segment = VulnerabilityStatusPostProcessor.getVariableAccessPath(variableAccessPath, 0)) {
            case "msrc": {
                return this.resolveMsrcVariable(vInventory, vulnerability, variableAccessPath);
            }
            case "vulnerability": {
                return this.resolveVulnerabilityVariable(vInventory, vulnerability, variableAccessPath);
            }
            case "artifact": {
                return this.resolveArtifactVariable(vInventory, vulnerability, variableAccessPath);
            }
            case "advisor": {
                return this.resolveAdvisorVariable(vInventory, vulnerability, variableAccessPath);
            }
            case "date": {
                return null;
            }
        }
        log.warn("Unable to resolve variable: {}", (Object)variable);
        return "";
    }

    private String resolveAdvisorVariable(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String[] variableAccessPath) {
        String segment;
        switch (segment = VulnerabilityStatusPostProcessor.getVariableAccessPath(variableAccessPath, 1)) {
            case "ids": {
                return String.valueOf(FunctionCallFilterAttribute.valueProviderVulnerability(vulnerability, "advisor-ids"));
            }
            case "providers": {
                return String.valueOf(FunctionCallFilterAttribute.valueProviderVulnerability(vulnerability, "advisor-providers"));
            }
            case "types": {
                return String.valueOf(FunctionCallFilterAttribute.valueProviderVulnerability(vulnerability, "advisor-types"));
            }
        }
        return null;
    }

    private String resolveArtifactVariable(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String[] variableAccessPath) {
        String segment = VulnerabilityStatusPostProcessor.getVariableAccessPath(variableAccessPath, 1);
        Set<Artifact> affectedArtifacts = vulnerability.getAffectedArtifactsByDefaultKey();
        if (segment.equals("id")) {
            return affectedArtifacts.stream().map(Artifact::getId).filter(Objects::nonNull).collect(Collectors.joining(", "));
        }
        return null;
    }

    private String resolveVulnerabilityVariable(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String[] variableAccessPath) {
        String segment = VulnerabilityStatusPostProcessor.getVariableAccessPath(variableAccessPath, 1);
        if (segment.equals("name")) {
            return vulnerability.getId();
        }
        return null;
    }

    private String resolveMsrcVariable(VulnerabilityContextInventory vInventory, Vulnerability vulnerability, String[] variableAccessPath) {
        if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 1, "product")) {
            Set<String> artifactProductIds = MsrcAdvisorEntry.getAllMsrcProductIds(vulnerability.getAffectedArtifactsByDefaultKey());
            if (!artifactProductIds.isEmpty()) {
                if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 2, "name")) {
                    return artifactProductIds.stream().map(id -> ((MsrcProductIndexQuery)this.msrcProductIndexQuery.get()).findProductByIdOrName((String)id)).map(MsrcProduct::getName).collect(Collectors.joining(", "));
                }
                if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 2, "id")) {
                    return String.join((CharSequence)", ", artifactProductIds);
                }
            }
        } else if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 1, "patch")) {
            JSONObject json;
            String fixingKbIdentifiers = vulnerability.getAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER);
            if (StringUtils.hasText(fixingKbIdentifiers)) {
                if (fixingKbIdentifiers.startsWith("{")) {
                    json = new JSONObject(fixingKbIdentifiers);
                } else {
                    json = new JSONObject();
                    json.put("", (Object)fixingKbIdentifiers);
                }
            } else {
                json = new JSONObject();
            }
            if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 2, "kblist")) {
                if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 3, "csv")) {
                    StringBuilder fixingProducts = new StringBuilder();
                    for (String productId : json.keySet()) {
                        JSONArray kbIds = json.getJSONArray(productId);
                        if (fixingProducts.length() > 0) {
                            fixingProducts.append("; ");
                        }
                        StringJoiner stringKbIds = new StringJoiner(", ");
                        for (int i = 0; i < kbIds.length(); ++i) {
                            stringKbIds.add(kbIds.getString(i));
                        }
                        if (StringUtils.hasText(productId)) {
                            fixingProducts.append(productId).append(": ");
                        }
                        fixingProducts.append(stringKbIds);
                    }
                    return fixingProducts.toString();
                }
                if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 3, "md")) {
                    StringJoiner fixingProducts = new StringJoiner("\n");
                    for (String productId : json.keySet()) {
                        JSONArray kbIds = json.getJSONArray(productId);
                        StringJoiner stringKbIds = new StringJoiner(", ");
                        for (int i = 0; i < kbIds.length(); ++i) {
                            String kbId = kbIds.getString(i);
                            String kbIdLink = String.format("([MS Support](https://support.microsoft.com/en-us/help/%s), [Update Catalog](https://catalog.update.microsoft.com/Search.aspx?q=KB%s))", kbId, kbId);
                            stringKbIds.add(kbId + " " + kbIdLink);
                        }
                        fixingProducts.add("- **" + productId + "**: " + stringKbIds);
                    }
                    return fixingProducts.toString();
                }
                if (VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 3, "html")) {
                    UlTag list = TagCreator.ul();
                    for (String productId : json.keySet()) {
                        JSONArray kbIds = json.getJSONArray(productId);
                        if (kbIds.isEmpty()) continue;
                        SpanTag spanKbIds = TagCreator.span((DomContent[])new DomContent[]{TagCreator.b((String)productId), TagCreator.text((String)": ")});
                        for (int i = 0; i < kbIds.length(); ++i) {
                            String kbId = kbIds.getString(i);
                            ATag msSupportLink = (ATag)TagCreator.a((String)"MS Support").withHref("https://support.microsoft.com/en-us/help/" + kbId);
                            ATag updateCatalogLink = (ATag)TagCreator.a((String)"Update Catalog").withHref("https://catalog.update.microsoft.com/Search.aspx?q=KB" + kbId);
                            ((SpanTag)((SpanTag)((SpanTag)((SpanTag)spanKbIds.withText(kbId + " (")).with((DomContent)msSupportLink)).withText(", ")).with((DomContent)updateCatalogLink)).withText(")");
                            if (i >= kbIds.length() - 1) continue;
                            spanKbIds.withText(", ");
                        }
                        list.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{spanKbIds}));
                    }
                    return list.render();
                }
            }
        }
        return null;
    }

    private List<Artifact> findAffectedArtifacts(Inventory inventory, VulnerabilityMetaData vmd) {
        return inventory.getArtifacts().stream().filter(artifact -> InventoryEnricher.splitVulnerabilitiesCsv(artifact.getVulnerability()).contains(vmd.get(VulnerabilityMetaData.Attribute.NAME))).collect(Collectors.toList());
    }

    public static boolean isVariableAccessPathPrefix(String[] parts, int offset, String ... check) {
        if (parts.length < offset + check.length) {
            return false;
        }
        for (int i = 0; i < check.length; ++i) {
            if (parts[offset + i].equals(check[i])) continue;
            return false;
        }
        return true;
    }

    public static String getVariableAccessPath(String[] parts, int offset) {
        return parts.length <= offset ? "" : parts[offset];
    }

    private String replaceVariables(String string, Map<String, String> resolvedVariables, Function<String, String> variableContentEscapeFunction) {
        String resolvedString = string;
        for (Map.Entry<String, String> resolvedVariable : resolvedVariables.entrySet()) {
            resolvedString = resolvedString.replace(resolvedVariable.getKey(), variableContentEscapeFunction != null ? (CharSequence)variableContentEscapeFunction.apply(resolvedVariable.getValue()) : (CharSequence)resolvedVariable.getValue());
        }
        return resolvedString;
    }

    public static String escapeJsonContent(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static Set<String> extractVariables(String string) {
        Matcher matcher = VARIABLE_PATTERN.matcher(string);
        HashSet<String> variables = new HashSet<String>();
        while (matcher.find()) {
            variables.add(matcher.group());
        }
        return variables;
    }

    public void setGhsaAdvisorIndexQuery(LazySupplier<GhsaAdvisorIndexQuery> ghsaAdvisorIndexQuery) {
        this.ghsaAdvisorIndexQuery = ghsaAdvisorIndexQuery;
    }

    public void setMsrcProductIndexQuery(LazySupplier<MsrcProductIndexQuery> msrcProductIndexQuery) {
        this.msrcProductIndexQuery = msrcProductIndexQuery;
    }
}

