/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.vulnerability.ghsa.matchers;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.enrichment.vulnerability.ghsa.GhsaArtifactVulnerabilityMatcher;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import java.util.Map;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class MavenGhsaMatcher
extends GhsaArtifactVulnerabilityMatcher {
    public MavenGhsaMatcher(GhsaAdvisorIndexQuery ghsaQuery, boolean githubReviewed) {
        super(ghsaQuery, githubReviewed);
    }

    @Override
    public Map<GhsaAdvisorEntry, DataSourceIndicator> match(Artifact artifact) {
        artifact.deriveArtifactId();
        String artifactId = this.effectiveArtifactId(artifact.getArtifactId(), artifact.getGroupId());
        String groupId = artifact.getGroupId();
        Version version = Version.of(artifact.getVersion(), VersionContext.fromArtifact(artifact));
        return this.ghsaQuery.findByVsMaven(artifact, groupId, artifactId, version, this.githubReviewed);
    }

    private String effectiveArtifactId(String artifactId, String groupId) {
        if (StringUtils.isEmpty(artifactId) || StringUtils.isEmpty(groupId)) {
            return artifactId;
        }
        if (artifactId.startsWith(groupId + ".")) {
            return artifactId.substring(groupId.length() + 1);
        }
        return artifactId;
    }

    @Override
    public boolean mayMatch(Artifact artifact) {
        return StringUtils.hasText(artifact.getId()) && StringUtils.hasText(artifact.getVersion());
    }
}

