/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.extractors.configuration;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.extractors.configuration.ExtractorConfiguration;
import java.io.File;
import java.io.IOException;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtractorConfiguration
extends ExtractorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExtractorConfiguration.class);
    private final String id;
    private final File resultInventoryFile;

    protected AbstractExtractorConfiguration(String id, File resultInventoryFile) {
        this.id = id;
        this.resultInventoryFile = resultInventoryFile;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public File getResultInventoryFile() {
        return this.resultInventoryFile;
    }

    protected void addToInventory(Inventory sourceInventory, Inventory aggregatedInventory) {
        for (Artifact artifact : sourceInventory.getArtifacts()) {
            Artifact referenceArtifact = !StringUtils.isEmpty(artifact.getChecksum()) ? aggregatedInventory.findArtifactByIdAndChecksum(artifact.getId(), artifact.getChecksum()) : aggregatedInventory.findArtifact(artifact.getId());
            if (referenceArtifact != null) {
                for (String attribute : artifact.getAttributes()) {
                    if (referenceArtifact.get(attribute) != null) continue;
                    referenceArtifact.set(attribute, artifact.get(attribute));
                }
                continue;
            }
            aggregatedInventory.getArtifacts().add(artifact);
        }
        aggregatedInventory.getAssetMetaData().addAll(sourceInventory.getAssetMetaData());
    }

    @Override
    public abstract void contribute(File var1, Inventory var2) throws IOException;

    protected File exist(File file) {
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public void validate() {
        FileUtils.validateExists((File)this.getResultInventoryFile());
    }
}

