/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.utils.ConfigurationDiscovery;
import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TermsMetaDataResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TermsMetaDataResolver.class);
    private static final TermsMetaDataResolver INSTANCE = new TermsMetaDataResolver();
    private NormalizationMetaData normalizationMetaData;

    private TermsMetaDataResolver() {
        this.discover();
    }

    private void discover() {
        try {
            Properties p = ConfigurationDiscovery.discoverLocalProperties();
            File termsMetadataPath = new File(p.getProperty("ae.terms.metadata.path"));
            this.normalizationMetaData = new NormalizationMetaData(termsMetadataPath);
        }
        catch (Exception e) {
            LOG.error("Cannot resolve terms metadata. Cannot complete initialize.", (Throwable)e);
        }
    }

    public static NormalizationMetaData get() {
        return TermsMetaDataResolver.INSTANCE.normalizationMetaData;
    }
}

