/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchPreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(MatchPreprocessor.class);
    private static final Pattern PATTERN_NEWLINE_MARKER = Pattern.compile("NEWLINE-MARKER");
    private static final Pattern PATTERN_EMPTY_LINE_MARKER = Pattern.compile("EMPTY-LINE-MARKER");
    private static final Pattern PATTERN_COLON_MARKER = Pattern.compile("COLON-MARKER");
    private static final Pattern PATTERN_WHITESPACE_MARKER = Pattern.compile("\\s+");
    private static final Pattern PATTERN_FILE_SEGMENT_MARKER = Pattern.compile("FILE-SEGMENT-MARKER");
    private static final Pattern PATTERN_LICENSES_SEGMENT_MARKER = Pattern.compile("LICENSE-SEGMENT-MARKER");
    private final NormalizationMetaData normalizationMetaData;

    public MatchPreprocessor(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    public String removeMarkers(String text) {
        text = PATTERN_NEWLINE_MARKER.matcher(text).replaceAll(" ");
        text = PATTERN_EMPTY_LINE_MARKER.matcher(text).replaceAll("");
        text = PATTERN_COLON_MARKER.matcher(text).replaceAll(":");
        text = PATTERN_WHITESPACE_MARKER.matcher(text).replaceAll(" ");
        return text;
    }

    public String removeMarkersForReadability(String text) {
        text = PATTERN_NEWLINE_MARKER.matcher(text).replaceAll("\n");
        text = PATTERN_EMPTY_LINE_MARKER.matcher(text).replaceAll("");
        text = PATTERN_COLON_MARKER.matcher(text).replaceAll(":");
        text = PATTERN_WHITESPACE_MARKER.matcher(text).replaceAll(" ");
        return text;
    }

    public List<String> applySegments(String fileContent) {
        String[] fileContexts;
        ArrayList<String> licenseContextList = new ArrayList<String>();
        for (String fileContext : fileContexts = PATTERN_FILE_SEGMENT_MARKER.split(fileContent)) {
            String[] localLicenseContext = PATTERN_LICENSES_SEGMENT_MARKER.split(fileContext);
            licenseContextList.addAll(Arrays.asList(localLicenseContext));
        }
        return licenseContextList;
    }

    public NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }
}

