/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.terms.model.MatchItem;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.InventoryUtils;

public class ScanResultPart {
    private List<TermsMetaData> matches = new ArrayList<TermsMetaData>();
    private List<TermsMetaData> nameMatches = new ArrayList<TermsMetaData>();
    private List<TermsMetaData> licenseMatches = new ArrayList<TermsMetaData>();
    private List<TermsMetaData> partialMatches = new ArrayList<TermsMetaData>();
    private List<TermsMetaData> excludedMatches = new ArrayList<TermsMetaData>();
    private List<MatchItem> matchItems = new ArrayList<MatchItem>();

    public void filterUnspecific() {
        Set coveredCategories = this.matches.stream().filter(lmd -> !lmd.isUnspecific()).map(TermsMetaData::getCategory).collect(Collectors.toSet());
        Set toBeRemoved = this.matches.stream().filter(lmd -> lmd.isUnspecific()).filter(lmd -> coveredCategories.contains(lmd.getCategory())).collect(Collectors.toSet());
        this.matches.removeAll(toBeRemoved);
    }

    public void filterSpecific() {
        Set coveredCategories = this.matches.stream().filter(lmd -> lmd.allowLaterVersions()).map(TermsMetaData::getCanonicalName).collect(Collectors.toSet());
        Set toBeRemoved = this.matches.stream().filter(lmd -> !lmd.allowLaterVersions()).filter(lmd -> coveredCategories.contains(lmd.getCanonicalName() + " (or any later version)")).collect(Collectors.toSet());
        this.matches.removeAll(toBeRemoved);
    }

    public void filterUnnamed() {
        Set coveredLicenses = this.matches.stream().map(lmd -> lmd.getNamedEquivalence()).filter(Objects::nonNull).collect(Collectors.toSet());
        Set toBeRemoved = this.matches.stream().filter(lmd -> coveredLicenses.contains(lmd.getCanonicalName())).collect(Collectors.toSet());
        this.matches.removeAll(toBeRemoved);
    }

    public void filterConflicts(String category) {
        Boolean licenseMatchCategory = false;
        for (TermsMetaData licenseMatch : this.licenseMatches) {
            if (!licenseMatch.getCategory().equals(category)) continue;
            licenseMatchCategory = true;
        }
        if (licenseMatchCategory.booleanValue()) {
            for (TermsMetaData nameMatch : this.nameMatches) {
                if (!nameMatch.getCategory().equals(category) || this.licenseMatches.contains(nameMatch)) continue;
                this.matches.remove(nameMatch);
            }
        }
    }

    public List<String> getMatchedTerms() {
        return this.matches.stream().filter(lmd -> !this.excludedMatches.contains(lmd)).map(TermsMetaData::getCanonicalName).collect(Collectors.toList());
    }

    public List<String> getNameMatchedTerms() {
        return this.nameMatches.stream().filter(lmd -> !this.excludedMatches.contains(lmd)).map(TermsMetaData::getCanonicalName).collect(Collectors.toList());
    }

    public List<String> getTextMatchedTerms() {
        return this.licenseMatches.stream().filter(lmd -> !this.excludedMatches.contains(lmd)).map(TermsMetaData::getCanonicalName).collect(Collectors.toList());
    }

    public List<String> getPartialMatchedTerms() {
        return this.partialMatches.stream().distinct().map(TermsMetaData::getCanonicalName).sorted(String::compareTo).collect(Collectors.toList());
    }

    public List<String> getExcludeMatchedLicenses() {
        return this.excludedMatches.stream().distinct().map(TermsMetaData::getCanonicalName).sorted(String::compareTo).collect(Collectors.toList());
    }

    public void cleanExcludedMatches() {
        this.excludedMatches.clear();
    }

    public void cleanLicenseMatches() {
        this.licenseMatches.clear();
    }

    private void addMatch(TermsMetaData licenseMetaData) {
        if (!this.matches.contains(licenseMetaData)) {
            this.matches.add(licenseMetaData);
        }
    }

    public void addNameMatch(TermsMetaData licenseMetaData) {
        if (!this.matches.contains(licenseMetaData)) {
            this.matches.add(licenseMetaData);
        }
        if (!this.nameMatches.contains(licenseMetaData)) {
            this.nameMatches.add(licenseMetaData);
        }
    }

    public void addLicenseMatch(TermsMetaData licenseMetaData) {
        if (!this.matches.contains(licenseMetaData)) {
            this.matches.add(licenseMetaData);
        }
        if (!this.licenseMatches.contains(licenseMetaData)) {
            this.licenseMatches.add(licenseMetaData);
        }
    }

    public synchronized void merge(ScanResultPart other) {
        for (TermsMetaData licenseMetaData : other.matches) {
            this.addMatch(licenseMetaData);
        }
        for (TermsMetaData licenseMetaData : other.licenseMatches) {
            this.addLicenseMatch(licenseMetaData);
        }
        for (TermsMetaData licenseMetaData : other.nameMatches) {
            this.addNameMatch(licenseMetaData);
        }
        for (TermsMetaData licenseMetaData : other.partialMatches) {
            this.addPartialMatch(licenseMetaData);
        }
        for (TermsMetaData licenseMetaData : other.excludedMatches) {
            this.addExcludedMatch(licenseMetaData);
        }
        this.matchItems.addAll(other.getMatchItems());
    }

    public void filterIgnored() {
        Set toBeRemoved = this.matches.stream().filter(lmd -> lmd.ignore()).collect(Collectors.toSet());
        this.matches.removeAll(toBeRemoved);
    }

    public void process(NormalizationMetaData normalizationMetaData, boolean enableIgnore, boolean enableCombine) {
        String[] categories;
        HashSet<TermsMetaData> toBeRemovedLmds = new HashSet<TermsMetaData>();
        for (String cat : categories = new String[]{"BSD"}) {
            this.filterConflicts(cat);
        }
        if (enableCombine) {
            this.combine(normalizationMetaData, toBeRemovedLmds);
        }
        if (enableIgnore) {
            this.filterIgnored();
        }
        if (enableCombine) {
            this.combine(normalizationMetaData, toBeRemovedLmds);
        }
        this.filterUnnamed();
        if (enableCombine) {
            this.combine(normalizationMetaData, toBeRemovedLmds);
        }
        this.filterSpecific();
        this.filterUnspecific();
        if (enableCombine) {
            this.combine(normalizationMetaData, toBeRemovedLmds);
            this.combine(normalizationMetaData, toBeRemovedLmds);
            this.combine(normalizationMetaData, toBeRemovedLmds);
        }
        this.matches.removeAll(toBeRemovedLmds);
        if (enableCombine) {
            Map<String, Set<String>> map = this.buildCategoryMap(normalizationMetaData);
            this.filterUnspecificFromCategoryMap(normalizationMetaData, map);
            this.resolveSpecificInMultiLicenseExpressions(normalizationMetaData, map, false);
            this.resolveSpecificInMultiLicenseExpressions(normalizationMetaData, map, true);
        }
    }

    protected void resolveSpecificInMultiLicenseExpressions(NormalizationMetaData normalizationMetaData, Map<String, Set<String>> map, boolean resolveAny) {
        HashSet<TermsMetaData> toBeRemovedLmds = new HashSet<TermsMetaData>();
        HashSet<TermsMetaData> toBeAddedLmds = new HashSet<TermsMetaData>();
        Set noMarkerMatches = this.matches.stream().filter(lmd -> !lmd.isMarker()).collect(Collectors.toSet());
        for (TermsMetaData lmd2 : this.matches) {
            boolean replacement = false;
            String canonicalName = lmd2.getCanonicalName();
            if (!canonicalName.contains(" + ")) continue;
            List parts = InventoryUtils.tokenizeLicense((String)lmd2.getCanonicalName(), (boolean)true, (boolean)false);
            ArrayList<TermsMetaData> partLicenseMetaData = new ArrayList<TermsMetaData>();
            for (String part : parts) {
                TermsMetaData licenseMetaData = normalizationMetaData.getTermsMetaData(part);
                if (licenseMetaData != null && licenseMetaData.isUnspecific()) {
                    Set<String> representatives = map.get(licenseMetaData.getCategory());
                    if (representatives != null && representatives.size() == 1) {
                        String representative = representatives.iterator().next();
                        canonicalName = canonicalName.replace(part + " +", representative + " +");
                        canonicalName = canonicalName.replace("+ " + part, "+ " + representative);
                        replacement = true;
                        TermsMetaData representativeLmd = normalizationMetaData.getTermsMetaData(representative);
                        if (representativeLmd != null) {
                            partLicenseMetaData.add(representativeLmd);
                        }
                    }
                } else if (licenseMetaData == null && "ANY".equals(part) && noMarkerMatches.size() == 2) {
                    HashSet representativeSet = new HashSet(noMarkerMatches);
                    representativeSet.remove(lmd2);
                    TermsMetaData representativeLmd = (TermsMetaData)representativeSet.iterator().next();
                    String representative = representativeLmd.getCanonicalName();
                    canonicalName = canonicalName.replace(part + " +", representative + " +");
                    canonicalName = canonicalName.replace("+ " + part, "+ " + representative);
                    replacement = true;
                    partLicenseMetaData.remove(representativeLmd);
                }
                if (licenseMetaData == null) continue;
                partLicenseMetaData.add(licenseMetaData);
            }
            if (replacement) {
                toBeRemovedLmds.add(lmd2);
                toBeAddedLmds.add(this.findOrCreateLicenseMetaData(normalizationMetaData, true, canonicalName));
            }
            toBeRemovedLmds.addAll(partLicenseMetaData);
        }
        this.matches.removeAll(toBeRemovedLmds);
        this.matches.addAll(toBeAddedLmds);
        this.removeLicenseOptionIfUnique(this.matches, normalizationMetaData);
    }

    private void removeLicenseOptionIfUnique(List<TermsMetaData> licenseMetaDataList, NormalizationMetaData normalizationMetaData) {
        Set names = licenseMetaDataList.stream().filter(lmd -> !lmd.isMarker()).map(l -> l.getCanonicalName()).collect(Collectors.toSet());
        long optionCount = names.stream().filter(n -> n.contains(" + ")).count();
        if (optionCount == 1L) {
            licenseMetaDataList.remove(normalizationMetaData.getTermsMetaData("Licensing Option"));
        }
    }

    protected void filterUnspecificFromCategoryMap(NormalizationMetaData normalizationMetaData, Map<String, Set<String>> map) {
        block0: for (Set<String> representatives : map.values()) {
            if (representatives.size() <= 1) continue;
            for (String cn : representatives) {
                TermsMetaData licenseMetaData = normalizationMetaData.getTermsMetaData(cn);
                if (!licenseMetaData.isUnspecific()) continue;
                representatives.remove(cn);
                continue block0;
            }
        }
    }

    protected Map<String, Set<String>> buildCategoryMap(NormalizationMetaData normalizationMetaData) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (TermsMetaData lmd : this.matches) {
            List parts = InventoryUtils.tokenizeLicense((String)lmd.getCanonicalName(), (boolean)true, (boolean)false);
            for (String part : parts) {
                TermsMetaData licenseMetaData = normalizationMetaData.getTermsMetaData(part);
                if (licenseMetaData == null) continue;
                map.computeIfAbsent(licenseMetaData.getCategory(), k -> new HashSet()).add(part);
            }
        }
        return map;
    }

    public void combine(NormalizationMetaData normalizationMetaData, Set<TermsMetaData> toBeRemoved) {
        ArrayList<TermsMetaData> toBeAdded = new ArrayList<TermsMetaData>();
        for (TermsMetaData lmd : this.matches) {
            if (lmd.getCombinedWith() == null) continue;
            for (Map.Entry<String, String> combinerEntry : lmd.getCombinedWith().entrySet()) {
                List<TermsMetaData> combinerBaseLmds = this.mapLicenseMetaData(combinerEntry.getKey(), normalizationMetaData, false);
                List<TermsMetaData> combinerTargetLmds = this.mapLicenseMetaData(combinerEntry.getValue(), normalizationMetaData, true);
                if (combinerBaseLmds.isEmpty()) {
                    throw new IllegalStateException("Cannot find base license meta data for combiner: " + combinerEntry);
                }
                if (!this.matches.containsAll(combinerBaseLmds)) continue;
                toBeRemoved.addAll(combinerBaseLmds);
                toBeRemoved.add(lmd);
                toBeAdded.addAll(combinerTargetLmds);
                toBeRemoved.removeAll(combinerTargetLmds);
            }
        }
        toBeAdded.removeAll(this.matches);
        for (TermsMetaData toAdd : toBeAdded) {
            if (this.matches.contains(toAdd)) continue;
            this.matches.add(toAdd);
        }
    }

    protected List<TermsMetaData> mapLicenseMetaData(String combiner, NormalizationMetaData normalizationMetaData, boolean allowCreate) {
        String[] targets;
        ArrayList<TermsMetaData> combinerTargetLmds = new ArrayList<TermsMetaData>();
        for (String combinerTargetName : targets = combiner.split(",")) {
            TermsMetaData combinerTarget = this.findOrCreateLicenseMetaData(normalizationMetaData, allowCreate, combinerTargetName);
            if (combinerTarget == null) continue;
            combinerTargetLmds.add(combinerTarget);
        }
        return combinerTargetLmds;
    }

    private TermsMetaData findOrCreateLicenseMetaData(NormalizationMetaData normalizationMetaData, boolean allowCreate, String combinerTargetName) {
        TermsMetaData combinerTarget = normalizationMetaData.getTermsMetaData(combinerTargetName.trim());
        if (combinerTarget == null && allowCreate) {
            combinerTarget = new TermsMetaData();
            combinerTarget.setCanonicalName(combinerTargetName);
            combinerTarget.setCategory(combinerTargetName);
        }
        return combinerTarget;
    }

    public void addPartialMatch(TermsMetaData licenseMetaData) {
        this.partialMatches.add(licenseMetaData);
    }

    public void addExcludedMatch(TermsMetaData licenseMetaData) {
        this.excludedMatches.add(licenseMetaData);
    }

    public void addMatchItem(MatchItem matchItem) {
        this.matchItems.add(matchItem);
    }

    public List<MatchItem> getMatchItems() {
        return this.matchItems;
    }

    public void addMatchItems(List<MatchItem> unmatchedMatchItems) {
        this.matchItems.addAll(unmatchedMatchItems);
    }

    public List<TermsMetaData> getMatches() {
        return this.matches;
    }
}

