/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.terms.model;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.analysis.utils.SimpleIntPair;
import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.Evidence;
import com.metaeffekt.artifact.terms.model.FileSegment;
import com.metaeffekt.artifact.terms.model.FileSegmentation;
import com.metaeffekt.artifact.terms.model.Grant;
import com.metaeffekt.artifact.terms.model.Masks;
import com.metaeffekt.artifact.terms.model.MatchItem;
import com.metaeffekt.artifact.terms.model.MatchSet;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.Obligation;
import com.metaeffekt.artifact.terms.model.Reference;
import com.metaeffekt.artifact.terms.model.ScanResultPart;
import com.metaeffekt.artifact.terms.model.Segmentation;
import com.metaeffekt.artifact.terms.model.SortedProperties;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.representer.Representer;

public class TermsMetaData
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(TermsMetaData.class);
    public static final String TYPE_MARKER = "marker";
    public static final String TYPE_EXCEPTION = "exception";
    public static final String TYPE_EXPRESSION = "expression";
    public static final String TYPE_REFERENCE = "reference";
    public static final String STATUS_NOT_APPROVED = "not approved";
    public static final String STATUS_APPROVED = "approved";
    public static final String STATUS_APPROVED_IMPLICIT = "(approved)";
    public static final Comparator<TermsMetaData> COMPARATOR = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.canonicalName, o2.canonicalName);
    private String canonicalName;
    private String category;
    private List<String> alternativeNames;
    private String url;
    private String type;
    private transient String licenseFile;
    private transient String readmeFile;
    private transient File file;
    private transient Set<String> namesAndReferences;
    private Evidence evidence;
    private Map<String, Reference> references;
    private String spdxIdentifier;
    private String spdxExpression;
    private String shortName;
    private Set<String> alternativeShortNames;
    private List<String> otherIds;
    private Map<String, String> combinedWith;
    private String namedEquivalence;
    private boolean unspecific;
    private boolean allowsLaterVersions;
    private final List<Reference> referenceList = new ArrayList<Reference>();
    private boolean ignore;
    private Masks masks;
    private Map<String, Grant> grants;
    private List<String> ignoreMatches;
    private List<String> comments;
    private String defaultSourceCategory;
    private boolean requiresAnnexNotice = true;
    private boolean requiresSourceCodeProvision = false;
    private boolean articleRequired = true;
    private String representedAs;
    private String licenseTemplate;
    private boolean requiresNote = false;
    private Boolean requiresCopyright;
    private boolean temporaryLMD = false;
    private Boolean requiresLicenseText;
    private String licenseTextRequirements;
    private List<String> status = new ArrayList<String>();
    private List<String> canonicalNameHistory = new ArrayList<String>();
    private HashMap<String, String> standardVariableSet = new HashMap();
    private boolean expressiveEvidence;
    private boolean deprecated;
    private String displayName;
    private String baseTerms;
    private boolean missingCopyrightNotAllowed;
    private List<String> noteChecklist;
    private String noticeTemplateId;
    private List<String> expectedSpdxMatches;
    private List<String> expectedMatches;
    private List<String> mappingOrder;
    private Map<String, String> mappings;
    private String classification;
    private Segmentation segmentation;
    private NormalizationMetaData normalizationMetaData = null;
    private List<String> partialMatches = null;
    private List<String> matchedMarkers = null;
    private List<String> excludedMatches = null;
    private String openCoDEStatus;
    private String openCoDESimilarLicenseId;
    private String osiStatus;
    private String osiCategory;
    private String osiRationale;
    private String osiSupersededBy;
    private Boolean publiclyAvailable;
    final Set<String> otherIdsFilter = new HashSet<String>(Arrays.asList("scancode:other-permissive", "scancode:unknown", "scancode:proprietary-license"));
    private static final String TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n<title>${canonicalName}</title>\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n<script>\nfunction allOn() {\n  ${onScript}\n}\nfunction allOff() {\n  ${offScript}\n}\nfunction toggle(matchNum) {\n  id='match-' + matchNum;\n  btnId='btn-' + matchNum;\n  if (document.getElementById(id).style.display == \"block\") {\n    document.getElementById(id).style.display = \"none\";\n    document.getElementById(btnId).style.backgroundColor = \"rgb(200,128,128)\";\n  } else {\n    document.getElementById(id).style.display = \"block\";\n    document.getElementById(btnId).style.backgroundColor = \"rgb(128,200,128)\";\n  }\n}\n</script>\n<style>\n.report{\n  position: absolute;\n  top: 0;\n  left: 50%;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  margin: 10px 10px 10px 10px;\n  font-family: Arial;\n  overflow-y: scroll;}\n.top{\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 50%;\n  bottom: 0;\n  z-index: 1;\n  overflow-y: scroll;  margin: 10px 10px 10px 10px;\n  font-family: Arial;\n}\n.base{\n  position: absolute;\n  top: 55pt;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n}\n.overlay {\n  position: absolute;\n  top: 55pt;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 2;\n color: rgba(255,255,255,0.0)}\n.tg  {border-collapse:collapse;border-spacing:0;}\n.tg td{font-family:Arial, sans-serif;font-size:14px;padding:10px 5px;border-style:solid;border-width:1px;overflow:hidden;word-break:normal;border-color:black;}\n.tg th{font-family:Arial, sans-serif;font-size:14px;font-weight:normal;padding:10px 5px;border-style:solid;border-width:1px;overflow:hidden;word-break:normal;border-color:black;}\n.tg .tg-0lax{text-align:left;vertical-align:top}\n</style>\n</head>\n<body>\n<div class=\"top\"><h2>License Text / Evaluated Text</h2><div class=\"base\">${licenseText}</div>${marker}\n</div><div class=\"report\">${matchedTableTemplate}\n${matchTemplate}\n</div>\n</body>\n</html>";
    public static final String MATCHES_TABLE = "<h2>All Matches</h2><table class=\"tg\">\n  <col width=\"4%\">\n  <col width=\"20%\">\n  <col width=\"70%\">\n  <col width=\"4%\">\n  <tr>\n    <th class=\"tg-0lax\">Number</th>\n    <th class=\"tg-0lax\">Canonical Name</th>\n    <th class=\"tg-0lax\">Match Text</th>\n    <th class=\"tg-0lax\"><button onclick='allOn()'>All On</button><button onclick='allOff()'>All Off</button></th>\n  </tr>\n  ${row}</table>";
    public static final String MATCHED_TABLE = "<h2>Full Matches / Partial Matches</h2><table class=\"tg\">\n  <col width=\"4%\">\n  <col width=\"20%\">\n  <col width=\"70%\">\n  <col width=\"4%\">\n  <tr>\n    <th class=\"tg-0lax\">Number</th>\n    <th class=\"tg-0lax\">Canonical Name</th>\n    <th class=\"tg-0lax\">Match Type / Match Text</th>\n    <th class=\"tg-0lax\"><button onclick='allOn()'>All On</button><button onclick='allOff()'>All Off</button></th>\n  </tr>\n  ${matchedRow}</table>";
    public static final String ROW_PATTERN = "  <tr>\n    <td class=\"tg-0lax\">${number}</td>\n    <td class=\"tg-0lax\">${canonicalName}</td>\n    <td class=\"tg-0lax\">${matchContext}<br>${matchText}<br>${matchType}${matchError}</td>\n    <td class=\"tg-0lax\">${onOff}</td>\n  </tr>\n${row}";
    public static final String MATCHED_ROW_PATTERN = "  <tr>\n    <td class=\"tg-0lax\">${number}</td>\n    <td class=\"tg-0lax\">${canonicalName}</td>\n    <td class=\"tg-0lax\">${matchContext}<br>${matchText}<br>${matchType}${matchError}</td>\n    <td class=\"tg-0lax\">${onOff}</td>\n  </tr>\n${matchedRow}";
    public static final Representer YAML_REPRESENTER = new Representer(new DumperOptions()){
        public static final String ATTRIBUTE_NAME = "name";

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode mappingNode = super.representJavaBean(properties, javaBean);
            NodeTuple nameNodeTuple = null;
            HashSet<NodeTuple> disposableNodes = new HashSet<NodeTuple>();
            for (NodeTuple nodeTuple : mappingNode.getValue()) {
                ScalarNode svn;
                Node valueNode;
                Node keyNode = nodeTuple.getKeyNode();
                if (!(keyNode instanceof ScalarNode)) continue;
                ScalarNode sn = (ScalarNode)keyNode;
                if (ATTRIBUTE_NAME.equals(sn.getValue())) {
                    nameNodeTuple = nodeTuple;
                }
                if ((valueNode = nodeTuple.getValueNode()) instanceof ScalarNode) {
                    svn = (ScalarNode)valueNode;
                    if (svn.getValue() == null || svn.getValue().equals("null")) {
                        disposableNodes.add(nodeTuple);
                    } else {
                        if (svn.getValue().equals("false")) {
                            disposableNodes.add(nodeTuple);
                        }
                        if ("articleRequired".equals(sn.getValue())) {
                            disposableNodes.add(nodeTuple);
                        }
                    }
                }
                if (valueNode instanceof SequenceNode && ((svn = (SequenceNode)valueNode).getValue() == null || svn.getValue().isEmpty())) {
                    disposableNodes.add(nodeTuple);
                }
                if (!(valueNode instanceof MappingNode) || (svn = (MappingNode)valueNode).getValue() != null && !svn.getValue().isEmpty()) continue;
                disposableNodes.add(nodeTuple);
            }
            if (nameNodeTuple != null) {
                mappingNode.getValue().remove(nameNodeTuple);
                mappingNode.getValue().add(0, nameNodeTuple);
            }
            mappingNode.getValue().removeAll(disposableNodes);
            return mappingNode;
        }
    };

    public String getCategory() {
        if (this.category == null) {
            return this.getCanonicalName();
        }
        return this.category;
    }

    public List<String> getAlternativeNames() {
        if (this.alternativeNames == null) {
            this.alternativeNames = new ArrayList<String>();
        }
        return this.alternativeNames;
    }

    public Boolean getExpressiveEvidence() {
        return this.expressiveEvidence;
    }

    public void setExpressiveEvidence(Boolean expressiveEvidence) {
        this.expressiveEvidence = expressiveEvidence;
    }

    public boolean hasVariables() {
        return this.getLicenseTemplate() != null && this.getLicenseTemplate().contains("{{");
    }

    public void validate(boolean updateMatchReports) throws IOException {
        if (this.canonicalName.contains(",")) {
            throw new IllegalStateException("Canonical name must not contain ',': " + this.canonicalName);
        }
        if (this.ignore()) {
            LOG.info("Skipped ignored license meta data [{}].", (Object)this.getCanonicalName());
            return;
        }
        this.validateLicenseFile(updateMatchReports);
    }

    protected void validateVariants(boolean updateMatchReports) throws IOException {
        File variantsFolder;
        if (this.getFile() != null && (variantsFolder = new File(this.getFile().getParentFile(), "variants")).exists()) {
            String[] variantFiles;
            for (String variantFile : variantFiles = FileUtils.scanDirectoryForFiles((File)variantsFolder, (String[])new String[]{"**/*"})) {
                String licenseVariant = FileUtils.readFileToString((File)new File(variantsFolder, variantFile), (String)"UTF-8");
                this.validate(licenseVariant, "Variant " + variantFile, false);
            }
        }
    }

    protected void validateLicenseFile(boolean updateMatchReports) throws IOException {
        if (this.getLicenseFile() != null) {
            LOG.debug("Scanning license file: {}", (Object)this.getLicenseFile());
            File licenseFile = new File(this.getLicenseFile());
            String license = FileUtils.readFileToString((File)licenseFile, (String)"UTF-8");
            this.validate(license, "Reference License " + licenseFile.getName(), updateMatchReports);
        } else {
            if (this.getCanonicalName().endsWith(" (undefined)")) {
                return;
            }
            if (this.getCanonicalName().endsWith(" (or any later version)")) {
                return;
            }
            if (this.ignore()) {
                return;
            }
            if (this.isMarker()) {
                return;
            }
            if (this.isExpression()) {
                return;
            }
            LOG.warn("No license text for license meta data: [{}]", (Object)this.getCanonicalName());
        }
    }

    protected void validate(String license, String validationContext, boolean updateMatchReports) throws IOException {
        File file;
        FileSegmentation fileSegmentation = new FileSegmentation(license, this.normalizationMetaData);
        File segmentsFile = new File(this.getFile().getParentFile(), ".meta/segments.txt");
        if (fileSegmentation.getSegmentCount() > 1) {
            FileUtils.write((File)segmentsFile, (CharSequence)fileSegmentation.getSegmentsString(), (String)"UTF-8");
            LOG.warn("More than one segment ({}) detected in license for [{}] in context [{}].", new Object[]{fileSegmentation.fileSegments.size(), this.getCanonicalName(), validationContext});
        } else if (segmentsFile.exists()) {
            FileUtils.forceDelete((File)segmentsFile);
        }
        StringStats normalizedLicense = fileSegmentation.mergeSegmentedText();
        if (updateMatchReports) {
            file = new File(this.getFile().getParentFile(), ".meta/ae-normalized-license.txt");
            FileUtils.write((File)file, (CharSequence)normalizedLicense.getNormalizedString(), (String)"UTF-8");
        }
        if (updateMatchReports) {
            file = new File(this.getFile().getParentFile(), ".meta/ae-normalized-masked-license.txt");
            FileUtils.write((File)file, (CharSequence)normalizedLicense.getNormalizedString(), (String)"UTF-8");
        }
        this.validateOthers(normalizedLicense);
        ScanResultPart resultSRP = new ScanResultPart();
        if (fileSegmentation.getFileSegments().size() > 1) {
            for (FileSegment segment : fileSegmentation.getFileSegments()) {
                StringStats normalizedSegment = segment.getNormalizedContent();
                ScanResultPart segmentSRP = this.normalizationMetaData.doAnalyze(normalizedSegment, false, true);
                segmentSRP.cleanExcludedMatches();
                segmentSRP.cleanLicenseMatches();
                resultSRP.merge(segmentSRP);
            }
            resultSRP.process(this.normalizationMetaData, false, true);
        } else {
            resultSRP = this.normalizationMetaData.doAnalyze(normalizedLicense, false, true);
        }
        List<String> actualMatches = resultSRP.getMatchedTerms();
        this.writeMatchedMarkersFile(actualMatches);
        if (actualMatches.isEmpty() && !this.ignore() && !this.isMarker()) {
            throw new IllegalStateException(String.format("License match not unique in context [%s]! No match found for license %s.", validationContext, this.canonicalName));
        }
        InventoryUtils.removeMarkers(actualMatches, this.normalizationMetaData);
        List ignored = actualMatches.stream().filter(s -> {
            TermsMetaData licenseMetaData = this.normalizationMetaData.getTermsMetaData((String)s);
            return licenseMetaData == null || licenseMetaData.ignore();
        }).collect(Collectors.toList());
        String queryLicense = this.modulateQueryLicense();
        this.produceReferences(updateMatchReports, resultSRP, normalizedLicense);
        this.handleMatches(validationContext, actualMatches, queryLicense);
    }

    private void validateOthers(StringStats normalizedLicense) {
        if (this.getEvidence() != null) {
            this.validateMatches(this.getEvidence().getMatches(), normalizedLicense);
            if (this.getEvidence().getExcludes() != null) {
                this.validateExcludeMatches(this.getEvidence().getExcludes(), normalizedLicense);
            }
        }
        if (this.getGrants() != null) {
            for (Grant grant : this.getGrants().values()) {
                this.validateMatches(grant.getMatches(), normalizedLicense);
                if (grant.getObligations() == null || grant.getObligations().values() == null) continue;
                for (Obligation obligation : grant.getObligations().values()) {
                    if (obligation.getMatches() == null) continue;
                    this.validateMatches(obligation.getMatches(), normalizedLicense);
                }
            }
        }
        if (this.getReferences() != null) {
            for (Reference reference : this.getReferences().values()) {
                this.validateMatches(reference.getMatches(), normalizedLicense);
            }
        }
    }

    private void produceReferences(boolean updateMatchReports, ScanResultPart resultSRP, StringStats normalizedLicense) throws IOException {
        SortedProperties properties = new SortedProperties();
        if (!resultSRP.getPartialMatchedTerms().isEmpty()) {
            properties.setProperty("partial.matches", StringUtils.toString(resultSRP.getPartialMatchedTerms()));
        }
        if (!resultSRP.getExcludeMatchedLicenses().isEmpty()) {
            properties.setProperty("excluded.matches", StringUtils.toString(resultSRP.getExcludeMatchedLicenses()));
        }
        File partialFile = new File(this.getFile().getParentFile(), ".meta/partial.matches.properties");
        PropertyUtils.saveProperties(partialFile, properties);
        if (updateMatchReports) {
            File htmlFile = new File(this.getFile().getParentFile(), ".meta/match.html");
            this.createMatchReportHtml(normalizedLicense, resultSRP, htmlFile, null);
        }
    }

    private void handleMatches(String validationContext, List<String> actualMatches, String queryLicense) {
        ArrayList<String> localExpectedMatches = new ArrayList<String>();
        if (this.expectedMatches != null) {
            localExpectedMatches.addAll(this.expectedMatches);
        }
        localExpectedMatches.add(this.canonicalName);
        List<String> ignoreMatches = this.getIgnoreMatches();
        if (ignoreMatches != null) {
            actualMatches.removeAll(ignoreMatches);
            localExpectedMatches.removeAll(ignoreMatches);
        }
        if (!actualMatches.isEmpty()) {
            actualMatches.stream().filter(s -> s.startsWith(queryLicense)).findAny().orElseThrow(() -> new IllegalStateException(String.format("License text in context [%s] contains a different license. Expected: %s. Match: %s", validationContext, queryLicense, actualMatches)));
        }
        ArrayList<String> unexpectedMatches = new ArrayList<String>(actualMatches);
        unexpectedMatches.removeAll(localExpectedMatches);
        ArrayList expectedNotMatchedMatches = new ArrayList(localExpectedMatches);
        expectedNotMatchedMatches.removeAll(actualMatches);
        if (!unexpectedMatches.isEmpty()) {
            LOG.error("Subject: file://{}", (Object)this.getFile().getAbsolutePath());
            for (String unexpectedMatch : unexpectedMatches) {
                TermsMetaData unexpectedTmd = this.normalizationMetaData.getTermsMetaData(unexpectedMatch);
                if (unexpectedTmd == null) continue;
                LOG.error("Matched: file://{}", (Object)unexpectedTmd.getFile().getAbsolutePath());
            }
            throw new IllegalStateException(String.format("Terms [%s] not matched as expected. The following matches are not expected: %s", this.canonicalName, unexpectedMatches));
        }
        expectedNotMatchedMatches.remove(this.getCanonicalName());
        if (!expectedNotMatchedMatches.isEmpty()) {
            LOG.error("file://{}", (Object)this.getFile().getAbsolutePath());
            LOG.error("Matched: {}", actualMatches);
            throw new IllegalStateException(String.format("Terms [%s] has defined expectedMatches, but the following are not matched: %s", this.canonicalName, expectedNotMatchedMatches));
        }
    }

    private void writeMatchedMarkersFile(List<String> matchedTerms) {
        List<String> markerList = InventoryUtils.extractMarkers(matchedTerms, this.normalizationMetaData);
        SortedProperties markerProperties = new SortedProperties();
        markerProperties.setProperty("matched.markers", String.join((CharSequence)", ", markerList));
        File markersFile = new File(this.getFile().getParentFile(), ".meta/matched-markers.properties");
        PropertyUtils.saveProperties(markersFile, markerProperties);
    }

    private String modulateQueryLicense() {
        String qLicense = this.canonicalName;
        qLicense = qLicense.endsWith(" (or any later version)") ? qLicense.replace(" (or any later version)", "") : qLicense;
        qLicense = qLicense.endsWith(" (invariants)") ? qLicense.replace(" (invariants)", "") : qLicense;
        qLicense = qLicense.endsWith(" (no invariants)") ? qLicense.replace(" (no invariants)", "") : qLicense;
        return qLicense;
    }

    public String deriveId() {
        String id = this.canonicalName;
        if (this.spdxIdentifier != null) {
            id = this.spdxIdentifier;
        }
        if (this.shortName != null) {
            id = this.shortName;
        }
        return id;
    }

    public void consolidateAlternativeNames() {
        if (this.alternativeNames == null) {
            return;
        }
        HashSet<String> strings = new HashSet<String>(this.alternativeNames);
        for (String name : strings) {
            StringStats normalizedName = StringStats.normalize(name, false);
            for (String candidate : strings) {
                StringStats normalizedCandidate;
                if (!this.alternativeNames.contains(name) || name.equals(candidate) || !(normalizedCandidate = StringStats.normalize(candidate, false)).contains(normalizedName, true)) continue;
                this.alternativeNames.remove(candidate);
                LOG.debug("Removed redundant alternative name '{}' for '{}'.", (Object)candidate, (Object)this.canonicalName);
                LOG.debug("'{}' covered by '{}'.", (Object)candidate, (Object)name);
            }
        }
    }

    public void addOtherId(String type, String id) {
        if (type == null || id == null) {
            return;
        }
        if (this.otherIds == null) {
            this.otherIds = new ArrayList<String>();
        }
        this.otherIds.add(type.toLowerCase() + ":" + id);
    }

    public List<String> getScanCodeIdentifiers() {
        File licenseFile;
        File termDefinitionDir;
        File scanCodeMatchProperties;
        ArrayList<String> scanCodeIds = new ArrayList<String>();
        List<String> otherIds = this.getOtherIds();
        if (otherIds != null) {
            for (String otherId : otherIds) {
                String scanCodeId;
                if (otherId == null || !otherId.matches("scancode:.*") || !StringUtils.notEmpty(scanCodeId = otherId.replace("scancode:", "").trim())) continue;
                scanCodeIds.add(scanCodeId);
            }
        }
        if (scanCodeIds.isEmpty() && this.getLicenseFile() != null && (scanCodeMatchProperties = new File(termDefinitionDir = (licenseFile = new File(this.getLicenseFile())).getParentFile().getParentFile(), ".meta/license_scancode.properties")).exists()) {
            String[] split;
            Properties p = PropertyUtils.loadProperties(scanCodeMatchProperties);
            String matched = StringUtils.stripArrayBoundaries(p.getProperty("detected.licenses"));
            for (String s : split = matched.split(",")) {
                if (!StringUtils.notEmpty(s = s.trim())) continue;
                scanCodeIds.add(s);
            }
        }
        return scanCodeIds;
    }

    public void addComment(String comment) {
        if (comment == null) {
            return;
        }
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
    }

    public void mergeExternalMetaData() throws IOException {
        File spdxTmdFile;
        if (this.isMarker()) {
            return;
        }
        if (this.isUnspecific()) {
            return;
        }
        if (this.canonicalName.contains(" + ")) {
            return;
        }
        File scanCodeTmdFile = new File(this.getFile().getParentFile(), ".meta/scancode-tmd.yaml");
        if (scanCodeTmdFile.exists()) {
            this.mergeMetaData(TermsMetaData.parseTermsMetaData(scanCodeTmdFile));
        }
        if ((spdxTmdFile = new File(this.getFile().getParentFile(), ".meta/spdx-tmd.yaml")).exists()) {
            this.mergeMetaData(TermsMetaData.parseTermsMetaData(spdxTmdFile));
        }
    }

    public static TermsMetaData parseTermsMetaData(File scanCodeTmdFile) throws IOException {
        try {
            Yaml yaml = new Yaml();
            String content = FileUtils.readFileToString((File)scanCodeTmdFile, (String)"UTF-8");
            return (TermsMetaData)yaml.loadAs(content, TermsMetaData.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot parse [%s].", scanCodeTmdFile.getAbsolutePath()), e);
        }
    }

    protected void mergeMetaData(TermsMetaData externalTmd) {
        if (externalTmd.getOtherIds() != null) {
            for (String otherId : externalTmd.getOtherIds()) {
                String type = otherId.substring(0, otherId.indexOf(":"));
                if (!StringUtils.isEmpty(this.getOtherId(type))) continue;
                if (this.otherIds == null) {
                    this.otherIds = new ArrayList<String>();
                }
                if (this.otherIds.contains(otherId) || this.otherIdsFilter.contains(otherId)) continue;
                this.otherIds.add(otherId);
            }
        }
        if (StringUtils.isEmpty(this.classification)) {
            this.classification = externalTmd.getClassification();
        }
        if (externalTmd.getComments() != null) {
            for (String comment : externalTmd.getComments()) {
                if (this.comments == null) {
                    this.comments = new ArrayList<String>();
                }
                if (this.comments.contains(comment)) continue;
                this.comments.add(comment);
            }
        }
    }

    public void createMatchReportHtml(StringStats normalizedLicense, ScanResultPart scanResultPart, File htmlFile, List<String> retainedPartialMatches) throws IOException {
        String row;
        TermsMetaData lmd;
        Object first;
        TermsMetaData lmd2;
        String text;
        String onOff;
        String normalizedLicenseText = normalizedLicense.getNormalizedString();
        String template = TEMPLATE.replace("${canonicalName}", this.getCanonicalName());
        template = template.replace("${licenseText}", normalizedLicenseText);
        template = template.replace("${matchTemplate}", MATCHES_TABLE);
        template = template.replace("${matchedTableTemplate}", MATCHED_TABLE);
        HashMap<String, List<ItemMatches>> nameToLMDMatches = new HashMap<String, List<ItemMatches>>();
        HashMap<String, List<ItemMatches>> fragmentToLMDMatches = new HashMap<String, List<ItemMatches>>();
        int z = 1;
        for (MatchItem matchItem : scanResultPart.getMatchItems()) {
            boolean realMatch = matchItem.getMatchType() != MatchItem.MatchType.NOT_MATCHED;
            String matchColor = matchItem.deriveColor(this);
            TermsMetaData lmd3 = matchItem.getSourceLicenseMetaData();
            String canonicalName = lmd3.getCanonicalName();
            this.addMatchIndex(z, matchItem, nameToLMDMatches, fragmentToLMDMatches, retainedPartialMatches);
            if (realMatch) {
                String markedLicenseText = normalizedLicenseText;
                StringStats nm = matchItem.getMatchStringStats();
                SimpleIntPair index = normalizedLicense.indexOf(nm, false);
                String errorMessage = "";
                if (index != null && index.getLeft() > -1 && index.getRight() > -1) {
                    int leftIndex = index.getLeft();
                    int rightIndex = Math.min(index.getRight(), normalizedLicenseText.length());
                    if (leftIndex == (rightIndex = Math.max(leftIndex, rightIndex))) {
                        errorMessage = "Could not match text in license. Unable to render mark.";
                    } else {
                        String substring = normalizedLicenseText.substring(leftIndex, rightIndex);
                        markedLicenseText = normalizedLicenseText.substring(0, leftIndex) + "<mark style=\"background: " + matchColor + "\">" + substring + "</mark>" + normalizedLicenseText.substring(rightIndex);
                    }
                } else {
                    errorMessage = "Could not match text in license. Index out of range: " + index;
                }
                template = template.replace("${marker}", "<div id=\"match-" + z + "\" class=\"overlay\" style=\"z-index: -" + z + ";\">" + markedLicenseText + "</div>\n${marker}");
                template = template.replace("${matchMarker}", "<p>" + (String)canonicalName + " - <mark style=\"background: " + matchColor + "\">" + matchItem.getMatchStringStats().getOriginalString() + "</mark> - " + matchItem.getMatchContext() + " - " + (Object)((Object)matchItem.getMatchType()) + "</p>\n${matchMarker}");
                String row2 = ROW_PATTERN;
                row2 = row2.replace("${number}", String.valueOf(z));
                row2 = row2.replace("${canonicalName}", this.getLinkedName(lmd3));
                row2 = row2.replace("${onOff}", "<button id=\"btn-" + z + "\" onclick=\"toggle('" + z + "')\" style=\"background-color: rgb(128,200,128);\">Toggle</button>");
                row2 = row2.replace("${matchText}", "<mark style=\"background: " + matchColor + "\">" + matchItem.getMatchStringStats().getOriginalString() + "</mark>");
                row2 = !StringUtils.isEmpty(String.valueOf(matchItem.getMatchContext())) ? row2.replace("${matchContext}", " (<i>" + matchItem.getMatchContext() + "</i>)") : row2.replace("${matchContext}", "");
                row2 = row2.replace("${matchType}", String.valueOf((Object)matchItem.getMatchType()));
                if (!StringUtils.isEmpty(errorMessage)) {
                    row2 = row2.replace("${matchError}", "<br><b>ERROR: " + errorMessage + "</b>");
                }
                template = template.replace("${row}", row2);
                template = template.replace("${onScript}", "document.getElementById('match-" + z + "').style.display = \"block\";\n${onScript}");
                template = template.replace("${onScript}", "document.getElementById('btn-" + z + "').style.backgroundColor = \"rgb(128,200,128)\";\n${onScript}");
                template = template.replace("${offScript}", "document.getElementById('match-" + z + "').style.display = \"none\";\n${offScript}");
                template = template.replace("${offScript}", "document.getElementById('btn-" + z + "').style.backgroundColor = \"rgb(200,128,128)\";\n${offScript}");
            }
            ++z;
        }
        z = 1;
        for (String fullyMatchedLicenses : scanResultPart.getMatchedTerms()) {
            List ms = (List)nameToLMDMatches.get(fullyMatchedLicenses);
            onOff = "<button onclick=\"";
            text = "";
            if (ms == null || ms.isEmpty()) continue;
            for (ItemMatches m : ms) {
                onOff = onOff + "toggle('" + m.z + "');";
                lmd2 = m.matchItem.getSourceLicenseMetaData();
                text = text + "<mark style=\"background: " + m.matchItem.deriveColor(lmd2) + "\">" + m.matchItem.getMatchStringStats().getNormalizedString() + "</mark><br/>";
            }
            onOff = onOff + "\">Toggle</button>";
            first = (ItemMatches)ms.get(0);
            lmd = ((ItemMatches)first).matchItem.getSourceLicenseMetaData();
            row = MATCHED_ROW_PATTERN;
            row = row.replace("${number}", String.valueOf(z));
            row = row.replace("${canonicalName}", this.getLinkedName(lmd));
            row = row.replace("${matchText}", text);
            row = row.replace("${matchContext}", "FULL MATCH");
            row = row.replace("${matchType}", "");
            row = row.replace("${onOff}", onOff);
            template = template.replace("${matchedRow}", row);
            ++z;
        }
        if (retainedPartialMatches != null && !retainedPartialMatches.isEmpty()) {
            for (String partialMatchedLicenses : retainedPartialMatches) {
                List ms = (List)nameToLMDMatches.get(partialMatchedLicenses);
                onOff = "<button onclick=\"";
                text = "";
                for (ItemMatches m : ms) {
                    onOff = onOff + "toggle('" + m.z + "');";
                    lmd2 = m.matchItem.getSourceLicenseMetaData();
                    text = text + "<mark style=\"background: " + m.matchItem.deriveColor(lmd2) + "\">" + m.matchItem.getMatchStringStats().getNormalizedString() + "</mark><br/>";
                }
                onOff = onOff + "\">Toggle</button>";
                if (ms.isEmpty()) continue;
                first = (ItemMatches)ms.get(0);
                lmd = ((ItemMatches)first).matchItem.getSourceLicenseMetaData();
                row = MATCHED_ROW_PATTERN;
                row = row.replace("${number}", String.valueOf(z));
                row = row.replace("${canonicalName}", this.getLinkedName(lmd));
                row = row.replace("${matchText}", text);
                row = row.replace("${matchContext}", "PARTIAL MATCH");
                row = row.replace("${matchType}", "");
                row = row.replace("${onOff}", onOff);
                template = template.replace("${matchedRow}", row);
                ++z;
            }
        }
        template = template.replace("${marker}", "");
        template = template.replace("${row}", "");
        template = template.replace("${matchedRow}", "");
        template = template.replace("${onScript}", "");
        template = template.replace("${offScript}", "");
        template = template.replace("${matchError}", "");
        FileUtils.write((File)htmlFile, (CharSequence)template, (String)"UTF-8");
    }

    protected String getLinkedName(TermsMetaData lmd) {
        if (lmd == null) {
            return "n.a.";
        }
        String linkedName = lmd.getCanonicalName();
        if (lmd.getFile() == null) {
            return lmd.getCanonicalName();
        }
        File parentFile = lmd.getFile().getParentFile();
        if (parentFile == null) {
            return lmd.getCanonicalName();
        }
        File matchHtmlFile = new File(parentFile, ".meta/match.html");
        if (!matchHtmlFile.exists()) {
            return lmd.getCanonicalName();
        }
        return "<a href=file://" + matchHtmlFile.getAbsolutePath() + ">" + linkedName + "</a>";
    }

    protected void addMatchIndex(int z, MatchItem matchItem, Map<String, List<ItemMatches>> nameToLMDMatches, Map<String, List<ItemMatches>> fragmentToLMDMatches, List<String> retainedPartialMatches) {
        ItemMatches m = new ItemMatches(matchItem, z);
        String key = matchItem.getSourceLicenseMetaData().getCanonicalName();
        List ms = nameToLMDMatches.computeIfAbsent(key, k -> new ArrayList());
        if (!ms.contains(m)) {
            ms.add(m);
        }
        if (retainedPartialMatches == null || !retainedPartialMatches.contains(key)) {
            return;
        }
        key = matchItem.getMatchStringStats().getNormalizedString();
        ms = fragmentToLMDMatches.computeIfAbsent(key, k -> new ArrayList());
        if (!ms.contains(m)) {
            ms.add(m);
        }
    }

    private void validateMatches(List<String> matches, StringStats normalizedLicense) {
        if (matches != null) {
            for (String match : matches) {
                StringStats normalizedMatch = this.normalizeString(match, true);
                if (!normalizedLicense.contains(normalizedMatch, true)) {
                    LOG.debug("Match not found in license text: [{}]", (Object)this.getCanonicalName());
                    LOG.info("Normalized license: [{}]", (Object)normalizedLicense);
                    LOG.info("Normalized match:   [{}]", (Object)normalizedMatch);
                    LOG.info("Terms Metadata:     [file://{}]", (Object)this.getFile().getAbsolutePath());
                    throw new IllegalStateException(String.format("Match not found in [%s] license text: [%s]", this.getCanonicalName(), match));
                }
                LOG.debug("Validated match: {}", (Object)normalizedMatch.getNormalizedString());
            }
        }
    }

    private void validateExcludeMatches(List<String> excludes, StringStats normalizedLicense) {
        for (String exclude : excludes) {
            StringStats normalizedMatch = this.normalizeString(exclude, true);
            if (normalizedLicense.contains(normalizedMatch, true)) {
                LOG.debug("Exclude found in license text: {}", (Object)this.getCanonicalName());
                LOG.debug("Normalized license: {}", (Object)normalizedLicense);
                LOG.debug("Normalized exclude:   {}", (Object)normalizedMatch);
                throw new IllegalStateException(String.format("Exclude must not be found in %s license text: %s", this.getCanonicalName(), exclude));
            }
            LOG.debug("Validated exclude: {}", (Object)normalizedMatch.getNormalizedString());
        }
    }

    public ScanResultPart analyze(StringStats licenseStats) {
        ScanResultPart scanResultPart = new ScanResultPart();
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getCanonicalName());
        }
        MatchMonitor matchMonitor = new MatchMonitor();
        this.matchExcludes(licenseStats, scanResultPart, matchMonitor);
        if (matchMonitor.matchedExcludes > 0) {
            return scanResultPart;
        }
        this.matchNamesAndReferences(licenseStats, scanResultPart);
        Evidence evidence = this.getEvidence();
        if (evidence != null) {
            this.match(evidence, matchMonitor, licenseStats, scanResultPart, MatchItem.MatchType.EVIDENCE_MATCH, "");
            List<MatchSet> oneOfMatchSetList = evidence.getOneOf();
            if (oneOfMatchSetList != null) {
                for (MatchSet matchSet : oneOfMatchSetList) {
                    MatchMonitor oneOfMatchMonitor = new MatchMonitor();
                    matchMonitor.addOneOfMatchMonitor(oneOfMatchMonitor);
                    this.match(matchSet, oneOfMatchMonitor, licenseStats, scanResultPart, MatchItem.MatchType.EVIDENCE_ONE_OF_MATCH, "");
                }
            }
        }
        if (this.getGrants() != null) {
            for (Grant grant : this.getGrants().values()) {
                this.match(grant, matchMonitor, licenseStats, scanResultPart, MatchItem.MatchType.GRANT_MATCH, this.deriveMatchContext(grant));
                if (grant.getObligations() == null) continue;
                for (Obligation obligation : grant.getObligations().values()) {
                    this.match(obligation, matchMonitor, licenseStats, scanResultPart, MatchItem.MatchType.OBLIGATION_MATCH, this.deriveMatchContext(grant, obligation));
                }
            }
        }
        matchMonitor.evaluate(scanResultPart, this);
        return scanResultPart;
    }

    private void match(MatchSet matchSet, MatchMonitor matchMonitor, StringStats licenseStats, ScanResultPart scanResultPart, MatchItem.MatchType matchType, CharSequence matchContext) {
        if (matchSet == null) {
            return;
        }
        List<String> matches = matchSet.getMatches();
        if (matches == null) {
            return;
        }
        for (String match : matches) {
            MatchItem matchItem;
            StringStats normalizedMatch = this.normalizeString(match, true);
            ++matchMonitor.total;
            if (licenseStats.contains(normalizedMatch, true)) {
                ++matchMonitor.matched;
                matchItem = new MatchItem(normalizedMatch, matchType, matchContext, this);
                scanResultPart.addMatchItem(matchItem);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Matched: {}", (Object)normalizedMatch.getOriginalString());
                continue;
            }
            matchItem = new MatchItem(normalizedMatch, MatchItem.MatchType.NOT_MATCHED, matchContext, this);
            matchMonitor.unmatchedMatchItems.add(matchItem);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Not matched: {}", (Object)normalizedMatch.getOriginalString());
        }
    }

    private void matchExcludes(StringStats licenseStats, ScanResultPart scanResultPart, MatchMonitor matchMonitor) {
        Evidence evidence = this.getEvidence();
        if (evidence != null && evidence.getExcludes() != null) {
            for (String exclude : evidence.getExcludes()) {
                StringStats normalizedExclude = this.normalizeString(exclude, true);
                if (!licenseStats.contains(normalizedExclude, true)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Matched exclude: {}", (Object)normalizedExclude.getOriginalString());
                }
                ++matchMonitor.matchedExcludes;
                MatchItem matchItem = new MatchItem(normalizedExclude, MatchItem.MatchType.EVIDENCE_EXCLUDE, "", this);
                scanResultPart.addMatchItem(matchItem);
                scanResultPart.addExcludedMatch(this);
            }
        }
    }

    private void matchNamesAndReferences(StringStats licenseStats, ScanResultPart scanResultPart) {
        Set<String> namesAndReferences = this.collectNamesAndReferencesAndCache();
        for (String nameOrReference : namesAndReferences) {
            this.matchAlternativeName(licenseStats, scanResultPart, nameOrReference);
        }
    }

    private synchronized Set<String> collectNamesAndReferencesAndCache() {
        if (this.namesAndReferences == null) {
            HashSet<String> namesAndReferences = new HashSet<String>();
            namesAndReferences.add(this.canonicalName);
            if (!StringUtils.isEmpty(this.shortName)) {
                String shortNameForMatching = this.shortName.replace("-?", "");
                namesAndReferences.add(shortNameForMatching + " licensed");
                namesAndReferences.add(shortNameForMatching + " license");
                namesAndReferences.add(shortNameForMatching + " License");
                namesAndReferences.add("licensed under" + shortNameForMatching);
                namesAndReferences.add("Licensed under" + shortNameForMatching);
                namesAndReferences.add("License: " + shortNameForMatching);
                namesAndReferences.add("license: " + shortNameForMatching);
            }
            if (!StringUtils.isEmpty(this.spdxIdentifier)) {
                namesAndReferences.add("SPDX-License-Identifier: " + this.spdxIdentifier);
                namesAndReferences.add(this.spdxIdentifier + " licensed");
                namesAndReferences.add(this.spdxIdentifier + " license");
                namesAndReferences.add(this.spdxIdentifier + " License");
                namesAndReferences.add("licensed under" + this.spdxIdentifier);
                namesAndReferences.add("Licensed under" + this.spdxIdentifier);
                namesAndReferences.add("License: " + this.spdxIdentifier);
                namesAndReferences.add("license: " + this.spdxIdentifier);
            }
            if (this.getAlternativeNames() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Matching canonical and alternative license names of [{}].", (Object)this.canonicalName);
                }
                namesAndReferences.addAll(this.getAlternativeNames());
            }
            this.namesAndReferences = namesAndReferences;
        }
        return this.namesAndReferences;
    }

    protected final StringBuilder deriveMatchContext(Grant grant, Obligation obligation) {
        StringBuilder sb = this.deriveMatchContext(grant);
        if (obligation.getDescription() != null) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(obligation.getDescription());
        }
        return sb;
    }

    protected final StringBuilder deriveMatchContext(Grant grant) {
        StringBuilder sb = new StringBuilder();
        if (grant.getAction() != null) {
            sb.append(grant.getAction());
        }
        if (grant.getSubject() != null) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(grant.getSubject());
        }
        return sb;
    }

    private void matchAlternativeName(StringStats licenseStats, ScanResultPart scanResultPart, String licenseName) {
        if (licenseName == null) {
            return;
        }
        StringStats normalizedLicenseName = this.normalizeString(licenseName, true);
        SimpleIntPair matchIndex = licenseStats.indexOf(normalizedLicenseName, true);
        int index = matchIndex.getLeft();
        if (index >= 0) {
            int[] matchIndexes = licenseStats.allMatches(normalizedLicenseName);
            boolean validMatch = true;
            for (Reference reference : this.referenceList) {
                if (reference == null || reference.getMatches() == null) continue;
                for (String match : reference.getMatches()) {
                    if (match == null) continue;
                    StringStats normalizedMatch = this.normalizeString(match, true);
                    SimpleIntPair referenceIndex = licenseStats.indexOf(normalizedMatch, true);
                    for (int candidateMatchIndex : matchIndexes) {
                        if (referenceIndex.getLeft() > candidateMatchIndex || referenceIndex.getRight() <= candidateMatchIndex) continue;
                        validMatch = false;
                        scanResultPart.addMatchItem(new MatchItem(normalizedMatch, MatchItem.MatchType.REFERENCE_MATCH, "", this));
                        break;
                    }
                    if (validMatch) continue;
                    break;
                }
                if (validMatch) continue;
                break;
            }
            if (validMatch) {
                scanResultPart.addNameMatch(this);
                scanResultPart.addMatchItem(new MatchItem(normalizedLicenseName, MatchItem.MatchType.NAME_MATCH, "", this));
                LOG.debug("Matched [{}] on name '{}'.", (Object)this.getCanonicalName(), (Object)licenseName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(licenseStats.getNormalizedString());
                }
            } else {
                scanResultPart.addMatchItem(new MatchItem(normalizedLicenseName, MatchItem.MatchType.IGNORED_NAME_MATCH, "", this));
            }
        }
    }

    private StringStats normalizeString(String licenseName, boolean isMatch) {
        return StringStats.normalize(licenseName, isMatch);
    }

    public void addReference(Reference reference) {
        this.referenceList.add(reference);
    }

    public void writeYaml(File file) throws IOException {
        String string = new Yaml(YAML_REPRESENTER).dumpAs((Object)this, null, DumperOptions.FlowStyle.BLOCK).replace("!!" + this.getClass().getName(), "").trim();
        FileUtils.writeStringToFile((File)file, (String)string, (Charset)StandardCharsets.UTF_8);
    }

    public void writeToFile(File file) {
        String template = "canonicalName: ${canonicalName}\ncategory: ${category}\nspdxIdentifier: ${spdxIdentifier}\nshortName: ${shortName}\n\notherIds:\n${otherIds}\nclassification: ${classification}\n\nalternativeNames:\n${alternativeNames}\ncomments:\n${comments}";
        String content = "canonicalName: ${canonicalName}\ncategory: ${category}\nspdxIdentifier: ${spdxIdentifier}\nshortName: ${shortName}\n\notherIds:\n${otherIds}\nclassification: ${classification}\n\nalternativeNames:\n${alternativeNames}\ncomments:\n${comments}";
        content = content.replace("${canonicalName}", this.canonicalName);
        content = content.replace("${category}", this.category == null ? "" : this.category);
        content = content.replace("${classification}", this.classification == null ? "" : this.classification);
        content = content.replace("${spdxIdentifier}", this.spdxIdentifier == null ? "" : this.spdxIdentifier);
        content = this.alternativeNames != null ? content.replace("${alternativeNames}", this.alternativeNames.stream().map(s -> "  - \"" + this.escapeYaml((String)s) + "\"").collect(Collectors.joining("\n"))) : content.replace("${alternativeNames}", "");
        content = this.comments != null ? content.replace("${comments}", this.comments.stream().map(s -> "  - \"" + this.escapeYaml((String)s) + "\"").collect(Collectors.joining("\n"))) : content.replace("${comments}", "");
        content = this.replaceVariable(content, "${shortName}", this.shortName);
        content = this.otherIds != null ? content.replace("${otherIds}", this.otherIds.stream().map(s -> "  - \"" + this.escapeYaml((String)s) + "\"").collect(Collectors.joining("\n"))) : content.replace("${otherIds}", "");
        try {
            FileUtils.write((File)file, (CharSequence)content, (String)"UTF-8");
        }
        catch (IOException e) {
            LOG.error("Cannot write license meta data.", (Throwable)e);
        }
    }

    private String escapeYaml(String s) {
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        return s;
    }

    protected String replaceVariable(String content, String variablePlaceholder, String variableValue) {
        content = variableValue != null ? content.replace(variablePlaceholder, variableValue) : content.replace(variablePlaceholder, "");
        return content;
    }

    public boolean allowLaterVersions() {
        return this.allowsLaterVersions;
    }

    public boolean ignore() {
        return this.ignore;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        return Objects.equals(this.getCanonicalName(), ((TermsMetaData)obj).getCanonicalName());
    }

    public boolean isMarker() {
        return TYPE_MARKER.equals(this.type);
    }

    public boolean isExpression() {
        return TYPE_EXPRESSION.equals(this.type);
    }

    public boolean isException() {
        return TYPE_EXCEPTION.equals(this.type);
    }

    public boolean isReference() {
        return TYPE_REFERENCE.equals(this.type);
    }

    public boolean requiresAnnexNotice() {
        return this.requiresAnnexNotice;
    }

    public boolean isOsiApproved() {
        return this.getOtherId("osi") != null;
    }

    public String getOtherId(String type) {
        String scancodeId;
        if (type == null) {
            return null;
        }
        String typePrefix = type + ":";
        if (this.getOtherIds() != null && (scancodeId = (String)this.getOtherIds().stream().filter(Objects::nonNull).filter(id -> id.startsWith(typePrefix)).findFirst().orElse(null)) != null) {
            return scancodeId.substring(scancodeId.indexOf(":") + 1);
        }
        return null;
    }

    public List<String> getOtherIds(String type) {
        if (type == null) {
            return null;
        }
        ArrayList<String> matchingIds = new ArrayList<String>();
        String typePrefix = type + ":";
        if (this.getOtherIds() != null) {
            for (String otherId : this.getOtherIds()) {
                if (otherId == null || !otherId.startsWith(typePrefix)) continue;
                matchingIds.add(otherId.replace(typePrefix, ""));
            }
        }
        return matchingIds;
    }

    public void readPartialMatches() {
        File partialFile = new File(this.getFile().getParentFile(), ".meta/partial.matches.properties");
        if (partialFile.exists()) {
            Properties p = PropertyUtils.loadProperties(partialFile);
            String pm = p.getProperty("partial.matches", "");
            this.partialMatches = InventoryUtils.tokenizeLicense((String)pm, (boolean)false, (boolean)true);
            String em = p.getProperty("excluded.matches", "");
            this.excludedMatches = InventoryUtils.tokenizeLicense((String)em, (boolean)false, (boolean)true);
        }
    }

    public void readMatchedMarkers() {
        File matchedMarkersFile = new File(this.getFile().getParentFile(), ".meta/matched-markers.properties");
        if (matchedMarkersFile.exists()) {
            Properties p = PropertyUtils.loadProperties(matchedMarkersFile);
            String pm = p.getProperty("matched.markers", "");
            this.matchedMarkers = InventoryUtils.tokenizeLicense((String)pm, (boolean)false, (boolean)true);
        }
    }

    public void setOpenCoDEStatus(String openCoDEStatus) {
        if (openCoDEStatus != null) {
            switch (openCoDEStatus) {
                case "not approved": 
                case "(approved)": 
                case "approved": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Open CoDE status [" + openCoDEStatus + "].");
                }
            }
        }
        this.openCoDEStatus = openCoDEStatus;
    }

    public boolean isOpenCodeApproved() {
        return STATUS_APPROVED.equals(this.openCoDEStatus) || STATUS_APPROVED_IMPLICIT.equals(this.openCoDEStatus);
    }

    public boolean isOpenCodeNotApproved() {
        return STATUS_NOT_APPROVED.equals(this.openCoDEStatus);
    }

    public boolean isOpenCodeUndefined() {
        return !this.isOpenCodeApproved() && !this.isOpenCodeNotApproved();
    }

    public boolean isCustomerMetaData() {
        File tmdYamlFile = this.getFile();
        return tmdYamlFile.getPath().contains("/_customer/");
    }

    public String resolveType() {
        return this.type == null ? "terms" : this.type;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setAlternativeNames(List<String> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public void setReadmeFile(String readmeFile) {
        this.readmeFile = readmeFile;
    }

    public String getReadmeFile() {
        return this.readmeFile;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public void setReferences(Map<String, Reference> references) {
        this.references = references;
    }

    public Map<String, Reference> getReferences() {
        return this.references;
    }

    public void setSpdxIdentifier(String spdxIdentifier) {
        this.spdxIdentifier = spdxIdentifier;
    }

    public String getSpdxIdentifier() {
        return this.spdxIdentifier;
    }

    public String getSpdxExpression() {
        return this.spdxExpression;
    }

    public void setSpdxExpression(String spdxExpression) {
        this.spdxExpression = spdxExpression;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setAlternativeShortNames(Set<String> alternativeShortNames) {
        this.alternativeShortNames = alternativeShortNames;
    }

    public Set<String> getAlternativeShortNames() {
        return this.alternativeShortNames;
    }

    public List<String> getOtherIds() {
        return this.otherIds;
    }

    public void setOtherIds(List<String> otherIds) {
        this.otherIds = otherIds;
    }

    public void setCombinedWith(Map<String, String> combinedWith) {
        this.combinedWith = combinedWith;
    }

    public Map<String, String> getCombinedWith() {
        return this.combinedWith;
    }

    public void setNamedEquivalence(String namedEquivalence) {
        this.namedEquivalence = namedEquivalence;
    }

    public String getNamedEquivalence() {
        return this.namedEquivalence;
    }

    public void setUnspecific(boolean unspecific) {
        this.unspecific = unspecific;
    }

    public boolean isUnspecific() {
        return this.unspecific;
    }

    public void setAllowsLaterVersions(boolean allowsLaterVersions) {
        this.allowsLaterVersions = allowsLaterVersions;
    }

    public boolean isAllowsLaterVersions() {
        return this.allowsLaterVersions;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setMasks(Masks masks) {
        this.masks = masks;
    }

    public Masks getMasks() {
        return this.masks;
    }

    public void setGrants(Map<String, Grant> grants) {
        this.grants = grants;
    }

    public Map<String, Grant> getGrants() {
        return this.grants;
    }

    public void setIgnoreMatches(List<String> ignoreMatches) {
        this.ignoreMatches = ignoreMatches;
    }

    public List<String> getIgnoreMatches() {
        return this.ignoreMatches;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public void setDefaultSourceCategory(String defaultSourceCategory) {
        this.defaultSourceCategory = defaultSourceCategory;
    }

    public String getDefaultSourceCategory() {
        return this.defaultSourceCategory;
    }

    public void setRequiresAnnexNotice(boolean requiresAnnexNotice) {
        this.requiresAnnexNotice = requiresAnnexNotice;
    }

    public boolean isRequiresSourceCodeProvision() {
        return this.requiresSourceCodeProvision;
    }

    public void setRequiresSourceCodeProvision(boolean requiresSourceCodeProvision) {
        this.requiresSourceCodeProvision = requiresSourceCodeProvision;
    }

    public boolean isArticleRequired() {
        return this.articleRequired;
    }

    public void setArticleRequired(boolean articleRequired) {
        this.articleRequired = articleRequired;
    }

    public void setRepresentedAs(String representedAs) {
        this.representedAs = representedAs;
    }

    public String getRepresentedAs() {
        return this.representedAs;
    }

    public String getLicenseTemplate() {
        return this.licenseTemplate;
    }

    public void setLicenseTemplate(String licenseTemplate) {
        this.licenseTemplate = licenseTemplate;
    }

    public boolean isRequiresNote() {
        return this.requiresNote;
    }

    public void setRequiresNote(boolean requiresNote) {
        this.requiresNote = requiresNote;
    }

    public void setRequiresCopyright(Boolean requiresCopyright) {
        this.requiresCopyright = requiresCopyright;
    }

    public Boolean getRequiresCopyright() {
        return this.requiresCopyright;
    }

    public void setTemporaryLMD(boolean temporaryLMD) {
        this.temporaryLMD = temporaryLMD;
    }

    public boolean isTemporaryLMD() {
        return this.temporaryLMD;
    }

    public void setRequiresLicenseText(Boolean requiresLicenseText) {
        this.requiresLicenseText = requiresLicenseText;
    }

    public Boolean getRequiresLicenseText() {
        return this.requiresLicenseText;
    }

    public void setLicenseTextRequirements(String licenseTextRequirements) {
        this.licenseTextRequirements = licenseTextRequirements;
    }

    public String getLicenseTextRequirements() {
        return this.licenseTextRequirements;
    }

    public void setStatus(List<String> status) {
        this.status = status;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public void setCanonicalNameHistory(List<String> canonicalNameHistory) {
        this.canonicalNameHistory = canonicalNameHistory;
    }

    public List<String> getCanonicalNameHistory() {
        return this.canonicalNameHistory;
    }

    public void setStandardVariableSet(HashMap<String, String> standardVariableSet) {
        this.standardVariableSet = standardVariableSet;
    }

    public HashMap<String, String> getStandardVariableSet() {
        return this.standardVariableSet;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setBaseTerms(String baseTerms) {
        this.baseTerms = baseTerms;
    }

    public String getBaseTerms() {
        return this.baseTerms;
    }

    public void setMissingCopyrightNotAllowed(boolean missingCopyrightNotAllowed) {
        this.missingCopyrightNotAllowed = missingCopyrightNotAllowed;
    }

    public boolean isMissingCopyrightNotAllowed() {
        return this.missingCopyrightNotAllowed;
    }

    public void setNoteChecklist(List<String> noteChecklist) {
        this.noteChecklist = noteChecklist;
    }

    public List<String> getNoteChecklist() {
        return this.noteChecklist;
    }

    public void setNoticeTemplateId(String noticeTemplateId) {
        this.noticeTemplateId = noticeTemplateId;
    }

    public String getNoticeTemplateId() {
        return this.noticeTemplateId;
    }

    public List<String> getExpectedSpdxMatches() {
        return this.expectedSpdxMatches;
    }

    public void setExpectedSpdxMatches(List<String> expectedSpdxMatches) {
        this.expectedSpdxMatches = expectedSpdxMatches;
    }

    public List<String> getExpectedMatches() {
        return this.expectedMatches;
    }

    public void setExpectedMatches(List<String> expectedMatches) {
        this.expectedMatches = expectedMatches;
    }

    public List<String> getMappingOrder() {
        return this.mappingOrder;
    }

    public void setMappingOrder(List<String> mappingOrder) {
        this.mappingOrder = mappingOrder;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public void setSegmentation(Segmentation segmentation) {
        this.segmentation = segmentation;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public void setNormalizationMetaData(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    public List<String> getPartialMatches() {
        return this.partialMatches;
    }

    public List<String> getMatchedMarkers() {
        return this.matchedMarkers;
    }

    public List<String> getExcludedMatches() {
        return this.excludedMatches;
    }

    public String getOpenCoDEStatus() {
        return this.openCoDEStatus;
    }

    public String getOpenCoDESimilarLicenseId() {
        return this.openCoDESimilarLicenseId;
    }

    public void setOpenCoDESimilarLicenseId(String openCoDESimilarLicenseId) {
        this.openCoDESimilarLicenseId = openCoDESimilarLicenseId;
    }

    public String getOsiStatus() {
        return this.osiStatus;
    }

    public void setOsiStatus(String osiStatus) {
        this.osiStatus = osiStatus;
    }

    public String getOsiCategory() {
        return this.osiCategory;
    }

    public void setOsiCategory(String osiCategory) {
        this.osiCategory = osiCategory;
    }

    public String getOsiRationale() {
        return this.osiRationale;
    }

    public void setOsiRationale(String osiRationale) {
        this.osiRationale = osiRationale;
    }

    public String getOsiSupersededBy() {
        return this.osiSupersededBy;
    }

    public void setOsiSupersededBy(String osiSupersededBy) {
        this.osiSupersededBy = osiSupersededBy;
    }

    public Boolean getPubliclyAvailable() {
        return this.publiclyAvailable;
    }

    public void setPubliclyAvailable(Boolean publiclyAvailable) {
        this.publiclyAvailable = publiclyAvailable;
    }

    private class MatchMonitor {
        int matched = 0;
        int total = 0;
        int matchedExcludes = 0;
        List<MatchMonitor> oneOfMatchMonitors = new ArrayList<MatchMonitor>();
        final List<MatchItem> unmatchedMatchItems = new ArrayList<MatchItem>();

        private MatchMonitor() {
        }

        public void evaluate(ScanResultPart scanResultPart, TermsMetaData termsMetaData) {
            if (this.matched > 0) {
                scanResultPart.addMatchItems(this.unmatchedMatchItems);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(TermsMetaData.this.getCanonicalName());
                    LOG.debug("  matchedEvidences: {}", (Object)this.matched);
                    LOG.debug("  totalEvidences:   {}", (Object)this.total);
                    LOG.debug("  matchedExcludes:  {}", (Object)this.matchedExcludes);
                }
                if (this.matched == this.total && this.matchedExcludes == 0) {
                    scanResultPart.addLicenseMatch(termsMetaData);
                } else {
                    scanResultPart.addPartialMatch(termsMetaData);
                }
            }
            if (this.getOneOfMatchMonitors() != null && this.matchedExcludes == 0) {
                boolean oneOfMatch = false;
                for (MatchMonitor matchMonitor : this.getOneOfMatchMonitors()) {
                    if (matchMonitor.matched != matchMonitor.total) continue;
                    oneOfMatch = true;
                    break;
                }
                if (oneOfMatch) {
                    scanResultPart.addLicenseMatch(termsMetaData);
                }
            }
        }

        public void addOneOfMatchMonitor(MatchMonitor matchMonitor) {
            this.oneOfMatchMonitors.add(matchMonitor);
        }

        public List<MatchMonitor> getOneOfMatchMonitors() {
            return this.oneOfMatchMonitors;
        }
    }

    private static class ItemMatches {
        MatchItem matchItem;
        int z;

        public ItemMatches(MatchItem matchItem, int z) {
            this.matchItem = matchItem;
            this.z = z;
        }
    }
}

