/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.OtherTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRange;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeEcosystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhsaAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(GhsaAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){};
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){
        {
            this.add("severity");
            this.add("githubReviewed");
            this.add("githubReviewedAt");
            this.add("nvdPublishedAt");
            this.add("vulnerableSoftware");
        }
    };
    private String severity;
    private boolean githubReviewed;
    private Date githubReviewedAt;
    private Date nvdPublishedAt;
    private final List<VulnerableSoftwareVersionRangeEcosystem> vulnerableSoftwares = new ArrayList<VulnerableSoftwareVersionRangeEcosystem>();
    private static final String CVSS_4_KEY = "CVSS_V4";
    private static final String CVSS_3_KEY = "CVSS_V3";
    private static final String CVSS_2_KEY = "CVSS_V2";

    public GhsaAdvisorEntry() {
        super(AdvisoryTypeStore.GHSA);
    }

    public GhsaAdvisorEntry(String id) {
        super(AdvisoryTypeStore.GHSA, id);
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public boolean isGithubReviewed() {
        return this.githubReviewed;
    }

    public List<VulnerableSoftwareVersionRangeEcosystem> getVulnerableSoftwares() {
        return this.vulnerableSoftwares;
    }

    public void setGithubReviewed(boolean githubReviewed) {
        this.githubReviewed = githubReviewed;
    }

    public Date getGithubReviewedAt() {
        return this.githubReviewedAt;
    }

    public void setGithubReviewedAt(Date githubReviewedAt) {
        this.githubReviewedAt = githubReviewedAt;
    }

    public Date getNvdPublishedAt() {
        return this.nvdPublishedAt;
    }

    public void setNvdPublishedAt(Date nvdPublishedAt) {
        this.nvdPublishedAt = nvdPublishedAt;
    }

    @Override
    public String getUrl() {
        return "https://github.com/advisories/" + this.getId();
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)"alert");
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public GhsaAdvisorEntry constructDataClass() {
        return new GhsaAdvisorEntry();
    }

    public static GhsaAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, GhsaAdvisorEntry::new);
    }

    public static GhsaAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, GhsaAdvisorEntry::new);
    }

    public static GhsaAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, GhsaAdvisorEntry::new);
    }

    public static GhsaAdvisorEntry fromDocument(Document document) {
        return AdvisoryEntry.fromDocument(document, GhsaAdvisorEntry::new);
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
        this.setSeverity(map.getOrDefault("severity", null));
        this.setGithubReviewed((Boolean)map.getOrDefault("githubReviewed", false));
        this.setGithubReviewedAt(TimeUtils.tryParse(map.getOrDefault("githubReviewedAt", null)));
        this.setNvdPublishedAt(TimeUtils.tryParse(map.getOrDefault("nvdPublishedAt", null)));
        List vulnerableSoftwareArray = map.getOrDefault("vulnerableSoftware", null);
        this.vulnerableSoftwares.addAll(GhsaAdvisorEntry.createVulnerableSoftwareConfigurationsFromJson(vulnerableSoftwareArray));
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
        json.put("severity", (Object)this.getSeverity());
        json.put("githubReviewed", this.isGithubReviewed());
        json.put("githubReviewedAt", ObjectUtils.defaultIfNull(this.githubReviewedAt == null ? null : Long.valueOf(this.githubReviewedAt.getTime()), (Object)JSONObject.NULL));
        json.put("nvdPublishedAt", ObjectUtils.defaultIfNull(this.nvdPublishedAt == null ? null : Long.valueOf(this.nvdPublishedAt.getTime()), (Object)JSONObject.NULL));
        JSONArray vulnerableSoftwareArray = new JSONArray();
        for (VulnerableSoftwareVersionRange vulnerableSoftwareVersionRange : this.vulnerableSoftwares) {
            vulnerableSoftwareArray.put((Object)vulnerableSoftwareVersionRange.toJson());
        }
        json.put("vulnerableSoftware", (Object)vulnerableSoftwareArray);
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
        this.setSeverity(document.get("severity"));
        this.setGithubReviewed(Boolean.parseBoolean(document.get("githubReviewed")));
        this.setGithubReviewedAt(TimeUtils.tryParse(document.get("githubReviewedAt")));
        this.setNvdPublishedAt(TimeUtils.tryParse(document.get("nvdPublishedAt")));
        String vulnerableSoftwareJson = document.get("vulnerableSoftware");
        if (vulnerableSoftwareJson != null) {
            this.vulnerableSoftwares.addAll(GhsaAdvisorEntry.createVulnerableSoftwareConfigurationsFromJson(new JSONArray(vulnerableSoftwareJson)));
        }
    }

    @Override
    public void appendToDocument(Document document) {
        super.appendToDocument(document);
        super.addToDocumentAsTextFieldIfNotEmpty(document, "severity", this.getSeverity());
        document.add((IndexableField)new StringField("githubReviewed", String.valueOf(this.isGithubReviewed()), Field.Store.YES));
        super.addToDocumentAsTextFieldIfNotEmpty(document, "githubReviewedAt", this.githubReviewedAt == null ? null : Long.toString(this.githubReviewedAt.getTime()));
        super.addToDocumentAsTextFieldIfNotEmpty(document, "nvdPublishedAt", this.nvdPublishedAt == null ? null : Long.toString(this.nvdPublishedAt.getTime()));
        JSONArray vulnerableSoftwareArray = new JSONArray();
        ArrayList<String> vulnerableSoftwareNamePhrases = new ArrayList<String>();
        for (VulnerableSoftwareVersionRangeEcosystem vulnerableSoftware : this.vulnerableSoftwares) {
            vulnerableSoftwareArray.put((Object)vulnerableSoftware.toJson());
            vulnerableSoftwareNamePhrases.addAll(Arrays.asList(vulnerableSoftware.getName().split("[.:-]")));
        }
        super.addToDocumentAsTextFieldIfNotEmpty(document, "vulnerableSoftware", vulnerableSoftwareArray.toString());
        super.addToDocumentAsTextFieldIfNotEmpty(document, "vulnerableSoftwareNamePhrases", String.join((CharSequence)" ", vulnerableSoftwareNamePhrases));
    }

    private static List<VulnerableSoftwareVersionRangeEcosystem> createVulnerableSoftwareConfigurationsFromJson(JSONArray vulnerableSoftwareArray) {
        ArrayList<VulnerableSoftwareVersionRangeEcosystem> entries = new ArrayList<VulnerableSoftwareVersionRangeEcosystem>();
        if (vulnerableSoftwareArray != null) {
            for (int i = 0; i < vulnerableSoftwareArray.length(); ++i) {
                JSONObject vulnerableSoftwareJson = vulnerableSoftwareArray.optJSONObject(i);
                if (vulnerableSoftwareJson == null) continue;
                entries.add(VulnerableSoftwareVersionRangeEcosystem.fromJson(vulnerableSoftwareJson));
            }
        }
        return entries;
    }

    private static List<VulnerableSoftwareVersionRangeEcosystem> createVulnerableSoftwareConfigurationsFromJson(List<Object> vulnerableSoftwareArray) {
        ArrayList<VulnerableSoftwareVersionRangeEcosystem> entries = new ArrayList<VulnerableSoftwareVersionRangeEcosystem>();
        if (vulnerableSoftwareArray != null) {
            for (Object vulnerableSoftwareJson : vulnerableSoftwareArray) {
                if (vulnerableSoftwareJson instanceof Map) {
                    entries.add(VulnerableSoftwareVersionRangeEcosystem.fromJson(new JSONObject(vulnerableSoftwareJson)));
                    continue;
                }
                if (vulnerableSoftwareJson instanceof JSONObject) {
                    entries.add(VulnerableSoftwareVersionRangeEcosystem.fromJson((JSONObject)vulnerableSoftwareJson));
                    continue;
                }
                LOG.warn("Unknown vulnerable software type: [{}]", vulnerableSoftwareJson.getClass());
            }
        }
        return entries;
    }

    public static GhsaAdvisorEntry fromGitRepoJson(JSONObject json) {
        JSONArray affected;
        JSONArray severity;
        JSONObject dbSpecific;
        JSONArray ref;
        JSONArray aliases;
        GhsaAdvisorEntry entry = new GhsaAdvisorEntry();
        entry.setId(json.getString("id"));
        entry.setUpdateDate(TimeUtils.tryParse(json.optString("modified", null)));
        entry.setCreateDate(TimeUtils.tryParse(json.optString("published", null)));
        entry.setSummary(json.optString("summary", null));
        if (!json.isNull("details")) {
            entry.setDescription(DescriptionParagraph.fromTitleAndContent("details", json.getString("details")));
        }
        if ((aliases = json.optJSONArray("aliases")) != null) {
            for (int i = 0; i < aliases.length(); ++i) {
                String alias = aliases.optString(i, null);
                if (alias == null || !alias.startsWith("CVE-")) continue;
                entry.addReferencedVulnerability(VulnerabilityTypeStore.CVE, alias);
            }
        }
        if ((ref = json.optJSONArray("references")) != null) {
            for (int i = 0; i < ref.length(); ++i) {
                JSONObject refEntry = ref.getJSONObject(i);
                String type = refEntry.getString("type");
                String url = refEntry.getString("url");
                entry.addReference(Reference.fromUrlAndTags(url, type));
            }
        }
        if ((dbSpecific = json.optJSONObject("database_specific")) != null) {
            JSONArray cweIds = dbSpecific.getJSONArray("cwe_ids");
            for (int i = 0; i < cweIds.length(); ++i) {
                entry.addOtherReferencedId(OtherTypeStore.CWE, cweIds.getString(i));
            }
            entry.setSeverity(dbSpecific.optString("severity", null));
            entry.setGithubReviewed(dbSpecific.optBoolean("github_reviewed", false));
            entry.setGithubReviewedAt(TimeUtils.tryParse(dbSpecific.optString("github_reviewed_at", null)));
            entry.setNvdPublishedAt(TimeUtils.tryParse(dbSpecific.optString("nvd_published_at", null)));
        }
        if ((severity = json.optJSONArray("severity")) != null) {
            CvssSource baseSourceV3 = new CvssSource(KnownCvssEntities.GHSA, Cvss3P1.class);
            block13: for (int i = 0; i < severity.length(); ++i) {
                JSONObject severityEntry = severity.getJSONObject(i);
                String type = severityEntry.getString("type");
                String value = (String)ObjectUtils.firstNonNull((Object[])new String[]{severityEntry.optString("value", null), severityEntry.optString("score", null)});
                if (value == null) {
                    LOG.warn("Severity value is null for type: [{}]", (Object)type);
                    continue;
                }
                switch (type) {
                    case "CVSS_V3": {
                        entry.getCvssVectors().addCvssVector((CvssVector)new Cvss3P1(value, baseSourceV3));
                        continue block13;
                    }
                    case "CVSS_V2": {
                        entry.getCvssVectors().addCvssVector((CvssVector)new Cvss2(value, baseSourceV3.deriveSource(Cvss2.class)));
                        continue block13;
                    }
                    case "CVSS_V4": {
                        entry.getCvssVectors().addCvssVector((CvssVector)new Cvss4P0(value, baseSourceV3.deriveSource(Cvss4P0.class)));
                        continue block13;
                    }
                    default: {
                        LOG.warn("Unknown severity type: [{}] with value [{}]", (Object)type, (Object)value);
                    }
                }
            }
        }
        if ((affected = json.optJSONArray("affected")) != null) {
            for (int i = 0; i < affected.length(); ++i) {
                JSONObject affectedEntry = affected.getJSONObject(i);
                JSONObject packageJson = affectedEntry.getJSONObject("package");
                String name = packageJson.getString("name");
                String ecosystem = packageJson.getString("ecosystem");
                JSONArray ranges = affectedEntry.optJSONArray("ranges");
                if (ranges == null) continue;
                for (int j = 0; j < ranges.length(); ++j) {
                    JSONObject range = ranges.getJSONObject(j);
                    String type = range.getString("type");
                    if (type.equals("ECOSYSTEM")) {
                        JSONArray events = range.getJSONArray("events");
                        String introducedVersion = null;
                        String fixedVersion = null;
                        String lastAffected = null;
                        for (int k = 0; k < events.length(); ++k) {
                            JSONObject event = events.getJSONObject(k);
                            if (event.has("introduced")) {
                                introducedVersion = event.getString("introduced");
                                continue;
                            }
                            if (event.has("fixed")) {
                                fixedVersion = event.getString("fixed");
                                continue;
                            }
                            if (event.has("last_affected")) {
                                lastAffected = event.getString("last_affected");
                                continue;
                            }
                            LOG.warn("Unknown event type: [{}] on [{}]", (Object)event.keySet(), (Object)entry.getId());
                        }
                        String versionStartIncluding = introducedVersion;
                        String versionEndExcluding = fixedVersion;
                        String versionEndIncluding = lastAffected;
                        VulnerableSoftwareVersionRangeEcosystem vs = new VulnerableSoftwareVersionRangeEcosystem(ecosystem, name, null, null, null, versionStartIncluding, versionEndIncluding, versionEndExcluding, VersionContext.fromGhsaProduct(name), true);
                        entry.vulnerableSoftwares.add(vs);
                        continue;
                    }
                    LOG.warn("Unknown range type: [{}]", (Object)type);
                }
            }
        }
        return entry;
    }
}

