/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.advisory;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertSeiAdvisorEntry;
import com.metaeffekt.mirror.contents.base.CvssConditionAttributes;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.msrcdata.MsThreat;
import com.metaeffekt.mirror.contents.msrcdata.MsrcRemediation;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.report.model.AdvisoryUtils;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MsrcAdvisorEntry
extends AdvisoryEntry {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcAdvisorEntry.class);
    protected static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_AMB){
        {
            this.add(InventoryAttribute.MS_AFFECTED_PRODUCTS.getKey());
            this.add(InventoryAttribute.MS_THREATS.getKey());
            this.add(InventoryAttribute.MS_REMEDIATIONS.getKey());
        }
    };
    protected static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(AdvisoryEntry.CONVERSION_KEYS_MAP){
        {
            this.add("affectedProducts");
            this.add("msThreats");
            this.add("msRemediations");
        }
    };
    protected final Set<String> affectedProducts = new HashSet<String>();
    protected final Set<MsThreat> msThreats = new HashSet<MsThreat>();
    protected final Set<MsrcRemediation> msrcRemediations = new HashSet<MsrcRemediation>();

    public MsrcAdvisorEntry() {
        super(AdvisoryTypeStore.MSRC);
    }

    public MsrcAdvisorEntry(String id) {
        super(AdvisoryTypeStore.MSRC, id);
    }

    public void addAffectedProduct(String product) {
        this.affectedProducts.add(product);
    }

    public void addAffectedProducts(Collection<String> products) {
        this.affectedProducts.addAll(products);
    }

    public void addMsThreat(MsThreat threat) {
        this.msThreats.add(threat);
    }

    public void addMsThreats(Collection<MsThreat> threats) {
        this.msThreats.addAll(threats);
    }

    private void addMsThreats(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            MsThreat threat = MsThreat.fromJson(json);
            this.msThreats.add(threat);
        }
    }

    private void addMsThreats(List<Map<String, Object>> maps) {
        for (Map<String, Object> map : maps) {
            MsThreat threat = MsThreat.fromMap(map);
            this.msThreats.add(threat);
        }
    }

    public void addMsRemediation(MsrcRemediation remediation) {
        this.msrcRemediations.add(remediation);
    }

    public void addMsRemediations(Collection<MsrcRemediation> remediations) {
        this.msrcRemediations.addAll(remediations);
    }

    private void addMsRemediations(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            MsrcRemediation remediation = MsrcRemediation.fromJson(json);
            this.msrcRemediations.add(remediation);
        }
    }

    private void addMsRemediations(List<Map<String, Object>> maps) {
        for (Map<String, Object> map : maps) {
            MsrcRemediation remediation = MsrcRemediation.fromMap(map);
            this.msrcRemediations.add(remediation);
        }
    }

    public Set<String> getAffectedProducts() {
        return this.affectedProducts;
    }

    public Set<MsThreat> getMsThreats() {
        return this.msThreats;
    }

    public Set<MsrcRemediation> getMsRemediations() {
        return this.msrcRemediations;
    }

    public Set<MsrcRemediation> getMsRemediationsByAffectedProduct(String productId) {
        return this.msrcRemediations.stream().filter(r -> r.getAffectedProductIds().contains(productId)).collect(Collectors.toSet());
    }

    public Set<MsrcRemediation> getMsRemediationsByDescriptionEquals(String description) {
        if (description.charAt(0) == 'K' && description.charAt(1) == 'B') {
            LOG.warn("MSRC remediation description starts with KB, which is most likely a mistake: {}", (Object)description);
        }
        return this.msrcRemediations.stream().filter(r -> Objects.equals(description, r.getDescription())).collect(Collectors.toSet());
    }

    public String getCveFromId() {
        if (StringUtils.isEmpty(this.id) || this.id.contains("ADV")) {
            return null;
        }
        return this.id.replace("MSRC-", "");
    }

    @Override
    public String getUrl() {
        return "https://msrc.microsoft.com/update-guide/en-US/vulnerability/" + this.id;
    }

    @Override
    public String getType() {
        return AdvisoryUtils.normalizeType((String)"alert");
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    @Override
    public CertSeiAdvisorEntry constructDataClass() {
        return new CertSeiAdvisorEntry();
    }

    public static MsrcAdvisorEntry fromAdvisoryMetaData(AdvisoryMetaData amd) {
        return AdvisoryEntry.fromAdvisoryMetaData(amd, MsrcAdvisorEntry::new);
    }

    public static MsrcAdvisorEntry fromInputMap(Map<String, Object> map) {
        return AdvisoryEntry.fromInputMap(map, MsrcAdvisorEntry::new);
    }

    public static MsrcAdvisorEntry fromJson(JSONObject json) {
        return AdvisoryEntry.fromJson(json, MsrcAdvisorEntry::new);
    }

    public static MsrcAdvisorEntry fromDocument(org.apache.lucene.document.Document document) {
        return AdvisoryEntry.fromDocument(document, MsrcAdvisorEntry::new);
    }

    @Override
    public void appendFromDataClass(AdvisoryEntry dataClass) {
        super.appendFromDataClass(dataClass);
        if (!(dataClass instanceof MsrcAdvisorEntry)) {
            return;
        }
        MsrcAdvisorEntry msrcAdvisorEntry = (MsrcAdvisorEntry)dataClass;
        this.addAffectedProducts(msrcAdvisorEntry.getAffectedProducts());
        this.addMsThreats(msrcAdvisorEntry.getMsThreats());
        this.addMsRemediations(msrcAdvisorEntry.getMsRemediations());
    }

    @Override
    public void appendFromBaseModel(AdvisoryMetaData amd) {
        super.appendFromBaseModel(amd);
        if (amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_AFFECTED_PRODUCTS) != null) {
            this.addAffectedProducts(Arrays.stream(amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_AFFECTED_PRODUCTS).split(", ")).collect(Collectors.toSet()));
        }
        if (amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_THREATS) != null) {
            this.addMsThreats(new JSONArray(amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_THREATS)));
        }
        if (amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_REMEDIATIONS) != null) {
            this.addMsRemediations(new JSONArray(amd.get((AbstractModelBase.Attribute)InventoryAttribute.MS_REMEDIATIONS)));
        }
    }

    @Override
    public void appendToBaseModel(AdvisoryMetaData amd) {
        super.appendToBaseModel(amd);
        amd.set((AbstractModelBase.Attribute)InventoryAttribute.MS_AFFECTED_PRODUCTS, String.join((CharSequence)", ", this.affectedProducts));
        amd.set((AbstractModelBase.Attribute)InventoryAttribute.MS_THREATS, new JSONArray((Collection)this.msThreats.stream().map(MsThreat::toJson).collect(Collectors.toList())).toString());
        amd.set((AbstractModelBase.Attribute)InventoryAttribute.MS_REMEDIATIONS, new JSONArray((Collection)this.msrcRemediations.stream().map(MsrcRemediation::toJson).collect(Collectors.toList())).toString());
    }

    @Override
    public void appendFromMap(Map<String, Object> map) {
        super.appendFromMap(map);
        try {
            if (map.containsKey("affectedProducts")) {
                this.addAffectedProducts(((List)map.get("affectedProducts")).stream().map(Object::toString).collect(Collectors.toSet()));
            }
            if (map.containsKey("msThreats")) {
                this.addMsThreats((List)map.get("msThreats"));
            }
            if (map.containsKey("msRemediations")) {
                this.addMsRemediations((List)map.get("msRemediations"));
            }
        }
        catch (Exception e) {
            LOG.error("Error parsing MSRC Advisor entry from map:\n" + map, (Throwable)e);
        }
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
        json.put("affectedProducts", (Object)this.affectedProducts.stream().collect(CustomCollectors.toJsonArray()));
        json.put("msThreats", (Object)this.msThreats.stream().map(MsThreat::toJson).collect(CustomCollectors.toJsonArray()));
        json.put("msRemediations", (Object)this.msrcRemediations.stream().map(MsrcRemediation::toJson).collect(CustomCollectors.toJsonArray()));
    }

    @Override
    public void appendFromDocument(org.apache.lucene.document.Document document) {
        super.appendFromDocument(document);
        this.addAffectedProducts(new JSONArray(document.get("affectedProducts")).toList().stream().map(Object::toString).collect(Collectors.toSet()));
        this.addMsThreats(new JSONArray(document.get("msThreats")));
        this.addMsRemediations(new JSONArray(document.get("msRemediations")));
    }

    @Override
    public void appendToDocument(org.apache.lucene.document.Document document) {
        super.appendToDocument(document);
        document.add((IndexableField)new TextField("affectedProducts", this.affectedProducts.stream().collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
        document.add((IndexableField)new TextField("msThreats", this.msThreats.stream().map(MsThreat::toJson).collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
        document.add((IndexableField)new TextField("msRemediations", this.msrcRemediations.stream().map(MsrcRemediation::toJson).collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
    }

    public static List<MsrcAdvisorEntry> fromDownloadXml(Document document) {
        ArrayList<MsrcAdvisorEntry> entries = new ArrayList<MsrcAdvisorEntry>();
        NodeList vulnerabilityElements = document.getElementsByTagName("vuln:Vulnerability");
        for (int i = 0; i < vulnerabilityElements.getLength(); ++i) {
            Element vulnerabilityElement = (Element)vulnerabilityElements.item(i);
            MsrcAdvisorEntry entry = MsrcAdvisorEntry.fromDownloadXmlVulnerabilityElement(vulnerabilityElement);
            entries.add(entry);
        }
        return entries;
    }

    public static MsrcAdvisorEntry fromDownloadXmlVulnerabilityElement(Element vulnerabilityElement) {
        MsrcAdvisorEntry entry = new MsrcAdvisorEntry();
        String title = MsrcAdvisorEntry.getTextContent(vulnerabilityElement, "vuln:Title");
        entry.setSummary(title);
        String cve = MsrcAdvisorEntry.getTextContent(vulnerabilityElement, "vuln:CVE");
        if (VulnerabilityTypeStore.CVE.patternMatchesId(cve)) {
            entry.addReferencedVulnerability(VulnerabilityTypeStore.CVE, cve);
        }
        boolean isAdv = cve.contains("ADV");
        String msrcId = cve.replaceAll("(MSRC-)?(CVE|CAN)-?", "").replaceAll(".*?(\\d{1,4})-(\\d+).*", "$1-$2").replace("ADV", "");
        msrcId = isAdv ? "ADV" + msrcId : "MSRC-CVE-" + msrcId;
        entry.setId(msrcId);
        Element notesElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:Notes").item(0);
        NodeList noteElements = notesElement.getElementsByTagName("vuln:Note");
        for (int j = 0; j < noteElements.getLength(); ++j) {
            Element noteElement = (Element)noteElements.item(j);
            String noteText = Arrays.stream(noteElement.getTextContent().split("\n")).map(e -> e.replaceAll("\\s{2,}", " ")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"));
            if (!StringUtils.hasText(noteText)) continue;
            String noteType = noteElement.getAttribute("Type");
            String noteTitle = noteElement.getAttribute("Title");
            String noteTitleJoined = noteTitle.equals(noteType) ? noteTitle : noteType + ": " + noteTitle;
            entry.addDescription(DescriptionParagraph.fromTitleAndContent(noteTitleJoined, noteText));
        }
        Element productStatusesElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:ProductStatuses").item(0);
        NodeList statusElements = productStatusesElement.getElementsByTagName("vuln:Status");
        for (int j = 0; j < statusElements.getLength(); ++j) {
            Element statusElement = (Element)statusElements.item(j);
            if (statusElement.getAttribute("Type").equals("Known Affected")) {
                NodeList productIdElements = statusElement.getElementsByTagName("vuln:ProductID");
                for (int k2 = 0; k2 < productIdElements.getLength(); ++k2) {
                    Element productIdElement = (Element)productIdElements.item(k2);
                    String productId = productIdElement.getTextContent();
                    entry.addAffectedProduct(productId);
                }
                continue;
            }
            LOG.info("Unknown status type: {}", (Object)statusElement.getAttribute("Type"));
        }
        Element threatsElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:Threats").item(0);
        NodeList threatElements = threatsElement.getElementsByTagName("vuln:Threat");
        for (int j = 0; j < threatElements.getLength(); ++j) {
            Element threatElement = (Element)threatElements.item(j);
            String threatType = threatElement.getAttribute("Type");
            String threatDescription = MsrcAdvisorEntry.getTextContent(threatElement, "vuln:Description");
            if (threatDescription == null) {
                LOG.warn("No threat description found for MSRC entry {}", (Object)entry.getId());
                continue;
            }
            String cleanedThreatDescription = threatDescription.replace("\n", " ").replaceAll(" +", " ").trim();
            String threatProductId = MsrcAdvisorEntry.getTextContent(threatElement, "vuln:ProductID");
            entry.addMsThreat(new MsThreat(threatType, threatProductId, cleanedThreatDescription));
        }
        for (MsThreat msThreat : entry.getMsThreats()) {
            if (!StringUtils.isEmpty(msThreat.getProductId())) continue;
            entry.setThreat((msThreat.getType() == null ? "" : msThreat.getType() + ": ") + msThreat.getDescription().replaceAll("([;:])(?! )", "$1 "));
        }
        Element remediationsElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:Remediations").item(0);
        NodeList remediationElements = remediationsElement.getElementsByTagName("vuln:Remediation");
        for (int i = 0; i < remediationElements.getLength(); ++i) {
            Element remediationElement = (Element)remediationElements.item(i);
            String remediationType = remediationElement.getAttribute("Type");
            String remediationDescription = MsrcAdvisorEntry.getTextContent(remediationElement, "vuln:Description");
            String cleanedRemediationDescription = remediationDescription != null ? remediationDescription.replace("\n", " ").replaceAll(" +", " ").trim() : "No description provided.";
            String remediationUrl = MsrcAdvisorEntry.getTextContent(remediationElement, "vuln:URL");
            String remediationSupercedence = MsrcAdvisorEntry.getTextContent(remediationElement, "vuln:Supercedence");
            HashSet<String> remediationProductIds = new HashSet<String>();
            NodeList remediationProductIdElements = remediationElement.getElementsByTagName("vuln:ProductID");
            for (int j = 0; j < remediationProductIdElements.getLength(); ++j) {
                Element remediationProductIdElement = (Element)remediationProductIdElements.item(j);
                remediationProductIds.add(remediationProductIdElement.getTextContent());
            }
            String remediationSubType = MsrcAdvisorEntry.getTextContent(remediationElement, "vuln:SubType");
            String remediationFixedBuild = MsrcAdvisorEntry.getTextContent(remediationElement, "vuln:FixedBuild");
            MsrcRemediation remediation = new MsrcRemediation(remediationType, remediationSubType, cleanedRemediationDescription, StringUtils.isEmpty(remediationUrl) ? null : Reference.fromTitleAndUrl(cleanedRemediationDescription != null ? cleanedRemediationDescription : remediationUrl, remediationUrl), remediationProductIds, remediationFixedBuild, remediationSupercedence);
            entry.addMsRemediation(remediation);
        }
        Element cvssScoreSetsElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:CVSSScoreSets").item(0);
        NodeList scoreSetElements = cvssScoreSetsElement.getElementsByTagName("vuln:ScoreSet");
        HashMap<CvssVector, Set> identicalProductVectors = new HashMap<CvssVector, Set>();
        for (int j = 0; j < scoreSetElements.getLength(); ++j) {
            Element scoreSetElement = (Element)scoreSetElements.item(j);
            String vector = MsrcAdvisorEntry.getTextContent(scoreSetElement, "vuln:Vector");
            String productId = MsrcAdvisorEntry.getTextContent(scoreSetElement, "vuln:ProductID");
            CvssVector parsedVector = CvssVector.parseVector((String)vector);
            if (parsedVector == null) {
                LOG.warn("Could not parse infer CVSS version from vector {} on entry {}", (Object)vector, (Object)entry.getId());
                continue;
            }
            identicalProductVectors.computeIfAbsent(parsedVector, k -> new HashSet()).add(productId);
        }
        for (Map.Entry cvssProductsEntry : identicalProductVectors.entrySet()) {
            CvssVector cvssVector = (CvssVector)cvssProductsEntry.getKey();
            Set productIds = (Set)cvssProductsEntry.getValue();
            CvssSource msrcCvss3Source = new CvssSource(KnownCvssEntities.MSRC, cvssVector.getClass());
            JSONObject applicabilityCondition = new JSONObject().put(CvssConditionAttributes.MATCHES_ON_MS_PRODUCT_ID, (Object)new JSONArray((Collection)productIds));
            CvssVector effectiveVector = cvssVector.deriveAddSource(msrcCvss3Source);
            effectiveVector.putAllApplicabilityCondition(applicabilityCondition);
            entry.getCvssVectors().addCvssVector(effectiveVector);
        }
        Element revisionHistoryElement = (Element)vulnerabilityElement.getElementsByTagName("vuln:RevisionHistory").item(0);
        NodeList revisionElements = revisionHistoryElement.getElementsByTagName("vuln:Revision");
        ArrayList<Date> revisionDates = new ArrayList<Date>();
        for (int j = 0; j < revisionElements.getLength(); ++j) {
            Element revisionElement = (Element)revisionElements.item(j);
            String dateString = MsrcAdvisorEntry.getTextContent(revisionElement, "cvrf:Date");
            Date date = TimeUtils.tryParse(dateString);
            if (date == null) continue;
            revisionDates.add(date);
        }
        revisionDates.sort(Comparator.comparing(Date::getTime));
        entry.setCreateDate(!revisionDates.isEmpty() ? (Date)revisionDates.get(0) : null);
        entry.setUpdateDate(!revisionDates.isEmpty() ? (Date)revisionDates.get(revisionDates.size() - 1) : null);
        for (DescriptionParagraph description : entry.getDescription()) {
            entry.addReferencedSecurityAdvisories(AdvisoryTypeStore.MSRC, AdvisoryTypeStore.MSRC.fromFreeText(description.getContent()));
        }
        if (StringUtils.isEmpty(entry.getId())) {
            LOG.warn("No id found for MSRC entry {}", (Object)entry.toJson());
        }
        return entry;
    }

    private static String getTextContent(Element element, String tagName) {
        NodeList urlNodeList = element.getElementsByTagName(tagName);
        Node node = urlNodeList.item(0);
        return node == null ? null : node.getTextContent();
    }

    public static Set<String> getAllMsrcProductIds(Collection<Artifact> artifacts) {
        return artifacts.stream().filter(a -> StringUtils.hasText(a.get(InventoryAttribute.MS_PRODUCT_ID.getKey()))).map(a -> a.get(InventoryAttribute.MS_PRODUCT_ID.getKey())).map(InventoryEnricher::splitVulnerabilitiesCsv).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

