/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.base;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import j2html.TagCreator;
import j2html.tags.specialized.ATag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Reference {
    public static final Pattern REFERENCE_STRING_PATTERN = Pattern.compile("^([^:]+): ([^(]+) \\((.+)\\)$");
    private final String title;
    private final String url;
    private final Set<String> tags = new LinkedHashSet<String>();

    public Reference(String title, String url) {
        this.title = StringUtils.isEmpty(title) || title.equals("null") ? null : title;
        this.url = StringUtils.isEmpty(url) || url.equals("null") ? null : url;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.toMarkdownString();
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("title", (Object)this.title);
        json.put("url", (Object)this.url);
        if (!this.tags.isEmpty()) {
            json.put("tags", this.tags);
        }
        return json;
    }

    private String getTaggedTitle() {
        return (this.title != null ? this.title : this.url) + (!this.tags.isEmpty() ? " (" + String.join((CharSequence)", ", this.tags) + ")" : "");
    }

    public String toMarkdownString() {
        return "[" + this.getTaggedTitle() + "](" + this.url + ")";
    }

    public String toDisplayString() {
        if (this.getTaggedTitle().equals("null")) {
            return this.url;
        }
        return this.getTaggedTitle() + " " + this.url;
    }

    public ATag toHtmlATag() {
        return (ATag)((ATag)TagCreator.a().withHref(this.url == null ? "#" : this.url)).withText(this.title == null ? this.url : this.getTaggedTitle());
    }

    public static Reference fromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        Reference ref = new Reference((String)ObjectUtils.firstNonNull((Object[])new String[]{json.optString("title", null), json.optString("type", null)}), (String)ObjectUtils.firstNonNull((Object[])new String[]{json.optString("url", null), json.optString("ref", null)}));
        JSONArray tags = json.optJSONArray("tags");
        if (tags != null) {
            tags.forEach(tag -> ref.addTag(tag.toString()));
        }
        return ref;
    }

    public static Reference fromMap(Map<String, Object> map) {
        String name = String.valueOf(map.getOrDefault("title", null));
        String url = String.valueOf(map.getOrDefault("url", null));
        Reference ref = new Reference(name, url);
        Object tags = map.getOrDefault("tags", null);
        if (tags instanceof Collection) {
            for (String tag : (Collection)tags) {
                ref.addTag(tag);
            }
        }
        return ref;
    }

    public static Reference fromUrl(String url) {
        return new Reference(null, url);
    }

    public static Reference fromUrlAndTags(String url, String ... tags) {
        Reference reference = new Reference(null, url);
        for (String tag : tags) {
            reference.addTag(tag);
        }
        return reference;
    }

    public static Reference fromTitle(String title) {
        return new Reference(title, null);
    }

    public static Reference fromTitleAndUrl(String title, String url) {
        return new Reference(title, url);
    }

    public static List<Reference> fromJsonArray(JSONArray json) {
        if (json == null) {
            return new ArrayList<Reference>();
        }
        return IntStream.range(0, json.length()).mapToObj(i -> {
            JSONObject entry = json.optJSONObject(i);
            if (entry == null) {
                return Reference.handleStringCase(json.optString(i, null));
            }
            return Reference.fromJson(entry);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Reference handleStringCase(String str) {
        if (str != null) {
            String[] parts = str.split(" \\(");
            if (parts.length == 2) {
                return new Reference(parts[0], parts[1].substring(0, parts[1].length() - 1));
            }
            if (str.startsWith("http")) {
                return new Reference(null, str);
            }
            return new Reference(str, null);
        }
        return null;
    }

    public static List<Reference> fromJsonArray(String jsonString) {
        if (jsonString == null || !jsonString.startsWith("[")) {
            return new ArrayList<Reference>();
        }
        return Reference.fromJsonArray(new JSONArray(jsonString));
    }

    public static List<Reference> mergeReferences(Collection<Reference> ... references) {
        ArrayList<Reference> merged = new ArrayList<Reference>();
        for (Collection<Reference> referenceSet : references) {
            for (Reference reference : referenceSet) {
                Reference existing = merged.stream().filter(r -> r.getUrl() != null && r.getUrl().equals(reference.getUrl())).findFirst().orElse(null);
                if (existing != null) {
                    existing.getTags().addAll(reference.getTags());
                    continue;
                }
                merged.add(reference);
            }
        }
        return merged;
    }
}

