/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.epss;

import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpssData {
    private static final Logger log = LoggerFactory.getLogger(EpssData.class);
    private String vulnerability;
    private float epssScore;
    private float percentile;

    public EpssData(String vulnerability, double epssScore, double percentile) {
        this.vulnerability = vulnerability;
        this.epssScore = (float)epssScore;
        this.percentile = (float)percentile;
    }

    public static EpssData fromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        EpssData epssData = new EpssData();
        epssData.setVulnerability((String)json.get("vulnerability"));
        epssData.setEpssScore(EpssData.parseFloat(json.get("epssScore")));
        epssData.setPercentile(EpssData.parseFloat(json.get("percentile")));
        return epssData;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("vulnerability", (Object)this.vulnerability);
        json.put("epssScore", this.epssScore);
        json.put("percentile", this.percentile);
        return json;
    }

    public static EpssData fromDocument(Document document) {
        EpssData epssData = new EpssData();
        epssData.setVulnerability(document.get("vulnerability"));
        epssData.setEpssScore(EpssData.parseFloat(document.get("epssScore")));
        epssData.setPercentile(EpssData.parseFloat(document.get("percentile")));
        return epssData;
    }

    public Document toDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("vulnerability", this.vulnerability, Field.Store.YES));
        doc.add((IndexableField)new TextField("epssScore", String.format(Locale.ENGLISH, "%f", Float.valueOf(this.epssScore)), Field.Store.YES));
        doc.add((IndexableField)new TextField("percentile", String.format(Locale.ENGLISH, "%f", Float.valueOf(this.percentile)), Field.Store.YES));
        return doc;
    }

    private static float parseFloat(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (!(value instanceof String)) {
            return 0.0f;
        }
        String stringValue = (String)value;
        try {
            return Float.parseFloat(stringValue);
        }
        catch (NumberFormatException e) {
            return Float.parseFloat(stringValue.replace(",", "."));
        }
    }

    public String getVulnerability() {
        return this.vulnerability;
    }

    public float getEpssScore() {
        return this.epssScore;
    }

    public float getPercentile() {
        return this.percentile;
    }

    public EpssData(String vulnerability, float epssScore, float percentile) {
        this.vulnerability = vulnerability;
        this.epssScore = epssScore;
        this.percentile = percentile;
    }

    private void setVulnerability(String vulnerability) {
        this.vulnerability = vulnerability;
    }

    private void setEpssScore(float epssScore) {
        this.epssScore = epssScore;
    }

    private void setPercentile(float percentile) {
        this.percentile = percentile;
    }

    public EpssData() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpssData)) {
            return false;
        }
        EpssData other = (EpssData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getEpssScore(), other.getEpssScore()) != 0) {
            return false;
        }
        if (Float.compare(this.getPercentile(), other.getPercentile()) != 0) {
            return false;
        }
        String this$vulnerability = this.getVulnerability();
        String other$vulnerability = other.getVulnerability();
        return !(this$vulnerability == null ? other$vulnerability != null : !this$vulnerability.equals(other$vulnerability));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EpssData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getEpssScore());
        result = result * 59 + Float.floatToIntBits(this.getPercentile());
        String $vulnerability = this.getVulnerability();
        result = result * 59 + ($vulnerability == null ? 43 : $vulnerability.hashCode());
        return result;
    }
}

