/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.store;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertEuAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.CertFrAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.CertSeiAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.GeneralAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.query.CertEuAdvisorIndexQuery;
import com.metaeffekt.mirror.query.CertFrAdvisorIndexQuery;
import com.metaeffekt.mirror.query.CertSeiAdvisorIndexQuery;
import com.metaeffekt.mirror.query.GhsaAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcAdvisorIndexQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryTypeStore
extends ContentIdentifierStore<AdvisoryTypeIdentifier<?>> {
    private static final Logger log = LoggerFactory.getLogger(AdvisoryTypeStore.class);
    public static final AdvisoryTypeIdentifier<CertFrAdvisorEntry> CERT_FR = new AdvisoryTypeIdentifier<CertFrAdvisorEntry>("CERT_FR", "CERT-FR", "", Pattern.compile("((?:CERT-?FR|CERTA)-\\d+-(?:ACT|AVI|ALE|INF)-\\d+(?:-\\d+)?)", 2), CertFrAdvisorEntry.class, CertFrAdvisorEntry::new, CertFrAdvisorIndexQuery.class, CertFrAdvisorIndexQuery::new);
    public static final AdvisoryTypeIdentifier<CertSeiAdvisorEntry> CERT_SEI = new AdvisoryTypeIdentifier<CertSeiAdvisorEntry>("CERT_SEI", "CERT-SEI", "", Pattern.compile("(VU#(\\d+))", 2), CertSeiAdvisorEntry.class, CertSeiAdvisorEntry::new, CertSeiAdvisorIndexQuery.class, CertSeiAdvisorIndexQuery::new);
    public static final AdvisoryTypeIdentifier<CertEuAdvisorEntry> CERT_EU = new AdvisoryTypeIdentifier<CertEuAdvisorEntry>("CERT_EU", "CERT-EU", "", Pattern.compile("(CERT-EU-(\\d+))", 2), CertEuAdvisorEntry.class, CertEuAdvisorEntry::new, CertEuAdvisorIndexQuery.class, CertEuAdvisorIndexQuery::new);
    public static final AdvisoryTypeIdentifier<MsrcAdvisorEntry> MSRC = new AdvisoryTypeIdentifier<MsrcAdvisorEntry>("MSRC", "MSRC", "", Pattern.compile("(MSRC-(?:CVE|CAN)-([0-9]{4})-([0-9]{4,})|ADV(\\d+))", 2), MsrcAdvisorEntry.class, MsrcAdvisorEntry::new, MsrcAdvisorIndexQuery.class, MsrcAdvisorIndexQuery::new);
    public static final AdvisoryTypeIdentifier<GhsaAdvisorEntry> GHSA = new AdvisoryTypeIdentifier<GhsaAdvisorEntry>("GHSA", "GHSA", "", Pattern.compile("GHSA(-[23456789cfghjmpqrvwx]{4}){3}"), GhsaAdvisorEntry.class, GhsaAdvisorEntry::new, GhsaAdvisorIndexQuery.class, GhsaAdvisorIndexQuery::new);
    public static final AdvisoryTypeIdentifier<GeneralAdvisorEntry> ANY_ADVISORY_FILTER_WILDCARD = new AdvisoryTypeIdentifier<GeneralAdvisorEntry>("any", "any", "any", Pattern.compile("(any|all)", 2), GeneralAdvisorEntry.class, GeneralAdvisorEntry::new, null, null);
    private static final AdvisoryTypeStore INSTANCE = new AdvisoryTypeStore();

    public static AdvisoryTypeStore get() {
        return INSTANCE;
    }

    protected AdvisoryTypeStore() {
    }

    @Override
    protected AdvisoryTypeIdentifier<?> createIdentifier(@NonNull String name, @NonNull String implementation) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation is marked non-null but is null");
        }
        if (implementation.equals("CSAF")) {
            throw new UnsupportedOperationException("CSAF is not yet supported, but will be in the future.");
        }
        if (name.equalsIgnoreCase("any") || implementation.equalsIgnoreCase("all")) {
            return ANY_ADVISORY_FILTER_WILDCARD;
        }
        return new AdvisoryTypeIdentifier<GeneralAdvisorEntry>(name, ContentIdentifierStore.ContentIdentifier.deriveWellFormedName(name), implementation, Pattern.compile("UNKNOWN", 2), GeneralAdvisorEntry.class, () -> new GeneralAdvisorEntry((AdvisoryTypeIdentifier)AdvisoryTypeStore.get().fromNameAndImplementation(name, implementation)), null, null);
    }

    @Override
    protected Collection<AdvisoryTypeIdentifier<?>> createDefaultIdentifiers() {
        return Arrays.asList(CERT_FR, CERT_SEI, CERT_EU, MSRC, GHSA, ANY_ADVISORY_FILTER_WILDCARD);
    }

    @Override
    public ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> fromJsonNameAndImplementation(JSONObject json) {
        ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> superResult = super.fromJsonNameAndImplementation(json);
        if (superResult.getIdentifier() instanceof AdvisoryTypeIdentifier) {
            return superResult;
        }
        throw new IllegalArgumentException("The provided JSON object does not represent an advisory type identifier, which is an impossible scenario since this class can by definition only support advisory type identifiers.");
    }

    @Override
    public ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> fromMap(Map<String, Object> map) {
        ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> superResult = super.fromMap(map);
        if (superResult.getIdentifier() instanceof AdvisoryTypeIdentifier) {
            return superResult;
        }
        throw new IllegalArgumentException("The provided map does not represent an advisory type identifier, which is an impossible scenario since this class can by definition only support advisory type identifiers.");
    }

    public ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>> fromAdvisoryMetaData(AdvisoryMetaData amd) {
        String source = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.SOURCE)});
        String implementation = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.SOURCE_IMPLEMENTATION)});
        String entryId = (String)ObjectUtils.firstNonNull((Object[])new String[]{amd.get(AdvisoryMetaData.Attribute.NAME)});
        if (StringUtils.isEmpty(source)) {
            Optional<ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>>> result = this.fromEntryIdentifier(entryId);
            if (result.isPresent()) {
                return result.get();
            }
            throw new IllegalArgumentException("The advisory meta data does not contain a source attribute, which is required to determine the advisory type.");
        }
        AdvisoryTypeIdentifier advisoryTypeIdentifier = (AdvisoryTypeIdentifier)this.fromNameAndImplementation(source, implementation);
        return new ContentIdentifierStore.SingleContentIdentifierParseResult(advisoryTypeIdentifier, entryId);
    }

    public <T extends ContentIdentifierStore.ContentIdentifier> Optional<ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>>> fromEntryIdentifier(String entryId) {
        if (StringUtils.isEmpty(entryId)) {
            log.warn("The advisory does not contain a source or name attribute, which is required to determine the advisory type.");
            return Optional.empty();
        }
        for (AdvisoryTypeIdentifier typeIdentifier : this.values()) {
            if (!typeIdentifier.patternMatchesId(entryId)) continue;
            return Optional.of(new ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier>(typeIdentifier, entryId));
        }
        return Optional.empty();
    }

    public void inferSourceIdentifierFromIdIfAbsent(AdvisoryEntry securityAdvisory) {
        if (securityAdvisory.getSourceIdentifier() == null) {
            this.fromId(securityAdvisory.getId()).ifPresent(inferred -> {
                if (log.isDebugEnabled()) {
                    log.debug("Inferred source identifier [{}] for advisory entry [{}]", (Object)inferred.toExtendedString(), (Object)securityAdvisory.getId());
                }
                securityAdvisory.setSourceIdentifier((AdvisoryTypeIdentifier<?>)inferred);
            });
        }
    }

    public String toString() {
        return "AdvisoryTypeStore()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvisoryTypeStore)) {
            return false;
        }
        AdvisoryTypeStore other = (AdvisoryTypeStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvisoryTypeStore;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

