/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.contents.vulnerability;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.keywords.KeywordSet;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.score.VulnerabilityPriorityCalculator;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusConverter;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.CvssConditionAttributes;
import com.metaeffekt.mirror.contents.base.MatchableDetailsAmbDataClass;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.epss.EpssData;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.OtherTypeStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareTreeNode;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.query.VulnerabilityIndexQuery;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.metaeffekt.core.security.cvss.processor.CvssSelectionResult;
import org.metaeffekt.core.security.cvss.processor.CvssSelector;
import org.metaeffekt.core.security.cvss.processor.CvssVectorSet;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

public class Vulnerability
extends MatchableDetailsAmbDataClass<VulnerabilityMetaData, Vulnerability> {
    private static final Logger LOG = LoggerFactory.getLogger(Vulnerability.class);
    private static final Set<String> CONVERSION_KEYS_AMB = new HashSet<String>(MatchableDetailsAmbDataClass.CONVERSION_KEYS_AMB){
        {
            this.addAll(Arrays.asList(VulnerabilityMetaData.Attribute.NAME.getKey(), VulnerabilityMetaData.Attribute.SOURCE.getKey(), VulnerabilityMetaData.Attribute.SOURCE_IMPLEMENTATION.getKey(), InventoryAttribute.DESCRIPTION.getKey(), VulnerabilityMetaData.Attribute.URL.getKey(), InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey(), InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey(), VulnerabilityMetaData.Attribute.REFERENCES.getKey(), VulnerabilityMetaData.Attribute.WEAKNESS.getKey(), InventoryAttribute.TAGS.getKey(), InventoryAttribute.VULNERABILITY_STATUS.getKey()));
        }
    };
    private static final Set<String> CONVERSION_KEYS_MAP = new HashSet<String>(MatchableDetailsAmbDataClass.CONVERSION_KEYS_MAP){
        {
            this.addAll(Arrays.asList("name", "description", "notes", "url", "cvssVectors", "createDate", "updateDate", "cwe", "vulnerable_software", "references", "tags", "vulnerabilityStatus", "cvss", "kevData", "epssData"));
        }
    };
    protected VulnerabilityTypeIdentifier<?> sourceIdentifier;
    private String description;
    private String notes;
    private String url;
    protected Date createDate;
    protected Date updateDate;
    private final CvssVectorSet cvssVectors = new CvssVectorSet();
    private CvssSelectionResult cvssSelectionResult;
    private final Set<Reference> references = new LinkedHashSet<Reference>();
    private final Set<String> cwes = new LinkedHashSet<String>();
    private EpssData epssData;
    private final Set<VulnerableSoftwareTreeNode> vulnerableSoftwareConfigurations = new HashSet<VulnerableSoftwareTreeNode>();
    private final Set<AdvisoryEntry> securityAdvisories = new LinkedHashSet<AdvisoryEntry>();
    private KevData kevData;
    private final Set<String> tags = new LinkedHashSet<String>();
    private VulnerabilityStatus vulnerabilityStatus;
    public static final Comparator<Vulnerability> UPDATE_CREATE_TIME_COMPARATOR = Comparator.comparing(Vulnerability::getUpdateDate).thenComparing(Vulnerability::getCreateDate);
    public static final Comparator<Vulnerability> COMPARE_BY_NAME = Comparator.comparing(AmbDataClass::getId);

    public Vulnerability() {
    }

    public Vulnerability(String id) {
        super.setId(id);
    }

    public void setSourceIdentifier(VulnerabilityTypeIdentifier<?> source) {
        if (source == null) {
            throw new IllegalArgumentException("Advisory source must not be null");
        }
        if (LOG.isDebugEnabled() && source != this.sourceIdentifier && this.sourceIdentifier != null) {
            LOG.warn("Explicitly assigned source differs from originally assigned [{}] --> [{}]", (Object)this.sourceIdentifier.toExtendedString(), (Object)source.toExtendedString());
        }
        this.sourceIdentifier = source;
    }

    @Override
    public VulnerabilityTypeIdentifier<?> getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        if (this.id.startsWith("CVE-")) {
            return "https://nvd.nist.gov/vuln/detail/" + this.id;
        }
        return null;
    }

    public boolean isCreatedAfter(Date date) {
        return this.createDate != null && this.createDate.after(date);
    }

    public boolean isCreatedBefore(Date date) {
        return this.createDate != null && this.createDate.before(date);
    }

    public boolean isUpdatedAfter(Date date) {
        return this.updateDate != null && this.updateDate.after(date);
    }

    public boolean isUpdatedBefore(Date date) {
        return this.updateDate != null && this.updateDate.before(date);
    }

    public boolean hasBeenUpdatedSince(long millis) {
        return this.updateDate != null && this.updateDate.getTime() > millis || this.createDate != null && this.createDate.getTime() > millis;
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addReferences(Collection<Reference> references) {
        this.references.addAll(references);
    }

    public void addCwe(String cwe) {
        if (cwe != null) {
            this.cwes.add(cwe);
        }
    }

    public void addCwe(String ... cwe) {
        this.addCwes(Arrays.asList(cwe));
    }

    private void addCwes(Collection<String> cwes) {
        cwes.forEach(this::addCwe);
    }

    public void addVulnerableSoftware(VulnerableSoftwareVersionRangeCpe vulnerableSoftware) {
        VulnerableSoftwareTreeNode node = new VulnerableSoftwareTreeNode("OR");
        node.addNode(vulnerableSoftware);
        this.vulnerableSoftwareConfigurations.add(node);
    }

    public void addVulnerableSoftwares(Collection<VulnerableSoftwareVersionRangeCpe> vulnerableSoftware) {
        vulnerableSoftware.forEach(this::addVulnerableSoftware);
    }

    public void addVulnerableSoftwareTreeNode(VulnerableSoftwareTreeNode vulnerableSoftware) {
        this.vulnerableSoftwareConfigurations.add(vulnerableSoftware);
    }

    public void addVulnerableSoftwaresTreeNodes(Collection<VulnerableSoftwareTreeNode> vulnerableSoftware) {
        vulnerableSoftware.forEach(this::addVulnerableSoftwareTreeNode);
    }

    public boolean cpeFlatMatchesVulnerableSoftware(Cpe cpe) {
        return this.vulnerableSoftwareConfigurations.stream().anyMatch(configuration -> configuration.isAffectedFlat(cpe));
    }

    public VulnerableSoftwareVersionRangeCpe getCpeFlatMatchedVulnerableSoftware(Cpe cpe) {
        return this.vulnerableSoftwareConfigurations.stream().map(configuration -> configuration.getFlatAffectedNode(cpe)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Optional<VulnerabilityStatus> optVulnerabilityStatus() {
        return Optional.ofNullable(this.vulnerabilityStatus);
    }

    public VulnerabilityStatus getOrCreateNewVulnerabilityStatus() {
        if (this.vulnerabilityStatus == null) {
            this.vulnerabilityStatus = new VulnerabilityStatus();
        }
        return this.vulnerabilityStatus;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AdvisoryTypeIdentifier<?>, Set<String>> deepCopyReferencedSecurityAdvisories() {
        HashMap copy = new HashMap();
        Map map = this.referencedSecurityAdvisories;
        synchronized (map) {
            for (Map.Entry referencedEntry : this.referencedSecurityAdvisories.entrySet()) {
                copy.put((AdvisoryTypeIdentifier<?>)referencedEntry.getKey(), (Set<String>)new HashSet((Collection)referencedEntry.getValue()));
            }
        }
        return copy;
    }

    public void addSecurityAdvisory(AdvisoryEntry advisoryEntry) {
        this.securityAdvisories.add(advisoryEntry);
        this.addReferencedSecurityAdvisory(advisoryEntry);
    }

    public void removeSecurityAdvisory(AdvisoryEntry advisoryEntry) {
        this.securityAdvisories.remove(advisoryEntry);
        this.removeReferencedSecurityAdvisory(advisoryEntry);
    }

    public Set<AdvisoryEntry> getRelatedAdvisors(AdvisoryTypeIdentifier<?> type) {
        return Vulnerability.getRelatedAdvisors(type, this.securityAdvisories);
    }

    public static Set<AdvisoryEntry> getRelatedAdvisors(AdvisoryTypeIdentifier<?> type, Collection<AdvisoryEntry> advisoryProviders) {
        if (type == null) {
            return Collections.emptySet();
        }
        return advisoryProviders.stream().filter(advisory -> advisory.getSourceIdentifier() == type).collect(Collectors.toSet());
    }

    public <A extends AdvisoryEntry> List<A> getRelatedAdvisors(AdvisoryTypeIdentifier<?> type, Class<A> typeClass) {
        if (type == null || typeClass == null) {
            return Collections.emptyList();
        }
        return this.getRelatedAdvisors(type).stream().filter(typeClass::isInstance).map(typeClass::cast).collect(Collectors.toList());
    }

    public Set<AdvisoryTypeIdentifier<?>> getRelatedAdvisorsTypes() {
        return this.securityAdvisories.stream().map(AdvisoryEntry::getSourceIdentifier).collect(Collectors.toSet());
    }

    public void setKevData(KevData kevData) {
        this.kevData = kevData;
    }

    public KevData getKevData() {
        return this.kevData;
    }

    public CvssVectorSet getCvssVectors() {
        return this.cvssVectors;
    }

    public CvssVectorSet calculateEffectiveCvssVectors() {
        return this.calculateEffectiveCvssVectors(this.cvssVectors);
    }

    public CvssVectorSet calculateEffectiveCvssVectors(CvssVectorSet cvssVectors) {
        CvssVectorSet effectiveCvssVectors = new CvssVectorSet();
        effectiveCvssVectors.addAllCvssVectors(cvssVectors);
        for (AdvisoryEntry advisoryEntry : this.securityAdvisories) {
            for (CvssVector sourcedCvssVector : advisoryEntry.getCvssVectors().getCvssVectors()) {
                if (!this.isCvssVectorApplicable(sourcedCvssVector.getApplicabilityCondition())) continue;
                effectiveCvssVectors.addCvssVector(sourcedCvssVector);
            }
        }
        return effectiveCvssVectors;
    }

    protected boolean isCvssVectorApplicable(JSONObject applicabilityCondition) {
        if (applicabilityCondition == null || applicabilityCondition.isEmpty()) {
            return true;
        }
        Object findMsProductIdsObj = applicabilityCondition.opt(CvssConditionAttributes.MATCHES_ON_MS_PRODUCT_ID);
        if (findMsProductIdsObj instanceof JSONArray) {
            List findMsProductIds = ((JSONArray)findMsProductIdsObj).toList().stream().map(String::valueOf).collect(Collectors.toList());
            boolean foundMatchingArtifact = false;
            for (Artifact artifact : this.getAffectedArtifactsByDefaultKey()) {
                String msProductId = artifact.get((AbstractModelBase.Attribute)InventoryAttribute.MS_PRODUCT_ID);
                if (msProductId == null) continue;
                List<String> artifactMsProductIds = Arrays.asList(msProductId.split(", "));
                if (!artifactMsProductIds.stream().anyMatch(findMsProductIds::contains)) continue;
                foundMatchingArtifact = true;
                break;
            }
            if (!foundMatchingArtifact) {
                return false;
            }
        }
        return true;
    }

    public CvssSelectionResult selectEffectiveCvssVectors(CvssVectorSet cvssVectorSet, CvssSelector baseSelector, CvssSelector effectiveSelector, List<CvssSelectionResult.CvssScoreVersionSelectionPolicy> versionSelectionPolicy) {
        return new CvssSelectionResult(cvssVectorSet, baseSelector, effectiveSelector, versionSelectionPolicy);
    }

    public CvssSelectionResult selectEffectiveCvssVectors(CvssVectorSet cvssVectorSet, CentralSecurityPolicyConfiguration config) {
        return this.selectEffectiveCvssVectors(cvssVectorSet, config.getInitialCvssSelector(), config.getContextCvssSelector(), config.getCvssVersionSelectionPolicy());
    }

    public void selectEffectiveCvssVectors(CvssSelector baseSelector, CvssSelector effectiveSelector, List<CvssSelectionResult.CvssScoreVersionSelectionPolicy> versionSelectionPolicy) {
        this.cvssSelectionResult = this.selectEffectiveCvssVectors(this.calculateEffectiveCvssVectors(), baseSelector, effectiveSelector, versionSelectionPolicy);
    }

    public void selectEffectiveCvssVectors(CentralSecurityPolicyConfiguration config) {
        this.selectEffectiveCvssVectors(config.getInitialCvssSelector(), config.getContextCvssSelector(), config.getCvssVersionSelectionPolicy());
    }

    public boolean isCvssSelectionResultAvailable() {
        return this.cvssSelectionResult != null;
    }

    public CvssSelectionResult getCvssSelectionResult() {
        if (!this.isCvssSelectionResultAvailable()) {
            throw new IllegalStateException("No cvss selection result available. Please call selectEffectiveCvssVectors() first, or use the getCvssSelectionResult(CentralSecurityPolicyConfiguration) method to select the effective cvss vectors on the fly.");
        }
        return this.cvssSelectionResult;
    }

    public CvssSelectionResult getCvssSelectionResult(CentralSecurityPolicyConfiguration config) {
        if (!this.isCvssSelectionResultAvailable()) {
            if (config == null) {
                throw new IllegalStateException("No cvss selection result available and passed CentralSecurityPolicyConfiguration is null, cannot select cvss vectors on the fly.");
            }
            this.selectEffectiveCvssVectors(config);
        }
        return this.cvssSelectionResult;
    }

    public void clearCvssSelectionResult() {
        this.cvssSelectionResult = null;
    }

    public void mapCvssSelectionResult(Function<CvssSelectionResult, CvssSelectionResult> mapper) {
        if (this.cvssSelectionResult == null) {
            throw new IllegalStateException("No cvss selection result available. Please call selectEffectiveCvssVectors() first, or use the getCvssSelectionResult(CentralSecurityPolicyConfiguration) method to select the effective cvss vectors on the fly.");
        }
        this.cvssSelectionResult = mapper.apply(this.cvssSelectionResult);
    }

    public List<KeywordSet> parseKeywords() {
        return KeywordSet.fromVulnerability(this);
    }

    public VulnerabilityPriorityCalculator.PriorityScoreResult calculatePriorityScore(CentralSecurityPolicyConfiguration config) {
        return new VulnerabilityPriorityCalculator().contribute(this).calculatePriorityScore(config);
    }

    public void clearNonTransferableStatusDetails() {
        this.setAdditionalAttribute(VulnerabilityMetaData.Attribute.STATUS, null);
        this.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RATIONALE, null);
        this.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RISK, null);
        this.setAdditionalAttribute(InventoryAttribute.STATUS_ACCEPTED, null);
        this.setAdditionalAttribute(InventoryAttribute.STATUS_REPORTED, null);
        this.setAdditionalAttribute(InventoryAttribute.STATUS_HISTORY, null);
        this.setAdditionalAttribute(InventoryAttribute.STATUS_TITLE, null);
        this.setAdditionalAttribute(InventoryAttribute.REVIEWED_ADVISORIES, null);
    }

    @Override
    public VulnerabilityMetaData constructBaseModel() {
        return new VulnerabilityMetaData();
    }

    @Override
    public Vulnerability constructDataClass() {
        return new Vulnerability();
    }

    @Override
    protected Set<String> conversionKeysAmb() {
        return CONVERSION_KEYS_AMB;
    }

    @Override
    protected Set<String> conversionKeysMap() {
        return CONVERSION_KEYS_MAP;
    }

    public static Vulnerability fromVulnerabilityMetaData(VulnerabilityMetaData vmd) {
        if (vmd == null) {
            return null;
        }
        return new Vulnerability().performAction(v -> v.appendFromBaseModel(vmd));
    }

    public static Vulnerability fromInputMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return new Vulnerability().performAction(v -> v.appendFromMap(map));
    }

    public static Vulnerability fromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        return Vulnerability.fromInputMap(json.toMap());
    }

    public static Vulnerability fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        return new Vulnerability().performAction(v -> v.appendFromDocument(document));
    }

    @Override
    public void appendFromBaseModel(VulnerabilityMetaData vmd) {
        String tagsString;
        super.appendFromBaseModel(vmd);
        this.setId(vmd.get(VulnerabilityMetaData.Attribute.NAME));
        String vulnerabilitySource = vmd.get(VulnerabilityMetaData.Attribute.SOURCE);
        String vulnerabilitySourceImplementation = vmd.get(VulnerabilityMetaData.Attribute.SOURCE_IMPLEMENTATION);
        if (StringUtils.hasText(vulnerabilitySource) || StringUtils.hasText(vulnerabilitySourceImplementation)) {
            this.setSourceIdentifier((VulnerabilityTypeIdentifier)VulnerabilityTypeStore.get().fromNameAndImplementation(vulnerabilitySource, vulnerabilitySourceImplementation));
        } else {
            VulnerabilityTypeStore.get().inferSourceIdentifierFromIdIfAbsent(this);
        }
        this.setDescription(vmd.get(InventoryAttribute.DESCRIPTION.getKey()));
        this.setUrl(vmd.get(VulnerabilityMetaData.Attribute.URL));
        CvssSource.fromMultipleColumnHeaderStrings((Set)vmd.getAttributes()).forEach((header, source) -> {
            if (StringUtils.hasText(vmd.get(header))) {
                this.cvssVectors.addCvssVector(source, vmd.get(header));
            }
        });
        if (StringUtils.hasText(vmd.get(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey()))) {
            this.setUpdateDate(new Date(Long.parseLong(vmd.get(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey()))));
        }
        if (StringUtils.hasText(vmd.get(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey()))) {
            this.setCreateDate(new Date(Long.parseLong(vmd.get(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey()))));
        }
        if (StringUtils.hasText(vmd.get(VulnerabilityMetaData.Attribute.REFERENCES))) {
            String referencesString = vmd.get(VulnerabilityMetaData.Attribute.REFERENCES);
            if (referencesString.startsWith("[")) {
                List<Reference> references = Reference.fromJsonArray(new JSONArray(referencesString));
                this.addReferences(references);
            } else {
                for (String ref : referencesString.split(", ?")) {
                    Matcher matcher = Reference.REFERENCE_STRING_PATTERN.matcher(ref);
                    if (matcher.matches()) {
                        this.addReference(Reference.fromTitleAndUrl(matcher.group(1) + "(" + matcher.group(3) + ")", matcher.group(2)));
                        continue;
                    }
                    this.addReference(Reference.fromUrl(ref));
                }
            }
        }
        if (vmd.get((AbstractModelBase.Attribute)InventoryAttribute.KEV_DATA) != null) {
            this.setKevData(KevData.fromJson(new JSONObject(vmd.get((AbstractModelBase.Attribute)InventoryAttribute.KEV_DATA))));
        }
        if (StringUtils.hasText(vmd.get(VulnerabilityMetaData.Attribute.WEAKNESS))) {
            this.addCwes(Arrays.asList(vmd.get(VulnerabilityMetaData.Attribute.WEAKNESS).split(", ?")));
        }
        if (vmd.get((AbstractModelBase.Attribute)InventoryAttribute.EPSS_DATA) != null) {
            this.setEpssData(EpssData.fromJson(new JSONObject(vmd.get((AbstractModelBase.Attribute)InventoryAttribute.EPSS_DATA))));
        }
        if (StringUtils.hasText(tagsString = vmd.get(InventoryAttribute.TAGS.getKey()))) {
            this.addTags(Arrays.asList(tagsString.split(", ")));
        }
        if (StringUtils.hasText(vmd.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_STATUS))) {
            this.setVulnerabilityStatus(VulnerabilityStatusConverter.fromJson(new JSONObject(vmd.get((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_STATUS))));
        }
    }

    @Override
    public void appendToBaseModel(VulnerabilityMetaData vmd) {
        super.appendToBaseModel(vmd);
        if (this.url != null) {
            vmd.set(VulnerabilityMetaData.Attribute.URL, this.url);
        } else if (StringUtils.hasText(this.id) && this.id.startsWith("CVE-")) {
            vmd.set(VulnerabilityMetaData.Attribute.URL, "https://nvd.nist.gov/vuln/detail/" + this.id);
        } else {
            vmd.set(VulnerabilityMetaData.Attribute.URL, null);
        }
        if (!this.cwes.isEmpty()) {
            vmd.set(VulnerabilityMetaData.Attribute.WEAKNESS, String.join((CharSequence)", ", this.cwes));
        } else {
            vmd.set(VulnerabilityMetaData.Attribute.WEAKNESS, null);
        }
        if (this.epssData != null) {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.EPSS_DATA, this.epssData.toJson().toString());
        } else {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.EPSS_DATA, null);
        }
        for (CvssVector entry : this.cvssVectors.getCvssVectors()) {
            if (entry.getCvssSource() == null) {
                LOG.warn("Using NVD-CNA-NVD for cvss vector [{}] for vulnerability [{}] as it has no source.", (Object)entry, (Object)this.id);
                vmd.set(new CvssSource(KnownCvssEntities.NVD, CvssSource.CvssIssuingEntityRole.CNA, KnownCvssEntities.NVD, entry.getClass()).toColumnHeaderString(), entry.toString());
                continue;
            }
            vmd.set(entry.getCvssSource().toColumnHeaderString(), entry.toString());
        }
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL_SEVERITY, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL_SEVERITY, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_BASE, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_EXPLOITABILITY, null);
        vmd.set(VulnerabilityMetaData.Attribute.SCORE_IMPACT, null);
        if (this.isCvssSelectionResultAvailable()) {
            CvssVector selectedContextCvss = this.cvssSelectionResult.getSelectedContextCvss();
            CvssVector selectedInitialCvss = this.cvssSelectionResult.getSelectedInitialCvss();
            CvssVector contextOrInitial = this.cvssSelectionResult.getSelectedContextIfAvailableOtherwiseInitial();
            if (selectedInitialCvss != null) {
                vmd.set(VulnerabilityMetaData.Attribute.SCORE_INITIAL_OVERALL, String.valueOf(selectedInitialCvss.getBakedScores().getOverallScore()));
                vmd.set(VulnerabilityMetaData.Attribute.SCORE_INITIAL_SELECTION, String.valueOf(selectedInitialCvss.toJson()));
            }
            if (selectedContextCvss != null) {
                vmd.set(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_OVERALL, String.valueOf(selectedContextCvss.getBakedScores().getOverallScore()));
                vmd.set(VulnerabilityMetaData.Attribute.SCORE_CONTEXT_SELECTION, String.valueOf(selectedContextCvss.toJson()));
            }
            if (contextOrInitial != null) {
                if (!Double.isNaN(contextOrInitial.getBakedScores().getBaseScore())) {
                    vmd.set(VulnerabilityMetaData.Attribute.SCORE_BASE, String.valueOf(contextOrInitial.getBakedScores().getBaseScore()));
                }
                if (!Double.isNaN(contextOrInitial.getBakedScores().getExploitabilityScore())) {
                    vmd.set(VulnerabilityMetaData.Attribute.SCORE_EXPLOITABILITY, String.valueOf(contextOrInitial.getBakedScores().getExploitabilityScore()));
                }
                if (!Double.isNaN(contextOrInitial.getBakedScores().getImpactScore())) {
                    vmd.set(VulnerabilityMetaData.Attribute.SCORE_IMPACT, String.valueOf(contextOrInitial.getBakedScores().getImpactScore()));
                }
            }
        }
        if (this.kevData != null) {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.KEV_DATA, this.kevData.toJson().toString());
        } else {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.KEV_DATA, null);
        }
        if (this.createDate != null) {
            vmd.set(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey(), Long.toString(this.createDate.getTime()));
            vmd.set(InventoryAttribute.VULNERABILITY_CREATED_DATE_FORMATTED.getKey(), TimeUtils.formatNormalizedDate(this.createDate));
        } else {
            vmd.set(InventoryAttribute.VULNERABILITY_CREATED_DATE_TIMESTAMP.getKey(), null);
        }
        if (this.updateDate != null) {
            vmd.set(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey(), Long.toString(this.updateDate.getTime()));
            vmd.set(InventoryAttribute.VULNERABILITY_UPDATED_DATE_FORMATTED.getKey(), TimeUtils.formatNormalizedDate(this.updateDate));
        } else {
            vmd.set(InventoryAttribute.VULNERABILITY_UPDATED_DATE_TIMESTAMP.getKey(), null);
        }
        if (!this.references.isEmpty()) {
            List<Reference> mergedReferences = Reference.mergeReferences(this.references, Reference.fromJsonArray(vmd.get(VulnerabilityMetaData.Attribute.REFERENCES)));
            vmd.set(VulnerabilityMetaData.Attribute.REFERENCES, mergedReferences.stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()).toString());
        } else {
            vmd.set(VulnerabilityMetaData.Attribute.REFERENCES, null);
        }
        if (this.description != null) {
            vmd.set(InventoryAttribute.DESCRIPTION.getKey(), this.description);
        } else {
            vmd.set(InventoryAttribute.DESCRIPTION.getKey(), null);
        }
        if (!this.tags.isEmpty()) {
            vmd.set(InventoryAttribute.TAGS.getKey(), String.join((CharSequence)", ", this.tags));
        } else {
            vmd.set(InventoryAttribute.TAGS.getKey(), null);
        }
        if (this.vulnerabilityStatus != null) {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_STATUS, this.vulnerabilityStatus.toJson().toString());
        } else {
            vmd.set((AbstractModelBase.Attribute)InventoryAttribute.VULNERABILITY_STATUS, null);
        }
    }

    @Override
    public void appendFromDataClass(Vulnerability dataClass) {
        super.appendFromDataClass(dataClass);
        if (StringUtils.hasText(dataClass.getDescription())) {
            this.setDescription(dataClass.getDescription());
        }
        if (StringUtils.hasText(dataClass.getNotes())) {
            this.setNotes(dataClass.getNotes());
        }
        if (StringUtils.hasText(dataClass.getUrl())) {
            this.setUrl(dataClass.getUrl());
        }
        if (dataClass.getCreateDate() != null) {
            this.setCreateDate(dataClass.getCreateDate());
        }
        if (dataClass.getUpdateDate() != null) {
            this.setUpdateDate(dataClass.getUpdateDate());
        }
        this.cvssVectors.addAllCvssVectors(dataClass.getCvssVectors());
        this.addReferences(dataClass.getReferences());
        this.addCwes(dataClass.getCwes());
        this.setKevData(dataClass.getKevData());
        this.setEpssData(dataClass.getEpssData());
        dataClass.getSecurityAdvisories().forEach(this::addSecurityAdvisory);
        if (dataClass.getVulnerabilityStatus() != null) {
            this.setVulnerabilityStatus(dataClass.getVulnerabilityStatus());
        }
        this.addTags(dataClass.getTags());
    }

    @Override
    public void appendFromMap(Map<String, Object> input) {
        Object ref;
        super.appendFromMap(input);
        this.setId(Vulnerability.getStringOrNullFromMap(input, "name"));
        String source = input.getOrDefault("source", null);
        String sourceImplementation = input.getOrDefault("sourceImplementation", null);
        if (source != null || sourceImplementation != null) {
            this.setSourceIdentifier((VulnerabilityTypeIdentifier)VulnerabilityTypeStore.get().fromNameAndImplementation(source, sourceImplementation));
        }
        this.setDescription(Vulnerability.getStringOrNullFromMap(input, "description"));
        this.setNotes(Vulnerability.getStringOrNullFromMap(input, "notes"));
        this.setUrl(Vulnerability.getStringOrNullFromMap(input, "url"));
        if (input.get("cvss") != null) {
            Object cvssVectorsJson;
            if (input.get("cvss") instanceof String) {
                String cvssVectors = (String)input.get("cvss");
                cvssVectorsJson = new JSONArray(cvssVectors);
            } else if (input.get("cvss") instanceof JSONArray) {
                cvssVectorsJson = (JSONArray)input.get("cvss");
            } else if (input.get("cvss") instanceof Collection) {
                cvssVectorsJson = new JSONArray((Collection)input.get("cvss"));
            } else {
                throw new RuntimeException("Unable to parse cvss vectors from input map: " + input.get("cvss"));
            }
            this.cvssVectors.addAllCvssVectors(CvssVectorSet.fromJson((JSONArray)cvssVectorsJson));
        }
        this.setCreateDate((Date)ObjectUtils.firstNonNull((Object[])new Date[]{Vulnerability.getDateOrNullFromMap(input, "createDate"), Vulnerability.getDateOrNullFromMap(input, "publishedDate")}));
        this.setUpdateDate((Date)ObjectUtils.firstNonNull((Object[])new Date[]{Vulnerability.getDateOrNullFromMap(input, "updateDate"), Vulnerability.getDateOrNullFromMap(input, "lastModifiedDate")}));
        for (String cwe : (Collection)input.getOrDefault("cwe", Collections.EMPTY_SET)) {
            this.addCwe(cwe);
        }
        if (input.get("vulnerable_software") != null) {
            try {
                JSONArray array = new JSONArray((Object)((ArrayList)input.get("vulnerable_software")).toArray(new Object[0]));
                VulnerableSoftwareTreeNode.fromJson(array).forEach(this::addVulnerableSoftwareTreeNode);
            }
            catch (CpeValidationException e) {
                throw new RuntimeException("Unable to parse CPE on vulnerable software whilst parsing vulnerability from input map", e);
            }
        }
        if ((ref = input.get("references")) instanceof ArrayList) {
            for (Object reference : (ArrayList)ref) {
                if (reference instanceof Map) {
                    this.addReference(Reference.fromMap((Map)reference));
                    continue;
                }
                LOG.warn("Reference in custom vulnerability [{}] is not of type Map: {}", (Object)this.getId(), reference);
            }
        }
        if (input.get("tags") != null) {
            this.addTags((Collection)input.get("tags"));
        }
        if (input.get("vulnerabilityStatus") != null) {
            this.setVulnerabilityStatus(VulnerabilityStatusConverter.fromJson(new JSONObject((Map)input.get("vulnerabilityStatus"))));
        }
        if (input.get("kevData") != null) {
            this.setKevData(KevData.fromJson(new JSONObject((Map)input.get("kevData"))));
        }
        if (input.get("epssData") != null) {
            this.setEpssData(EpssData.fromJson(new JSONObject((Map)input.get("epssData"))));
        }
    }

    @Override
    public void appendToJson(JSONObject json) {
        super.appendToJson(json);
        json.put("name", (Object)this.getId());
        json.put("description", (Object)this.getDescription());
        json.put("notes", (Object)this.getNotes());
        json.put("url", (Object)this.getUrl());
        json.put("cvss", (Object)this.cvssVectors.toJson());
        json.put("createDate", this.getCreateDate() != null ? Long.valueOf(this.getCreateDate().getTime()) : null);
        json.put("updateDate", this.getUpdateDate() != null ? Long.valueOf(this.getUpdateDate().getTime()) : null);
        json.put("cwe", this.getCwes());
        json.put("vulnerable_software", (Object)this.getVulnerableSoftwareConfigurations().stream().map(VulnerableSoftwareTreeNode::toJson).collect(CustomCollectors.toJsonArray()));
        json.put("references", (Object)this.getReferences().stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()));
        json.put("tags", this.getTags());
        json.put("vulnerabilityStatus", this.getVulnerabilityStatus() != null ? this.getVulnerabilityStatus().toJson() : null);
        if (this.kevData != null) {
            json.put("kevData", (Object)this.kevData.toJson());
        }
        if (this.epssData != null) {
            json.put("epssData", (Object)this.epssData.toJson());
        }
    }

    @Override
    public void appendFromDocument(Document document) {
        super.appendFromDocument(document);
        this.setId(document.get("name"));
        this.setDescription(document.get("description"));
        this.setNotes(document.get("notes"));
        this.setUrl(document.get("url"));
        if (document.get("cvssV2") != null) {
            this.cvssVectors.addCvssVector(new CvssSource(KnownCvssEntities.NVD, Cvss2.class), document.get("cvssV2"));
        }
        if (document.get("cvssV3") != null) {
            this.cvssVectors.addCvssVector(new CvssSource(KnownCvssEntities.NVD, Cvss3P1.class), document.get("cvssV3"));
        }
        if (document.get("cvssV4") != null) {
            this.cvssVectors.addCvssVector(new CvssSource(KnownCvssEntities.NVD, Cvss4P0.class), document.get("cvssV4"));
        }
        if (document.get("cvssVectors") != null) {
            String cvssVectors = document.get("cvssVectors");
            JSONArray cvssVectorsJson = new JSONArray(cvssVectors);
            this.cvssVectors.addAllCvssVectors(CvssVectorSet.fromJson((JSONArray)cvssVectorsJson));
        }
        this.setCreateDate(Vulnerability.getDateOrNullFromDocument(document, "createDate"));
        this.setUpdateDate(Vulnerability.getDateOrNullFromDocument(document, "updateDate"));
        if (document.get("cwe") != null) {
            Arrays.stream(document.get("cwe").split(", ?")).forEach(this::addCwe);
        }
        if (document.get("vulnerable_software") != null) {
            try {
                VulnerableSoftwareTreeNode.fromJson(new JSONArray(document.get("vulnerable_software"))).forEach(this::addVulnerableSoftwareTreeNode);
            }
            catch (CpeValidationException e) {
                throw new RuntimeException("Unable to parse CPE on vulnerable software whilst parsing vulnerability from document", e);
            }
        }
        Reference.fromJsonArray(new JSONArray(document.get("references"))).forEach(this::addReference);
    }

    @Override
    public void appendToDocument(Document doc) {
        super.appendToDocument(doc);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "name", this.getId());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "description", this.getDescription());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "notes", this.getNotes());
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "url", this.getUrl());
        if (!this.cvssVectors.isEmpty()) {
            JSONArray cvssVectors = this.cvssVectors.toJson();
            doc.add((IndexableField)new TextField("cvssVectors", cvssVectors.toString(), Field.Store.YES));
        }
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "createDate", this.getCreateDate() != null ? "" + this.getCreateDate().getTime() : null);
        this.addToDocumentAsTextFieldIfNotEmpty(doc, "updateDate", this.getUpdateDate() != null ? "" + this.getUpdateDate().getTime() : null);
        doc.add((IndexableField)new TextField("cwe", String.join((CharSequence)",", this.getCwes()), Field.Store.YES));
        doc.add((IndexableField)new TextField("references", this.getReferences().stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
        doc.add((IndexableField)new TextField("vulnerable_software", this.getVulnerableSoftwareConfigurations().stream().map(VulnerableSoftwareTreeNode::toJson).collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
        String allVendorProducts = this.getVulnerableSoftwareConfigurations().stream().map(VulnerableSoftwareTreeNode::getAllCpes).flatMap(Collection::stream).map(cpe -> cpe.getCpe().getVendor() + ":" + cpe.getCpe().getProduct()).collect(Collectors.joining(" "));
        doc.add((IndexableField)new TextField("vulnerable_software_vp", allVendorProducts, Field.Store.YES));
    }

    private static Date getDateOrNullFromDocument(Document document, String date) {
        if (document.get(date) != null) {
            return new Date(Long.parseLong(document.get(date)));
        }
        return null;
    }

    protected void addToDocumentAsTextFieldIfNotEmpty(Document doc, String fieldName, String value) {
        if (StringUtils.hasText(value)) {
            doc.add((IndexableField)new TextField(fieldName, value, Field.Store.YES));
        }
    }

    @Deprecated
    public static Vulnerability fromVulnerabilityMetaData(VulnerabilityMetaData vmd, VulnerabilityIndexQuery vulnerabilityIndex) {
        Vulnerability vulnerability = Vulnerability.fromVulnerabilityMetaData(vmd);
        vulnerabilityIndex.findVulnerabilityByName(vulnerability.getId()).ifPresent(officialVulnerability -> vulnerability.addVulnerableSoftwaresTreeNodes(officialVulnerability.getVulnerableSoftwareConfigurations()));
        return vulnerability;
    }

    @Deprecated
    public static Vulnerability fromNvdMirrorCveItem1P0(JSONObject cveItem) {
        Cvss3P1 cvss3;
        JSONObject cveInformation;
        Vulnerability vulnerability = new Vulnerability();
        JSONObject jSONObject = cveInformation = cveItem.has("cve") ? cveItem.getJSONObject("cve") : cveItem;
        if (!cveInformation.getString("data_type").equals("CVE")) {
            LOG.warn("Data type should be [CVE] in CVE item, but was [{}]", (Object)cveInformation.getString("data_type"));
        }
        vulnerability.setId(cveInformation.getJSONObject("CVE_data_meta").getString("ID"));
        vulnerability.setNotes("Assigner: " + cveInformation.getJSONObject("CVE_data_meta").getString("ASSIGNER"));
        vulnerability.addDataSource(VulnerabilityTypeStore.CVE);
        vulnerability.addDataSource(OtherTypeStore.NVD);
        JSONArray descriptions = cveInformation.getJSONObject("description").getJSONArray("description_data");
        String description = null;
        for (int i = 0; i < descriptions.length(); ++i) {
            JSONObject descriptionData = descriptions.getJSONObject(i);
            if (descriptionData.getString("lang").equals("en")) {
                description = descriptionData.getString("value");
                break;
            }
            if (description != null) continue;
            description = descriptionData.getString("value");
        }
        if (StringUtils.hasText(description)) {
            vulnerability.setDescription(description);
        }
        if (StringUtils.hasText(cveItem.optString("publishedDate"))) {
            vulnerability.setCreateDate(TimeUtils.tryParse(cveItem.getString("publishedDate")));
        }
        if (StringUtils.hasText(cveItem.optString("lastModifiedDate"))) {
            vulnerability.setUpdateDate(TimeUtils.tryParse(cveItem.getString("lastModifiedDate")));
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        JSONArray referencesData = cveInformation.getJSONObject("references").getJSONArray("reference_data");
        for (int i = 0; i < referencesData.length(); ++i) {
            JSONObject referenceData = referencesData.getJSONObject(i);
            Reference reference = Reference.fromTitleAndUrl(referenceData.getString("name"), referenceData.getString("url"));
            referenceData.getJSONArray("tags").forEach(tag -> reference.addTag(String.valueOf(tag)));
            reference.addTag(referenceData.getString("refsource"));
            references.add(reference);
        }
        vulnerability.addReferences(references);
        HashSet<String> cwes = new HashSet<String>();
        JSONArray problemtypeData = cveInformation.getJSONObject("problemtype").getJSONArray("problemtype_data");
        for (int i = 0; i < problemtypeData.length(); ++i) {
            JSONArray descriptionData = problemtypeData.getJSONObject(i).getJSONArray("description");
            for (int j = 0; j < descriptionData.length(); ++j) {
                JSONObject descriptionDataItem = descriptionData.getJSONObject(j);
                if (Vulnerability.isNoInfoOtherCwe(descriptionDataItem.getString("value"))) continue;
                cwes.add(descriptionDataItem.getString("value"));
            }
        }
        vulnerability.addCwes(cwes);
        JSONObject impact = cveItem.getJSONObject("impact");
        if (impact.has("baseMetricV2")) {
            Cvss2 cvss2 = new Cvss2(impact.getJSONObject("baseMetricV2").getJSONObject("cvssV2").getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, Cvss2.class));
            vulnerability.cvssVectors.addCvssVector((CvssVector)cvss2);
        }
        if (impact.has("baseMetricV3")) {
            cvss3 = new Cvss3P1(impact.getJSONObject("baseMetricV3").getJSONObject("cvssV3").getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, Cvss3P1.class));
            vulnerability.cvssVectors.addCvssVector((CvssVector)cvss3);
        }
        if (impact.has("baseMetricV4")) {
            cvss3 = new Cvss4P0(impact.getJSONObject("baseMetricV4").getJSONObject("cvssV4").getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, Cvss4P0.class));
        }
        HashSet<VulnerableSoftwareTreeNode> vulnerableSoftware = new HashSet<VulnerableSoftwareTreeNode>();
        JSONArray affectedConfigurations = cveItem.getJSONObject("configurations").getJSONArray("nodes");
        for (int i = 0; i < affectedConfigurations.length(); ++i) {
            JSONObject affectedConfigurationNode = affectedConfigurations.getJSONObject(i);
            try {
                VulnerableSoftwareTreeNode vulnerableSoftwareTree = VulnerableSoftwareTreeNode.fromJson(affectedConfigurationNode);
                vulnerableSoftware.add(vulnerableSoftwareTree);
                continue;
            }
            catch (CpeValidationException e) {
                throw new RuntimeException("Invalid CPE URI on [" + vulnerability.getId() + "] in software configuration: " + affectedConfigurationNode, e);
            }
        }
        vulnerability.addVulnerableSoftwaresTreeNodes(vulnerableSoftware);
        return vulnerability;
    }

    public static Vulnerability fromNvdMirrorCveItem2P0(JSONObject cveItem) {
        JSONObject metrics;
        Vulnerability vulnerability = new Vulnerability();
        vulnerability.setId(cveItem.getString("id"));
        vulnerability.addDataSource(VulnerabilityTypeStore.CVE);
        vulnerability.addDataSource(OtherTypeStore.NVD);
        JSONArray descriptions = cveItem.getJSONArray("descriptions");
        String description = null;
        for (int i = 0; i < descriptions.length(); ++i) {
            JSONObject descriptionData = descriptions.getJSONObject(i);
            if (descriptionData.getString("lang").equals("en")) {
                description = descriptionData.getString("value");
                break;
            }
            if (description != null) continue;
            description = descriptionData.getString("value");
        }
        if (StringUtils.hasText(description)) {
            vulnerability.setDescription(description);
        }
        if (StringUtils.hasText(cveItem.optString("published"))) {
            vulnerability.setCreateDate(TimeUtils.tryParse(cveItem.getString("published")));
        }
        if (StringUtils.hasText(cveItem.optString("lastModified"))) {
            vulnerability.setUpdateDate(TimeUtils.tryParse(cveItem.getString("lastModified")));
        }
        ArrayList<Reference> references = new ArrayList<Reference>();
        JSONArray referencesData = cveItem.getJSONArray("references");
        for (int i = 0; i < referencesData.length(); ++i) {
            JSONObject referenceData = referencesData.getJSONObject(i);
            Reference reference = Reference.fromTitleAndUrl(referenceData.getString("source"), referenceData.getString("url"));
            JSONArray tags = referenceData.optJSONArray("tags");
            if (tags != null) {
                tags.forEach(tag -> reference.addTag(String.valueOf(tag)));
            }
            reference.addTag(referenceData.getString("source"));
            references.add(reference);
        }
        vulnerability.addReferences(references);
        JSONArray weaknesses = cveItem.optJSONArray("weaknesses");
        if (weaknesses != null) {
            ArrayList<String> cwes = new ArrayList<String>();
            block4: for (int i = 0; i < weaknesses.length(); ++i) {
                JSONObject weakness = weaknesses.getJSONObject(i);
                JSONArray descriptionData = weakness.getJSONArray("description");
                for (int j = 0; j < descriptionData.length(); ++j) {
                    JSONObject descriptionObject = descriptionData.getJSONObject(j);
                    if (Vulnerability.isNoInfoOtherCwe(descriptionObject.getString("value"))) continue;
                    cwes.add(descriptionObject.getString("value"));
                    continue block4;
                }
            }
            vulnerability.addCwes(cwes);
        }
        if ((metrics = cveItem.optJSONObject("metrics")) != null) {
            JSONArray cvssMetricV4;
            JSONArray cvssMetricV3;
            JSONArray cvssMetricV2 = metrics.optJSONArray("cvssMetricV2");
            if (cvssMetricV2 != null) {
                for (int i = 0; i < cvssMetricV2.length(); ++i) {
                    JSONObject cvssMetricV2Object = cvssMetricV2.getJSONObject(i);
                    String source = cvssMetricV2Object.getString("source");
                    CvssSource.CvssEntity sourceEntity = source == null ? KnownCvssEntities.NVD : KnownCvssEntities.findByNameOrMailOrCreateNew((String)source);
                    JSONObject cvssData = cvssMetricV2Object.getJSONObject("cvssData");
                    Cvss2 cvssV2 = new Cvss2(cvssData.getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, CvssSource.CvssIssuingEntityRole.CNA, sourceEntity, Cvss2.class));
                    vulnerability.cvssVectors.addCvssVector((CvssVector)cvssV2);
                }
            }
            if ((cvssMetricV3 = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{metrics.optJSONArray("cvssMetricV30"), metrics.optJSONArray("cvssMetricV31")})) != null) {
                for (int i = 0; i < cvssMetricV3.length(); ++i) {
                    JSONObject cvssMetricV3Object = cvssMetricV3.getJSONObject(i);
                    String source = cvssMetricV3Object.getString("source");
                    CvssSource.CvssEntity sourceEntity = source == null ? KnownCvssEntities.NVD : KnownCvssEntities.findByNameOrMailOrCreateNew((String)source);
                    JSONObject cvssData = cvssMetricV3Object.getJSONObject("cvssData");
                    Cvss3P1 cvssV3 = new Cvss3P1(cvssData.getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, CvssSource.CvssIssuingEntityRole.CNA, sourceEntity, Cvss3P1.class));
                    vulnerability.cvssVectors.addCvssVector((CvssVector)cvssV3);
                }
            }
            if ((cvssMetricV4 = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{metrics.optJSONArray("cvssMetricV40"), metrics.optJSONArray("cvssMetricV4")})) != null) {
                for (int i = 0; i < cvssMetricV4.length(); ++i) {
                    JSONObject cvssMetricV4Object = cvssMetricV4.getJSONObject(i);
                    String source = cvssMetricV4Object.getString("source");
                    CvssSource.CvssEntity sourceEntity = source == null ? KnownCvssEntities.NVD : KnownCvssEntities.findByNameOrMailOrCreateNew((String)source);
                    JSONObject cvssData = cvssMetricV4Object.getJSONObject("cvssData");
                    Cvss4P0 cvssV4 = new Cvss4P0(cvssData.getString("vectorString"), new CvssSource(KnownCvssEntities.NVD, CvssSource.CvssIssuingEntityRole.CNA, sourceEntity, Cvss4P0.class));
                    vulnerability.cvssVectors.addCvssVector((CvssVector)cvssV4);
                }
            }
            if (metrics.keySet().stream().anyMatch(key -> !key.equals("cvssMetricV2") && !key.equals("cvssMetricV30") && !key.equals("cvssMetricV31") && !key.equals("cvssMetricV40") && !key.equals("cvssMetricV4"))) {
                LOG.warn("Unknown CVSS metric version: {}", (Object)metrics.keySet());
            }
        }
        if (cveItem.has("configurations")) {
            HashSet<VulnerableSoftwareTreeNode> vulnerableSoftware = new HashSet<VulnerableSoftwareTreeNode>();
            JSONArray affectedConfigurations = cveItem.getJSONArray("configurations");
            for (int i = 0; i < affectedConfigurations.length(); ++i) {
                JSONArray nodes = affectedConfigurations.getJSONObject(i).getJSONArray("nodes");
                for (int j = 0; j < nodes.length(); ++j) {
                    JSONObject configurationNode = nodes.getJSONObject(j);
                    try {
                        VulnerableSoftwareTreeNode vulnerableSoftwareTree = VulnerableSoftwareTreeNode.fromJson(configurationNode);
                        vulnerableSoftware.add(vulnerableSoftwareTree);
                        continue;
                    }
                    catch (CpeValidationException e) {
                        throw new RuntimeException("Invalid CPE URI on [" + vulnerability.getId() + "] in software configuration: " + configurationNode, e);
                    }
                }
            }
            vulnerability.addVulnerableSoftwaresTreeNodes(vulnerableSoftware);
        }
        return vulnerability;
    }

    public static List<Vulnerability> fromCustomVulnerabilityFileOrDir(File file) {
        ArrayList<Vulnerability> vulnerabilities;
        block18: {
            vulnerabilities = new ArrayList<Vulnerability>();
            if (!file.exists()) {
                LOG.warn("Vulnerability file does not exist: {}", (Object)file.getAbsolutePath());
                return vulnerabilities;
            }
            if (file.isDirectory()) {
                for (File subFile : file.listFiles()) {
                    vulnerabilities.addAll(Vulnerability.fromCustomVulnerabilityFileOrDir(subFile));
                }
            } else if (file.getName().endsWith(".yaml")) {
                try {
                    Object loaded = new Yaml().load(Files.newInputStream(file.toPath(), new OpenOption[0]));
                    if (loaded instanceof List) {
                        List loadedVulnerabilities = (List)loaded;
                        for (Object loadedVulnerability : loadedVulnerabilities) {
                            if (!(loadedVulnerability instanceof Map)) continue;
                            vulnerabilities.add(Vulnerability.fromInputMap((Map)loadedVulnerability));
                        }
                    } else if (loaded instanceof Map) {
                        vulnerabilities.add(Vulnerability.fromInputMap((Map)loaded));
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to parse YAML vulnerability file: " + file, (Throwable)e);
                }
            } else if (file.getName().endsWith(".json")) {
                try {
                    String lines = String.join((CharSequence)"", FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8));
                    if (lines.startsWith("[")) {
                        JSONArray array = new JSONArray(lines);
                        for (int i = 0; i < array.length(); ++i) {
                            vulnerabilities.add(Vulnerability.fromInputMap(array.getJSONObject(i).toMap()));
                        }
                        break block18;
                    }
                    vulnerabilities.add(Vulnerability.fromInputMap(new JSONObject(lines).toMap()));
                }
                catch (Exception e) {
                    LOG.error("Failed to parse JSON vulnerability file: " + file, (Throwable)e);
                }
            } else {
                LOG.info("Skipping file during vulnerability parsing: {}", (Object)file.getAbsolutePath());
            }
        }
        LOG.info("Parsed [{}] vulnerabilit{} from {}", new Object[]{vulnerabilities.size(), vulnerabilities.size() == 1 ? "y" : "ies", file.getAbsolutePath()});
        return vulnerabilities;
    }

    private static boolean isNoInfoOtherCwe(String value) {
        return (value = value.toLowerCase()).equals("nvd-cwe-noinfo") || value.equals("nvd-cwe-other");
    }

    private static String getStringOrNullFromMap(Map<String, Object> map, String key) {
        Object value = map.getOrDefault(key, null);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    private static Date getDateOrNullFromMap(Map<String, Object> map, String key) {
        Object value = map.getOrDefault(key, null);
        if (value == null) {
            return null;
        }
        return TimeUtils.tryParse(value.toString());
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static Map<Artifact, List<Vulnerability>> groupVulnerabilitiesByArtifact(Collection<Vulnerability> vulnerabilities) {
        HashMap<Artifact, List<Vulnerability>> groupedVulnerabilities = new HashMap<Artifact, List<Vulnerability>>();
        for (Vulnerability vulnerability : vulnerabilities) {
            for (Artifact artifact : vulnerability.getAffectedArtifactsByDefaultKey()) {
                groupedVulnerabilities.computeIfAbsent(artifact, k -> new ArrayList()).add(vulnerability);
            }
        }
        return groupedVulnerabilities;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Set<Reference> getReferences() {
        return this.references;
    }

    public Set<String> getCwes() {
        return this.cwes;
    }

    public EpssData getEpssData() {
        return this.epssData;
    }

    public void setEpssData(EpssData epssData) {
        this.epssData = epssData;
    }

    public Set<VulnerableSoftwareTreeNode> getVulnerableSoftwareConfigurations() {
        return this.vulnerableSoftwareConfigurations;
    }

    public Set<AdvisoryEntry> getSecurityAdvisories() {
        return this.securityAdvisories;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public VulnerabilityStatus getVulnerabilityStatus() {
        return this.vulnerabilityStatus;
    }

    public void setVulnerabilityStatus(VulnerabilityStatus vulnerabilityStatus) {
        this.vulnerabilityStatus = vulnerabilityStatus;
    }
}

