/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.advisor;

import com.metaeffekt.artifact.analysis.utils.ArchiveUtils;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.concurrency.ScheduledDelayedThreadPoolExecutor;
import com.metaeffekt.mirror.contents.advisory.CertFrAdvisorEntry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.WebAccess;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certfr", mavenPropertyName="certFrDownload")
public class CertFrDownload
extends Download {
    private static final Logger LOG = LoggerFactory.getLogger(CertFrDownload.class);
    private List<Integer> cachedAvailableArchiveYears = null;
    private List<Integer> cachedUnavailableArchiveYears = null;
    private static final Pattern EXTRACT_HTML_LISTING_DATE_PATTERN = Pattern.compile(".*le (\\d{1,2}) ([a-z\u00e9\u00fb]+) (\\d{4}).*");

    public CertFrDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertFrDownload.class);
    }

    @Override
    @DocRelevantMethods(value={"CertFrDownload#downloadRequiredArchiveYears"})
    protected void performDownload() {
        this.downloadRequiredArchiveYears();
        this.propertyFiles.set(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CERT_FR_PREFIX.getKey() + "last-feed-size", this.getCurrentFeedSize());
    }

    private void downloadRequiredArchiveYears() {
        List<Integer> updateYears = this.determineWhatYearsRequireUpdate();
        LOG.info("Updating year archives {}", updateYears);
        if (updateYears.isEmpty()) {
            LOG.info("--> No archive years require update, skipping archive download");
            return;
        }
        for (Integer year : updateYears) {
            File downloadIntoDirectory = this.downloadIntoDirectory;
            WebAccess downloader = this.downloader;
            ScheduledDelayedThreadPoolExecutor.ThrowingRunnable downloadThread = () -> {
                String content;
                LOG.info("Updating year [{}]", (Object)year);
                URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_ARCHIVE, year);
                File downloadToFile = new File(downloadIntoDirectory, year + ".tar");
                File unpackedDirectory = new File(downloadIntoDirectory, year.toString());
                if (unpackedDirectory.exists()) {
                    FileUtils.deleteDir(unpackedDirectory);
                }
                downloader.fetchResponseBodyFromUrlToFile(requestUrl, downloadToFile);
                if (!downloadToFile.exists()) {
                    throw new RuntimeException("Expected downloaded file does not exist: " + downloadToFile.getAbsolutePath() + " from " + requestUrl);
                }
                if (downloadToFile.length() < 2000L && ((content = FileUtils.readFileToString((File)downloadToFile, (Charset)StandardCharsets.UTF_8)).contains("404") && (content.startsWith("{") || content.startsWith("[") || content.startsWith("<")) || content.startsWith("<") && content.contains("502 Bad Gateway"))) {
                    FileUtils.deleteQuietly((File)downloadToFile);
                    throw new RuntimeException("Downloaded file contains 404 or 502 error. Skipping further processing for: " + downloadToFile.getAbsolutePath());
                }
                try {
                    ArchiveUtils.untar((File)downloadToFile, (File)unpackedDirectory);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Unable to untar from " + downloadToFile + " to " + unpackedDirectory, e);
                }
                if (!unpackedDirectory.exists()) {
                    if (!downloadToFile.delete()) {
                        LOG.warn("Unable to delete downloaded archive file: {}", (Object)downloadToFile.getAbsolutePath());
                    }
                    if (year == 2000) {
                        LOG.warn("Unable to untar from {} to {}, this is known for the year 2000, skipping year", (Object)downloadToFile, (Object)unpackedDirectory);
                        return;
                    }
                    throw new RuntimeException("Unable to untar from " + downloadToFile + " to " + unpackedDirectory);
                }
                for (File entry : unpackedDirectory.listFiles()) {
                    String content2;
                    if (entry.length() >= 2000L || !(content2 = FileUtils.readFileToString((File)entry, (Charset)StandardCharsets.UTF_8)).startsWith("<") || !content2.contains("502 Bad Gateway")) continue;
                    LOG.warn("Unpacked file contains HTTP error code. Deleting: {}", (Object)entry.getAbsolutePath());
                    FileUtils.deleteQuietly((File)entry);
                }
                FileUtils.forceDelete((File)downloadToFile);
                CertFrDownload.cleanFilesOfTypes(unpackedDirectory, pathname -> pathname.getName().endsWith(".pdf") || pathname.isDirectory() || pathname.getName().contains("XXX"));
                File[] extractedFiles = unpackedDirectory.listFiles();
                if (extractedFiles != null) {
                    LOG.info("Extracted [{}] entries for year [{}]", (Object)extractedFiles.length, (Object)year);
                }
            };
            this.executor.submit(downloadThread);
        }
        this.executor.setDelay(3000L);
        this.executor.setSize(4);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for download threads to finish.", e);
        }
    }

    private static void cleanFilesOfTypes(File directory, FileFilter fileFilter) {
        File[] filesForDeletion = directory.listFiles(fileFilter);
        if (filesForDeletion != null) {
            for (File file : filesForDeletion) {
                if (file.delete()) continue;
                LOG.warn("Unable to delete file {} whilst deleting files in {}", (Object)file.getAbsolutePath(), (Object)directory.getAbsolutePath());
            }
        }
    }

    private List<Integer> determineWhatYearsRequireUpdate() {
        List<Integer> availableArchiveYears = this.findAvailableArchiveYears();
        ArrayList<Integer> years = new ArrayList<Integer>(availableArchiveYears);
        if (this.downloadIntoDirectory.exists()) {
            Arrays.stream(this.downloadIntoDirectory.listFiles(File::isDirectory)).map(File::getName).filter(f -> f.matches("\\d+")).map(Integer::parseInt).forEach(years::remove);
        }
        years.add(availableArchiveYears.get(availableArchiveYears.size() - 1));
        years.add(availableArchiveYears.get(availableArchiveYears.size() - 2));
        URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_RSS_FEED, new Object[0]);
        List<String> rssFeedLines = this.downloader.fetchResponseBodyFromUrlAsList(requestUrl);
        Pattern certFrIdYearPattern = Pattern.compile(".*CERTFR-(\\d{4}).+");
        for (String rssFeedLine : rssFeedLines) {
            Matcher matcher = certFrIdYearPattern.matcher(rssFeedLine);
            if (!matcher.matches()) continue;
            years.add(Integer.parseInt(matcher.group(1)));
        }
        return years.stream().distinct().sorted(Integer::compareTo).collect(Collectors.toList());
    }

    @Override
    public void performInternalDownload() {
        this.downloadJsonForAll("json");
        LOG.info("Converting CERT-FR JSON entries to legacy text format");
        for (File jsonFile : FileUtils.listFiles((File)new File(this.downloadIntoDirectory, "json"), (String[])new String[]{"json"}, (boolean)true)) {
            String textFileContent;
            CertFrAdvisorEntry entry;
            File[] textFileName = jsonFile.getName().replace(".json", ".txt");
            File textFile = new File(new File(new File(this.downloadIntoDirectory, "txt"), jsonFile.getParentFile().getName()), (String)textFileName);
            try {
                entry = CertFrAdvisorEntry.fromApiJson(jsonFile);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse JSON file, skipping conversion to text: {}", (Object)jsonFile.getAbsolutePath(), (Object)e);
                continue;
            }
            try {
                textFileContent = entry.toCertFrArchiveLegacyTextFormat();
            }
            catch (Exception e) {
                LOG.warn("Unable to convert JSON file to text format, skipping conversion to text: {}", (Object)jsonFile.getAbsolutePath(), (Object)e);
                continue;
            }
            try {
                FileUtils.writeStringToFile((File)textFile, (String)textFileContent, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.warn("Unable to write text file, skipping conversion to text: {}", (Object)textFile.getAbsolutePath(), (Object)e);
            }
        }
        LOG.info("Packing CERT-FR mirror directories into tar files");
        for (String fileType : Arrays.asList("txt", "json")) {
            for (File file : new File(this.downloadIntoDirectory, fileType).listFiles()) {
                if (!file.isDirectory()) continue;
                try {
                    ArchiveUtils.tarDirectory(file, new File(this.downloadIntoDirectory, "internal-mirror/" + fileType + "/" + file.getName() + ".tar"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to pack directory " + file.getAbsolutePath() + " into tar file.", e);
                }
            }
            try {
                FileUtils.forceDelete((File)new File(this.downloadIntoDirectory, fileType));
            }
            catch (IOException e) {
                LOG.warn("Unable to delete CERT-FR mirror directory {}", (Object)new File(this.downloadIntoDirectory, fileType).getAbsolutePath());
            }
        }
    }

    public void downloadJsonForAll(String subdir) {
        List<HtmlScrapingEntry> alerteEntries = this.scrapeHtmlPagesForEntryMetadata("alerte", 0);
        List<HtmlScrapingEntry> avisEntries = this.scrapeHtmlPagesForEntryMetadata("avis", 0);
        LOG.info("");
        LOG.info("Found the following amounts of entries for all time:");
        LOG.info(" - alerte: {}", (Object)alerteEntries.size());
        LOG.info(" - avis: {}", (Object)avisEntries.size());
        LOG.info("");
        this.downloadAllJsonEntries("alerte", alerteEntries, subdir, true);
        this.downloadAllJsonEntries("avis", avisEntries, subdir, true);
    }

    private void downloadAllJsonEntries(String type, List<HtmlScrapingEntry> entries, String subdir, boolean forceUpdate) {
        LOG.info("Downloading JSON entries for [{}] with [{}] entries", (Object)type, (Object)entries.size());
        int i = 0;
        for (HtmlScrapingEntry entry : entries) {
            if (i % 500 == 0) {
                LOG.info("Downloading JSON entries for [{}] with [{}] entries, currently at [{}]", new Object[]{type, entries.size(), i});
            }
            ++i;
            this.downloadJsonEntry(type, entry.getId(), subdir, forceUpdate);
        }
    }

    private void downloadJsonEntry(String type, String entryId, String subdir, boolean forceUpdate) {
        boolean requiresUpdate;
        String year = entryId.replaceAll(".*-(\\d{4,5})-.*", "$1");
        if (year.isEmpty() && !year.matches("\\d{4,5}")) {
            LOG.warn("Unable to extract year from entry ID [{}], skipping download", (Object)entryId);
            return;
        }
        URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_SINGLE_JSON_ENTRY, type, entryId);
        File downloadToFile = new File(this.downloadIntoDirectory, (StringUtils.hasText(subdir) ? subdir + "/" : "") + year + "/" + entryId + ".json");
        if (forceUpdate) {
            requiresUpdate = true;
        } else if (downloadToFile.exists()) {
            long localFileSize;
            long remoteFileSize = this.downloader.fetchFileSizeFromUrl(requestUrl);
            boolean bl = requiresUpdate = remoteFileSize != (localFileSize = downloadToFile.length());
            if (requiresUpdate) {
                LOG.info("Entry [{}] has changed [{}] -> [{}], updating", new Object[]{downloadToFile.getName().replace(".json", ""), localFileSize, remoteFileSize});
            }
        } else {
            requiresUpdate = true;
        }
        if (requiresUpdate) {
            this.downloader.fetchResponseBodyFromUrlToFile(requestUrl, downloadToFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<HtmlScrapingEntry> scrapeHtmlPagesForEntryMetadata(String type, int lowestIncludeYear) {
        LOG.info("Scraping HTML pages for type [{}] up to (including) year [{}]", (Object)type, (Object)lowestIncludeYear);
        ArrayList<HtmlScrapingEntry> entries = new ArrayList<HtmlScrapingEntry>();
        int maxPage = 1;
        int page = 1;
        while (true) {
            if (page > maxPage) {
                LOG.info("Scraped [{}] entries for type [{}]", (Object)entries.size(), (Object)type);
                return entries;
            }
            URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_ENTRY_LISTING_HTML, type, page);
            Document document = this.downloader.fetchResponseBodyFromUrlAsDocument(requestUrl);
            Elements itemMetaElements = document.getElementsByClass("item-meta");
            for (int i = 0; i < itemMetaElements.size(); ++i) {
                int latestYear;
                HtmlScrapingDate closedDate;
                HtmlScrapingDate publishDate;
                int publishYear;
                String id;
                block15: {
                    block16: {
                        Elements itemRefElements = ((Element)itemMetaElements.get(i)).getElementsByClass("item-ref");
                        Elements itemDateElements = ((Element)itemMetaElements.get(i)).getElementsByClass("item-date");
                        Elements itemStatusElements = ((Element)itemMetaElements.get(i)).getElementsByClass("item-status");
                        if (itemRefElements.size() != 1 || itemDateElements.size() != 1) {
                            LOG.warn("Skipping entry [{}] due to missing or duplicate title or ref elements", (Object)i);
                            continue;
                        }
                        id = ((Element)itemRefElements.get(0)).text().trim();
                        String date = ((Element)itemDateElements.get(0)).text().trim();
                        Matcher dateMatcher = EXTRACT_HTML_LISTING_DATE_PATTERN.matcher(date);
                        if (!dateMatcher.matches()) {
                            LOG.warn("Skipping entry [{}] due to invalid date format [{}]", (Object)i, (Object)date);
                            continue;
                        }
                        int publishDay = Integer.parseInt(dateMatcher.group(1));
                        int publishMonth = Arrays.asList("janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre").indexOf(dateMatcher.group(2)) + 1;
                        publishYear = Integer.parseInt(dateMatcher.group(3));
                        publishDate = new HtmlScrapingDate(publishYear, publishMonth, publishDay);
                        if (itemStatusElements.size() != 1) break block16;
                        String status = ((Element)itemStatusElements.get(0)).text().trim();
                        if (status.equals("Alerte en cours")) {
                            closedDate = null;
                            break block15;
                        } else {
                            Matcher statusMatcher = EXTRACT_HTML_LISTING_DATE_PATTERN.matcher(status);
                            if (statusMatcher.matches()) {
                                int closedDay = Integer.parseInt(statusMatcher.group(1));
                                int closedMonth = Arrays.asList("janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre").indexOf(statusMatcher.group(2)) + 1;
                                int closedYear = Integer.parseInt(statusMatcher.group(3));
                                closedDate = new HtmlScrapingDate(closedYear, closedMonth, closedDay);
                                break block15;
                            } else {
                                LOG.warn("Skipping entry [{}] due to invalid status format [{}]", (Object)i, (Object)status);
                                continue;
                            }
                        }
                    }
                    closedDate = null;
                }
                if ((latestYear = Math.max(publishYear, closedDate != null ? closedDate.getYear() : 0)) < lowestIncludeYear) {
                    LOG.info("Last include year [{} < {}] passed, stopping scraping for type [{}] on page [{}] with [{}] entries", new Object[]{latestYear, lowestIncludeYear, type, page, entries.size()});
                    return entries;
                }
                entries.add(new HtmlScrapingEntry(id, publishDate, closedDate));
            }
            Elements pageNumbersElements = document.select("ul.page-numbers > li");
            if (!pageNumbersElements.isEmpty()) {
                int maxFoundPage = Integer.MIN_VALUE;
                for (Element pageNumbersElement : pageNumbersElements) {
                    for (Element textElements : pageNumbersElement.children()) {
                        int pageNumber;
                        String text = textElements.text().trim();
                        if (!text.matches("\\d+") || (pageNumber = Integer.parseInt(text)) <= maxFoundPage) continue;
                        maxFoundPage = pageNumber;
                    }
                }
                if (maxFoundPage > maxPage) {
                    LOG.info("Found new max page [{}]", (Object)maxFoundPage);
                    maxPage = maxFoundPage;
                }
            } else {
                LOG.warn("Unable to find page numbers element to extract max page number");
            }
            ++page;
        }
    }

    public List<Integer> findAvailableArchiveYears() {
        if (this.cachedAvailableArchiveYears != null) {
            return this.cachedAvailableArchiveYears;
        }
        this.cachedAvailableArchiveYears = new ArrayList<Integer>();
        URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_BASE_URL_FOR_ARCHIVE_LISTING, new Object[0]);
        Document document = this.downloader.fetchResponseBodyFromUrlAsDocument(requestUrl);
        Elements archiveYearElements = document.select("ul.dropdown-menu > li > a");
        for (Element archiveYearElement : archiveYearElements) {
            String href = archiveYearElement.attr("href");
            String text = archiveYearElement.text();
            if (!href.matches(".*/\\d{4,5}\\.tar") || !text.matches("\\d{4,5}")) continue;
            this.cachedAvailableArchiveYears.add(Integer.parseInt(text));
        }
        if (this.cachedAvailableArchiveYears.isEmpty()) {
            LOG.warn("Unable to find any archive years on the CERT-FR website, website might have removed element. Assuming 2000 to (current year - 1) as available years.");
            int currentYear = this.getCurrentYear();
            for (int year = 2000; year < currentYear; ++year) {
                this.cachedAvailableArchiveYears.add(year);
            }
        }
        LOG.info("Found available CERT-FR archive years: {}", this.cachedAvailableArchiveYears);
        return this.cachedAvailableArchiveYears;
    }

    public List<Integer> findUnavailableArchiveYears() {
        if (this.cachedUnavailableArchiveYears != null) {
            return this.cachedUnavailableArchiveYears;
        }
        List<Integer> availableArchiveYears = this.findAvailableArchiveYears();
        if (availableArchiveYears.isEmpty()) {
            this.cachedUnavailableArchiveYears = new ArrayList<Integer>();
            LOG.warn("No available archive years found, unable to determine unavailable years");
            return this.cachedUnavailableArchiveYears;
        }
        int currentYear = this.getCurrentYear();
        this.cachedUnavailableArchiveYears = new ArrayList<Integer>();
        for (int year = 2000; year <= currentYear; ++year) {
            if (availableArchiveYears.contains(year)) continue;
            this.cachedUnavailableArchiveYears.add(year);
        }
        LOG.info("Found unavailable CERT-FR archive years: {}", this.cachedUnavailableArchiveYears);
        return this.cachedUnavailableArchiveYears;
    }

    private int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        long previousFeedSize = this.propertyFiles.getLong(this.downloadIntoDirectory, "info", Mirror.InfoFileAttributes.CERT_FR_PREFIX.getKey() + "last-feed-size").orElse(0L);
        if (previousFeedSize == 0L) {
            return true;
        }
        return previousFeedSize != this.getCurrentFeedSize();
    }

    private long getCurrentFeedSize() {
        URL requestUrl = this.getRemoteResourceLocationUrl(ResourceLocationCertFr.CERT_FR_RSS_FEED, new Object[0]);
        return this.downloader.fetchFileSizeFromUrl(requestUrl);
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationCertFr.valueOf(location), url);
    }

    public static class HtmlScrapingDate {
        private final int year;
        private final int month;
        private final int day;

        public HtmlScrapingDate(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HtmlScrapingDate)) {
                return false;
            }
            HtmlScrapingDate other = (HtmlScrapingDate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getYear() != other.getYear()) {
                return false;
            }
            if (this.getMonth() != other.getMonth()) {
                return false;
            }
            return this.getDay() == other.getDay();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HtmlScrapingDate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getYear();
            result = result * 59 + this.getMonth();
            result = result * 59 + this.getDay();
            return result;
        }

        public String toString() {
            return "CertFrDownload.HtmlScrapingDate(year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ")";
        }
    }

    public static class HtmlScrapingEntry {
        private final String id;
        private final HtmlScrapingDate publishDate;
        private final HtmlScrapingDate closedDate;

        public HtmlScrapingEntry(String id, HtmlScrapingDate publishDate, HtmlScrapingDate closedDate) {
            this.id = id;
            this.publishDate = publishDate;
            this.closedDate = closedDate;
        }

        public String getId() {
            return this.id;
        }

        public HtmlScrapingDate getPublishDate() {
            return this.publishDate;
        }

        public HtmlScrapingDate getClosedDate() {
            return this.closedDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HtmlScrapingEntry)) {
                return false;
            }
            HtmlScrapingEntry other = (HtmlScrapingEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            HtmlScrapingDate this$publishDate = this.getPublishDate();
            HtmlScrapingDate other$publishDate = other.getPublishDate();
            if (this$publishDate == null ? other$publishDate != null : !((Object)this$publishDate).equals(other$publishDate)) {
                return false;
            }
            HtmlScrapingDate this$closedDate = this.getClosedDate();
            HtmlScrapingDate other$closedDate = other.getClosedDate();
            return !(this$closedDate == null ? other$closedDate != null : !((Object)this$closedDate).equals(other$closedDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HtmlScrapingEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            HtmlScrapingDate $publishDate = this.getPublishDate();
            result = result * 59 + ($publishDate == null ? 43 : ((Object)$publishDate).hashCode());
            HtmlScrapingDate $closedDate = this.getClosedDate();
            result = result * 59 + ($closedDate == null ? 43 : ((Object)$closedDate).hashCode());
            return result;
        }

        public String toString() {
            return "CertFrDownload.HtmlScrapingEntry(id=" + this.getId() + ", publishDate=" + this.getPublishDate() + ", closedDate=" + this.getClosedDate() + ")";
        }
    }

    public static enum ResourceLocationCertFr implements ResourceLocation
    {
        CERT_FR_ARCHIVE("https://metaeffekt.com/mirror/cert-fr/json/%d.tar"),
        CERT_FR_RSS_FEED("https://www.cert.ssi.gouv.fr/feed/"),
        CERT_FR_ENTRY_LISTING_HTML("https://www.cert.ssi.gouv.fr/%s/page/%d"),
        CERT_FR_BASE_URL_FOR_ARCHIVE_LISTING("https://www.cert.ssi.gouv.fr"),
        CERT_FR_SINGLE_JSON_ENTRY("https://www.cert.ssi.gouv.fr/%s/%s/json");

        private final String defaultValue;

        private ResourceLocationCertFr(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

