/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index;

import com.metaeffekt.artifact.analysis.utils.BuildProperties;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.Mirror;
import com.metaeffekt.mirror.concurrency.ScheduledDelayedThreadPoolExecutor;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Analyzers;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.CertFrAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.CertSeiAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.MsrcAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.MsrcKbChainIndex;
import com.metaeffekt.mirror.index.advisor.MsrcProductIndex;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryIndex;
import com.metaeffekt.mirror.index.nvd.CpeDictionaryVendorProductIndex;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiIndex;
import com.metaeffekt.mirror.index.nvd.NvdCveApiIndex;
import com.metaeffekt.mirror.index.nvd.NvdVulnerabilityIndex;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Index
extends Mirror {
    private static final Logger LOG = LoggerFactory.getLogger(Index.class);
    protected final File indexIntoDirectory;
    protected int lockFileTimeout = 600000;
    protected final ScheduledDelayedThreadPoolExecutor executor = new ScheduledDelayedThreadPoolExecutor(16, 0L);
    protected final Directory luceneDirectory;
    private IndexReader cachedIndexReader;
    private IndexSearcher cachedIndexSearcher;
    protected final File[] requiredDownloads;
    protected final Index[] requiredIndexes;
    protected final File[] optionalDownloads;
    protected final Index[] optionalIndexes;
    protected static final String UNIQUE_LUCENE_DOCUMENT_ID = "uldid";

    public Index(File baseMirrorDirectory, Class<? extends Index> indexClass, List<Class<? extends Download>> requiredDownloads, List<Class<? extends Index>> requiredIndexes) {
        this(baseMirrorDirectory, indexClass, requiredDownloads, requiredIndexes, Collections.emptyList(), Collections.emptyList());
    }

    public Index(File baseMirrorDirectory, Class<? extends Index> indexClass, List<Class<? extends Download>> requiredDownloads, List<Class<? extends Index>> requiredIndexes, List<Class<? extends Download>> optionalDownloads, List<Class<? extends Index>> optionalIndexes) {
        super(baseMirrorDirectory, Index.getDirectoryIdentifier(indexClass));
        int i;
        this.indexIntoDirectory = new File(new File(this.baseMirrorDirectory, "index"), this.mirrorIdentifier);
        if (!this.indexIntoDirectory.exists()) {
            this.indexIntoDirectory.mkdirs();
        }
        try {
            this.luceneDirectory = FSDirectory.open((Path)this.indexIntoDirectory.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open lucene index directory inside " + baseMirrorDirectory.getAbsolutePath(), e);
        }
        this.requiredDownloads = new File[requiredDownloads.size()];
        for (i = 0; i < requiredDownloads.size(); ++i) {
            this.requiredDownloads[i] = new File(new File(this.baseMirrorDirectory, "download"), Download.getDirectoryIdentifier(requiredDownloads.get(i)));
            if (this.requiredDownloads[i].exists()) continue;
            LOG.debug("Required download does not exist in {} for index [{}] (this can be ignored if only read access is required) in {}", new Object[]{this.requiredDownloads[i].getClass().getSimpleName(), this.mirrorIdentifier, this.getClass().getName()});
        }
        this.requiredIndexes = new Index[requiredIndexes.size()];
        for (i = 0; i < requiredIndexes.size(); ++i) {
            this.requiredIndexes[i] = Index.getInstance(requiredIndexes.get(i), baseMirrorDirectory);
            try {
                this.requiredIndexes[i].assertExists();
                continue;
            }
            catch (Exception e) {
                LOG.debug("Required index does not exist in {} for index [{}] (this can be ignored if only read access is required): {} in {}", new Object[]{this.requiredIndexes[i].getClass().getSimpleName(), this.mirrorIdentifier, e.getMessage(), this.getClass().getSimpleName()});
            }
        }
        this.optionalDownloads = new File[optionalDownloads.size()];
        for (i = 0; i < optionalDownloads.size(); ++i) {
            this.optionalDownloads[i] = new File(new File(this.baseMirrorDirectory, "download"), Download.getDirectoryIdentifier(optionalDownloads.get(i)));
            if (this.optionalDownloads[i].exists()) continue;
            LOG.debug("Optional download does not exist in {} for index [{}] (this can be ignored if index is not required) in {}", new Object[]{this.optionalDownloads[i].getClass().getSimpleName(), this.mirrorIdentifier, this.getClass().getName()});
        }
        this.optionalIndexes = new Index[optionalIndexes.size()];
        for (i = 0; i < optionalIndexes.size(); ++i) {
            this.optionalIndexes[i] = Index.getInstance(optionalIndexes.get(i), baseMirrorDirectory);
            try {
                this.optionalIndexes[i].assertExists();
                continue;
            }
            catch (Exception e) {
                LOG.debug("Optional index does not exist in {} for index [{}] (this can be ignored if index is not required): {} in {}", new Object[]{this.optionalIndexes[i].getClass().getSimpleName(), this.mirrorIdentifier, e.getMessage(), this.getClass().getSimpleName()});
            }
        }
    }

    public void setLockFileTimeout(int lockFileTimeout) {
        this.lockFileTimeout = lockFileTimeout;
    }

    public <T extends Index> T getRequiredIndex(Class<T> indexClass) {
        for (Index index : this.requiredIndexes) {
            if (!indexClass.isInstance(index)) continue;
            return (T)((Index)indexClass.cast(index));
        }
        return null;
    }

    public File getIndexIntoDirectory() {
        return this.indexIntoDirectory;
    }

    public void assertExists() {
        if (!this.indexIntoDirectory.exists()) {
            throw new RuntimeException("Index directory does not exist: " + this.indexIntoDirectory);
        }
        if (!this.indexIntoDirectory.isDirectory()) {
            throw new RuntimeException("Index directory is not a directory: " + this.indexIntoDirectory);
        }
        if (this.indexIntoDirectory.listFiles().length < 2) {
            throw new RuntimeException("Index directory is empty: " + this.indexIntoDirectory);
        }
    }

    public void createIndexIfRequired() {
        boolean outcome = false;
        try {
            super.logTitle("");
            super.waitForFileUnlockIfLocked(this.indexIntoDirectory, this.lockFileTimeout);
            super.lockFile(this.indexIntoDirectory);
            if (this.isIndexingRequired()) {
                this.createIndexBackup();
                this.clearIndex();
                this.createIndex();
                this.setLastUpdatedToNow();
            } else {
                LOG.info("Index is already up to date: {}", (Object)this.indexIntoDirectory);
            }
            this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.INDEX_FAILED_FLAG.getKey(), "false");
            outcome = true;
        }
        catch (Exception e) {
            try {
                this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.INDEX_FAILED_FLAG.getKey(), "true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadIndexBackup();
            throw new RuntimeException("Unable to update index in " + this.indexIntoDirectory + "\n" + e.getMessage(), e);
        }
        finally {
            this.removeIndexBackup();
            super.unlockFile(this.indexIntoDirectory);
            if (outcome) {
                super.logTitle("Done: ");
            } else {
                super.logTitle("FAILED: ");
            }
        }
    }

    protected void createIndex() {
        this.assertRequiredDownloadsExist();
        LOG.info("Creating index documents for index in: {}", (Object)this.indexIntoDirectory);
        Map<String, org.apache.lucene.document.Document> indexDocuments = this.createIndexDocuments();
        if (indexDocuments.size() > 0) {
            this.writeIndexDocuments(indexDocuments);
        }
    }

    private void createIndexBackup() {
        try {
            File backupDirectory = new File(this.indexIntoDirectory.getParentFile(), this.indexIntoDirectory.getName() + "-backup");
            if (backupDirectory.exists()) {
                FileUtils.cleanDirectory((File)backupDirectory);
            }
            if (!this.indexIntoDirectory.exists()) {
                LOG.warn("Index directory does not exist, unable to create backup: {}", (Object)this.indexIntoDirectory);
                return;
            }
            FileUtils.copyDirectory((File)this.indexIntoDirectory, (File)backupDirectory);
            LOG.info("Created index backup in: {}", (Object)backupDirectory);
        }
        catch (IOException e) {
            LOG.error("Unable to create index backup for " + this.indexIntoDirectory.getAbsolutePath(), (Throwable)e);
        }
    }

    private void loadIndexBackup() {
        try {
            File backupDirectory = new File(this.indexIntoDirectory.getParentFile(), this.indexIntoDirectory.getName() + "-backup");
            if (!backupDirectory.exists()) {
                LOG.error("Unable to load index backup for " + this.indexIntoDirectory.getAbsolutePath() + " as it does not exist");
                return;
            }
            if (this.indexIntoDirectory.exists()) {
                FileUtils.cleanDirectory((File)this.indexIntoDirectory);
            }
            FileUtils.copyDirectory((File)backupDirectory, (File)this.indexIntoDirectory);
            LOG.info("Loaded index backup from: {}", (Object)backupDirectory);
        }
        catch (IOException e) {
            LOG.error("Unable to load index backup for " + this.indexIntoDirectory.getAbsolutePath(), (Throwable)e);
        }
    }

    private void removeIndexBackup() {
        File backupDirectory = new File(this.indexIntoDirectory.getParentFile(), this.indexIntoDirectory.getName() + "-backup");
        if (backupDirectory.exists()) {
            FileUtils.deleteDir(backupDirectory);
        }
    }

    protected void writeIndexDocuments(Map<String, org.apache.lucene.document.Document> indexDocuments) {
        LOG.info("Indexing [{}] document{}", (Object)indexDocuments.size(), (Object)(indexDocuments.size() == 1 ? "" : "s"));
        try {
            IndexWriterConfig luceneWriterConfig = new IndexWriterConfig(Analyzers.getStandardAnalyzer());
            luceneWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            IndexWriter luceneDocumentWriter = new IndexWriter(this.luceneDirectory, luceneWriterConfig);
            for (Map.Entry<String, org.apache.lucene.document.Document> indexDocument : indexDocuments.entrySet()) {
                if (indexDocument.getKey() == null) {
                    LOG.warn("Index document has no key: {}", (Object)indexDocument.getValue());
                    continue;
                }
                Term term = new Term("doc_id", String.valueOf(indexDocument.getKey().hashCode()));
                luceneDocumentWriter.updateDocument(term, (Iterable)indexDocument.getValue());
            }
            luceneDocumentWriter.close();
            this.resetCachedReaderSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        indexDocuments.clear();
    }

    private void resetCachedReaderSearcher() {
        if (this.cachedIndexReader != null) {
            try {
                this.cachedIndexReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cachedIndexReader = null;
        this.cachedIndexSearcher = null;
    }

    private IndexReader getIndexReader() throws IOException {
        if (this.cachedIndexReader == null) {
            try {
                this.cachedIndexReader = DirectoryReader.open((Directory)this.luceneDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.cachedIndexReader;
    }

    private IndexSearcher getIndexSearcher() throws IOException {
        if (this.cachedIndexSearcher == null) {
            this.cachedIndexSearcher = new IndexSearcher(this.getIndexReader());
        }
        return this.cachedIndexSearcher;
    }

    public List<org.apache.lucene.document.Document> findAllDocuments() {
        try {
            IndexReader indexReader = this.getIndexReader();
            int docCount = indexReader.numDocs();
            ArrayList<org.apache.lucene.document.Document> documents = new ArrayList<org.apache.lucene.document.Document>(docCount);
            for (int i = 0; i < docCount; ++i) {
                documents.add(indexReader.document(i));
            }
            return documents;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find all documents in index", e);
        }
    }

    public int documentCount() {
        try {
            return this.getIndexReader().numDocs();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find all documents in index", e);
        }
    }

    public void findAndProcessAllDocuments(Consumer<org.apache.lucene.document.Document> consumer) {
        try {
            IndexReader indexReader = this.getIndexReader();
            int docCount = indexReader.numDocs();
            for (int i = 0; i < docCount; ++i) {
                consumer.accept(indexReader.document(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find all documents in index", e);
        }
    }

    public void findAndProcessAllDocumentsCancelable(Function<org.apache.lucene.document.Document, Boolean> consumer) {
        try {
            boolean continueSearch;
            IndexReader indexReader = this.getIndexReader();
            int docCount = indexReader.numDocs();
            for (int i = 0; i < docCount && (continueSearch = consumer.apply(indexReader.document(i)).booleanValue()); ++i) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find all documents in index", e);
        }
    }

    public void findAndProcessAllDocuments(BiConsumer<org.apache.lucene.document.Document, Integer> consumer) {
        try {
            IndexReader indexReader = this.getIndexReader();
            int docCount = indexReader.numDocs();
            for (int i = 0; i < docCount; ++i) {
                consumer.accept(indexReader.document(i), i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find all documents in index", e);
        }
    }

    public List<org.apache.lucene.document.Document> findDocuments(IndexSearch indexSearch) {
        try {
            return indexSearch.search(this.getIndexSearcher());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to search index for [" + indexSearch + "]", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Malformed search query for [" + indexSearch + "]", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception whilst performing query [" + indexSearch + "] on index in " + this.indexIntoDirectory.getAbsolutePath() + " ; make sure that the index exists and is valid", e);
        }
    }

    public List<org.apache.lucene.document.Document> findDocuments(Query query) {
        try {
            TopDocs topDocs = this.getIndexSearcher().search(query, Integer.MAX_VALUE);
            ArrayList<org.apache.lucene.document.Document> documents = new ArrayList<org.apache.lucene.document.Document>((int)topDocs.totalHits.value);
            int i = 0;
            while ((long)i < topDocs.totalHits.value) {
                documents.add(this.getIndexSearcher().doc(topDocs.scoreDocs[i].doc));
                ++i;
            }
            return documents;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to search index for [" + query + "]", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception whilst performing query [" + query + "] on index in " + this.indexIntoDirectory.getAbsolutePath() + " ; make sure that the index exists and is valid", e);
        }
    }

    protected boolean isIndexingRequired() {
        this.setLastCheckedToNow();
        long directoryLastModified = this.getDirectoryLastModified();
        if (directoryLastModified == 0L) {
            LOG.info("Index directory is empty, indexing is required");
            return true;
        }
        for (File requiredDownload : this.requiredDownloads) {
            long downloadLastModified = this.propertyFiles.getLong(requiredDownload, "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey()).orElse(0L);
            if (downloadLastModified == 0L) {
                LOG.info("Required download is empty, attempting to index");
                return true;
            }
            if (downloadLastModified > directoryLastModified) {
                LOG.info("Index is out of date, download [{}] is more recent [{}] --> [{}]", new Object[]{requiredDownload.getName(), TimeUtils.formatNormalizedDate(new Date(downloadLastModified)), TimeUtils.formatNormalizedDate(new Date(directoryLastModified))});
                return true;
            }
            boolean hasLastDownloadFailed = this.propertyFiles.getBoolean(requiredDownload, "info", Mirror.InfoFileAttributes.DOWNLOAD_FAILED_FLAG.getKey()).orElse(false);
            if (hasLastDownloadFailed) {
                LOG.info("Last download failed, attempting to index");
                return true;
            }
            boolean hasLastIndexFailed = this.hasLastIndexFailed();
            if (!hasLastIndexFailed) continue;
            LOG.info("Last index failed, attempting to index");
            return true;
        }
        if (this.requiredIndexes != null) {
            for (Index requiredIndex : this.requiredIndexes) {
                long indexLastModified = this.propertyFiles.getLong(requiredIndex.getIndexIntoDirectory(), "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey()).orElse(0L);
                if (indexLastModified == 0L || indexLastModified <= directoryLastModified) continue;
                LOG.info("Index is out of date, index [{}] is more recent [{}] --> [{}]", new Object[]{requiredIndex.getIndexIntoDirectory().getName(), TimeUtils.formatNormalizedDate(new Date(indexLastModified)), TimeUtils.formatNormalizedDate(new Date(directoryLastModified))});
                return true;
            }
        }
        return false;
    }

    public boolean hasLastIndexFailed() {
        return this.propertyFiles.getBoolean(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.INDEX_FAILED_FLAG.getKey()).orElse(false);
    }

    public long getDirectoryLastModified() {
        return this.propertyFiles.getLong(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey()).orElse(0L);
    }

    private void setLastUpdatedToNow() {
        long now = TimeUtils.utcNow();
        this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED.getKey(), now);
        this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_UPDATED_FORMATTED.getKey(), new Date(now));
        this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.MIRROR_VERSION.getKey(), BuildProperties.getProjectVersion());
        LOG.info("Set last updated to [{}] in {}", (Object)new Date(now), (Object)this.indexIntoDirectory);
    }

    private void setLastCheckedToNow() {
        long now = TimeUtils.utcNow();
        this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_CHECKED.getKey(), now);
        this.propertyFiles.set(this.indexIntoDirectory, "info", Mirror.InfoFileAttributes.LAST_CHECKED_FORMATTED.getKey(), new Date(now));
        LOG.info("Set last updated to [{}] in {}", (Object)new Date(now), (Object)this.indexIntoDirectory);
    }

    private void assertRequiredDownloadsExist() {
        ArrayList<File> missingDownloads = new ArrayList<File>();
        ArrayList<File> failedDownloads = new ArrayList<File>();
        for (File requiredDownload : this.requiredDownloads) {
            boolean hasLastDownloadFailed;
            if (!requiredDownload.exists()) {
                missingDownloads.add(requiredDownload);
            }
            if (!(hasLastDownloadFailed = this.propertyFiles.getBoolean(requiredDownload, "info", Mirror.InfoFileAttributes.DOWNLOAD_FAILED_FLAG.getKey()).orElse(false).booleanValue())) continue;
            failedDownloads.add(requiredDownload);
        }
        StringBuilder message = new StringBuilder();
        if (!missingDownloads.isEmpty()) {
            message.append("Cannot create index [").append(this.getClass().getSimpleName()).append("], required downloads are missing: ");
            message.append(missingDownloads.stream().map(File::getName).collect(Collectors.joining(", ")));
        }
        if (!failedDownloads.isEmpty()) {
            if (message.length() > 0) {
                message.append(System.lineSeparator());
            }
            message.append("Cannot create index, required downloads have failed (re-download the data to fix corrupted download): ");
            message.append(failedDownloads.stream().map(File::getName).collect(Collectors.joining(", ")));
        }
        if (message.length() > 0) {
            throw new RuntimeException(message.toString());
        }
    }

    public Index clearIndex() {
        try {
            this.propertyFiles.flushCachedAePropertyFiles();
            FileUtils.deleteDir(this.indexIntoDirectory);
            LOG.info("Cleared index in {}", (Object)this.indexIntoDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.warn("Unable to clear index in " + this.indexIntoDirectory.getAbsolutePath());
            throw e;
        }
        return this;
    }

    protected abstract Map<String, org.apache.lucene.document.Document> createIndexDocuments();

    protected List<File> getAllFilesInSubDirectories(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] subDirectories = directory.listFiles();
        if (subDirectories == null) {
            throw new RuntimeException("Could not list files in " + directory.getAbsolutePath());
        }
        for (File dir : subDirectories) {
            if (!dir.isDirectory()) continue;
            File[] noteFiles = dir.listFiles();
            if (noteFiles == null) {
                throw new RuntimeException("Could not list files in " + dir.getAbsolutePath());
            }
            for (File noteFile : noteFiles) {
                if (!noteFile.isFile()) continue;
                files.add(noteFile);
            }
        }
        return files;
    }

    protected Collection<File> getAllFilesRecursively(File directory) {
        return FileUtils.listFiles((File)directory, null, (boolean)true);
    }

    protected Document parseXmlDocument(String string) throws ParserConfigurationException, IOException, SAXException {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("String cannot be empty to create XML document");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static String getDirectoryIdentifier(Class<? extends Index> index) {
        if (index.isAnnotationPresent(MirrorMetadata.class)) {
            return index.getAnnotation(MirrorMetadata.class).directoryName();
        }
        LOG.warn("Index {} does not have a directory name annotation", (Object)index.getSimpleName());
        if (CertFrAdvisorIndex.class.equals(index)) {
            return "certfr-advisors";
        }
        if (CertSeiAdvisorIndex.class.equals(index)) {
            return "certsei-advisors";
        }
        if (CpeDictionaryVendorProductIndex.class.equals(index)) {
            return "cpe-dict-vp-legacy-feed";
        }
        if (NvdCpeApiIndex.class.equals(index) || CpeDictionaryIndex.class.equals(index)) {
            return "cpe-dict";
        }
        if (MsrcAdvisorIndex.class.equals(index)) {
            return "msrc-advisors";
        }
        if (MsrcProductIndex.class.equals(index)) {
            return "msrc-products";
        }
        if (MsrcKbChainIndex.class.equals(index)) {
            return "msrc-kb-chains";
        }
        if (NvdVulnerabilityIndex.class.equals(index)) {
            return "nvd-cve-legacy-feed";
        }
        if (NvdCveApiIndex.class.equals(index)) {
            return "nvd-cve";
        }
        throw new RuntimeException("Unknown index class: " + index);
    }

    public static Index getInstance(Class<? extends Index> clazz, File baseMirrorDirectory) {
        try {
            return clazz.getConstructor(File.class).newInstance(baseMirrorDirectory);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create index class", e);
        }
    }
}

