/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.index.Analyzers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearch {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSearch.class);
    private final Map<String, List<String>> fieldContains = new HashMap<String, List<String>>();
    private final Map<String, List<String>> fieldNotContains = new HashMap<String, List<String>>();
    private final Map<String, List<String>> fieldEquals = new HashMap<String, List<String>>();
    private final Map<String, List<String>> fieldContainsUnquoted = new HashMap<String, List<String>>();
    private final List<String> withoutField = new ArrayList<String>();
    private final Map<String, List<Pair<Long, Long>>> fieldNumericBetween = new HashMap<String, List<Pair<Long, Long>>>();
    private Analyzer analyzer = Analyzers.getStandardAnalyzer();
    private int maxDocs = Integer.MAX_VALUE;
    private String joinOperator = "AND";

    public IndexSearch fieldContains(String field, String value) {
        IndexSearch.validateFieldSpecified(field);
        this.fieldContains.computeIfAbsent(field, k -> new ArrayList()).add(value);
        return this;
    }

    public IndexSearch fieldNotContains(String field, String value) {
        IndexSearch.validateFieldSpecified(field);
        this.fieldNotContains.computeIfAbsent(field, k -> new ArrayList()).add(value);
        return this;
    }

    public IndexSearch fieldContainsUnquoted(String field, String value) {
        IndexSearch.validateFieldSpecified(field);
        this.fieldContainsUnquoted.computeIfAbsent(field, k -> new ArrayList()).add(value);
        return this;
    }

    public IndexSearch fieldEquals(String field, String value) {
        IndexSearch.validateFieldSpecified(field);
        this.fieldEquals.computeIfAbsent(field, k -> new ArrayList()).add(value);
        return this;
    }

    public IndexSearch fieldNumericBetween(String field, long from, long to) {
        IndexSearch.validateFieldSpecified(field);
        this.fieldNumericBetween.computeIfAbsent(field, k -> new ArrayList()).add(Pair.of((Object)from, (Object)to));
        return this;
    }

    public IndexSearch uniqueDocumentIdEquals(String value) {
        return this.fieldEquals("uldid", value);
    }

    public IndexSearch withoutField(String field) {
        IndexSearch.validateFieldSpecified(field);
        this.withoutField.add(field);
        return this;
    }

    public IndexSearch analyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public IndexSearch maxDocs(int maxDocs) {
        this.maxDocs = maxDocs;
        return this;
    }

    public IndexSearch joinOperator(String joinOperator) {
        this.joinOperator = joinOperator.toUpperCase();
        return this;
    }

    private static void validateFieldSpecified(String field) {
        if (!StringUtils.hasText(field)) {
            throw new IllegalArgumentException("Field must be specified");
        }
    }

    public List<Document> search(IndexSearcher searcher) throws ParseException, IOException {
        Query query = this.buildQuery();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching index for: {}", (Object)query);
        }
        TopDocs topDocs = searcher.search(query, this.maxDocs);
        ArrayList<Document> documents = new ArrayList<Document>((int)topDocs.totalHits.value);
        int i = 0;
        while ((long)i < topDocs.totalHits.value) {
            documents.add(searcher.doc(topDocs.scoreDocs[i].doc));
            ++i;
        }
        if (this.fieldEquals.size() > 0) {
            documents.removeIf(e -> {
                for (Map.Entry<String, List<String>> entry : this.fieldEquals.entrySet()) {
                    String field = entry.getKey();
                    List<String> values = entry.getValue();
                    for (String value : values) {
                        if (Objects.equals(e.get(field), value)) continue;
                        return true;
                    }
                }
                return false;
            });
        }
        return documents;
    }

    public Query buildQuery() throws ParseException {
        StringBuilder queryBuilder = this.buildQueryString();
        QueryParser parser = new QueryParser("uldid", this.analyzer);
        parser.setAllowLeadingWildcard(true);
        return parser.parse(queryBuilder.toString());
    }

    private StringBuilder buildQueryString() {
        StringBuilder queryBuilder = new StringBuilder();
        this.appendFieldQuerySearchParameters(queryBuilder, this.fieldContains, true, true);
        this.appendFieldQuerySearchParameters(queryBuilder, this.fieldContainsUnquoted, false, true);
        this.appendFieldQuerySearchParameters(queryBuilder, this.fieldEquals, true, true);
        this.appendFieldQuerySearchParameters(queryBuilder, this.fieldNotContains, true, false);
        this.appendFieldQuerySearchParameters(queryBuilder, this.withoutField.stream().collect(Collectors.toMap(e -> e, e -> Collections.singletonList("*"))), false, false);
        for (Map.Entry<String, List<Pair<Long, Long>>> entry : this.fieldNumericBetween.entrySet()) {
            String field = entry.getKey();
            List<Pair<Long, Long>> values = entry.getValue();
            for (Pair<Long, Long> value : values) {
                if (queryBuilder.length() > 0) {
                    queryBuilder.append(" ").append(this.joinOperator).append(" ");
                }
                queryBuilder.append(field).append(":[").append(value.getLeft()).append(" TO ").append(value.getRight()).append("]");
            }
        }
        return queryBuilder;
    }

    private void appendFieldQuerySearchParameters(StringBuilder queryBuilder, Map<String, List<String>> fields, boolean quoted, boolean contains) {
        for (Map.Entry<String, List<String>> entry : fields.entrySet()) {
            String field = entry.getKey();
            List<String> values = entry.getValue();
            for (String queryPart : values) {
                if (queryBuilder.length() > 0) {
                    queryBuilder.append(" ").append(this.joinOperator).append(" ");
                }
                if (!contains) {
                    if (queryBuilder.length() == 0) {
                        queryBuilder.append("*:* NOT ");
                    } else {
                        queryBuilder.append("NOT ");
                    }
                }
                if (StringUtils.hasText(field)) {
                    queryBuilder.append(field).append(":");
                }
                if (quoted) {
                    String effectiveQueryPart;
                    if (queryPart.contains("\"")) {
                        Matcher matcher = Pattern.compile("(?<!\\\\)\"").matcher(queryPart);
                        StringBuffer sb = new StringBuffer();
                        while (matcher.find()) {
                            matcher.appendReplacement(sb, "\\\\\"");
                        }
                        matcher.appendTail(sb);
                        effectiveQueryPart = sb.toString();
                    } else {
                        effectiveQueryPart = queryPart;
                    }
                    queryBuilder.append("\"").append(effectiveQueryPart).append("\"");
                    continue;
                }
                queryBuilder.append(queryPart);
            }
        }
    }

    public String toString() {
        try {
            return this.buildQuery().toString();
        }
        catch (ParseException e) {
            return this.buildQueryString() + " [INVALID QUERY: " + e.getMessage() + "]";
        }
    }
}

