/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.advisory.CertSeiAdvisorEntry;
import com.metaeffekt.mirror.download.advisor.CertSeiDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certsei-advisors", mavenPropertyName="certSeiAdvisorIndex")
public class CertSeiAdvisorIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(CertSeiAdvisorIndex.class);

    public CertSeiAdvisorIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertSeiAdvisorIndex.class, Collections.singletonList(CertSeiDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"CertSeiAdvisorEntry#fromDownloadJson"})
    protected Map<String, Document> createIndexDocuments() {
        HashMap<String, Document> documents = new HashMap<String, Document>();
        List<File> files = super.getAllFilesInSubDirectories(this.requiredDownloads[0]);
        for (File file : files) {
            try {
                List contents = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonContent = new JSONObject(String.join((CharSequence)"", contents));
                CertSeiAdvisorEntry parsedEntry = CertSeiAdvisorEntry.fromDownloadJson(jsonContent);
                documents.put(parsedEntry.getId(), parsedEntry.toDocument());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read file contents during indexing ", e);
            }
        }
        return documents;
    }
}

