/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.download.advisor.GhsaDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="github-advisory-database", mavenPropertyName="githubAdvisorIndex")
public class GhsaAdvisorIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(GhsaAdvisorIndex.class);

    public GhsaAdvisorIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, GhsaAdvisorIndex.class, Collections.singletonList(GhsaDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"GhsaAdvisorEntry#fromGitRepoJson"})
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        LOG.info("Searching for files in repository, this may take a while {}", (Object)this.requiredDownloads[0].getAbsolutePath());
        Collection<File> files = super.getAllFilesRecursively(this.requiredDownloads[0]);
        LOG.info("Found [{}] files in repository", (Object)files.size());
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            this.executor.submit(() -> {
                try {
                    GhsaAdvisorEntry parsedEntry;
                    String contents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    try {
                        parsedEntry = GhsaAdvisorEntry.fromGitRepoJson(new JSONObject(contents));
                    }
                    catch (Exception e) {
                        LOG.error("Unable to parse file content during indexing: {}\n{}", new Object[]{file.getAbsolutePath(), contents, e});
                        throw e;
                    }
                    if (documents.containsKey(parsedEntry.getId())) {
                        LOG.warn("Duplicate entry found, skipping: {}", (Object)parsedEntry.toJson());
                    } else {
                        documents.put(parsedEntry.getId(), parsedEntry.toDocument());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read file contents during indexing: " + file.getAbsolutePath(), e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse file content during indexing: " + file.getAbsolutePath(), e);
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for all vulnerability sheets to be created", e);
        }
        return documents;
    }
}

