/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.download.advisor.MsrcDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@MirrorMetadata(directoryName="msrc-advisors", mavenPropertyName="msrcAdvisorIndex")
public class MsrcAdvisorIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcAdvisorIndex.class);

    public MsrcAdvisorIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcAdvisorIndex.class, Collections.singletonList(MsrcDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"MsrcAdvisorEntry#fromDownloadXml"})
    protected Map<String, org.apache.lucene.document.Document> createIndexDocuments() {
        ConcurrentHashMap<String, org.apache.lucene.document.Document> documents = new ConcurrentHashMap<String, org.apache.lucene.document.Document>();
        List<File> files = super.getAllFilesInSubDirectories(this.requiredDownloads[0]);
        for (File file : files) {
            if (!file.getName().endsWith(".xml")) continue;
            this.executor.submit(() -> {
                try {
                    List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                    if (lines.isEmpty() || lines.size() < 3 && StringUtils.isEmpty(String.join((CharSequence)"", lines))) {
                        return;
                    }
                    Document document = this.parseXmlDocument(String.join((CharSequence)"\n", lines));
                    List<MsrcAdvisorEntry> parsedEntries = MsrcAdvisorEntry.fromDownloadXml(document);
                    for (MsrcAdvisorEntry entry : parsedEntries) {
                        if (documents.containsKey(entry.getId()) && StringUtils.isEmpty(entry.getSummary())) continue;
                        documents.put(entry.getId(), entry.toDocument());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read file contents during indexing: " + file.getAbsolutePath(), e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse file content during indexing: " + file.getAbsolutePath(), e);
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        return documents;
    }
}

