/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.contents.msrcdata.MsrcRemediation;
import com.metaeffekt.mirror.contents.msrcdata.MsrcSupersedeNode;
import com.metaeffekt.mirror.download.advisor.MsrcManualCsvDownload;
import com.metaeffekt.mirror.download.advisor.MsrcSecurityGuideDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.advisor.MsrcAdvisorIndex;
import com.metaeffekt.mirror.index.advisor.MsrcProductIndex;
import com.metaeffekt.mirror.query.MsrcAdvisorIndexQuery;
import com.metaeffekt.mirror.query.MsrcProductIndexQuery;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="msrc-kb-chains", mavenPropertyName="msrcKbChainIndex")
public class MsrcKbChainIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcKbChainIndex.class);
    private final List<File> additionalCsvFiles = new ArrayList<File>();

    public MsrcKbChainIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcKbChainIndex.class, Collections.singletonList(MsrcSecurityGuideDownload.class), Arrays.asList(MsrcAdvisorIndex.class, MsrcProductIndex.class), Collections.singletonList(MsrcManualCsvDownload.class), Collections.emptyList());
    }

    public MsrcKbChainIndex addAdditionalCsvFile(File additionalCsvFile) {
        this.additionalCsvFiles.add(additionalCsvFile);
        return this;
    }

    @Override
    @DocRelevantMethods(value={"MsrcKbChainIndex#createMsrcApiNodes", "MsrcKbChainIndex#createMsrcUpdateGuideNodes", "MsrcKbChainIndex#createMsrcJsonDownloadNodes"})
    protected Map<String, Document> createIndexDocuments() {
        MsrcAdvisorIndexQuery advisorQuery = new MsrcAdvisorIndexQuery(this.getRequiredIndex(MsrcAdvisorIndex.class));
        MsrcProductIndexQuery productQuery = new MsrcProductIndexQuery(this.getRequiredIndex(MsrcProductIndex.class));
        List<File> allMsrcUpdateGuideCsvFiles = this.getAllMsrcUpdateGuideCsvFiles();
        List<File> allMsrcUpdateGuideJsonFiles = this.getAllMsrcUpdateGuideJsonFiles();
        LOG.info("");
        LOG.info("Parsing KB nodes from:");
        LOG.info("  - the MSRC Api Advisor Mirror");
        if (!allMsrcUpdateGuideCsvFiles.isEmpty()) {
            LOG.info("  - [{}] MSRC Security Update Guide CSV files", (Object)allMsrcUpdateGuideCsvFiles.size());
        }
        if (!allMsrcUpdateGuideJsonFiles.isEmpty()) {
            LOG.info("  - [{}] MSRC Security Update Guide JSON files", (Object)allMsrcUpdateGuideJsonFiles.size());
        }
        LOG.info("");
        LOG.info("- - - - - - - -");
        List<MsrcSupersedeNode> msrcApiNodes = this.createMsrcApiNodes(advisorQuery);
        Map<File, List<MsrcSupersedeNode>> msrcUpdateGuideNodes = this.createMsrcUpdateGuideNodes(productQuery, allMsrcUpdateGuideCsvFiles);
        Map<File, List<MsrcSupersedeNode>> msrcUpdateGuideJsonNodes = this.createMsrcUpdateGuideJsonNodes(productQuery, allMsrcUpdateGuideJsonFiles);
        ArrayList<MsrcSupersedeNode> parsedNodes = new ArrayList<MsrcSupersedeNode>(msrcApiNodes);
        for (Map.Entry<File, List<MsrcSupersedeNode>> fileEntry : msrcUpdateGuideNodes.entrySet()) {
            parsedNodes.addAll((Collection<MsrcSupersedeNode>)fileEntry.getValue());
        }
        for (Map.Entry<File, List<MsrcSupersedeNode>> fileEntry : msrcUpdateGuideJsonNodes.entrySet()) {
            parsedNodes.addAll((Collection<MsrcSupersedeNode>)fileEntry.getValue());
        }
        Map<String, MsrcSupersedeNode> uniqueNodes = MsrcSupersedeNode.mergeNodes(Collections.singleton(parsedNodes));
        LOG.info("Deduplicated parsed KB entries [{} --> {}]", (Object)parsedNodes.size(), (Object)uniqueNodes.size());
        HashMap<String, Document> documents = new HashMap<String, Document>();
        for (Map.Entry<String, MsrcSupersedeNode> entry : uniqueNodes.entrySet()) {
            documents.put(entry.getKey(), entry.getValue().toDocument());
        }
        return documents;
    }

    private List<File> getAllMsrcUpdateGuideCsvFiles() {
        if (!this.optionalDownloads[0].exists()) {
            return Collections.emptyList();
        }
        Collection files = FileUtils.listFiles((File)this.optionalDownloads[0], (String[])new String[]{"csv"}, (boolean)true);
        for (File additionalCsvFile : this.additionalCsvFiles) {
            files.addAll(FileUtils.listFiles((File)additionalCsvFile, (String[])new String[]{"csv"}, (boolean)true));
        }
        return files.stream().sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
    }

    private List<File> getAllMsrcUpdateGuideJsonFiles() {
        if (!this.requiredDownloads[0].exists()) {
            return Collections.emptyList();
        }
        return FileUtils.listFiles((File)this.requiredDownloads[0], (String[])new String[]{"json"}, (boolean)true).stream().sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
    }

    private List<MsrcSupersedeNode> createMsrcApiNodes(MsrcAdvisorIndexQuery advisorQuery) {
        HashMap<String, MsrcSupersedeNode> nodes = new HashMap<String, MsrcSupersedeNode>();
        LOG.info("Querying MSRC API for KB entries");
        for (MsrcAdvisorEntry entry : advisorQuery.findAll()) {
            String vulnerabilityId = entry.getId().replace("MSRC-", "");
            for (MsrcRemediation msRemediation : entry.getMsRemediations()) {
                String description = msRemediation.getDescription();
                if (!this.isKbIdentifier(description)) continue;
                MsrcSupersedeNode node = nodes.computeIfAbsent(description, MsrcSupersedeNode::new);
                Set<String> affectedProductIds = msRemediation.getAffectedProductIds();
                String supercedence = msRemediation.getSupercedence();
                List<String> supersedence = this.extractSupersedeIdentifiers(supercedence);
                for (String affectedProductId : affectedProductIds) {
                    node.addAffectsVulnerability(affectedProductId, vulnerabilityId);
                    for (String supersededKbId : supersedence) {
                        MsrcSupersedeNode supersededNode = nodes.computeIfAbsent(supersededKbId, MsrcSupersedeNode::new);
                        node.addSupersedes(affectedProductId, supersededNode);
                        supersededNode.addSupersededBy(affectedProductId, node);
                    }
                }
            }
        }
        Map<String, MsrcSupersedeNode> normalized = MsrcSupersedeNode.mergeNodes(Collections.singletonList(nodes.values()));
        if (normalized.size() != nodes.size()) {
            LOG.info("Found [{}] --> [{}] KB entries", (Object)nodes.size(), (Object)normalized.size());
        } else {
            LOG.info("Found [{}] KB entries", (Object)nodes.size());
        }
        LOG.info("- - - - - - - -");
        return new ArrayList<MsrcSupersedeNode>(normalized.values());
    }

    private Map<File, List<MsrcSupersedeNode>> createMsrcUpdateGuideNodes(MsrcProductIndexQuery productQuery, List<File> files) {
        LinkedHashMap<File, List<MsrcSupersedeNode>> msrcUpdateGuideNodes = new LinkedHashMap<File, List<MsrcSupersedeNode>>();
        if (files.isEmpty()) {
            return msrcUpdateGuideNodes;
        }
        for (File msrcUpdateGuideDownloadCsvFile : files) {
            this.executor.submit(() -> {
                try {
                    List<MsrcSupersedeNode> msrcCsvDownloadNodes = this.createMsrcCsvDownloadNodes(productQuery, msrcUpdateGuideDownloadCsvFile);
                    msrcUpdateGuideNodes.put(msrcUpdateGuideDownloadCsvFile, msrcCsvDownloadNodes);
                }
                catch (IOException e) {
                    LOG.error("Failed to read MSRC update guide CSV file: " + msrcUpdateGuideDownloadCsvFile, (Throwable)e);
                    throw new RuntimeException("Failed to read MSRC update guide CSV file: " + msrcUpdateGuideDownloadCsvFile, e);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse MSRC update guide CSV file: " + msrcUpdateGuideDownloadCsvFile, (Throwable)e);
                    throw new RuntimeException("Failed to parse MSRC update guide CSV file: " + msrcUpdateGuideDownloadCsvFile, e);
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        LOG.info("- - - - - - - -");
        return msrcUpdateGuideNodes;
    }

    private Map<File, List<MsrcSupersedeNode>> createMsrcUpdateGuideJsonNodes(MsrcProductIndexQuery productQuery, List<File> files) {
        LinkedHashMap<File, List<MsrcSupersedeNode>> msrcUpdateGuideNodes = new LinkedHashMap<File, List<MsrcSupersedeNode>>();
        if (files.isEmpty()) {
            return msrcUpdateGuideNodes;
        }
        for (File msrcUpdateGuideDownloadJsonFile : files) {
            this.executor.submit(() -> {
                try {
                    List<MsrcSupersedeNode> msrcJsonDownloadNodes = this.createMsrcJsonDownloadNodes(productQuery, msrcUpdateGuideDownloadJsonFile);
                    msrcUpdateGuideNodes.put(msrcUpdateGuideDownloadJsonFile, msrcJsonDownloadNodes);
                }
                catch (IOException e) {
                    LOG.error("Failed to read MSRC update guide JSON file: " + msrcUpdateGuideDownloadJsonFile, (Throwable)e);
                    throw new RuntimeException("Failed to read MSRC update guide JSON file: " + msrcUpdateGuideDownloadJsonFile, e);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse MSRC update guide JSON file: " + msrcUpdateGuideDownloadJsonFile, (Throwable)e);
                    throw new RuntimeException("Failed to parse MSRC update guide JSON file: " + msrcUpdateGuideDownloadJsonFile, e);
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        LOG.info("- - - - - - - -");
        return msrcUpdateGuideNodes;
    }

    private List<MsrcSupersedeNode> createMsrcCsvDownloadNodes(MsrcProductIndexQuery productQuery, File file) throws IOException {
        if (file.isDirectory() || !file.isFile() || !file.getName().endsWith(".csv")) {
            LOG.warn("File is not a CSV file, but a directory: " + file.getAbsolutePath());
            return Collections.emptyList();
        }
        LOG.info("Parsing CSV file from [{}]", (Object)file.getAbsolutePath());
        List<Map<String, String>> csvData = this.parseCsvFile(file);
        LOG.info("Parsing CSV file with [{}] entries", (Object)csvData.size());
        HashMap<String, MsrcSupersedeNode> nodes = new HashMap<String, MsrcSupersedeNode>();
        HashSet<String> unknownProducts = new HashSet<String>();
        for (Map<String, String> entry : csvData) {
            String cveId = entry.get("Details");
            String article = entry.get("Article");
            String productName = entry.get("Product");
            String effectiveProduct = this.resolveEffectiveProduct(productQuery, productName, unknownProducts, cveId);
            if (!StringUtils.hasText(cveId) || !StringUtils.hasText(article) || !article.matches("\\d{6,8}")) continue;
            for (String product : effectiveProduct.split(",")) {
                nodes.computeIfAbsent(article, MsrcSupersedeNode::new).addAffectsVulnerability(product, cveId);
            }
        }
        LOG.info("Parsed [{}] KB entries", (Object)nodes.size());
        return new ArrayList<MsrcSupersedeNode>(MsrcSupersedeNode.mergeNodes(Collections.singletonList(nodes.values())).values());
    }

    private List<MsrcSupersedeNode> createMsrcJsonDownloadNodes(MsrcProductIndexQuery productQuery, File file) throws IOException {
        if (file.isDirectory() || !file.isFile() || !file.getName().endsWith(".json")) {
            LOG.warn("File is not a JSON file, but a directory: " + file.getAbsolutePath());
            return Collections.emptyList();
        }
        LOG.info("Parsing JSON file from [{}]", (Object)file.getAbsolutePath());
        JSONArray jsonArray = new JSONArray(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
        LOG.info("Parsing JSON file with [{}] entries", (Object)jsonArray.length());
        HashMap<String, MsrcSupersedeNode> nodes = new HashMap<String, MsrcSupersedeNode>();
        HashSet<String> unknownProducts = new HashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject entry = jsonArray.getJSONObject(i);
            String cveId = entry.getString("cveNumber");
            JSONArray entryArticles = entry.getJSONArray("kbArticles");
            String productName = entry.getString("product");
            String effectiveProduct = this.resolveEffectiveProduct(productQuery, productName, unknownProducts, cveId);
            for (int j = 0; j < entryArticles.length(); ++j) {
                JSONObject currentArticle = entryArticles.getJSONObject(j);
                String article = currentArticle.optString("articleName", null);
                String articleUrl = (String)ObjectUtils.firstNonNull((Object[])new String[]{currentArticle.optString("articleUrl", null), currentArticle.optString("knownIssuesUrl", null)});
                String downloadUrl = currentArticle.optString("downloadUrl", null);
                if (!StringUtils.hasText(cveId) || !StringUtils.hasText(article) || !article.matches("\\d{6,8}")) continue;
                for (String product : effectiveProduct.split(",")) {
                    nodes.computeIfAbsent(article, a -> new MsrcSupersedeNode((String)a, articleUrl, downloadUrl)).addAffectsVulnerability(product, cveId);
                }
            }
        }
        LOG.info("Parsed [{}] KB entries", (Object)nodes.size());
        return new ArrayList<MsrcSupersedeNode>(MsrcSupersedeNode.mergeNodes(Collections.singletonList(nodes.values())).values());
    }

    private String resolveEffectiveProduct(MsrcProductIndexQuery productQuery, String productName, Set<String> unknownProducts, String cveId) {
        String effectiveProduct;
        if (StringUtils.hasText(productName)) {
            MsrcProduct productByOriginalName = productQuery.findProductByName(productName);
            if (productByOriginalName != null) {
                effectiveProduct = productByOriginalName.getId();
            } else {
                List<MsrcProduct> products = productQuery.findProductByNameFuzzyIfNoExactMatch(productName);
                if (products.isEmpty()) {
                    if (unknownProducts.add(productName)) {
                        LOG.info("Product not found: {}", (Object)productName);
                    }
                    effectiveProduct = "unknown";
                } else {
                    effectiveProduct = products.stream().map(MsrcProduct::getId).collect(Collectors.joining(","));
                }
            }
        } else {
            effectiveProduct = "unknown";
            LOG.warn("No product name found for [{}]", (Object)cveId);
        }
        return effectiveProduct;
    }

    private List<Map<String, String>> parseCsvFile(File file) throws IOException {
        CSVParser parser = CSVParser.parse((File)file, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader().withAllowDuplicateHeaderNames());
        ArrayList<Map<String, String>> csvData = new ArrayList<Map<String, String>>();
        for (CSVRecord record : parser) {
            HashMap<String, String> entry = new HashMap<String, String>();
            int i = 0;
            for (String header : record.getParser().getHeaderNames()) {
                String value = record.get(i++);
                if (entry.containsKey(header)) {
                    entry.put(header + " (" + (entry.keySet().stream().filter(k -> k.startsWith(header)).count() + 1L) + ")", value);
                    continue;
                }
                entry.put(header, value);
            }
            csvData.add(entry);
        }
        return csvData;
    }

    private List<String> extractSupersedeIdentifiers(String identifiers) {
        if (StringUtils.isEmpty(identifiers)) {
            return Collections.emptyList();
        }
        return Arrays.stream(identifiers.split("([,;]|<br>) ?")).filter(StringUtils::hasText).map(kb -> kb.replace("\n", "")).map(kb -> kb.replace(" ", "")).filter(this::isKbIdentifier).collect(Collectors.toList());
    }

    private boolean isKbIdentifier(String id) {
        return StringUtils.hasText(id) && id.matches("\\d{6,8}");
    }
}

