/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.download.advisor.MsrcDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@MirrorMetadata(directoryName="msrc-products", mavenPropertyName="msrcProductIndex")
public class MsrcProductIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(MsrcProductIndex.class);

    public MsrcProductIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcProductIndex.class, Collections.singletonList(MsrcDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"MsrcProductIndex#parseMsProductsFromFile"})
    protected Map<String, org.apache.lucene.document.Document> createIndexDocuments() {
        ConcurrentHashMap<String, org.apache.lucene.document.Document> documents = new ConcurrentHashMap<String, org.apache.lucene.document.Document>();
        List<File> files = super.getAllFilesInSubDirectories(this.requiredDownloads[0]);
        HashSet productIdsWithFullContent = new HashSet();
        for (File file : files) {
            if (!file.getName().endsWith(".xml")) continue;
            this.executor.submit(() -> {
                List<MsrcProduct> products = this.parseMsProductsFromFile(file);
                for (MsrcProduct product : products) {
                    if (productIdsWithFullContent.contains(product.getId())) continue;
                    if (product.getVendor() != null && product.getFamily() != null) {
                        productIdsWithFullContent.add(product.getId());
                    }
                    documents.put(product.getId(), product.toDocument());
                }
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        return documents;
    }

    private List<MsrcProduct> parseMsProductsFromFile(File file) {
        Document xmlDocument;
        List lines;
        ArrayList<MsrcProduct> products = new ArrayList<MsrcProduct>();
        try {
            lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file to extract ms products " + file.getAbsolutePath(), e);
        }
        if (lines.size() == 0 || lines.size() < 3 && StringUtils.isEmpty(String.join((CharSequence)"", lines))) {
            return products;
        }
        try {
            xmlDocument = this.parseXmlDocument(String.join((CharSequence)"", lines));
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Cannot parse xml file " + file.getAbsolutePath(), e);
        }
        NodeList productNodes = xmlDocument.getElementsByTagName("prod:FullProductName");
        for (int i = 0; i < productNodes.getLength(); ++i) {
            Element productElement = (Element)productNodes.item(i);
            String productId = productElement.getAttribute("ProductID");
            String productName = productElement.getTextContent();
            Node productFamilyNameNode = productElement.getParentNode().getAttributes().getNamedItem("Name");
            String productFamily = productFamilyNameNode == null ? null : productFamilyNameNode.getTextContent();
            Node vendorNameNode = productElement.getParentNode().getParentNode().getAttributes().getNamedItem("Name");
            String vendor = vendorNameNode == null ? null : vendorNameNode.getTextContent();
            products.add(new MsrcProduct(productId, productName, productFamily, vendor));
        }
        return products;
    }
}

