/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.nvd;

import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiIndex;
import com.metaeffekt.mirror.query.NvdCpeApiIndexQuery;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="cpe-dict-vp", mavenPropertyName="nvdCpeVendorProductIndex")
public class NvdCpeApiVendorProductIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCpeApiVendorProductIndex.class);

    public NvdCpeApiVendorProductIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCpeApiVendorProductIndex.class, Collections.emptyList(), Collections.singletonList(NvdCpeApiIndex.class));
    }

    @Override
    protected Map<String, Document> createIndexDocuments() {
        Object document2;
        NvdCpeApiIndexQuery indexQuery = new NvdCpeApiIndexQuery(this.getRequiredIndex(NvdCpeApiIndex.class));
        HashMap<String, Document> documents = new HashMap<String, Document>();
        LOG.info("Parsing all [Vendor Products] / [Product Vendors] pairs");
        HashMap vendorProductsMap = new HashMap();
        HashMap productVendorsMap = new HashMap();
        indexQuery.getIndex().findAndProcessAllDocuments((Document document) -> {
            vendorProductsMap.computeIfAbsent(document.get("vendor"), k -> new HashSet()).add(document.get("product"));
            productVendorsMap.computeIfAbsent(document.get("product"), k -> new HashSet()).add(document.get("vendor"));
        });
        LOG.info("Extracted [{} Vendor Products] and [{} Product Vendors]", (Object)vendorProductsMap.size(), (Object)productVendorsMap.size());
        LOG.info("Building Vendor Products map");
        for (Map.Entry vendorProducts : vendorProductsMap.entrySet()) {
            StringJoiner productJoiner = new StringJoiner(", ");
            for (String product : (Set)vendorProducts.getValue()) {
                productJoiner.add(product);
            }
            document2 = new Document();
            document2.add((IndexableField)new StringField("type", "vp", Field.Store.YES));
            document2.add((IndexableField)new TextField("vendor", (String)vendorProducts.getKey(), Field.Store.YES));
            document2.add((IndexableField)new TextField("product", productJoiner.toString(), Field.Store.YES));
            documents.put("vp" + (String)vendorProducts.getKey(), (Document)document2);
        }
        LOG.info("Building Product Vendors map");
        for (Map.Entry productVendors : productVendorsMap.entrySet()) {
            StringJoiner vendorJoiner = new StringJoiner(", ");
            for (String vendor : (Set)productVendors.getValue()) {
                vendorJoiner.add(vendor);
            }
            document2 = new Document();
            document2.add((IndexableField)new StringField("type", "pv", Field.Store.YES));
            document2.add((IndexableField)new TextField("product", (String)productVendors.getKey(), Field.Store.YES));
            document2.add((IndexableField)new TextField("vendor", vendorJoiner.toString(), Field.Store.YES));
            documents.put("pv" + (String)productVendors.getKey(), (Document)document2);
        }
        return documents;
    }
}

