/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.EolLifecycle;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.MsrcProductIndex;
import com.metaeffekt.mirror.index.other.EolIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EolIndexQuery
extends IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(EolIndexQuery.class);

    public EolIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EolIndex.class);
    }

    public EolIndexQuery(MsrcProductIndex index) {
        super(index);
    }

    public EolLifecycle findCyclesByProduct(String product) {
        return this.findCyclesBySearcher(new IndexSearch().fieldEquals("product", product));
    }

    public EolLifecycle findCyclesBySearcher(IndexSearch search) {
        List<EolCycle> cycles = this.index.findDocuments(search).stream().map(EolCycle::fromDocument).sorted().collect(Collectors.toList());
        if (cycles.stream().map(EolCycle::getProduct).distinct().count() > 1L) {
            LOG.error("Multiple products [{}] found for search: {}", (Object)cycles.stream().map(EolCycle::getProduct).distinct().collect(Collectors.joining(", ")), (Object)search);
        }
        if (cycles.isEmpty()) {
            return null;
        }
        return new EolLifecycle(((EolCycle)cycles.get(0)).getProduct(), cycles);
    }

    public List<String> findProducts() {
        HashSet products = new HashSet();
        this.index.findAndProcessAllDocuments(doc -> products.add(doc.get("product")));
        return products.stream().sorted().collect(Collectors.toList());
    }

    public Optional<EolCycle> findCycleByProductAndCycle(String product, String cycle) {
        List cycles = this.index.findDocuments(new IndexSearch().fieldEquals("product", product).fieldEquals("cycle", cycle)).stream().map(EolCycle::fromDocument).sorted().collect(Collectors.toList());
        if (cycles.size() > 1) {
            LOG.error("Multiple cycles [{}] found for product {} and cycle {}", new Object[]{cycles.stream().map(EolCycle::getCycle).distinct().collect(Collectors.joining(", ")), product, cycle});
        }
        return cycles.stream().findFirst();
    }

    public List<EolLifecycle> findAll() {
        return this.index.findAllDocuments().stream().map(EolCycle::fromDocument).collect(Collectors.groupingBy(EolCycle::getProduct)).entrySet().stream().map(e -> new EolLifecycle((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
    }
}

