/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.index.Index;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(IndexQuery.class);
    protected final Index index;

    protected IndexQuery(File baseMirrorDirectory, Class<? extends Index> requiredIndex) {
        if (requiredIndex == null) {
            LOG.debug("No index specified in index query");
            this.index = null;
        } else {
            this.index = Index.getInstance(requiredIndex, baseMirrorDirectory);
            this.index.assertExists();
        }
    }

    protected IndexQuery(Index index) {
        if (index == null) {
            throw new IllegalArgumentException("index must not be null");
        }
        this.index = index;
        this.index.assertExists();
    }

    public Index getIndex() {
        return this.index;
    }

    public String toString() {
        if (this.index == null) {
            return "IndexQuery@" + Integer.toHexString(this.hashCode()) + "[no index]";
        }
        return "IndexQuery@" + Integer.toHexString(this.hashCode()) + "[" + this.index + "]";
    }
}

