function hideOverviewChartsWithoutData() {
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartCvssSeverityContextByComponent, 'vulnerabilityOverviewChartCvssSeverityContextByComponent');
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartCvssSeverityContext, 'vulnerabilityOverviewChartCvssSeverityContext');
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartCvssSeverityContextByStatusInReview, 'vulnerabilityOverviewChartCvssSeverityContextByStatusInReview');
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartCvssSeverityContextByStatusApplicable, 'vulnerabilityOverviewChartCvssSeverityContextByStatusApplicable');
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartVulnerabilityStatus, 'vulnerabilityOverviewChartVulnerabilityStatus');
    hideOverviewChartsWithoutDataForChart(vulnerabilityOverviewChartCvssSeverityInitial, 'vulnerabilityOverviewChartCvssSeverityInitial');
}

function hideOverviewChartsWithoutDataForChart(chartData, canvasId) {
    const chartCanvas = document.getElementById(canvasId);
    if (chartData.data.datasets[0].data.filter(e => e !== null && e !== 0).length === 0) {
        chartCanvas.classList.add('hidden');
        if (chartCanvas.nextSibling) { /* center dot for "by status" charts */
            chartCanvas.nextSibling.classList.add('hidden');
        }
    } else {
        chartCanvas.classList.remove('hidden');
        if (chartCanvas.nextSibling) {
            chartCanvas.nextSibling.classList.remove('hidden');
        }
    }
}

hideOverviewChartsWithoutData();

/* START: ASSESSMENT EDITOR */

let assessmentEditorData = {};

function findOrCreateDummyInput(inputElementId) {
    let inputElement = document.getElementById(inputElementId);
    if (!inputElement) {
        inputElement = document.createElement('input');
        inputElement.id = inputElementId;
    }
    return inputElement;
}

const assessmentEditorModalInputElements = {
    scope: findOrCreateDummyInput('assessment-editor-scope-select'),
    title: findOrCreateDummyInput('assessment-editor-title-input'),
    reportedBy: findOrCreateDummyInput('assessment-editor-reported-by-input'),
    reportedDate: findOrCreateDummyInput('assessment-editor-reported-date-input'),
    acceptedBy: findOrCreateDummyInput('assessment-editor-accepted-by-input'),
    acceptedDate: findOrCreateDummyInput('assessment-editor-accepted-date-input'),

    assessmentStatus: findOrCreateDummyInput('assessment-editor-assessment-status-select'),
    assessmentRationale: findOrCreateDummyInput('assessment-editor-assessment-rationale-input'),
    assessmentRisk: findOrCreateDummyInput('assessment-editor-assessment-risk-input'),
    assessmentMeasures: findOrCreateDummyInput('assessment-editor-assessment-measures-input'),
    assessmentScore: findOrCreateDummyInput('assessment-editor-assessment-score-input'),
    assessmentAuthor: findOrCreateDummyInput('assessment-editor-assessment-author-input'),
    assessmentDate: findOrCreateDummyInput('assessment-editor-assessment-date-input'),
    assessmentLabelsInclude: findOrCreateDummyInput('assessment-editor-assessment-labels-include-input'),
    assessmentLabelsExclude: findOrCreateDummyInput('assessment-editor-assessment-labels-exclude-input'),

    assessmentCvssVector2P0All: findOrCreateDummyInput('assessment-editor-cvss-vector-2.0-all-input'),
    assessmentCvssVector2P0Lower: findOrCreateDummyInput('assessment-editor-cvss-vector-2.0-lower-input'),
    assessmentCvssVector2P0Higher: findOrCreateDummyInput('assessment-editor-cvss-vector-2.0-higher-input'),
    assessmentCvssVector3P1All: findOrCreateDummyInput('assessment-editor-cvss-vector-3.1-all-input'),
    assessmentCvssVector3P1Lower: findOrCreateDummyInput('assessment-editor-cvss-vector-3.1-lower-input'),
    assessmentCvssVector3P1Higher: findOrCreateDummyInput('assessment-editor-cvss-vector-3.1-higher-input'),
    assessmentCvssVector4P0All: findOrCreateDummyInput('assessment-editor-cvss-vector-4.0-all-input'),
    assessmentCvssVector4P0Lower: findOrCreateDummyInput('assessment-editor-cvss-vector-4.0-lower-input'),
    assessmentCvssVector4P0Higher: findOrCreateDummyInput('assessment-editor-cvss-vector-4.0-higher-input'),
};

function setupAssessmentEditorModal() {
    clearAssessmentEditorModal();

    function createAffectsElement(field, value) {
        if (!value) return;
        if (!assessmentEditorData[field]) assessmentEditorData[field] = [];
        if (assessmentEditorData[field].includes(value)) return;
        assessmentEditorData[field].push(value);
        updateAssessmentEditorModalVisuals();
    }

    /* affects section with matching criteria */
    ['cpe', 'vulnerability', 'cwe', 'condition'].forEach((field) => {
        const inputElement = document.getElementById(`assessment-editor-affects-${field}-input`);
        inputElement.addEventListener('blur', () => {
            createAffectsElement(field, inputElement.value);
            inputElement.value = '';
        });
        inputElement.addEventListener('keyup', (event) => {
            if (event.key === 'Enter') {
                createAffectsElement(field, inputElement.value);
                inputElement.value = '';
            }
        });
    });

    /* general data */
    assessmentEditorModalInputElements.scope.addEventListener('change', () => {
        assessmentEditorData.scope = assessmentEditorModalInputElements.scope.value;
        updateAssessmentEditorModalVisuals();
    });

    assessmentEditorModalInputElements.title.addEventListener('blur', () => {
        assessmentEditorData.title = assessmentEditorModalInputElements.title.value;
        updateAssessmentEditorModalVisuals();
    });

    assessmentEditorModalInputElements.reportedBy.addEventListener('blur', () => {
        assessmentEditorData.reportedBy = assessmentEditorModalInputElements.reportedBy.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.reportedDate.addEventListener('blur', () => {
        assessmentEditorData.reportedDate = assessmentEditorModalInputElements.reportedDate.value;
        updateAssessmentEditorModalVisuals();
    });

    assessmentEditorModalInputElements.acceptedBy.addEventListener('blur', () => {
        assessmentEditorData.acceptedBy = assessmentEditorModalInputElements.acceptedBy.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.acceptedDate.addEventListener('blur', () => {
        assessmentEditorData.acceptedDate = assessmentEditorModalInputElements.acceptedDate.value;
        updateAssessmentEditorModalVisuals();
    });

    assessmentEditorModalInputElements.assessmentCvssVector2P0All.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector2P0All = assessmentEditorModalInputElements.assessmentCvssVector2P0All.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector2P0Lower.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector2P0Lower = assessmentEditorModalInputElements.assessmentCvssVector2P0Lower.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector2P0Higher.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector2P0Higher = assessmentEditorModalInputElements.assessmentCvssVector2P0Higher.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector3P1All.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector3P1All = assessmentEditorModalInputElements.assessmentCvssVector3P1All.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector3P1Lower.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector3P1Lower = assessmentEditorModalInputElements.assessmentCvssVector3P1Lower.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector3P1Higher.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector3P1Higher = assessmentEditorModalInputElements.assessmentCvssVector3P1Higher.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector4P0All.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector4P0All = assessmentEditorModalInputElements.assessmentCvssVector4P0All.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector4P0Lower.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector4P0Lower = assessmentEditorModalInputElements.assessmentCvssVector4P0Lower.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentCvssVector4P0Higher.addEventListener('blur', () => {
        assessmentEditorData.assessmentCvssVector4P0Higher = assessmentEditorModalInputElements.assessmentCvssVector4P0Higher.value;
        updateAssessmentEditorModalVisuals();
    });

    /* assessment */
    assessmentEditorModalInputElements.assessmentStatus.addEventListener('change', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentStatus = assessmentEditorModalInputElements.assessmentStatus.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentRationale.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentRationale = assessmentEditorModalInputElements.assessmentRationale.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentRisk.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentRisk = assessmentEditorModalInputElements.assessmentRisk.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentMeasures.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentMeasures = assessmentEditorModalInputElements.assessmentMeasures.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentScore.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentScore = assessmentEditorModalInputElements.assessmentScore.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentAuthor.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentAuthor = assessmentEditorModalInputElements.assessmentAuthor.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentDate.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentDate = assessmentEditorModalInputElements.assessmentDate.value;
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentLabelsInclude.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentLabelsInclude = assessmentEditorModalInputElements.assessmentLabelsInclude.value.split(', ').map((v) => v.trim()).filter((v) => v);
        updateAssessmentEditorModalVisuals();
    });
    assessmentEditorModalInputElements.assessmentLabelsExclude.addEventListener('blur', () => {
        assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex].assessmentLabelsExclude = assessmentEditorModalInputElements.assessmentLabelsExclude.value.split(', ').map((v) => v.trim()).filter((v) => v);
        updateAssessmentEditorModalVisuals();
    });

    /* new button */
    document.getElementById('assessment-editor-assessment-add-new-button').addEventListener('click', () => {
        assessmentEditorData.assessments.unshift({
            assessmentStatus: 'applicable',
        });
        assessmentEditorData.selectedAssessmentIndex = 0;
        updateAssessmentEditorModalVisuals();
    });

    /* remove button assessment-editor-assessment-remove-button */
    document.getElementById('assessment-editor-assessment-remove-button').addEventListener('click', () => {
        if (assessmentEditorData.selectedAssessmentIndex < 0) {
            return;
        }
        assessmentEditorData.assessments.splice(assessmentEditorData.selectedAssessmentIndex, 1);
        if (assessmentEditorData.selectedAssessmentIndex > 0) {
            assessmentEditorData.selectedAssessmentIndex = assessmentEditorData.assessments.length - 1;
        } else if (assessmentEditorData.selectedAssessmentIndex === 0 && assessmentEditorData.assessments.length > 0) {
            assessmentEditorData.selectedAssessmentIndex = 0;
        } else {
            assessmentEditorData.selectedAssessmentIndex = -1;
        }
        updateAssessmentEditorModalVisuals();
    });

}

function updateAssessmentEditorModalVisuals() {
    const affectsCreatedElementsContainer = document.getElementById('assessment-editor-affects-container');
    affectsCreatedElementsContainer.innerHTML = '';

    /* affects section with matching criteria */
    if (assessmentEditorData.scope === 'inventory') {
        document.getElementById('assessment-editor-affects-add-elements-container').classList.add('hidden');
        document.getElementById('assessment-editor-inventory-scope-selected').classList.remove('hidden');
    } else {
        document.getElementById('assessment-editor-affects-add-elements-container').classList.remove('hidden');
        document.getElementById('assessment-editor-inventory-scope-selected').classList.add('hidden');

        ['cpe', 'vulnerability', 'cwe', 'condition'].forEach((field) => {
            if (!assessmentEditorData[field]) return;
            assessmentEditorData[field].forEach((value) => {
                const badgeElement = document.createElement('div');
                badgeElement.classList.add('matching-criteria-badge');

                const fieldSpan = document.createElement('span');
                fieldSpan.innerText = {
                    'cpe': 'CPE',
                    'vulnerability': 'Vulnerability',
                    'cwe': 'CWE',
                    'condition': 'Condition'
                }[field] || field;
                badgeElement.appendChild(fieldSpan);

                const valueSpan = document.createElement('span');
                const valueEditElement = document.createElement('input');
                valueEditElement.value = value;
                valueSpan.appendChild(valueEditElement);
                badgeElement.appendChild(valueSpan);

                valueEditElement.addEventListener('blur', () => {
                    const newValue = valueEditElement.value;
                    assessmentEditorData[field] = assessmentEditorData[field].map((v) => v === value ? newValue : v);
                    assessmentEditorData[field] = assessmentEditorData[field].filter((v) => v);
                    updateAssessmentEditorModalVisuals();
                });

                const span = document.createElement('span');
                document.body.appendChild(span);
                const computedStyle = getComputedStyle(valueEditElement);
                span.style.fontSize = computedStyle.fontSize;
                span.style.fontFamily = computedStyle.fontFamily;
                span.style.fontWeight = computedStyle.fontWeight;
                span.style.fontStyle = computedStyle.fontStyle;
                span.style.letterSpacing = computedStyle.letterSpacing;
                span.style.whiteSpace = 'pre';
                span.textContent = valueEditElement.value;
                const textWidth = span.getBoundingClientRect().width;
                document.body.removeChild(span);
                valueEditElement.style.width = `${textWidth + 6}px`;

                affectsCreatedElementsContainer.appendChild(badgeElement);
            });
        });
    }

    /* general data */
    assessmentEditorModalInputElements.scope.value = assessmentEditorData.scope;
    assessmentEditorModalInputElements.title.value = assessmentEditorData.title || '';
    assessmentEditorModalInputElements.reportedBy.value = assessmentEditorData.reportedBy || '';
    assessmentEditorModalInputElements.reportedDate.value = assessmentEditorData.reportedDate || '';
    assessmentEditorModalInputElements.acceptedBy.value = assessmentEditorData.acceptedBy || '';
    assessmentEditorModalInputElements.acceptedDate.value = assessmentEditorData.acceptedDate || '';

    assessmentEditorModalInputElements.assessmentCvssVector2P0All.value = assessmentEditorData.assessmentCvssVector2P0All || '';
    assessmentEditorModalInputElements.assessmentCvssVector2P0Lower.value = assessmentEditorData.assessmentCvssVector2P0Lower || '';
    assessmentEditorModalInputElements.assessmentCvssVector2P0Higher.value = assessmentEditorData.assessmentCvssVector2P0Higher || '';
    assessmentEditorModalInputElements.assessmentCvssVector3P1All.value = assessmentEditorData.assessmentCvssVector3P1All || '';
    assessmentEditorModalInputElements.assessmentCvssVector3P1Lower.value = assessmentEditorData.assessmentCvssVector3P1Lower || '';
    assessmentEditorModalInputElements.assessmentCvssVector3P1Higher.value = assessmentEditorData.assessmentCvssVector3P1Higher || '';
    assessmentEditorModalInputElements.assessmentCvssVector4P0All.value = assessmentEditorData.assessmentCvssVector4P0All || '';
    assessmentEditorModalInputElements.assessmentCvssVector4P0Lower.value = assessmentEditorData.assessmentCvssVector4P0Lower || '';
    assessmentEditorModalInputElements.assessmentCvssVector4P0Higher.value = assessmentEditorData.assessmentCvssVector4P0Higher || '';

    /* assessment */
    const assessmentsContainer = document.getElementById('assessment-editor-assessment-add-button-container');
    assessmentsContainer.innerHTML = '';
    assessmentEditorData.assessments = assessmentEditorData.assessments || [];
    assessmentEditorData.assessments.forEach((assessment, index) => {
        if (!assessment.assessmentStatus) {
            console.warn('Assessment status not set for assessment, using "none":', assessment);
            assessment.assessmentStatus = 'none';
        }
        const assessmentElement = document.createElement('span');
        assessmentElement.classList.add('assessment-editor-assessment-existing-entry', 'btn', 'btn-primary', 'btn-sm');
        assessmentElement.classList.add(`status-${assessment.assessmentStatus.replaceAll(/ +/g, '-')}`);
        assessmentElement.innerText = assessment.assessmentStatus + (assessment.assessmentDate ? ` (${assessment.assessmentDate})` : '');
        assessmentElement.addEventListener('click', () => {
            if (assessmentEditorData.selectedAssessmentIndex === index) {
                assessmentEditorData.selectedAssessmentIndex = -1;
            } else {
                assessmentEditorData.selectedAssessmentIndex = index;
            }
            updateAssessmentEditorModalVisuals();
        });
        if (index === assessmentEditorData.selectedAssessmentIndex) {
            assessmentElement.style.fontWeight = 'bold';
        }
        assessmentsContainer.appendChild(assessmentElement);
    });

    const selectedAssessment = assessmentEditorData.assessments[assessmentEditorData.selectedAssessmentIndex];
    if (selectedAssessment) {
        assessmentEditorModalInputElements.assessmentStatus.value = selectedAssessment.assessmentStatus;
        assessmentEditorModalInputElements.assessmentRationale.value = selectedAssessment.assessmentRationale || '';
        assessmentEditorModalInputElements.assessmentRisk.value = selectedAssessment.assessmentRisk || '';
        assessmentEditorModalInputElements.assessmentMeasures.value = selectedAssessment.assessmentMeasures || '';
        assessmentEditorModalInputElements.assessmentScore.value = selectedAssessment.assessmentScore || '';
        assessmentEditorModalInputElements.assessmentAuthor.value = selectedAssessment.assessmentAuthor || '';
        assessmentEditorModalInputElements.assessmentDate.value = selectedAssessment.assessmentDate || '';
        assessmentEditorModalInputElements.assessmentLabelsInclude.value = (selectedAssessment.assessmentLabelsInclude || []).join(', ');
        assessmentEditorModalInputElements.assessmentLabelsExclude.value = (selectedAssessment.assessmentLabelsExclude || []).join(', ');

        document.getElementById('assessment-editor-assessment-add-elements-container').classList.remove('hidden');
    } else {
        document.getElementById('assessment-editor-assessment-add-elements-container').classList.add('hidden');
    }

    const outputElement = document.getElementById('assessment-editor-yaml-output');
    outputElement.value = generateAssessmentYaml(assessmentEditorData);
    outputElement.rows = outputElement.value.split('\n').length;
}

/*
affects:
  cve:
    - CVE-2021-44228
    - CVE-2021-45046
    - CVE-2022-2330?
  cpe:
    - cpe:/a:apache:log4j
  cwe:
    - CWE-502
scope: artifact
title: Log4j Vulnerabilities
reported:
  by: Author
  date: 2022-01-04 15:30:00
accepted:
  by: Author
  date: 2022-01-10
cvssV3:
  all: CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
history:
  - status: not applicable
    rationale: This vulnerability is not applicable to our application.
    risk: Poses no risk.
    score: 0
    author: Author
    date: 2022-01-12
    labels:
      excludes:
        - feature-2
        - feature-1
 */
function generateAssessmentYaml(data) {
    function validateDate(dateTime) {
        if (!dateTime) return false;
        return /^\d{4,}-\d{2}-\d{2}( \d{2}:\d{2}:\d{2})?$/.test(dateTime);
    }

    function yamlMultilineString(key, value, indent = 2) {
        const indentSpaces = ' '.repeat(indent * 2);
        const nestedIndentSpaces = ' '.repeat((indent + 1) * 2);

        if (typeof value === 'string' && value.includes('\n')) {
            return `${indentSpaces}${key}: |-\n${nestedIndentSpaces}${value.split('\n').join(`\n${nestedIndentSpaces}`)}`;
        } else {
            return `${indentSpaces}${key}: "${value}"`;
        }
    }

    const yamlLines = [];

    const scope = data.scope || 'artifact';

    if (scope !== 'inventory') {
        yamlLines.push('affects:');
        let affectsData = false;
        ['cpe', 'vulnerability', 'cwe', 'condition'].forEach((field) => {
            if (data[field] && data[field].some((value) => value)) {
                const fieldTitle = {
                    'cpe': 'cpe',
                    'vulnerability': 'cve',
                    'cwe': 'cwe',
                    'condition': 'condition'
                }[field] || field;
                yamlLines.push(`  ${fieldTitle}:`);
                data[field].forEach((value) => {
                    if (value) {
                        affectsData = true;
                        yamlLines.push(`    - \"${value}\"`);
                    }
                });
            }
        });
        if (!affectsData) return 'Either one "affects" field must be filled out, or the scope must be set to "inventory".';
    }

    if (scope !== 'artifact') {
        yamlLines.push(`scope: ${scope}`);
    }

    if (data.title) yamlLines.push(`title: \"${data.title}\"`);
    if (data.reportedBy || data.reportedDate) {
        yamlLines.push('reported:');
        if (data.reportedBy) yamlLines.push(`  by: \"${data.reportedBy}\"`);
        if (data.reportedDate) {
            if (!validateDate(data.reportedDate)) return 'Invalid reported date format (YYYY-MM-DD HH:MM:SS): ' + data.reportedDate;
            yamlLines.push(`  date: ${data.reportedDate}`);
        }
    }
    if (data.acceptedBy || data.acceptedDate) {
        yamlLines.push('accepted:');
        if (data.acceptedBy) yamlLines.push(`  by: \"${data.acceptedBy}\"`);
        if (data.acceptedDate) {
            if (!validateDate(data.acceptedDate)) return 'Invalid accepted date format (YYYY-MM-DD HH:MM:SS): ' + data.acceptedDate;
            yamlLines.push(`  date: \"${data.acceptedDate}\"`);
        }
    }

    const anyCvss2P0 = data.assessmentCvssVector2P0All || data.assessmentCvssVector2P0Lower || data.assessmentCvssVector2P0Higher;
    const anyCvss3P0 = data.assessmentCvssVector3P1All || data.assessmentCvssVector3P1Lower || data.assessmentCvssVector3P1Higher;
    const anyCvss4P0 = data.assessmentCvssVector4P0All || data.assessmentCvssVector4P0Lower || data.assessmentCvssVector4P0Higher;

    if (anyCvss2P0) {
        yamlLines.push('cvssV2:');
        if (data.assessmentCvssVector2P0All) yamlLines.push(`  all: \"${data.assessmentCvssVector2P0All}\"`);
        if (data.assessmentCvssVector2P0Lower) yamlLines.push(`  lower: \"${data.assessmentCvssVector2P0Lower}\"`);
        if (data.assessmentCvssVector2P0Higher) yamlLines.push(`  higher: \"${data.assessmentCvssVector2P0Higher}\"`);
    }
    if (anyCvss3P0) {
        yamlLines.push('cvssV3:');
        if (data.assessmentCvssVector3P1All) yamlLines.push(`  all: \"${data.assessmentCvssVector3P1All}\"`);
        if (data.assessmentCvssVector3P1Lower) yamlLines.push(`  lower: \"${data.assessmentCvssVector3P1Lower}\"`);
        if (data.assessmentCvssVector3P1Higher) yamlLines.push(`  higher: \"${data.assessmentCvssVector3P1Higher}\"`);
    }
    if (anyCvss4P0) {
        yamlLines.push('cvssV4:');
        if (data.assessmentCvssVector4P0All) yamlLines.push(`  all: \"${data.assessmentCvssVector4P0All}\"`);
        if (data.assessmentCvssVector4P0Lower) yamlLines.push(`  lower: \"${data.assessmentCvssVector4P0Lower}\"`);
        if (data.assessmentCvssVector4P0Higher) yamlLines.push(`  higher: \"${data.assessmentCvssVector4P0Higher}\"`);
    }

    if (data.assessments.length > 0) {
        yamlLines.push('history:');
        for (const assessment of data.assessments) {
            if (assessment.assessmentStatus === 'none') {
                yamlLines.push(`  - # no assessment status set`);
            } else {
                yamlLines.push(`  - status: "${assessment.assessmentStatus}"`);
            }
            if (assessment.assessmentRationale) yamlLines.push(yamlMultilineString('rationale', assessment.assessmentRationale));
            if (assessment.assessmentRisk) yamlLines.push(yamlMultilineString('risk', assessment.assessmentRisk));
            if (assessment.assessmentMeasures) yamlLines.push(yamlMultilineString('measures', assessment.assessmentMeasures));
            if (assessment.assessmentScore) {
                if (isNaN(assessment.assessmentScore)) return 'Invalid assessment score format (must be number): ' + assessment.assessmentScore;
                yamlLines.push(`    score: ${assessment.assessmentScore}`);
            }
            if (assessment.assessmentAuthor) yamlLines.push(`    author: "${assessment.assessmentAuthor}"`);
            if (assessment.assessmentDate) {
                if (!validateDate(assessment.assessmentDate)) return 'Invalid assessment date format (YYYY-MM-DD HH:MM:SS): ' + assessment.assessmentDate;
                yamlLines.push(`    date: "${assessment.assessmentDate}"`);
            }
            const hasIncludeLabels = assessment.assessmentLabelsInclude && assessment.assessmentLabelsInclude.length > 0;
            const hasExcludeLabels = assessment.assessmentLabelsExclude && assessment.assessmentLabelsExclude.length > 0;
            if (hasIncludeLabels || hasExcludeLabels) {
                yamlLines.push('    labels:');
                if (hasIncludeLabels) yamlLines.push(`      includes: [${assessment.assessmentLabelsInclude.map((v) => `"${v}"`).join(', ')}]`);
                if (hasExcludeLabels) yamlLines.push(`      excludes: [${assessment.assessmentLabelsExclude.map((v) => `"${v}"`).join(', ')}]`);
            }
        }
    }

    yamlLines.push('');

    return yamlLines.join('\n');
}

function clearAssessmentEditorModal() {
    assessmentEditorData = {
        scope: 'artifact',
        selectedAssessmentIndex: -1,
        assessments: [],
    };
    if (lastSheet) {
        assessmentEditorData.vulnerability = [lastSheet];
    } else {
        assessmentEditorData.vulnerability = ['CVE-2021-44228'];
    }

    ['cpe', 'vulnerability', 'cwe', 'condition'].forEach((field) => {
        document.getElementById(`assessment-editor-affects-${field}-input`).value = '';
    });

    document.getElementById('assessment-editor-affects-container').innerHTML = '';

    Object.keys(assessmentEditorModalInputElements).forEach((key) => {
        assessmentEditorModalInputElements[key].value = '';
    });

    updateAssessmentEditorModalVisuals();
}

setupAssessmentEditorModal();

/* END: ASSESSMENT EDITOR */
