/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternHelper {
    private static final Logger log = LoggerFactory.getLogger(PatternHelper.class);

    public static boolean anyMatch(List<Pattern> patterns, String value) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    public static List<Pattern> readPatternFile(File patternFile) {
        if (patternFile != null) {
            try {
                List lines = FileUtils.readLines((File)patternFile, (String)"UTF-8");
                return lines.stream().map(l -> Pattern.compile(l)).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.warn("Cannot read pattern file [{}].", (Object)patternFile.getAbsolutePath());
            }
        }
        return Collections.emptyList();
    }

    public static boolean isExcluded(String attribute, List<Pattern> includedAttributePatterns, List<Pattern> excludedAttributePatterns) {
        boolean excluded = PatternHelper.anyMatch(excludedAttributePatterns, attribute);
        if (excluded && PatternHelper.anyMatch(includedAttributePatterns, attribute)) {
            return false;
        }
        return excluded;
    }
}

