/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.cyclonedx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.lang3.ObjectUtils;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Property;

public class CycloneDxUtils {
    public static List<Component> getAllComponents(Bom bom) {
        ArrayList<Component> allComponents = new ArrayList<Component>();
        Stack<Component> componentStack = new Stack<Component>();
        List components = bom.getComponents();
        if (components == null) {
            return Collections.emptyList();
        }
        for (Component component : components) {
            componentStack.push(component);
        }
        while (!componentStack.isEmpty()) {
            Component currentComponent = (Component)componentStack.pop();
            allComponents.add(currentComponent);
            if (currentComponent.getComponents() == null) continue;
            for (Component childComponent : currentComponent.getComponents()) {
                componentStack.push(childComponent);
            }
        }
        return allComponents;
    }

    public static boolean isAsset(Component component) {
        Optional<Property> classProperty;
        List properties = component.getProperties();
        if (properties != null && (classProperty = component.getProperties().stream().filter(p -> p.getName().equals("com.metaeffekt.component.class")).findFirst()).isPresent()) {
            return classProperty.get().getValue().equals("asset");
        }
        String componentName = (String)ObjectUtils.firstNonNull((Object[])new String[]{component.getName(), ""});
        return componentName.startsWith("CID") || componentName.startsWith("AID");
    }
}

