/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.validation;

import com.metaeffekt.artifact.analysis.bom.spdx.facade.SpdxApiFacade;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.SpdxDocument;

public class ValidationResultGenerator {
    private static final Logger log = LoggerFactory.getLogger(ValidationResultGenerator.class);

    public static void generateCycloneDXValidationResults(List<File> bomFiles, String outputDirectory, File template) throws IOException {
        for (File bomFile : bomFiles) {
            HashMap<String, String> placeholderData = new HashMap<String, String>();
            ArrayList<String> validationResults = new ArrayList<String>();
            placeholderData.put("documentName", bomFile.getName());
            placeholderData.put("creationDate", Calendar.getInstance().getTime().toString());
            placeholderData.put("manualAdjustments", "No manual adjustments were made.");
            placeholderData.put("additionalRemarks", "No additional remarks.");
            placeholderData.put("specVersion", "1.6");
            if (FilenameUtils.getExtension((String)bomFile.getName()).equals("xml")) {
                validationResults.addAll(new XmlParser().validate(bomFile).stream().map(Throwable::getMessage).collect(Collectors.toList()));
            } else if (FilenameUtils.getExtension((String)bomFile.getName()).equals("json")) {
                validationResults.addAll(new JsonParser().validate(bomFile).stream().map(Throwable::getMessage).collect(Collectors.toList()));
            } else {
                log.error("Unsupported file type {}", (Object)bomFile.getName());
                validationResults.add("Unsupported file type " + bomFile.getName() + ". Can't provide validation results.");
            }
            ValidationResultGenerator.writeValidationResultsToFile(validationResults, outputDirectory, bomFile, placeholderData, template);
        }
    }

    public static void generateSpdxValidationResults(List<File> spdxDocumentFiles, String outputDirectory, File template) {
        for (File spdxDocumentFile : spdxDocumentFiles) {
            HashMap<String, String> placeholderData = new HashMap<String, String>();
            ArrayList<String> validationResults = new ArrayList<String>();
            placeholderData.put("documentName", spdxDocumentFile.getName());
            placeholderData.put("creationDate", Calendar.getInstance().getTime().toString());
            placeholderData.put("manualAdjustments", "No manual adjustments were made.");
            placeholderData.put("additionalRemarks", "No additional remarks.");
            SpdxDocument spdxDocument = SpdxApiFacade.generateFromFile(spdxDocumentFile);
            if (spdxDocument != null) {
                validationResults.addAll(spdxDocument.verify("2.3"));
                placeholderData.put("specVersion", "2.3");
            } else {
                placeholderData.put("specVersion", "Could not be automatically derived");
                placeholderData.put("validationResults", "Validation failed because the document is not a valid document as described by the spdx specification.");
            }
            ValidationResultGenerator.writeValidationResultsToFile(validationResults, outputDirectory, spdxDocumentFile, placeholderData, template);
        }
    }

    private static void writeValidationResultsToFile(List<String> validationResults, String outputDirectory, File documentFile, Map<String, String> placeholderData, File template) {
        File validationFile = new File(outputDirectory + FilenameUtils.removeExtension((String)documentFile.getName()) + ".validation.md");
        if (validationFile.exists()) {
            validationFile.delete();
        }
        if (validationResults.isEmpty() && !placeholderData.containsKey("validationResults")) {
            placeholderData.put("validationResults", "Document validation returned no errors or warnings.");
        } else if (!placeholderData.containsKey("validationResults")) {
            placeholderData.put("validationResults", ValidationResultGenerator.filteredValidationResults(validationResults));
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(template.toString()));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            String result = content.toString();
            for (Map.Entry<String, String> entry : placeholderData.entrySet()) {
                String placeholder = "{{" + entry.getKey() + "}}";
                result = result.replace(placeholder, entry.getValue());
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(validationFile.toString()));){
                writer.write(result);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String filteredValidationResults(List<String> validationResults) {
        return validationResults.stream().distinct().collect(Collectors.joining("\n"));
    }
}

