/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.MergedSegmentResult;
import com.metaeffekt.artifact.terms.model.Variables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedScanResult {
    private static final Logger LOG = LoggerFactory.getLogger(MergedScanResult.class);
    private List<MergedSegmentResult> mergedScanResult = new ArrayList<MergedSegmentResult>();

    public void setMergedScanResult(List<MergedSegmentResult> mergedScanResult) {
        this.mergedScanResult = mergedScanResult;
    }

    public List<MergedSegmentResult> getMergedScanResult() {
        return this.mergedScanResult;
    }

    public void mergeResults(Artifact artifact, File sourceDir) throws IOException {
        JSONArray result;
        JSONArray segments;
        if (sourceDir == null) {
            return;
        }
        File analysisDir = sourceDir.getParentFile();
        String sourceFolderName = sourceDir.getName();
        File targetFolder = new File(analysisDir, sourceFolderName + "-analysis");
        File metaScanResultJson = FileUtils.findSingleFile(targetFolder, "*_metascan.json");
        File scancodeResultJson = FileUtils.findSingleFile(targetFolder, "*_scancode.json");
        FileUtils.validateExists((File)analysisDir);
        if (metaScanResultJson == null || scancodeResultJson == null) {
            LOG.debug("No scan result found for artifact {}.", (Object)artifact.deriveQualifier());
            artifact.append("Errors", "Missing scan result", "|\n");
            return;
        }
        try {
            segments = new JSONObject(FileUtils.readFileToString((File)scancodeResultJson, (Charset)StandardCharsets.UTF_8)).optJSONArray("files");
        }
        catch (JSONException e) {
            LOG.error("Cannot parse json file: " + scancodeResultJson.getAbsolutePath());
            throw new IllegalStateException(e.getMessage(), e);
        }
        LOG.debug("Number of segments used for deriving notice parameter: [{}]", (Object)segments.length());
        try {
            result = new JSONArray(FileUtils.readFileToString((File)metaScanResultJson, (Charset)StandardCharsets.UTF_8));
        }
        catch (JSONException e) {
            LOG.error("Cannot parse json file: " + metaScanResultJson.getAbsolutePath());
            throw new IllegalStateException(e.getMessage(), e);
        }
        for (int i = 0; i < result.length(); ++i) {
            JSONObject file = result.optJSONObject(i);
            JSONObject segmentsMetascan = file.optJSONObject("segments");
            int segmentCount = file.optInt("segmentCount");
            for (int j = 0; j < segmentCount; ++j) {
                String segmentName = "segment-" + j;
                JSONObject segmentMetascan = segmentsMetascan.optJSONObject(segmentName);
                String filePath = file.optString("file");
                String scancodePath = sourceFolderName + "-intermediate/" + filePath + "/" + segmentName + ".txt";
                JSONObject segmentScancode = MergedScanResult.getSegmentFromScancode(segments, scancodePath);
                MergedSegmentResult mergedSegmentResult = new MergedSegmentResult();
                boolean add = false;
                if (segmentMetascan != null) {
                    mergedSegmentResult.setResolvedLicenses(this.extractFromMetascanResult(segmentMetascan.optJSONArray("resolvedLicenses")));
                    mergedSegmentResult.setNameMatches(this.extractFromMetascanResult(segmentMetascan.optJSONArray("nameMatches")));
                    mergedSegmentResult.setTextMatches(this.extractFromMetascanResult(segmentMetascan.optJSONArray("textMatches")));
                    mergedSegmentResult.setVariables(this.extractVariables(segmentMetascan.optJSONArray("variables")));
                    add = true;
                }
                if (segmentScancode != null) {
                    mergedSegmentResult.setCopyrights(this.extractCopyrights(segmentScancode));
                    mergedSegmentResult.setScancodeLicenses(this.extractScancodeLicenses(segmentScancode));
                    mergedSegmentResult.setScancodeLicenseKeys(this.extractScancodeLicenseKeys(segmentScancode));
                    mergedSegmentResult.setPath(scancodePath);
                    add = true;
                }
                if (!add) continue;
                this.mergedScanResult.add(mergedSegmentResult);
            }
        }
    }

    private static JSONObject getSegmentFromScancode(JSONArray segments, String path) throws IOException {
        for (int i = 0; i < segments.length(); ++i) {
            JSONObject segment = segments.optJSONObject(i);
            if (!segment.optString("path").equals(path)) continue;
            return segment;
        }
        return null;
    }

    private List<String> extractCopyrights(JSONObject segment) throws IOException {
        JSONArray copyrightsJson = segment.optJSONArray("copyrights");
        if (copyrightsJson != null) {
            ArrayList<String> copyrights = new ArrayList<String>();
            for (int i = 0; i < copyrightsJson.length(); ++i) {
                StringUtils.addNonEmptyString(copyrightsJson.getJSONObject(i).optString("copyright"), copyrights);
            }
            if (!copyrights.isEmpty()) {
                return copyrights;
            }
        }
        return Collections.emptyList();
    }

    private List<String> extractScancodeLicenses(JSONObject segmentScancode) throws IOException {
        ArrayList<String> licenses = new ArrayList<String>();
        JSONArray licenseJson = segmentScancode.optJSONArray("licenses");
        if (licenseJson != null) {
            for (int k = 0; k < licenseJson.length(); ++k) {
                StringUtils.addNonEmptyString(licenseJson.getJSONObject(k).optString("name"), licenses);
            }
            if (!licenses.isEmpty()) {
                return licenses;
            }
        }
        return Collections.emptyList();
    }

    private Map<String, Float> extractScancodeLicenseKeys(JSONObject segmentScancode) throws IOException {
        HashMap<String, Float> keyValues = new HashMap<String, Float>();
        JSONArray licenseJson = segmentScancode.optJSONArray("licenses");
        if (licenseJson != null) {
            for (int k = 0; k < licenseJson.length(); ++k) {
                String key = licenseJson.getJSONObject(k).getString("key");
                Float value = Float.valueOf(licenseJson.getJSONObject(k).getFloat("score"));
                if (!StringUtils.notEmpty(key) || !StringUtils.notEmpty(String.valueOf(value))) continue;
                keyValues.put(key, value);
            }
            if (!keyValues.isEmpty()) {
                return keyValues;
            }
        }
        return Collections.emptyMap();
    }

    private List<String> extractFromMetascanResult(JSONArray array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                list.add(array.optString(i));
            }
        }
        return list;
    }

    private List<Variables> extractVariables(JSONArray array) {
        ArrayList<Variables> list = new ArrayList<Variables>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject variable = array.optJSONObject(i);
                String license = variable.keySet().toArray()[0].toString();
                JSONObject values = variable.optJSONObject(license);
                Variables variableObj = new Variables();
                for (String s : values.keySet()) {
                    variableObj.putValues(s, values.optString(s));
                }
                variableObj.setLicense(license);
                list.add(variableObj);
            }
        }
        return list;
    }
}

