/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.preprocess.filter.range;

import com.metaeffekt.artifact.analysis.preprocess.filter.range.DiscreteRangeMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class IntegerDiscreteRangeMap<V>
implements DiscreteRangeMap<Integer, V> {
    private final NavigableMap<Integer, V> backingMap = new TreeMap<Integer, V>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putCombining(Integer rangeStart, Integer rangeEnd, V value, BiFunction<V, V, V> combiningFunction) {
        if (rangeEnd < rangeStart) {
            throw new IllegalArgumentException("Range end can't be smaller than range start.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null.");
        }
        NavigableMap<Integer, V> navigableMap = this.backingMap;
        synchronized (navigableMap) {
            Map.Entry<Integer, V> nextRangeStart;
            Map.Entry<Integer, V> precedingRangeStart = this.backingMap.floorEntry(rangeStart);
            if (precedingRangeStart != null && precedingRangeStart.getValue() != null) {
                value = combiningFunction.apply(precedingRangeStart.getValue(), value);
                rangeStart = precedingRangeStart.getKey();
                this.backingMap.remove(precedingRangeStart.getKey());
            }
            Integer checked = rangeStart;
            while ((nextRangeStart = this.backingMap.ceilingEntry(checked)) != null && nextRangeStart.getKey() <= rangeEnd) {
                this.backingMap.entrySet().remove(nextRangeStart);
                if (nextRangeStart.getValue() == null) continue;
                value = combiningFunction.apply(nextRangeStart.getValue(), value);
                Map.Entry<Integer, V> afterNext = this.backingMap.ceilingEntry(nextRangeStart.getKey());
                if (afterNext == null) continue;
                if (afterNext.getValue() == null) {
                    this.backingMap.entrySet().remove(afterNext);
                }
                rangeEnd = Math.max(rangeEnd, afterNext.getKey() - 1);
            }
            this.backingMap.put(rangeStart, value);
            if (rangeEnd != Integer.MAX_VALUE) {
                this.backingMap.putIfAbsent(rangeEnd + 1, null);
            }
            Map.Entry<Integer, V> checkHigher = this.backingMap.higherEntry(rangeStart);
            Map.Entry<Integer, V> checkLower = this.backingMap.floorEntry(rangeEnd);
            if (checkLower != null) {
                if (checkLower.getKey().intValue() != rangeStart.intValue()) {
                    throw new RuntimeException("Error during consistency check: got invalid value for lower.");
                }
                if (checkHigher != null) {
                    if (checkHigher.getKey() != rangeEnd + 1) {
                        throw new RuntimeException("Error during consistency check: got invalid values in range.");
                    }
                } else if (rangeEnd != Integer.MAX_VALUE) {
                    throw new RuntimeException("Error during consistency check: unexpected null entry for higher.");
                }
            } else {
                throw new RuntimeException("Error during consistency check: got null entry for checkLower.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Integer key) {
        NavigableMap<Integer, V> navigableMap = this.backingMap;
        synchronized (navigableMap) {
            Integer floorKey = this.backingMap.floorKey(key);
            return floorKey == null ? null : (V)this.backingMap.get(floorKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<Map.Entry<Integer, Integer>> getRangeSet() {
        TreeSet<Map.Entry<Integer, Integer>> ranges = new TreeSet<Map.Entry<Integer, Integer>>(Comparator.comparingInt(Map.Entry::getKey));
        NavigableMap<Integer, V> navigableMap = this.backingMap;
        synchronized (navigableMap) {
            for (Map.Entry markerEntry : this.backingMap.entrySet()) {
                if (markerEntry.getValue() == null) continue;
                Integer rangeEnd = this.backingMap.higherKey((Integer)markerEntry.getKey());
                rangeEnd = rangeEnd == null ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(rangeEnd - 1);
                ranges.add(new AbstractMap.SimpleImmutableEntry(markerEntry.getKey(), rangeEnd));
            }
        }
        return ranges;
    }

    private boolean doesNotIntersect(Integer toCheckMin, Integer toCheckMax, Integer rangeMin, Integer rangeMax) {
        return toCheckMin < rangeMin && toCheckMax < toCheckMin || rangeMax < toCheckMin && rangeMax < toCheckMax;
    }

    public SortedSet<Map.Entry<Integer, Integer>> subRangeSet(Integer min, Integer max) {
        ArrayList inclusiveRanges = new ArrayList(this.getRangeSet());
        TreeSet<Map.Entry<Integer, Integer>> subRanges = new TreeSet<Map.Entry<Integer, Integer>>(Comparator.comparingInt(Map.Entry::getKey));
        for (Map.Entry currentEntry : inclusiveRanges) {
            if (this.doesNotIntersect((Integer)currentEntry.getKey(), (Integer)currentEntry.getValue(), min, max)) continue;
            subRanges.add(new AbstractMap.SimpleEntry<Integer, Integer>(Math.max((Integer)currentEntry.getKey(), min), Math.min((Integer)currentEntry.getValue(), max)));
        }
        return subRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        NavigableMap<Integer, V> navigableMap = this.backingMap;
        synchronized (navigableMap) {
            this.backingMap.clear();
        }
    }
}

