/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.report;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.SvgCreator;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverityReport {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private int offset;
    private int totalRows;
    private final HashMap<String, String> columnIdentifiers = new HashMap();
    private final ArrayList<String> sortedColumnIdentifiers = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private static final HashMap<String, String> CELL_TEXT_TO_COLORS = new HashMap();
    private static final HashMap<String, String> COLOR_NAME_TO_HEX = new HashMap();
    private boolean asLabel = true;
    private boolean asOneFile = true;
    private String labelDirectory;
    private String allLabels = null;
    private static final String TD = "td";
    private static final String TH = "th";
    private ArrayList<String> labelGenerated = new ArrayList();
    public static final String CID = "cid";
    public static final String DISPLAY_TYPE = "displayType";
    public static final String DISPLAY_IMPACT = "displayImpact";
    public static final String STATUS = "status";
    public static final String FIRST_DETECTED = "firstDetected";
    public static final String OWNER = "owner";
    public static final String CLASSIFICATION = "classification";
    public static final String SEVERITY = "severity";
    public static final String ACTION = "action";
    public static final String DISPLAY_COMPONENT = "displayComponent";
    public static final String DISPLAY_CATEGORY = "displayCategory";
    public static final String DISPLAY_FILE = "displayFile";
    public static final String DISPLAY_FUNCTION = "displayFunction";
    public static final String CWE = "cwe";
    public static final String EXTERNAL_REFERENCE = "externalReference";
    public static final String FIX_TARGET = "fixTarget";
    public static final String LAST_TRIAGE_COMMENT = "lastTriageComment";
    public static final String LAST_TRIAGED = "lastTriaged";
    public static final String RULE_STRENGTH = "ruleStrength";
    public static final String CHECKER = "checker";
    public static final String DISPLAY_COMPARISON = "displayComparison";
    public static final String OCCURRENCE_COUNT = "occurrenceCount";
    public static final String FIRST_SNAPSHOT_ID = "firstSnapshotId";
    public static final String FIRST_SNAPSHOT_DATE = "firstSnapshotDate";
    public static final String FIRST_SNAPSHOT_DESCRIPTION = "firstSnapshotDescription";
    public static final String FIRST_SNAPSHOT_STREAM = "firstSnapshotStream";
    public static final String FIRST_SNAPSHOT_TARGET = "firstSnapshotTarget";
    public static final String FIRST_SNAPSHOT_VERSION = "firstSnapshotVersion";
    public static final String FUNCTION_MERGE_NAME = "functionMergeName";
    public static final String DISPLAY_ISSUE_KIND = "displayIssueKind";
    public static final String FILE_LANGUAGE = "fileLanguage";
    public static final String LAST_DETECTED_ID = "lastDetectedId";
    public static final String LAST_DETECTED = "lastDetected";
    public static final String LAST_DETECTED_DESCRIPTION = "lastDetectedDescription";
    public static final String LAST_DETECTED_STREAM = "lastDetectedStream";
    public static final String LAST_DETECTED_TARGET = "lastDetectedTarget";
    public static final String LAST_DETECTED_VERSION = "lastDetectedVersion";
    public static final String LAST_TRIAGED_USER = "lastTriagedUser";
    public static final String LEGACY = "legacy";
    public static final String LINE_NUMBER = "lineNumber";
    public static final String MERGE_EXTRA = "mergeExtra";
    public static final String MERGE_KEY = "mergeKey";
    public static final String OWNER_FULL_NAME = "ownerFullName";
    public static final String SCORE = "score";
    public static final String SA_10001 = "SA_10001";
    public static final String SA_10002 = "SA_10002";
    public static final String SA_10003 = "SA_10003";
    public static final String SA_10004 = "SA_10004";
    public static final String SA_10005 = "SA_10005";
    public static final String SA_10006 = "SA_10006";
    public static final String SA_10007 = "SA_10007";
    public static final String SA_10008 = "SA_10008";
    public static final String SA_10009 = "SA_10009";
    public static final String SA_10010 = "SA_10010";
    public static final String SA_10011 = "SA_10011";

    public CoverityReport(File file, File tempDir) throws IOException, JSONException {
        this.initializeColors();
        List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        this.parseData((String)lines.get(0));
        this.labelDirectory = new File(tempDir, "labels").toString();
    }

    private void parseData(String json) throws JSONException {
        int i;
        JSONObject mainObject = new JSONObject(json);
        JSONObject viewContentsV1 = mainObject.getJSONObject("viewContentsV1");
        this.offset = viewContentsV1.getInt("offset");
        this.totalRows = viewContentsV1.getInt("totalRows");
        JSONArray columns = viewContentsV1.getJSONArray("columns");
        JSONArray rows = viewContentsV1.getJSONArray("rows");
        for (i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.getJSONObject(i);
            this.columnIdentifiers.put(column.getString("name"), column.getString("label"));
            this.sortedColumnIdentifiers.add(column.getString("name"));
        }
        for (i = 0; i < rows.length(); ++i) {
            JSONObject row = rows.getJSONObject(i);
            Row addRow = new Row(row);
            addRow.setReport(this);
            this.rows.add(addRow);
        }
    }

    public Row getRowWithCID(int cid) {
        String c = "" + cid;
        for (Row row : this.rows) {
            if (!row.get(CID).equals(c)) continue;
            return row;
        }
        return null;
    }

    public String getLabelForIdentifier(String identifier) {
        return this.columnIdentifiers.getOrDefault(identifier, null);
    }

    public String getIdentifierForlabel(String label) {
        if (this.columnIdentifiers.containsValue(label)) {
            for (Map.Entry<String, String> entry : this.columnIdentifiers.entrySet()) {
                String i = entry.getKey();
                String l = entry.getValue();
                if (!l.equals(label)) continue;
                return i;
            }
        }
        return null;
    }

    public int[] getRowCIDs() {
        int[] cids = new int[this.rows.size()];
        for (int i = 0; i < this.rows.size(); ++i) {
            cids[i] = this.rows.get(i).getCid();
        }
        return cids;
    }

    public ArrayList<Row> getRows() {
        return this.rows;
    }

    public HashMap<String, String> getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void print() {
        this.LOG.info("General data:");
        this.LOG.info("offset = [{}]", (Object)this.offset);
        this.LOG.info("rows = [{}]", this.rows);
        this.LOG.info("\nPrinting all rows:");
        this.rows.forEach(Row::print);
    }

    public void generateHtmlReport(File outFile, File css, File tableSort, File upDownArrow, File replaceContents, File jsUpdateFile, File jsCreateFile) throws IOException {
        if (!this.asLabel && !new File(this.labelDirectory).exists()) {
            new File(this.labelDirectory).mkdirs();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<!DOCTYPE html>\n<html>\n<head>\n<title>Coverity Report</title>\n<style>\n" + this.loadFile(css.toString()) + "\n</style>\n</head>\n<body>\n<script>\n" + this.loadFile(tableSort.toString()) + "\n\n" + this.loadFile(replaceContents.toString()) + "\n</script>\n" + (this.allLabels != null ? "<div id=\"hiddenLabels\" style=\"display: none;\">" + this.allLabels + "</div>\n" : "") + "<h1>Coverity Report</h1>\nDisplaying <b>" + this.rows.size() + "</b> row" + (this.rows.size() == 1 ? "" : "s") + " and <b>" + this.sortedColumnIdentifiers.size() + "</b> column" + (this.sortedColumnIdentifiers.size() == 1 ? "" : "s") + ". Click on column header to sort alphabetically.\n");
        lines.add("<table class=\"table-sort\">\n");
        lines.add("<thead>\n<tr>");
        int sortedColumnIdentifiersSize = this.sortedColumnIdentifiers.size();
        for (int i = 0; i < sortedColumnIdentifiersSize; ++i) {
            String identifier = this.sortedColumnIdentifiers.get(i);
            int isFirstOrLast = 0;
            if (i == 0) {
                isFirstOrLast = 1;
            }
            if (i == sortedColumnIdentifiersSize - 1) {
                isFirstOrLast = 2;
            }
            if (this.asOneFile) {
                lines.add(this.createHTMLtableCell(this.getLabelForIdentifier(identifier) + " " + this.loadFile(upDownArrow.toString()), TH, isFirstOrLast, null, null));
                continue;
            }
            lines.add(this.createHTMLtableCell(this.getLabelForIdentifier(identifier) + " <img src=\"up-down-arrows.svg\" alt=\"Sort\" width=\"14\" height=\"14\">", TH, isFirstOrLast, null, null));
        }
        lines.add("</tr>\n</thead>\n<tbody>\n");
        for (Row row : this.rows) {
            lines.add("<tr>");
            for (String identifier : this.sortedColumnIdentifiers) {
                lines.add(this.createHTMLtableCell(row.get(identifier), TD, -1, row, identifier));
            }
            lines.add("</tr>");
        }
        lines.add("</tbody>\n</table>\n");
        lines.add(this.createSvgPieCharts(jsUpdateFile, jsCreateFile));
        lines.add("</body>\n</html>");
        FileUtils.writeLines((File)outFile, (String)"UTF-8", lines);
    }

    private void initializeColors() {
        if (CELL_TEXT_TO_COLORS.size() > 0 && COLOR_NAME_TO_HEX.size() > 0) {
            return;
        }
        CELL_TEXT_TO_COLORS.put("none", "gray");
        CELL_TEXT_TO_COLORS.put("other", "gray");
        CELL_TEXT_TO_COLORS.put("untargeted", "gray");
        CELL_TEXT_TO_COLORS.put("undecided", "gray");
        CELL_TEXT_TO_COLORS.put("unspecified", "gray");
        CELL_TEXT_TO_COLORS.put("unclassified", "gray");
        CELL_TEXT_TO_COLORS.put("unassigned", "gray");
        CELL_TEXT_TO_COLORS.put("medium", "orange");
        CELL_TEXT_TO_COLORS.put("moderate", "orange");
        CELL_TEXT_TO_COLORS.put("high", "red");
        CELL_TEXT_TO_COLORS.put("fix required", "red");
        CELL_TEXT_TO_COLORS.put("low", "yellow");
        CELL_TEXT_TO_COLORS.put("pending", "yellow");
        CELL_TEXT_TO_COLORS.put("new", "light_blue");
        CELL_TEXT_TO_COLORS.put("triaged", "green");
        CELL_TEXT_TO_COLORS.put("true", "green");
        CELL_TEXT_TO_COLORS.put("false", "blue");
        CELL_TEXT_TO_COLORS.put("c++", "yellow");
        CELL_TEXT_TO_COLORS.put("c", "orange");
        CELL_TEXT_TO_COLORS.put("java", "light_blue");
        CELL_TEXT_TO_COLORS.put("javascript", "blue");
        CELL_TEXT_TO_COLORS.put("php", "green");
        CELL_TEXT_TO_COLORS.put("python", "yellow");
        CELL_TEXT_TO_COLORS.put("ruby", "red");
        CELL_TEXT_TO_COLORS.put("various", "gray");
        CELL_TEXT_TO_COLORS.put("quality", "blue");
        CELL_TEXT_TO_COLORS.put("cat i", "red");
        CELL_TEXT_TO_COLORS.put("cat ii", "orange");
        CELL_TEXT_TO_COLORS.put("cat iii", "green");
        CELL_TEXT_TO_COLORS.put("m1", "orange");
        CELL_TEXT_TO_COLORS.put("m2", "orange");
        CELL_TEXT_TO_COLORS.put("m3", "orange");
        CELL_TEXT_TO_COLORS.put("m4", "orange");
        CELL_TEXT_TO_COLORS.put("m5", "orange");
        CELL_TEXT_TO_COLORS.put("m6", "orange");
        CELL_TEXT_TO_COLORS.put("m7", "orange");
        CELL_TEXT_TO_COLORS.put("m8", "orange");
        CELL_TEXT_TO_COLORS.put("m9", "orange");
        CELL_TEXT_TO_COLORS.put("m10", "orange");
        CELL_TEXT_TO_COLORS.put("a1", "orange");
        CELL_TEXT_TO_COLORS.put("a2", "orange");
        CELL_TEXT_TO_COLORS.put("a3", "orange");
        CELL_TEXT_TO_COLORS.put("a4", "orange");
        CELL_TEXT_TO_COLORS.put("a5", "orange");
        CELL_TEXT_TO_COLORS.put("a6", "orange");
        CELL_TEXT_TO_COLORS.put("a7", "orange");
        CELL_TEXT_TO_COLORS.put("a8", "orange");
        CELL_TEXT_TO_COLORS.put("a9", "orange");
        CELL_TEXT_TO_COLORS.put("a10", "orange");
        CELL_TEXT_TO_COLORS.put("absent", "orange");
        CELL_TEXT_TO_COLORS.put("admin", "green");
        if (!this.asLabel) {
            COLOR_NAME_TO_HEX.put("gray", "dbdbdb");
            COLOR_NAME_TO_HEX.put("orange", "ffbd24");
            COLOR_NAME_TO_HEX.put("red", "ff2e2e");
            COLOR_NAME_TO_HEX.put("yellow", "fffc63");
            COLOR_NAME_TO_HEX.put("light_blue", "d9fdff");
            COLOR_NAME_TO_HEX.put("green", "8affad");
            COLOR_NAME_TO_HEX.put("light_green", "AFE35B");
            COLOR_NAME_TO_HEX.put("dark_green", "5FB97F");
            COLOR_NAME_TO_HEX.put("blue", "8A9FFF");
        } else {
            COLOR_NAME_TO_HEX.put("gray", "535353");
            COLOR_NAME_TO_HEX.put("orange", "DC8F00");
            COLOR_NAME_TO_HEX.put("red", "E30A0A");
            COLOR_NAME_TO_HEX.put("yellow", "F5DE00");
            COLOR_NAME_TO_HEX.put("light_blue", "00ADB7");
            COLOR_NAME_TO_HEX.put("green", "00E650");
            COLOR_NAME_TO_HEX.put("light_green", "80CF00");
            COLOR_NAME_TO_HEX.put("dark_green", "00B840");
            COLOR_NAME_TO_HEX.put("blue", "0047F5");
        }
        if (this.asLabel && this.asOneFile) {
            for (String text : CELL_TEXT_TO_COLORS.keySet()) {
                this.allLabels = this.allLabels + this.generateTextLabel(text, this.getColorForText(text), new Color(0, 0, 0, 0), this.getColorForText(text), 2, 17);
            }
        }
    }

    private String getColorForText(String text) {
        if (CELL_TEXT_TO_COLORS.containsKey(text)) {
            return COLOR_NAME_TO_HEX.get(CELL_TEXT_TO_COLORS.get(text.toLowerCase()));
        }
        Random rand = new Random(text.hashCode());
        int red = rand.nextInt(255);
        int green = rand.nextInt(255);
        int blue = rand.nextInt(255);
        Color c = this.makeMoreSaturated(red, green, blue, 0.4);
        return String.format("%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    private Color makeMoreSaturated(int r, int g, int b, double factor) {
        if ((r = r < 127 ? (int)Math.max((double)r * (1.0 - factor), 0.0) : (int)Math.min((double)r * (1.0 + factor), 255.0)) + (g = g < 127 ? (int)Math.max((double)g * (1.0 - factor), 0.0) : (int)Math.min((double)g * (1.0 + factor), 255.0)) + (b = b < 127 ? (int)Math.max((double)b * (1.0 - factor), 0.0) : (int)Math.min((double)b * (1.0 + factor), 255.0)) > 600) {
            if (r < g && r < b) {
                r = (int)Math.max((double)r * (1.0 - factor), 0.0);
            } else if (g < r && g < b) {
                g = (int)Math.max((double)g * (1.0 - factor), 0.0);
            } else {
                b = (int)Math.max((double)b * (1.0 - factor), 0.0);
            }
        }
        return new Color(r, g, b);
    }

    private String createHTMLtableCell(String text, String elementType, int isFirstOrLast, Row row, String identifier) {
        if (CELL_TEXT_TO_COLORS.containsKey(text.toLowerCase())) {
            if (this.asLabel) {
                return "<" + elementType + this.getFirstOrLastClass(isFirstOrLast) + this.getCellIdClickEvent(row, identifier) + "><font style=\"font-size:0px\">" + text + "</font>" + this.generateTextLabel(text, this.getColorForText(text), new Color(0, 0, 0, 0), this.getColorForText(text), 2, 17) + "</" + elementType + ">";
            }
            return "<" + elementType + this.getFirstOrLastClass(isFirstOrLast) + this.getCellIdClickEvent(row, identifier) + " style=\"background-color:#" + this.getColorForText(text) + "\">" + text + "</" + elementType + ">";
        }
        return "<" + elementType + this.getFirstOrLastClass(isFirstOrLast) + this.getCellIdClickEvent(row, identifier) + ">" + text + "</" + elementType + ">";
    }

    private String getCellIdClickEvent(Row row, String identifier) {
        if (row == null) {
            return "";
        }
        return " id=\"" + row.getCid() + "_" + identifier + "\"";
    }

    private String getFirstOrLastClass(int isFirstOrLast) {
        if (isFirstOrLast <= 0) {
            return "";
        }
        if (isFirstOrLast == 1) {
            return " class=\"firstTitle\"";
        }
        if (isFirstOrLast == 2) {
            return " class=\"lastTitle\"";
        }
        return "";
    }

    private String generateTextLabel(String text, String textColor, Color backgroundColor, String borderColor, int borderSize, int size) {
        int offsetX = 10 + borderSize;
        int offsetY = borderSize;
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        Font font = new Font("Arial", 0, size);
        int textwidth = (int)font.getStringBounds(text, frc).getWidth();
        int textheight = (int)font.getStringBounds(text, frc).getHeight();
        if (this.labelGenerated.contains(text.toLowerCase())) {
            return "<svg width=\"" + (textwidth + offsetX * 2) + "\" height=\"" + (textheight + offsetY * 2) + "\"><use xlink:href=\"#textFrame" + text.toLowerCase() + "\"></use><use xlink:href=\"#text" + text.toLowerCase() + "\"></use></svg>";
        }
        SvgCreator svg = new SvgCreator();
        svg.setViewBox(0, 0, textwidth + offsetX * 2, textheight + offsetY * 2);
        if (this.asOneFile) {
            svg.setSvgParameters("height=\"" + (size + 4) + "px\"");
        }
        int random = CoverityReport.getRandomNumber(0, 0x7FFFFFF);
        svg.createFont("font" + random, size + "px Arial, sans-serif", textColor);
        svg.createRoundedRectangle("textFrame" + text.toLowerCase(), borderSize, borderSize, textwidth + offsetX * 2 - borderSize * 2, textheight + offsetY * 2 - borderSize * 2, (textheight + offsetY * 2) / 2, textheight + offsetY * 2);
        if (backgroundColor.getAlpha() == 0) {
            svg.setShapeFillOpacity("textFrame" + text.toLowerCase(), 0.0);
        } else {
            svg.setShapeFillColor("textFrame" + text.toLowerCase(), CoverityReport.toHex(backgroundColor));
        }
        svg.setShapeBorder("textFrame" + text.toLowerCase(), borderSize, borderColor);
        svg.createText("text" + text.toLowerCase(), (textwidth + offsetX * 2) / 2, (textheight + offsetY * 2) / 2, text, "font" + random);
        svg.setShapeParameter("text" + text.toLowerCase(), "text-anchor=middle", "alignment-baseline=central");
        if (!this.asOneFile) {
            try {
                svg.generate(new File(this.labelDirectory + text.toLowerCase() + ".svg"));
            }
            catch (IOException e) {
                this.LOG.error("Unable to write SVG file [" + this.labelDirectory + text.toLowerCase() + ".svg]", (Throwable)e);
            }
            if (new File(this.labelDirectory + text.toLowerCase() + ".svg").exists()) {
                return "<img height=\"" + (textheight + offsetY * 2) + "px\" width=\"" + (textwidth + offsetX * 2) + "px\" src=\"" + this.labelDirectory + text.toLowerCase() + ".svg\">";
            }
        }
        this.labelGenerated.add(text.toLowerCase());
        return CoverityReport.arrayListToString(svg.generateSVG());
    }

    private static String toHex(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    private static int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private static String arrayListToString(ArrayList<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String o : list) {
            if (list.size() != 0) {
                sb.append(o.toString());
                continue;
            }
            sb.append("\n").append(o.toString());
        }
        return sb.toString();
    }

    private String loadFile(String file) {
        try {
            List input = FileUtils.readLines((File)new File(file), (Charset)StandardCharsets.UTF_8);
            StringBuilder sb = new StringBuilder();
            boolean isComment = false;
            for (String s : input) {
                if (s.trim().startsWith("//")) {
                    if (!s.trim().equals("//CREATE CID ROWS")) continue;
                    s = this.getJsRowEntries();
                }
                if (s.trim().startsWith("/*")) {
                    isComment = true;
                }
                if (isComment) {
                    if (!s.trim().startsWith("*/") && !s.endsWith("*/")) continue;
                    isComment = false;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load file string from file [" + file + "]", e);
        }
    }

    private ArrayList<String> loadFileAsList(String file) {
        try {
            List input = FileUtils.readLines((File)new File(file), (Charset)StandardCharsets.UTF_8);
            return new ArrayList<String>(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load file from [" + file + "]", e);
        }
    }

    private String getJsRowEntries() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows.size(); ++i) {
            if (sb.length() > 0) {
                sb.append("\n").append("rows[").append(i).append("] = new Row(").append(this.rows.get(i).getJsObjectParameters()).append(");");
                continue;
            }
            sb.append("rows[").append(i).append("] = new Row(").append(this.rows.get(i).getJsObjectParameters()).append(");");
        }
        return sb.toString();
    }

    private String createSvgPieCharts(File jsUpdateFile, File jsCreateFile) {
        String ident;
        StringBuilder output = new StringBuilder();
        ArrayList<String> createChartsFor = new ArrayList<String>();
        createChartsFor.add(STATUS);
        createChartsFor.add(DISPLAY_IMPACT);
        createChartsFor.add(CWE);
        HashMap<String, String> identifiers = this.getColumnIdentifiers();
        output.append("<select id=\"pieChartSelector\" onchange=\"pieChartUpdate()\">\n");
        for (Map.Entry<String, String> identifier : identifiers.entrySet()) {
            ident = identifier.getKey();
            String name = identifier.getValue();
            output.append("<option value=\"").append(ident).append("\">").append(name).append("</option>\n");
        }
        output.append("</select>\n");
        output.append("<script>\n");
        output.append(this.loadFile(jsUpdateFile.toString()));
        output.append("</script>\n");
        for (Map.Entry<String, String> identifier : identifiers.entrySet()) {
            ident = identifier.getKey();
            output.append("<div id=\"").append(ident).append("\" style=\"display: none;\">").append("<br>");
            ArrayList<Double> rowValueCount = new ArrayList<Double>();
            ArrayList<String> rowValueText = new ArrayList<String>();
            ArrayList<String> rowValueColor = new ArrayList<String>();
            for (Row row : this.rows) {
                String value = row.get(ident).toLowerCase();
                if (rowValueText.contains(value)) {
                    int index = rowValueText.indexOf(value);
                    rowValueCount.set(index, (Double)rowValueCount.get(index) + 1.0);
                    continue;
                }
                rowValueText.add(value);
                rowValueCount.add(1.0);
                rowValueColor.add("#" + this.getColorForText(value));
            }
            output.append(this.makePieChartFromAbsoluteData(rowValueCount.toArray(new Double[0]), rowValueColor.toArray(new String[0]), rowValueText.toArray(new String[0]), 400, jsCreateFile));
            output.append("</div>");
        }
        output.append("<br><br><br><br><br><br><br><br><br>");
        return output.toString();
    }

    private String makePieChartFromAbsoluteData(Double[] data, String[] colors, String[] labels, int size, File jsCreateFile) {
        double total = Arrays.stream(data).mapToDouble(dat -> dat).sum();
        IntStream.range(0, data.length).forEach(i -> {
            data[i] = 100.0 / total * data[i];
        });
        return this.makePieChart(data, colors, labels, size, jsCreateFile);
    }

    private String makePieChart(Double[] data, String[] colors, String[] labels, int size, File jsCreateFile) {
        ArrayList<String> input = this.loadFileAsList(jsCreateFile.toString());
        int randomId = CoverityReport.getRandomNumber(0, 9999999);
        String[] makeUniqueID = new String[]{"#pie", "svgEl", "slices", "cumulativePercent"};
        for (int i = 0; i < input.size(); ++i) {
            for (String s : makeUniqueID) {
                if (!input.get(i).contains(s)) continue;
                input.set(i, input.get(i).replace(s, s + randomId));
            }
            if (!input.get(i).trim().equals("//CREATE PIE ELEMENTS")) continue;
            StringBuilder elements = new StringBuilder();
            int dataLength = data.length;
            for (int j = 0; j < dataLength; ++j) {
                double dat = data[j];
                String color = colors[j];
                String label = labels[j];
                elements.append("{ percent: ").append(dat / 100.0).append(", color: '").append(color).append("', hoverText: '").append(StringUtils.capitalize((String)label)).append("' },");
            }
            input.set(i, elements.toString());
        }
        StringBuilder returnValue = new StringBuilder();
        returnValue.append("<svg id=\"pie").append(randomId).append("\" viewBox=\"-1 -1 2 2\" width=\"").append(size).append("\" style=\"transform: rotate(-90deg)\"></svg>");
        for (String s : input) {
            returnValue.append("\n").append(s);
        }
        return returnValue.toString();
    }

    public static class Row {
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private final HashMap<String, String> entries = new HashMap();
        private CoverityReport report;
        private final int cid;

        public Row(JSONObject row) throws JSONException {
            JSONArray rowIdentifiers = row.names();
            for (int i = 0; i < rowIdentifiers.length(); ++i) {
                Object value = row.get(rowIdentifiers.getString(i));
                this.entries.put(rowIdentifiers.getString(i), value.toString());
            }
            this.cid = Integer.parseInt(this.entries.getOrDefault(CoverityReport.CID, "-1"));
        }

        public int getCid() {
            return this.cid;
        }

        public String get(String identifier) {
            return this.entries.getOrDefault(identifier, null);
        }

        public void setReport(CoverityReport report) {
            this.report = report;
        }

        public void print() {
            this.LOG.info("Row with cid: [{}]", (Object)this.entries.get(CoverityReport.CID));
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                String identifier = entry.getKey();
                String value = entry.getValue();
                this.LOG.info("\t[{}] = [{}]", (Object)identifier, (Object)value);
            }
        }

        public String getEntryAsString(String identifier) {
            String label = this.report.getLabelForIdentifier(identifier);
            String value = this.get(identifier);
            if (label == null || value == null) {
                return identifier + " not found";
            }
            return label + " = " + value;
        }

        public String getJsObjectParameters() {
            String value;
            String identifier;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.cid).append(", '");
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                identifier = entry.getKey();
                value = entry.getValue();
                stringBuilder.append(identifier).append(":").append(value.replace("'", "\\'")).append(",");
            }
            stringBuilder.append("', '");
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                identifier = entry.getKey();
                value = entry.getValue();
                stringBuilder.append(identifier).append(":").append(value.replace("'", "\\'").toUpperCase()).append(",");
            }
            stringBuilder.append("'");
            return stringBuilder.toString();
        }
    }
}

