/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

public class CountdownTimer {
    private long time;
    private long startTime = -1L;
    private int runningCount = 0;
    private boolean cancelled = false;

    public CountdownTimer(long time) {
        this.time = time;
    }

    public long getRemainingTime() {
        this.recalculateRemainingTime();
        return this.time;
    }

    private void recalculateRemainingTime() {
        if (this.isRunning()) {
            this.stop();
            this.start();
        }
    }

    public boolean isEndReached() {
        return this.getRemainingTime() <= 0L;
    }

    public boolean isRunning() {
        return this.startTime != -1L;
    }

    public synchronized void start() {
        if (this.isCancelled()) {
            return;
        }
        ++this.runningCount;
        if (this.isRunning() || this.isEndReached()) {
            return;
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        --this.runningCount;
        long now = System.currentTimeMillis();
        if (this.runningCount <= 0) {
            this.time -= now - this.startTime;
            this.startTime = -1L;
            this.runningCount = 0;
        } else {
            this.time -= now - this.startTime;
            this.startTime = now;
        }
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        this.runningCount = 0;
        this.stop();
    }
}

