/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.resource.InventoryResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySearch {
    private static final Logger LOG = LoggerFactory.getLogger(InventorySearch.class);
    private Inventory inventory;
    private Map<String, Set<Artifact>> checksumArtifactMap = new HashMap<String, Set<Artifact>>();
    private Map<String, Set<Artifact>> idArtifactMap = new HashMap<String, Set<Artifact>>();
    private Set<Artifact> artifactsWithWildcard = new HashSet<Artifact>();

    public InventorySearch(InventoryResource inventoryResource) {
        this(inventoryResource.getInventory());
    }

    public InventorySearch(Inventory inventory) {
        this.inventory = inventory == null ? new Inventory() : inventory;
        for (Artifact artifact : this.inventory.getArtifacts()) {
            this.contributeToMaps(artifact);
        }
    }

    private void contributeToMaps(Artifact artifact) {
        String checksum = InventorySearch.modulateChecksum(artifact);
        String id = InventorySearch.modulateId(artifact);
        this.checksumArtifactMap.computeIfAbsent(checksum, s -> new HashSet()).add(artifact);
        this.idArtifactMap.computeIfAbsent(id, s -> new HashSet()).add(artifact);
        if (id.contains("*") && StringUtils.isEmpty(checksum)) {
            this.artifactsWithWildcard.add(artifact);
        }
        if (StringUtils.hasText(artifact.getGroupId())) {
            String compositeId = artifact.getGroupId() + "." + artifact.getId();
            this.idArtifactMap.computeIfAbsent(compositeId, s -> new HashSet()).add(artifact);
        }
    }

    private static String modulateChecksum(Artifact artifact) {
        String checksum = artifact.getChecksum();
        if (!StringUtils.hasText(checksum)) {
            checksum = artifact.get("Checksum (MD5)");
        }
        if (!StringUtils.hasText(checksum)) {
            checksum = null;
        }
        return checksum;
    }

    public Artifact findArtifactByIdAndChecksum(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String id = InventorySearch.modulateId(artifact);
        String checksum = InventorySearch.modulateChecksum(artifact);
        if (id == null || checksum == null) {
            return null;
        }
        Set<Artifact> artifacts = this.checksumArtifactMap.get(checksum);
        Set<Artifact> artifactsById = this.idArtifactMap.get(id);
        if (artifacts != null && artifactsById != null) {
            HashSet<Artifact> commonSet = new HashSet<Artifact>(artifacts);
            commonSet.retainAll(artifactsById);
            if (!commonSet.isEmpty()) {
                if (commonSet.size() > 1) {
                    LOG.warn("More than one artifact matches id and checksum!");
                }
                return (Artifact)commonSet.iterator().next();
            }
        }
        return null;
    }

    private static String modulateId(Artifact artifact) {
        return artifact.getId();
    }

    public Artifact findArtifactById(Artifact artifact) {
        Iterator<Artifact> iterator;
        if (artifact == null) {
            return null;
        }
        String id = InventorySearch.modulateId(artifact);
        if (id == null) {
            return null;
        }
        Set<Artifact> artifacts = this.idArtifactMap.get(id);
        if (artifacts != null && (iterator = artifacts.iterator()).hasNext()) {
            Artifact candidate = iterator.next();
            return candidate;
        }
        return null;
    }

    public void close() {
        this.inventory = null;
    }

    public void add(Artifact artifact) {
        if (artifact == null) {
            return;
        }
        this.contributeToMaps(artifact);
        this.inventory.getArtifacts().add(artifact);
    }

    public Artifact findArtifactWildcardMatchingId(Artifact artifact) {
        int maximumMatchLength = -1;
        Artifact longestIdMatchCandidate = null;
        for (Artifact candidate : this.artifactsWithWildcard) {
            if (!this.matchesOnId(artifact.getId(), candidate, true)) continue;
            int idLength = candidate.getId().length();
            if (!candidate.getId().contains("*") || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)candidate.getChecksum()) || idLength <= maximumMatchLength) continue;
            longestIdMatchCandidate = candidate;
            maximumMatchLength = idLength;
        }
        return longestIdMatchCandidate;
    }

    private boolean matchesOnId(String id, Artifact candidate, boolean allowWildcards) {
        int index;
        String candidateId = candidate.getId();
        if (id == null && candidateId == null) {
            return true;
        }
        if (candidateId == null) {
            return false;
        }
        if (id != null && id.equals(candidateId)) {
            return true;
        }
        if (allowWildcards && "*".equals(candidate.getVersion()) && (index = candidateId.indexOf("*")) != -1) {
            String prefix = candidateId.substring(0, index);
            String suffix = candidateId.substring(index + 1);
            if (id.startsWith(prefix) && id.endsWith(suffix)) {
                return true;
            }
        }
        return false;
    }

    public List<Artifact> getArtifacts() {
        return Collections.unmodifiableList(this.inventory.getArtifacts());
    }

    public Set<Artifact> findAllWithId(String id) {
        Set<Artifact> artifacts = this.idArtifactMap.get(id);
        if (artifacts == null) {
            return Collections.emptySet();
        }
        return artifacts;
    }
}

