/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventorySearch;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.TermsMetaDataResolver;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import com.metaeffekt.resource.InventoryResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Constants;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventorySerializationContext;
import org.metaeffekt.core.inventory.processor.model.LicenseData;
import org.metaeffekt.core.inventory.processor.model.LicenseMetaData;
import org.metaeffekt.core.inventory.processor.report.InventoryReport;
import org.metaeffekt.core.inventory.processor.report.ReportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryUtils
extends org.metaeffekt.core.inventory.InventoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryUtils.class);
    public static final String INVENTORY_KEY_LICENSE_DIFF = "License / Derived Src/Bin License Diff";
    public static final String INVENTORY_KEY_LICENSE_DIFF_SRC_BIN = "Src/Bin Derived Licenses Diff";
    public static NormalizationMetaData NORMALIZATION_META_DATA;
    private static final Set<String> filterFullList;
    static final HashSet<String> INTERNAL_COLUMNS;

    public static void initialize(NormalizationMetaData normalizationMetaData) {
        NORMALIZATION_META_DATA = normalizationMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NormalizationMetaData getNormalizationMetaData() {
        if (NORMALIZATION_META_DATA != null) return NORMALIZATION_META_DATA;
        Class<InventoryUtils> clazz = InventoryUtils.class;
        synchronized (InventoryUtils.class) {
            LOG.warn("Implicitly discovering TermsMetaData. Please consider explicitly initializing.");
            NORMALIZATION_META_DATA = TermsMetaDataResolver.get();
            // ** MonitorExit[var0] (shouldn't be in output)
            return NORMALIZATION_META_DATA;
        }
    }

    public static void diffDerivedLicenses(Inventory inventory) {
        if (inventory == null) {
            return;
        }
        for (Artifact artifact : inventory.getArtifacts()) {
            String referenceLicense = artifact.getLicense();
            if (StringUtils.isEmpty(referenceLicense)) {
                referenceLicense = artifact.getLicense();
            }
            String derivedLicenses = artifact.get("Binary Artifact - Derived Licenses");
            String sourceDerivedLicenses = artifact.get("Source Artifact - Derived Licenses");
            if (!StringUtils.isEmpty(sourceDerivedLicenses)) {
                derivedLicenses = StringUtils.isEmpty(derivedLicenses) ? sourceDerivedLicenses : derivedLicenses + ", " + sourceDerivedLicenses;
            }
            String licenseDiff = InventoryUtils.diffLicenses(derivedLicenses, referenceLicense, true);
            artifact.set(INVENTORY_KEY_LICENSE_DIFF, licenseDiff);
        }
    }

    public static String diffLicenses(String lhsLicense, String rhsLicense, boolean commaSeparatorOnly) {
        lhsLicense = InventoryUtils.normalizeLicenseOrderAndName(lhsLicense, true, commaSeparatorOnly);
        rhsLicense = InventoryUtils.normalizeLicenseOrderAndName(rhsLicense, true, commaSeparatorOnly);
        List licenseTokens = InventoryUtils.tokenizeLicense((String)lhsLicense, (boolean)true, (boolean)commaSeparatorOnly);
        if (licenseTokens.isEmpty()) {
            return "";
        }
        List derivedLicenseTokens = InventoryUtils.tokenizeLicense((String)rhsLicense, (boolean)true, (boolean)commaSeparatorOnly);
        ArrayList<String> addedTokens = new ArrayList<String>();
        ArrayList<String> removedTokens = new ArrayList<String>();
        for (String s : licenseTokens) {
            if (derivedLicenseTokens.contains(s)) continue;
            removedTokens.add(s + " (r)");
        }
        for (String s : derivedLicenseTokens) {
            if (licenseTokens.contains(s)) continue;
            addedTokens.add(s + " (a)");
        }
        ArrayList<String> diffTokens = new ArrayList<String>();
        diffTokens.addAll(removedTokens);
        diffTokens.addAll(addedTokens);
        return String.join((CharSequence)", ", diffTokens);
    }

    public static String normalizeLicenseOrderAndName(String license, boolean reorder, boolean commaSeparatorOnly) {
        if (license == null) {
            return "";
        }
        List licenses = InventoryUtils.tokenizeLicense((String)license, (boolean)reorder, (boolean)commaSeparatorOnly);
        return InventoryUtils.joinLicenses(licenses);
    }

    public static void createReportFiles(Inventory inventory, File workDir, String inventoryId, File referenceInventoryDir) {
        InventoryReport report = new InventoryReport();
        report.setReportContext(new ReportContext(inventoryId, null, inventoryId));
        report.setFailOnUnknown(false);
        report.setFailOnUnknownVersion(false);
        report.setInventory(inventory);
        report.setReferenceInventoryDir(referenceInventoryDir);
        report.setReferenceInventoryIncludes("**/*-inventory.xls");
        report.setReferenceComponentPath(new File(referenceInventoryDir, "components").getAbsolutePath());
        report.setReferenceLicensePath(new File(referenceInventoryDir, "licenses").getAbsolutePath());
        FileUtils.forceMkDirQuietly(workDir);
        report.setFailOnBanned(false);
        report.setFailOnDevelopment(false);
        report.setFailOnDowngrade(false);
        report.setFailOnError(false);
        report.setFailOnInternal(false);
        report.setFailOnMissingLicense(false);
        report.setFailOnMissingLicenseFile(false);
        report.setFailOnMissingNotice(false);
        report.setTargetReportDir(workDir);
        try {
            report.createReport();
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static String joinLicenses(Collection<String> licenses) {
        return licenses.stream().sorted(String::compareToIgnoreCase).collect(Collectors.joining(", "));
    }

    public static String joinOredLicenses(Collection<String> licenses) {
        return licenses.stream().sorted(String::compareToIgnoreCase).collect(Collectors.joining(" + "));
    }

    public static void normalize(List<String> licenses) {
        Collections.sort(licenses, String.CASE_INSENSITIVE_ORDER);
    }

    public static void removeMarkers(Collection<String> licenseList, NormalizationMetaData normalizationMetaData) {
        for (String license : new ArrayList<String>(licenseList)) {
            TermsMetaData termsMetaData = normalizationMetaData.findTermsMetaData(license);
            if (termsMetaData == null || !termsMetaData.isMarker()) continue;
            licenseList.remove(license);
        }
    }

    public static List<String> extractMarkers(Collection<String> licenseList, NormalizationMetaData normalizationMetaData) {
        ArrayList<String> markers = new ArrayList<String>();
        for (String license : new ArrayList<String>(licenseList)) {
            TermsMetaData termsMetaData = normalizationMetaData.findTermsMetaData(license);
            if (termsMetaData == null || !termsMetaData.isMarker()) continue;
            markers.add(license);
        }
        return markers;
    }

    public static void removeUnspecific(Collection<String> licenseList, NormalizationMetaData normalizationMetaData) {
        ArrayList<String> del = new ArrayList<String>();
        for (String license : licenseList) {
            TermsMetaData lmd = normalizationMetaData.getTermsMetaData(license);
            if (lmd == null || !lmd.isUnspecific()) continue;
            del.add(license);
        }
        licenseList.removeAll(del);
    }

    public static Set<String> collectCoveredRemovableLicenses(Set<String> derivedLicenses) {
        HashSet<String> removableLicenses = new HashSet<String>();
        for (String l : derivedLicenses) {
            if (l.endsWith(" (undefined)")) {
                String lm = l.substring(0, l.indexOf(" (undefined)"));
                for (String r : derivedLicenses) {
                    if (r.equalsIgnoreCase(l) || !r.startsWith(lm)) continue;
                    removableLicenses.add(l);
                }
                continue;
            }
            if (l.equalsIgnoreCase("BSD alike")) {
                for (String r : derivedLicenses) {
                    if (r.equalsIgnoreCase(l) || !r.startsWith("BSD ") || !r.endsWith("-Clause License")) continue;
                    removableLicenses.add(l);
                }
                continue;
            }
            if (!l.equalsIgnoreCase("MIT alike")) continue;
            for (String r : derivedLicenses) {
                if (r.equalsIgnoreCase(l) || !r.equals("MIT License")) continue;
                removableLicenses.add(l);
            }
        }
        return removableLicenses;
    }

    @Deprecated
    public static void diffBinaryAndSourceDerivedLicenses(Inventory inventory) {
        for (Artifact a : inventory.getArtifacts()) {
            String derivedLicenseSource = a.get("Source Artifact - Derived Licenses");
            String derivedLicenseBinary = a.get("Binary Artifact - Derived Licenses");
            derivedLicenseSource = derivedLicenseSource == null ? "" : derivedLicenseSource.trim();
            String string = derivedLicenseBinary = derivedLicenseBinary == null ? "" : derivedLicenseBinary.trim();
            if (derivedLicenseSource.equalsIgnoreCase(derivedLicenseBinary)) {
                a.set(INVENTORY_KEY_LICENSE_DIFF_SRC_BIN, "-");
                continue;
            }
            List tokenizedDerivedBinary = InventoryUtils.tokenizeLicense((String)derivedLicenseBinary, (boolean)true, (boolean)true);
            List tokenizedDerivedSource = InventoryUtils.tokenizeLicense((String)derivedLicenseSource, (boolean)true, (boolean)true);
            ArrayList tmp = new ArrayList(tokenizedDerivedBinary);
            tokenizedDerivedBinary.removeAll(tokenizedDerivedSource);
            tokenizedDerivedSource.removeAll(tmp);
            List filteredMappedDerivedSource = tokenizedDerivedSource.stream().map(s -> "src: " + s).collect(Collectors.toList());
            List filteredMappedDerivedBinary = tokenizedDerivedBinary.stream().map(s -> "bin: " + s).collect(Collectors.toList());
            ArrayList diff = new ArrayList(filteredMappedDerivedSource);
            diff.addAll(filteredMappedDerivedBinary);
            Collections.sort(diff);
            a.set(INVENTORY_KEY_LICENSE_DIFF_SRC_BIN, String.join((CharSequence)"\n", diff));
        }
    }

    public static String deriveEffectiveLicenses(String license) {
        if (StringUtils.isEmpty(license)) {
            return "";
        }
        String effectiveLicense = license.replace(",", "|").replace("| ", "|");
        ArrayList<String> licenses = new ArrayList<String>(Arrays.asList(effectiveLicense.split("\\|")));
        return InventoryUtils.deriveEffectiveLicenses(licenses);
    }

    public static String deriveEffectiveLicenses(Collection<String> associatedLicenses) {
        ArrayList<String> licenses = new ArrayList<String>(associatedLicenses);
        licenses.remove("Licensing Option");
        String gplUndefined = "GNU General Public License (undefined)";
        String gpl3OrLater = "GNU General Public License 3.0 (or any later version)";
        String gpl2OrLater = "GNU General Public License 2.0 (or any later version)";
        String gpl1OrLater = "GNU General Public License 1.0 (or any later version)";
        String gpl3 = "GNU General Public License 3.0";
        String gpl2 = "GNU General Public License 2.0";
        String gpl1 = "GNU General Public License 1.0";
        String lgplUndefined = "GNU Lesser General Public License (undefined)";
        String lgpl3OrLater = "GNU Lesser General Public License 3.0 (or any later version)";
        String lgpl21OrLater = "GNU Lesser General Public License 2.1 (or any later version)";
        String lgpl2OrLater = "GNU Library General Public License 2.0 (or any later version)";
        String lgpl2 = "GNU Library General Public License 2.0";
        String lgpl3 = "GNU Lesser General Public License 3.0";
        String lgpl21 = "GNU Lesser General Public License 2.1";
        if (licenses.contains(gplUndefined)) {
            if (licenses.contains(gpl3) || licenses.contains(gpl3OrLater)) {
                InventoryUtils.replace(licenses, gplUndefined, gpl3);
            } else if (licenses.contains(lgpl2) || licenses.contains(lgpl2OrLater)) {
                InventoryUtils.replace(licenses, gplUndefined, gpl2);
            } else if (licenses.contains(gpl2) || licenses.contains(gpl2OrLater)) {
                InventoryUtils.replace(licenses, gplUndefined, gpl2);
            } else if (licenses.contains(lgpl21) || licenses.contains(lgpl21OrLater)) {
                InventoryUtils.replace(licenses, gplUndefined, gpl2);
            } else if (licenses.contains(lgpl3) || licenses.contains(lgpl3OrLater)) {
                InventoryUtils.replace(licenses, gplUndefined, gpl3);
            }
            InventoryUtils.replace(licenses, gplUndefined, gpl3);
        }
        if (licenses.contains(gpl3OrLater) || licenses.contains(gpl3)) {
            licenses.remove(gpl2OrLater);
            licenses.remove(gpl1OrLater);
            InventoryUtils.replace(licenses, gpl3OrLater, gpl3);
        }
        if (licenses.contains(gpl2OrLater) || licenses.contains(gpl2)) {
            licenses.remove(gpl1OrLater);
            InventoryUtils.replace(licenses, gpl2OrLater, gpl2);
        }
        if (licenses.contains(gpl1OrLater)) {
            InventoryUtils.replace(licenses, gpl1OrLater, gpl1);
        }
        if (licenses.contains(lgplUndefined)) {
            if (licenses.contains(lgpl21) || licenses.contains(lgpl21OrLater)) {
                if (licenses.contains(lgpl21)) {
                    InventoryUtils.replace(licenses, lgplUndefined, lgpl21);
                } else {
                    InventoryUtils.replace(licenses, lgplUndefined, lgpl21OrLater);
                }
            } else if (licenses.contains(gpl3)) {
                InventoryUtils.replace(licenses, lgplUndefined, lgpl3);
            } else if (licenses.contains(gpl2)) {
                InventoryUtils.replace(licenses, lgplUndefined, lgpl21);
            } else {
                InventoryUtils.replace(licenses, lgplUndefined, lgpl3);
            }
        }
        if (licenses.contains(lgpl3OrLater) || licenses.contains(lgpl3)) {
            licenses.remove(lgpl21OrLater);
            licenses.remove(lgpl2OrLater);
            InventoryUtils.replace(licenses, lgpl3OrLater, lgpl3);
        }
        if (licenses.contains(lgpl21OrLater) && licenses.contains(gpl3)) {
            licenses.remove(lgpl2OrLater);
            InventoryUtils.replace(licenses, lgpl21OrLater, lgpl3);
        }
        if (licenses.contains(lgpl21OrLater) && licenses.contains(gpl2)) {
            licenses.remove(lgpl2OrLater);
            InventoryUtils.replace(licenses, lgpl21OrLater, lgpl21);
        }
        if (licenses.contains(lgpl21OrLater) || licenses.contains(lgpl21)) {
            licenses.remove(lgpl2OrLater);
            InventoryUtils.replace(licenses, lgpl21OrLater, lgpl21);
        }
        if (licenses.contains(lgpl2OrLater) && licenses.contains(gpl3)) {
            InventoryUtils.replace(licenses, lgpl2OrLater, lgpl3);
        }
        if (licenses.contains(lgpl2OrLater) && licenses.contains(gpl2)) {
            InventoryUtils.replace(licenses, lgpl2OrLater, lgpl21);
        }
        if (licenses.contains(lgpl2OrLater)) {
            InventoryUtils.replace(licenses, lgpl2OrLater, lgpl21);
        }
        String gfdlUndefined = "GNU Free Documentation License (undefined)";
        String gfdl13OrLater = "GNU Free Documentation License 1.3 (or any later version)";
        String gfdl12OrLater = "GNU Free Documentation License 1.2 (or any later version)";
        String gfdl11OrLater = "GNU Free Documentation License 1.1 (or any later version)";
        String gfdl13 = "GNU Free Documentation License 1.3";
        String gfdl12 = "GNU Free Documentation License 1.2";
        String gfdl11 = "GNU Free Documentation License 1.1";
        if (licenses.contains(gfdlUndefined)) {
            InventoryUtils.replace(licenses, gfdlUndefined, gfdl13);
        }
        if (licenses.contains(gfdl13OrLater) || licenses.contains(gfdl13)) {
            licenses.remove(gfdl12OrLater);
            licenses.remove(gfdl11OrLater);
            InventoryUtils.replace(licenses, gfdl13OrLater, gfdl13);
        }
        if (licenses.contains(gfdl12OrLater) || licenses.contains(gfdl12)) {
            licenses.remove(gfdl12OrLater);
            InventoryUtils.replace(licenses, gfdl12OrLater, gfdl12);
        }
        if (licenses.contains(gfdl11OrLater)) {
            InventoryUtils.replace(licenses, gfdl11OrLater, gfdl11);
        }
        String lpplUndefined = "LaTeX Project Public License (undefined)";
        String lppl12OrLater = "LaTeX Project Public License 1.2 (or any later version)";
        String lppl11OrLater = "LaTeX Project Public License 1.1 (or any later version)";
        String lppl10OrLater = "LaTeX Project Public License 1.0 (or any later version)";
        String lppl12 = "LaTeX Project Public License 1.2";
        String lppl11 = "LaTeX Project Public License 1.1";
        String lppl10 = "LaTeX Project Public License 1.0";
        if (licenses.contains(lpplUndefined)) {
            InventoryUtils.replace(licenses, lpplUndefined, lppl12);
        }
        if (licenses.contains(lppl12OrLater) || licenses.contains(lppl12)) {
            licenses.remove(lppl11OrLater);
            licenses.remove(lppl10OrLater);
            InventoryUtils.replace(licenses, lppl12OrLater, lppl12);
        }
        if (licenses.contains(lppl11OrLater) || licenses.contains(lppl11)) {
            licenses.remove(lppl10OrLater);
            InventoryUtils.replace(licenses, lppl11OrLater, lppl11);
        }
        if (licenses.contains(lppl10OrLater)) {
            InventoryUtils.replace(licenses, lppl10OrLater, lppl10);
        }
        String beopen = "BeOpen Python Open Source License Agreement 1.0";
        String cnri = "CNRI License Agreement";
        String permission = "Permission Terms (no advertising; no warranty; no liability)";
        String phyton = "Python Software Foundation License 2.0";
        if (licenses.contains(beopen) && licenses.contains(cnri) && licenses.contains(permission) && licenses.contains(phyton)) {
            licenses.remove(beopen);
            licenses.remove(cnri);
            licenses.remove(permission);
        }
        String bsdUndefined = "BSD (undefined)";
        String bsd3Clause = "BSD 3-Clause License";
        if (licenses.contains(bsdUndefined)) {
            licenses.remove(bsdUndefined);
            licenses.add(bsd3Clause);
        }
        String apacheLicenseUndefined = "Apache License (undefined)";
        String apacheLicense20 = "Apache License 2.0";
        if (licenses.contains(apacheLicenseUndefined)) {
            licenses.remove(apacheLicenseUndefined);
            licenses.add(apacheLicense20);
        }
        String licenseUndefined = "Mozilla Public License (undefined)";
        String license20 = "Mozilla Public License 2.0";
        if (licenses.contains(licenseUndefined)) {
            licenses.remove(licenseUndefined);
            licenses.add(license20);
        }
        String cddlUndefined = "CDDL (undefined)";
        String cddl10 = "CDDL 1.0";
        String cddl11 = "CDDL 1.1";
        if (licenses.contains(cddl10) && licenses.contains(cddl11)) {
            licenses.remove(cddlUndefined);
        }
        if (licenses.contains(cddlUndefined)) {
            InventoryUtils.replace(licenses, cddlUndefined, cddl10);
        }
        for (String l2 : new ArrayList<String>(licenses)) {
            InventoryUtils.replaceLicense(licenses, l2, "FreeType Project License + GNU General Public License 2.0 (or any later version)", "FreeType Project License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 (or any later version) + GNU General Public License 2.0 (or any later version) + Mozilla Public License (undefined)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Netscape + GNU General Public License 2.0 (or any later version) + GNU Library General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (variant 003) + GNU General Public License (undefined)", "BSD 3-Clause License (variant 003)");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (variant 003) + GNU General Public License 2.0", "BSD 3-Clause License (variant 003)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 (or any later version), GNU Library General Public License 2.0 (or any later version) + GNU General Public License 2.0 (or any later version) + Mozilla Public License (undefined)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Netscape + GNU General Public License 2.0 (or any later version) + GNU Library General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + CC0 Universal 1.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 2.0 + GNU General Public License 2.0 (or any later version)", "Mozilla Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU Lesser General Public License 2.1 (or any later version) + GNU General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Academic Free License 2.1", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + MIT License", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 3.0 (or any later version) + MIT License", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Academic Free License 2.0", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License 3.0 (or any later version)", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU General Public License 2.0 + GNU Lesser General Public License 2.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 + GNU General Public License 2.0", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Lesser General Public License 2.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 + Mozilla Public License 2.0 + GNU General Public License 2.0", " GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU Genral Public License 3.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 3.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Lesser General Public License 3.0", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU General Public License 2.0 + GNU Lesser General Public License 2.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 3.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Lesser General Public License 3.0", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 3.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 3.0 (or any later version)", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + CC0 Universal (undefined)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License 2.1 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 (or any later version) + GNU General Public License 2.0 (or any later version)", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License 2.1 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 (or any later version) + Mozilla Public License 2.0 + GNU General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 (or any later version) + Artistic License (undefined)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + X11 License", "X11 License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Free Documentation License 1.1 (or any later version)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Transitive Grace Period Public Licence 1.0 (or any later version)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License  3.0 (or any later version)", "GNU Lesser General Public License  3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License version 3.0 (or any later version)", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License 3.0 (or any later version)", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU Genral Public License 3.0 (or any later version)", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 3.0 (or any later version)", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 2.0 (or any later version)", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + GNU General Public License 2.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License (undefined)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License (undefined) + GNU General Public License 1.0", "Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License 1.0 + GNU General Public License 1.0", "Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 + Creative Commons BY-SA 3.0", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License (undefined) + GNU General Public License (undefined)", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License (undefined) + GNU General Public License 1.0", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License 1.0 + GNU General Public License (undefined)", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License 1.0 + GNU General Public License 3.0", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License 1.0 + GNU General Public License 2.0", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License 1.0 + GNU General Public License 1.0", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 + Artistic License (undefined)", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License (undefined) + GNU General Public License 1.0 (or any later version)", "Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 + Mozilla Public License 1.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License 1.0 + GNU General Public License 1.0", "Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Lesser General Public License 2.1 + Mozilla Public License 1.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "HSIEH-DERIVATIVE + HSIEH-BSD + GNU Lesser General Public License 2.1", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Artistic License 1.0 (Perl)", "Artistic License 1.0 (Perl)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 (or any later version) + Artistic License 1.0 (Perl)", "Artistic License 1.0 (Perl)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 + Artistic License 1.0 (Perl)", "Artistic License 1.0 (Perl)");
            InventoryUtils.replaceLicense(licenses, l2, "Expat License + GNU General Public License 1.0 + Artistic License 1.0 (Perl)", "Expat License");
            InventoryUtils.replaceLicense(licenses, l2, "Expat License + GNU General Public License 1.0 (or any later version) + Artistic License 1.0 (Perl)", "Expat License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 3.0 (or any later version) + GNU Free Documentation License 1.2 (or any later version)", "GNU General Public License 3.0 (or any later version)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + FreeType Project License", "GNU General Public License 2.0 (or any later version)");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU General Public License 2.0 + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GPL 2.0 with classpath exception", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General License 2.0", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GNU General Public License 2.0", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU General Public License 3.0 (or any later version)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License + GNU General Public License 3.0 (or any later version)", "BSD 3-Clause License");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (variant 013) + GNU General Public License (undefined)", "BSD 3-Clause License (variant 013)");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GNU General Public License 2.0 (with classpath exception)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GNU General Public License 2.0 (with Oracle classpath exception)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0 (with Oracle classpath exception)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0 (with classpath exception)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GNU General Public License 2.0 (with Sun classpath exception)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GPL 2 (with classpath exception)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GPL 2 (with classpath exception)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GPL 2 with classpath exception", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GPL 2 with classpath exception", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU Lesser General Public License 2.1 (or any later version)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU Lesser General Public License 3.0 (or any later version)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Mozilla Public License 1.1", "Mozilla Public License 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + Mozilla Public License 2.0", "Eclipse Public License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + GNU Lesser General Public License 2.1", "Eclipse Public License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 + Creative Commons BY-SA 4.0", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 2.0 + GNU General Public License 2.0 (with classpath exception)", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + GNU General Public License 2.0 (with classpath exception)", "Eclipse Public License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License (undefined) + Frontier Artistic License", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Frontier Artistic License", "Frontier Artistic License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + NCSA License", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "Public Domain + BSD alike", "Public Domain");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + gSOAP Public License + Genivia's Commercial License", "gSOAP Public License");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU Library General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU Library General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + Mozilla Public License 2.0", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + GNU Lesser General Public License 3.0 (or any later version) + Mozilla Public License 2.0", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + Mozilla Public License 1.1 + GNU Lesser General Public License 2.1 (or any later version)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU Lesser General Public License 2.1 (or any later version) + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU General Public License 2.0 (with classpath exception)", "GNU General Public License 2.0 (with classpath exception)");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU Lesser General Public License 3.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0 (with classpath exception)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (copyright variant) + GNU General Public License (undefined)", "BSD 3-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (copyright holder variant) + GNU General Public License (undefined)", "BSD 3-Clause License (copyright holder  variant)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1  + Eclipse Public License 1.0", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL (undefined) + GNU General Public License 2.0 (with classpath exception), CDDL 1.0", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU Lesser General Public License 2.1 (or any later version) + Mozilla Public License 1.1", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Academic Free License 2.1 + GNU Library General Public License 2.0", "GNU Library General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 (or any later version) + MIT License", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.0 + GNU General Public License 2.0 (with classpath exception 2.0)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL (undefined) + GNU General Public License 2.0 (with classpath exception 2.0)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 2-Clause License (copyright holder variant) + GNU General Public License (undefined) 002", "BSD 2-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License (undefined) 002", "GNU General Public License (undefined)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 3.0 002", "GNU General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 + GNU Lesser General Public License 2.1", "Eclipse Public License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + CC0 Universal 1.0", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 2.0 + GNU General Public License 2.0 (with classpath exception)", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 2.0 + GNU General Public License 2.0 (with classpath exception)", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 2.0 + GNU General Public License 2.0", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0 (with classpath exception 2.0)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 (or any later version) + GNU General Public License 2.0 (or any later version)", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 + Artistic License (undefined)", "GNU General Public License 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (variant 003) + GNU General Public License (undefined)", "BSD 3-Clause License (variant 003)");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + GNU General Public License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 + Eclipse Public License 2.0", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 1.1 + Apache License 2.0 + BSD (undefined) + Public Domain + Indiana University Extreme! Lab Software License 1.1.1", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "LGPLv2 + with exceptions", "GNU Library General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GPLv2 + with exceptions", "GNU General Public License 2.0 (or any later version; with exceptions)");
            InventoryUtils.replaceLicense(licenses, l2, "GPLv3 + with exceptions", "GNU General Public License 3.0 (or any later version; with exceptions)");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL (undefined) + GNU General Public License 2.0 (with classpath exception), CDDL 1.0 + GNU General Public License 2.0 (with classpath exception), GNU General Public License 2.0 (with classpath exception)", "CDDL 1.0 + GNU General Public License 2.0 (with classpath exception)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 (or any later version) + Artistic License 1.0", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 1.0 (or any later version) + Artistic License (undefined)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License (undefined) + Artistic License (undefined)", "GNU General Public License (undefined)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 2.1 + Mozilla Public License 1.1 + GNU General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License (undefined; or any later version) + Artistic License (undefined)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Artistic License (undefined)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License 1.0 (Perl) + GNU General Public License 1.0 (or any later version)", "GNU General Public License 2.0 (or any later version)");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License 1.0 + GNU General Public License 1.0 (or any later version)", "GNU General Public License 2.0 (or any later version)");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (copyright holder variant) + GNU General Public License 2.0", "BSD 3-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + Linux Kernel Variant of OpenIB.org License", "Linux Kernel Variant of OpenIB.org License");
            InventoryUtils.replaceLicense(licenses, l2, "OpenSSL License + Original SSLeay License", "OpenSSL License");
            InventoryUtils.replaceLicense(licenses, l2, "Academic Free License 2.1 + GNU General Public License 2.0 (or any later version)", "Academic Free License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Academic Free License 2.1 + GNU General Public License 2.0", "Academic Free License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Open Software License 2.1", "Open Software License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License + GNU General Public License 2.0", "BSD 3-Clause License");
            InventoryUtils.replaceLicense(licenses, l2, "MIT License + X11 License", "MIT License");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU General Public License 3.0", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU Lesser General Public License 3.0 (or any later version)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Cavium EULA + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 (or any later version) + GNU General Public License 2.0", "GNU Lesser General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Artistic License (undefined) + GNU Lesser General Public License (undefined)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License + GNU Lesser General Public License 2.1 (or any later version)", "BSD 3-Clause License");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License + GNU General Public License 2.0 (or any later version)", "BSD 3-Clause License");
            InventoryUtils.replaceLicense(licenses, l2, "FreeType Project License + GNU General Public License 2.0", "FreeType Project License");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 (or any later version) + GNU Lesser General Public License 2.1 (or any later version) + GNU General Public License 2.0 (or any later version) + Apache License 2.0 (or any later version) + BSD 3-Clause License", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL 1.1 + GNU General Public License 2.0 (with classpath exception)", "CDDL 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Mozilla Public License (undefined)", "Mozilla Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Academic Free License 2.1 + GNU General Public License 2.0 (or any later version)", "Academic Free License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + Academic Free License (undefined)", "Academic Free License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + Boost Software License 1.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + Eclipse Public License 1.0 + Eclipse Public License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + BSD (undefined)", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (Libcap) + GNU General Public License 2.0", "BSD 3-Clause License (Libcap)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 (or any later version) + GNU General Public License 2.0 (or any later version) + Mozilla Public License (undefined)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "Netscape Public License (undefined) + GNU General Public License 2.0 (or any later version) + GNU Library General Public License 2.0 (or any later version)", "GNU Lesser General Public License 2.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 3.0 (or any later version) + BSD (undefined)", "GNU General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + BSD (undefined)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD (undefined) + GNU General Public License 2.0", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD (undefined) + GNU General Public License 2.0 (or any later version)", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD (undefined) + GNU General Public License (undefined; or any later version)", "GNU General Public License 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "Apache License 2.0 + Eclipse Public License 1.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 2.0 + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "CDDL (undefined) + GNU General Public License 2.0 (with classpath exception)", "CDDL 1.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (variant 003) + GNU Library General Public License 2.0 (or any later version)", "BSD 3-Clause License (variant 003)");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 4-Clause License (UC) + Permission Terms (variant 137)", "BSD 4-Clause License (UC)");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 2-Clause License (copyright holder variant) + GNU General Public License 2.0 (or any later version)", "BSD 2-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 (or any later version) + GNU Lesser General Public License 2.1 (or any later version) + Mozilla Public License 1.1 + BSD 2-Clause License (copyright holder variant)", "BSD 2-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "OpenSSL License + BSD 3-Clause License (copyright holder variant) + GNU General Public License (undefined)", "BSD 3-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "OpenSSL License + BSD 3-Clause License (copyright holder variant) + GNU General Public License 2.0", "BSD 3-Clause License (copyright holder variant)");
            InventoryUtils.replaceLicense(licenses, l2, "Public Domain + BSD (undefined)", "Public Domain");
            InventoryUtils.replaceLicense(licenses, l2, "Mozilla Public License 1.1 + GNU General Public License 2.0 + GNU Library General Public License 2.0", "Mozilla Public License 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "Unicode Terms of Use + Unicode DFS License 2016", "Unicode Terms of Use, Unicode DFS License 2016");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 + Mozilla Public License 1.1", "Mozilla Public License 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 + Apache License 2.0", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 + Mozilla Public License 1.1", "Mozilla Public License 1.1");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License (Eclipse Distribution) + Eclipse Public License 2.0", "BSD 3-Clause License (Eclipse Distribution)");
            InventoryUtils.replaceLicense(licenses, l2, "Eclipse Public License 1.0 (or any later version) + GNU Lesser General Public License 2.1 (or any later version) + GNU Affero General Public License 3.0 (or any later version) + Apache License 2.0 (or any later version) + BSD 2-Clause License + MIT License", "Apache License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU General Public License 2.0 + GNU General Public License 3.0", "GNU General Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "IBM Public License 1.0 + Eclipse Public License 2.0", "Eclipse Public License 2.0");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 + BSD (undefined)", "BSD (undefined)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Library General Public License 2.0 + BSD (undefined)", "BSD (undefined)");
            InventoryUtils.replaceLicense(licenses, l2, "GNU Lesser General Public License 3.0 (or any later version) + Creative Commons BY-SA 3.0", "Creative Commons BY-SA 3.0");
            InventoryUtils.replaceLicense(licenses, l2, "BSD 3-Clause License + WTF Public License 2.0", "BSD 3-Clause License");
        }
        licenses.stream().filter(l -> l.contains(" + ")).forEach(l -> LOG.info("License [{}] still contains a license option!", l));
        String derived = licenses.stream().distinct().sorted().collect(Collectors.joining("|"));
        derived = derived.replace(" (undefined; or any later version)", "(undefined)");
        derived = derived.replace("Artistic License (undefined)", "Artistic License 1.0");
        derived = derived.replace("CC0 Universal (undefined)", "CC0 Universal 1.0");
        derived = derived.replace("CC0 Universal License (undefined)", "CC0 Universal 1.0");
        derived = derived.replace("GNU Lesser General Public License (undefined)", "GNU Lesser General Public License 2.1");
        derived = derived.replace("GNU General Public License (undefined)", "GNU General Public License 2.0");
        derived = derived.replace("Eclipse Public License (undefined)", "Eclipse Public License 2.0");
        derived = derived.replace("Eclipse Public License 1.0", "Eclipse Public License 2.0");
        derived = derived.replace(" (or any later version)", "");
        derived = derived.replace(" (or any later version; ", " (");
        return derived;
    }

    protected static void replaceLicense(List<String> licenses, String l, String dual, String replace) {
        if (l.equals(dual) && licenses.remove(dual)) {
            licenses.add(replace);
        }
    }

    public static void replace(List<String> licenses, String gpl2OrLater, String gpl2) {
        int index = licenses.indexOf(gpl2OrLater);
        if (index != -1) {
            licenses.remove(gpl2OrLater);
            licenses.add(index, gpl2);
        }
    }

    public static void removeNonPublicArtifacts(Inventory referenceInventory) {
        referenceInventory.getArtifacts().removeIf(artifact -> !InventoryUtils.isPublicArtifact(artifact));
    }

    public static boolean isPublicArtifact(Artifact artifact) {
        String sPublic = artifact.get("Public");
        if (sPublic == null) {
            sPublic = String.valueOf(Boolean.TRUE);
        }
        return String.valueOf(Boolean.TRUE).equalsIgnoreCase(sPublic);
    }

    public static void updatePackageLicenseNotice(LicenseMetaData lmd) {
        StringBuilder sb = new StringBuilder();
        String newline = String.format("%n", new Object[0]);
        String license = lmd.getLicense();
        String licensesInEffect = lmd.deriveLicenseInEffect();
        sb.append("<p>The package <b>").append(lmd.getComponent()).append("</b> in the present version is licensed under ").append(InventoryUtils.convertAssociatedLicenseToText(license)).append(".</p>").append(newline);
        if (!InventoryUtils.tokenizeLicense((String)license, (boolean)true, (boolean)false).equals(InventoryUtils.tokenizeLicense((String)licensesInEffect, (boolean)true, (boolean)false))) {
            sb.append("<p>As effective licenses for distribution ").append(licensesInEffect.replace("|", ", "));
            if (licensesInEffect.contains("|")) {
                sb.append(" have been identified.");
            } else {
                sb.append(" has been identified.");
            }
            sb.append("</p>").append(newline);
            if (license.contains("GNU Affero General Public License") && !licensesInEffect.contains("GNU Affero General Public License")) {
                sb.append("<p>In particular, the GNU Affero General Public License does not apply as the affected portions are not part of the distribution.</p>");
            }
        }
        sb.append("<p>Detailed licensing information can be found in the <codeph>copyright</codeph> file included in the software distribution annex.</p>").append(newline);
        sb.append("<p>The corresponding source code of the covered open source components is provided on demand.</p>");
        lmd.setNotice(sb.toString());
        if (licensesInEffect.contains(" + ")) {
            throw new IllegalStateException("Undecided effective license detected " + license + " --> " + licensesInEffect);
        }
    }

    private static String convertAssociatedLicenseToText(String license) {
        int lastIndexOfComma = license.lastIndexOf(",");
        if (lastIndexOfComma != -1) {
            String replacement = license.substring(0, lastIndexOfComma) + ", and " + license.substring(lastIndexOfComma + 1);
            replacement = replacement.replaceAll("and  ", "and ");
            return replacement;
        }
        return license;
    }

    public static String escapeXml(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    public static String filterAuthors(String authors) {
        String[] split = authors.split("\\|\\n");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
        for (String author : new ArrayList<String>(list)) {
            String improved = author.replaceAll("> ", ">, ");
            improved = improved.replaceAll("Patrick McHardy, <kaber@trash.net>", "Patrick McHardy <kaber@trash.net>");
            improved = improved.replaceAll("Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>", "Alexey Kuznetsov <kuznet@ms2.inr.ac.ru>");
            improved = improved.replaceAll("McHardy\\.", "McHardy");
            improved = improved.replace(", ,", ", ");
            improved = improved.replace(" ,", ",");
            list.remove(author);
            if (!StringUtils.hasText(improved)) continue;
            list.add(improved);
        }
        Collections.sort(list, String::compareToIgnoreCase);
        return String.join((CharSequence)Constants.DELIMITER_NEWLINE, list);
    }

    public static List<String> filterCopyrightsAndAuthorsList(String copyrights) {
        if (!StringUtils.hasText(copyrights)) {
            return new ArrayList<String>();
        }
        String[] split = copyrights.split("\\|\\n");
        ArrayList<String> copyrightList = new ArrayList<String>(Arrays.asList(split));
        Collections.sort(copyrightList, String::compareToIgnoreCase);
        HashSet<String> filterPrefixList = new HashSet<String>();
        filterPrefixList.add("(c) .");
        HashSet<String> filterSuffixList = new HashSet<String>();
        filterSuffixList.add("pppppp \u0010 .kawasaki.jp");
        for (String copyright : new ArrayList<String>(copyrightList)) {
            if (InventoryUtils.fullMatch(copyright, filterFullList)) {
                InventoryUtils.removeCopyright(copyright, copyrightList);
                continue;
            }
            if (InventoryUtils.prefixMatch(copyright, filterPrefixList)) {
                InventoryUtils.removeCopyright(copyright, copyrightList);
                continue;
            }
            if (InventoryUtils.suffixMatch(copyright, filterSuffixList)) {
                InventoryUtils.removeCopyright(copyright, copyrightList);
                continue;
            }
            if (copyright.equals("GPL. Patrick McHardy (c) 2006-2012")) {
                copyrightList.remove(copyright);
                copyrightList.add("Patrick McHardy (C) 2006-2012");
            }
            if (copyright.toLowerCase().contains("$year")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("copyright if $contents")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("$(year)")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0000")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0001")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0002")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0003")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0004")) {
                copyrightList.remove(copyright);
            }
            if (copyright.toLowerCase().contains("\u0005")) {
                copyrightList.remove(copyright);
            }
            if (!copyright.startsWith("(c) Returns ")) continue;
            copyrightList.remove(copyright);
        }
        return copyrightList;
    }

    protected static boolean suffixMatch(String copyright, Set<String> filterSuffixList) {
        for (String suffix : filterSuffixList) {
            if (!copyright.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected static boolean prefixMatch(String copyright, Set<String> filterPrefixList) {
        for (String prefix : filterPrefixList) {
            if (!copyright.endsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected static boolean fullMatch(String copyright, Set<String> filterFullList) {
        for (String candidate : filterFullList) {
            if (!copyright.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    protected static void removeCopyright(String copyright, List<String> copyrightList) {
        copyrightList.remove(copyright);
        LOG.debug("Removed copyright: [{}] found in {}.", (Object)copyright, copyrightList);
    }

    private static String escape(String s) {
        return StringEscapeUtils.escapeXml((String)s.trim());
    }

    @Deprecated
    public static void diffScanCodeResults(Inventory inventory) {
        for (Artifact a : inventory.getArtifacts()) {
            String derivedLicense = a.get("Derived Licenses");
            String derivedLicenseScanCode = StringUtils.stripArrayBoundaries(a.get("Derived Licenses (ScanCode)"));
            Set<String> remainingScanCodeLicenses = InventoryUtils.diffLicensesWithScanCodeLicenses(derivedLicense, derivedLicenseScanCode);
            String sourceDerivedLicenses = a.get("Source Artifact - Derived Licenses");
            String sourceDerivedLicenses_ScanCode = StringUtils.stripArrayBoundaries(a.get("Source Artifact - Derived Licenses (ScanCode)"));
            Set<String> remainingScanCodeLicenses_Source = InventoryUtils.diffLicensesWithScanCodeLicenses(sourceDerivedLicenses, sourceDerivedLicenses_ScanCode);
            StringBuilder sb = new StringBuilder();
            if (!remainingScanCodeLicenses.isEmpty()) {
                sb.append("bin: ");
                sb.append(remainingScanCodeLicenses);
            }
            if (!remainingScanCodeLicenses_Source.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("src: ");
                sb.append(remainingScanCodeLicenses);
            }
            a.set("Diff - Derived License / Scancode", sb.toString());
        }
    }

    protected static Set<String> diffLicensesWithScanCodeLicenses(String derivedLicense, String derivedLicenseScanCode) {
        List licenseList = InventoryUtils.tokenizeLicense((String)derivedLicense, (boolean)false, (boolean)false);
        List<TermsMetaData> termsList = NORMALIZATION_META_DATA.convert(licenseList);
        List scanCodeLicenseList = InventoryUtils.tokenizeLicense((String)derivedLicenseScanCode, (boolean)false, (boolean)false);
        HashSet<String> coveredScanCodeIds = new HashSet<String>();
        for (TermsMetaData termsMetaData : termsList) {
            List<String> scanCodeIds = termsMetaData.getScanCodeIdentifiers();
            coveredScanCodeIds.addAll(scanCodeIds);
        }
        HashSet<String> remainingScanCodeLicenses = new HashSet<String>(scanCodeLicenseList);
        remainingScanCodeLicenses.removeAll(coveredScanCodeIds);
        return remainingScanCodeLicenses;
    }

    public static void insertLicenseDataForCanonicalNames(Collection<String> canonicalNames, Inventory projectInventory) {
        for (String canonicalName : canonicalNames) {
            LicenseData matchedLd = projectInventory.findMatchingLicenseData(canonicalName);
            if (matchedLd != null) continue;
            TermsMetaData termsMetaData = NORMALIZATION_META_DATA.getTermsMetaData(canonicalName);
            if (termsMetaData != null) {
                LicenseData ld = new LicenseData();
                InventoryUtils.transferTmdAttributesToLicenseData(ld, termsMetaData);
                projectInventory.getLicenseData().add(ld);
                continue;
            }
            LOG.debug("No explicit license metadata for [{}].", (Object)canonicalName);
            TermsMetaData alternativeTermsMetaData = NORMALIZATION_META_DATA.findTermsMetaData(canonicalName);
            if (alternativeTermsMetaData != null) {
                String alternativeCanonicalName = alternativeTermsMetaData.getCanonicalName();
                LicenseData alternativeLicensData = projectInventory.findMatchingLicenseData(alternativeCanonicalName);
                if (alternativeLicensData != null) continue;
                LicenseData ld = new LicenseData();
                InventoryUtils.transferTmdAttributesToLicenseData(ld, alternativeTermsMetaData);
                projectInventory.getLicenseData().add(ld);
                continue;
            }
            if (canonicalName.contains(" + ")) continue;
            LicenseData ld = new LicenseData();
            ld.set(LicenseData.Attribute.CANONICAL_NAME, canonicalName);
            projectInventory.getLicenseData().add(ld);
            ld.set("Unknown License Type", "x");
            if (!canonicalName.toLowerCase().contains("commercial")) continue;
            ld.set(LicenseData.Attribute.COMMERCIAL, "x");
        }
    }

    public static void transferTmdAttributesToLicenseData(LicenseData ld, TermsMetaData termsMetaData) {
        List<String> matchedMarkers;
        String type;
        ld.set(LicenseData.Attribute.CANONICAL_NAME, termsMetaData.getCanonicalName());
        ld.set(LicenseData.Attribute.ID, termsMetaData.deriveId());
        ld.set(LicenseData.Attribute.SPDX_ID, termsMetaData.getSpdxIdentifier());
        ld.set(LicenseData.Attribute.REPRESENTED_AS, termsMetaData.getRepresentedAs());
        List<String> scanCodeIds = termsMetaData.getScanCodeIdentifiers();
        if (scanCodeIds != null) {
            ld.set("ScanCode Ids", scanCodeIds.stream().sorted().collect(Collectors.joining(", ")));
        }
        ld.set("OSI Status", termsMetaData.getOsiStatus());
        ld.set("Open CoDE Status", termsMetaData.getOpenCoDEStatus());
        ld.set("Open CoDE Similar License", termsMetaData.getOpenCoDESimilarLicenseId());
        boolean openCodeAssessmentPending = true;
        if (StringUtils.hasText(termsMetaData.getOpenCoDEStatus())) {
            openCodeAssessmentPending = false;
        }
        if (termsMetaData.isException()) {
            openCodeAssessmentPending = false;
        }
        if (termsMetaData.isUnspecific()) {
            openCodeAssessmentPending = false;
        }
        if (termsMetaData.isMarker()) {
            openCodeAssessmentPending = false;
        }
        if (termsMetaData.isExpression()) {
            openCodeAssessmentPending = false;
        }
        if (termsMetaData.allowLaterVersions()) {
            openCodeAssessmentPending = false;
        }
        if (StringUtils.hasText(termsMetaData.getRepresentedAs()) && StringUtils.isEmpty(termsMetaData.getSpdxIdentifier()) && (termsMetaData.getOtherIds() == null || termsMetaData.getOtherIds().isEmpty())) {
            openCodeAssessmentPending = false;
        }
        if (openCodeAssessmentPending) {
            ld.set("Open CoDE Assessment Pending", "x");
        } else {
            ld.set("Open CoDE Assessment Pending", null);
        }
        String licenseClassification = termsMetaData.getClassification();
        if (licenseClassification != null) {
            String licenseClassificationLowerCase = licenseClassification.toLowerCase();
            ld.set("C-" + licenseClassificationLowerCase, "x");
        }
        if (StringUtils.isEmpty(type = termsMetaData.getType())) {
            type = "terms";
        }
        ld.set("Type", type);
        if ("terms".equalsIgnoreCase(type) && (matchedMarkers = termsMetaData.getMatchedMarkers()) != null) {
            for (String marker : matchedMarkers) {
                TermsMetaData tmd = InventoryUtils.getNormalizationMetaData().resolveTermsMetaData(marker);
                ld.set("M-" + tmd.getShortName(), "x");
            }
        }
    }

    public static void applyDerivedLicenses(Inventory projectInventory) {
        for (Artifact artifact : projectInventory.getArtifacts()) {
            String derivedLicense;
            if (StringUtils.hasText(artifact.getLicense()) || !StringUtils.hasText(derivedLicense = artifact.get("Derived Licenses"))) continue;
            artifact.setLicense(derivedLicense);
        }
    }

    public static boolean canCarryLicenseMetaData(Artifact artifact) {
        return StringUtils.notEmpty(artifact.getLicense()) && StringUtils.notEmpty(artifact.getVersion()) && StringUtils.notEmpty(artifact.getComponent());
    }

    public static void addToInventory(Inventory sourceInventory, Inventory targetInventory, boolean processAssets) {
        InventorySearch inventorySearch = new InventorySearch(targetInventory);
        InventoryUtils.addToInventory(sourceInventory.getArtifacts(), inventorySearch);
        if (processAssets) {
            targetInventory.getAssetMetaData().addAll(sourceInventory.getAssetMetaData());
            InventoryUtils.mergeDuplicateAssets(targetInventory);
        }
    }

    public static void addToInventory(Collection<Artifact> artifacts, InventorySearch inventorySearch) {
        for (Artifact artifact : artifacts) {
            Artifact referenceArtifact = !StringUtils.isEmpty(artifact.getChecksum()) ? inventorySearch.findArtifactByIdAndChecksum(artifact) : inventorySearch.findArtifactById(artifact);
            if (referenceArtifact != null) {
                String value = artifact.get(Artifact.Attribute.ROOT_PATHS);
                if (!StringUtils.isEmpty(value)) {
                    referenceArtifact.append(Artifact.Attribute.ROOT_PATHS.getKey(), value, "|\n");
                }
                for (String attribute : artifact.getAttributes()) {
                    if (attribute.equals(Artifact.Attribute.ROOT_PATHS.getKey()) || referenceArtifact.get(attribute) != null) continue;
                    referenceArtifact.set(attribute, artifact.get(attribute));
                }
                continue;
            }
            inventorySearch.add(artifact);
        }
    }

    public static void deriveComponentNamesAndVersions(Inventory filteredInventory) {
        for (Artifact a : filteredInventory.getArtifacts()) {
            if (StringUtils.isEmpty(a.getComponent()) && StringUtils.notEmpty(a.getId())) {
                if (StringUtils.notEmpty(a.getVersion())) {
                    a.deriveArtifactId();
                    a.setComponent(a.getArtifactId());
                }
                if (StringUtils.isEmpty(a.getComponent())) {
                    String componentName = a.getId();
                    int dashIndex = componentName.lastIndexOf("-");
                    if (dashIndex > 0) {
                        componentName = componentName.substring(0, dashIndex);
                    } else {
                        int dotIndex = componentName.lastIndexOf(".");
                        if (dotIndex > 0) {
                            componentName = componentName.substring(0, dotIndex);
                        }
                    }
                    a.setComponent(componentName);
                }
            }
            String proposedVersion = a.get("Descriptor - Derived Version");
            if (StringUtils.isEmpty(a.getVersion()) && StringUtils.notEmpty(proposedVersion)) {
                a.setVersion(proposedVersion);
            }
            String proposedGroupId = a.get("Descriptor - Derived GroupId");
            if (!StringUtils.isEmpty(a.getGroupId()) || !StringUtils.notEmpty(proposedGroupId)) continue;
            a.setGroupId(proposedGroupId);
        }
    }

    public static void inheritInformationFromReferenceInventory(Inventory inventory, InventorySearch referenceInventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            String bestMatchQualifier;
            String qualifier;
            String id = artifact.getId();
            String version = artifact.getVersion();
            if (id == null || version == null) continue;
            int index = id.indexOf(version);
            String prefix = index != -1 ? id.substring(0, index) : id;
            String suffix = index != -1 ? id.substring(index + version.length()) : "";
            int count = -1;
            Artifact bestMatch = referenceInventory.findArtifactByIdAndChecksum(artifact);
            if (bestMatch == null) {
                bestMatch = referenceInventory.findArtifactWildcardMatchingId(artifact);
            }
            if (bestMatch == null) {
                for (Artifact a : referenceInventory.getArtifacts()) {
                    String aSuffix;
                    String aId = a.getId();
                    String aVersion = a.getVersion();
                    if (aId == null || a.getVersion() == null) continue;
                    int aIndex = aId.indexOf(a.getVersion());
                    String aPrefix = aIndex != -1 ? aId.substring(0, aIndex) : id;
                    String string = aSuffix = aIndex != -1 ? aId.substring(aIndex + aVersion.length()) : "";
                    if (!prefix.equals(aPrefix) || !suffix.equals(aSuffix)) continue;
                    if (aVersion.equals(version)) {
                        bestMatch = a;
                        break;
                    }
                    for (int i = 0; i < Math.min(version.length(), aVersion.length()) && version.charAt(i) == aVersion.charAt(i); ++i) {
                        if (count >= i) continue;
                        count = i;
                        bestMatch = a;
                    }
                }
            }
            if (bestMatch == null || (qualifier = artifact.getId() + "/" + artifact.getChecksum() + "/" + artifact.getVersion() + "/" + artifact.getGroupId()).equals(bestMatchQualifier = bestMatch.getId() + "/" + bestMatch.getChecksum() + "/" + bestMatch.getVersion() + "/" + bestMatch.getGroupId())) continue;
            artifact.set("Inherited Component", bestMatch.getComponent());
            artifact.set("Inherited Version", bestMatch.getVersion());
            artifact.set("Inherited GroupId", bestMatch.getGroupId());
            artifact.set("Inherited License", bestMatch.getLicense());
            artifact.set("Inherited Notice Parameter", bestMatch.get("Notice Parameter"));
            artifact.set("Inherited Analysis", bestMatch.get("Analysis"));
            artifact.set("Inherited Protocol of Research", bestMatch.get("Protocol of Research"));
        }
    }

    public static void filterExceptionsFromLicenses(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            List licenses = artifact.getLicenses();
            for (String license : new ArrayList(licenses)) {
                TermsMetaData termsMetaData = InventoryUtils.getNormalizationMetaData().getTermsMetaData(license);
                if (termsMetaData == null || !termsMetaData.isException()) continue;
                licenses.remove(license);
            }
            artifact.setLicense(InventoryUtils.joinLicenses(licenses));
        }
    }

    public static void orderLicenses(Inventory inventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            List licenses = InventoryUtils.tokenizeLicense((String)artifact.getLicense(), (boolean)true, (boolean)true);
            ArrayList<String> newLicenses = new ArrayList<String>();
            for (String license : licenses) {
                if (license.contains(" + ")) {
                    List orLicenses = InventoryUtils.tokenizeLicense((String)license, (boolean)true, (boolean)false);
                    newLicenses.add(InventoryUtils.joinOredLicenses(orLicenses));
                    continue;
                }
                newLicenses.add(license);
            }
            Collections.sort(newLicenses, String.CASE_INSENSITIVE_ORDER);
            artifact.setLicense(InventoryUtils.joinLicenses(newLicenses));
        }
    }

    public static void renameArtifactAttributes(Inventory inventory, String oldAttributeKey, String newAttributeKey) {
        InventoryUtils.renameArtifactAttributes(inventory, oldAttributeKey, newAttributeKey, false);
    }

    public static void renameArtifactAttributes(Inventory inventory, String oldAttributeKey, String newAttributeKey, boolean allowOverwrites) {
        for (Artifact artifact : inventory.getArtifacts()) {
            String oldValue = artifact.get(oldAttributeKey);
            String newValue = artifact.get(newAttributeKey);
            if (StringUtils.isEmpty(oldValue)) {
                oldValue = null;
            }
            if (StringUtils.isEmpty(newValue)) {
                newValue = null;
            }
            if (Objects.equals(oldValue, newValue)) {
                artifact.set(oldAttributeKey, null);
                continue;
            }
            if (newValue != null && oldValue != null) {
                if (!allowOverwrites) {
                    String message = String.format("Cannot rename [%s] attribute %s to %s. New attribute already exists and contains different values: old [%s] vs new [%s]", artifact.getId(), oldAttributeKey, newAttributeKey, oldValue, newValue);
                    LOG.error(message);
                    continue;
                }
                artifact.set(newAttributeKey, oldValue);
                artifact.set(oldAttributeKey, null);
                continue;
            }
            if (newValue != null) continue;
            artifact.set(newAttributeKey, oldValue);
            artifact.set(oldAttributeKey, null);
        }
        InventorySerializationContext serializationContext = inventory.getSerializationContext();
        ArrayList list = (ArrayList)serializationContext.get("artifact.columnlist");
        if (list != null) {
            int index = list.indexOf(oldAttributeKey);
            int indexNew = list.indexOf(newAttributeKey);
            if (indexNew == -1 && index != -1) {
                list.set(index, newAttributeKey);
            }
            while (list.contains(oldAttributeKey)) {
                list.remove(oldAttributeKey);
            }
        }
    }

    public static void removeArtifactInheritedAttributes(Inventory inventory) {
        InventoryUtils.removeArtifactAttributeStartingWith((Inventory)inventory, (String)"Inherited ");
    }

    public static void removeArtifactInternalAttributes(Inventory inventory) {
        InventoryUtils.removeAttributes((Inventory)inventory, INTERNAL_COLUMNS);
    }

    public static String createStringRepresentation(Artifact artifact) {
        String id = artifact.getId();
        String groupId = artifact.getGroupId();
        String version = artifact.getVersion();
        String s = "";
        s = id != null ? s + "/" + id : s + "/";
        s = groupId != null ? s + "/" + groupId : s + "/";
        s = version != null ? s + "/" + version : s + "/";
        return s;
    }

    public static String createStringRepresentation(AssetMetaData assetMetaData) {
        String assetId = assetMetaData.get(AssetMetaData.Attribute.ASSET_ID);
        String s = "";
        s = assetId != null ? s + "/" + assetId : s + "/";
        return s;
    }

    public static String createStringRepresentation(LicenseData licenseData) {
        String assetId = licenseData.get(LicenseData.Attribute.CANONICAL_NAME);
        String s = "";
        s = assetId != null ? s + "/" + assetId : s + "/";
        return s;
    }

    public static void removeLicenseDataAttributeContaining(String substring, Inventory inventory) {
        for (LicenseData licenseData : inventory.getLicenseData()) {
            for (String key : new HashSet(licenseData.getAttributes())) {
                if (!key.contains(substring)) continue;
                licenseData.set(key, null);
            }
        }
    }

    public static void removeAssetAttribute(String key, Inventory inventory) {
        for (AssetMetaData assetMetaData : inventory.getAssetMetaData()) {
            assetMetaData.set(key, null);
        }
    }

    public static void removeAssetsAndReferences(Inventory inventory) {
        for (AssetMetaData asset : inventory.getAssetMetaData()) {
            String assetId = asset.get(AssetMetaData.Attribute.ASSET_ID);
            for (Artifact artifact : inventory.getArtifacts()) {
                if (!StringUtils.notEmpty(artifact.get(asset.get(AssetMetaData.Attribute.ASSET_ID)))) continue;
                artifact.set(assetId, null);
            }
        }
        inventory.setAssetMetaData(Collections.emptyList());
    }

    public static void mergeDuplicateAssets(Inventory mergedInventory) {
        HashMap<String, HashSet> qualiferAssetMap = new HashMap<String, HashSet>();
        for (AssetMetaData assetMetaData : mergedInventory.getAssetMetaData()) {
            qualiferAssetMap.computeIfAbsent(assetMetaData.deriveQualifier(), c -> new LinkedHashSet()).add(assetMetaData);
        }
        HashSet<AssetMetaData> toBeDeleted = new HashSet<AssetMetaData>();
        for (HashSet assetMetaDataSet : qualiferAssetMap.values()) {
            Iterator assetMetaDataIterator = assetMetaDataSet.iterator();
            AssetMetaData referenceAsset = (AssetMetaData)assetMetaDataIterator.next();
            while (assetMetaDataIterator.hasNext()) {
                AssetMetaData duplicate = (AssetMetaData)assetMetaDataIterator.next();
                toBeDeleted.add(duplicate);
                for (String key : duplicate.getAttributes()) {
                    String value = referenceAsset.get(key);
                    if (StringUtils.hasText(value)) continue;
                    referenceAsset.set(key, duplicate.get(key));
                }
            }
        }
        toBeDeleted.forEach(mergedInventory.getAssetMetaData()::remove);
    }

    public static void addContentChecksum(Inventory referenceInventory) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "ae-content-checksum");
        for (Artifact artifact : referenceInventory.getArtifacts()) {
            File artifactAnalysisPath;
            String analysisPath;
            if (!StringUtils.isEmpty(artifact.get("Content MD5")) || !StringUtils.notEmpty(analysisPath = artifact.get("Analysis Path"))) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing content checksum for " + artifact.deriveQualifier());
            }
            if ((artifactAnalysisPath = new File(analysisPath)).exists()) {
                String contentChecksum = FileUtils.computeContentChecksum(artifactAnalysisPath, tmpDir);
                artifact.set("Content MD5", contentChecksum);
                continue;
            }
            LOG.warn("Expected content in path " + artifactAnalysisPath + ". Cannot compute content checksum.");
        }
    }

    public static void inheritInformationFromReferenceInventory(Inventory inventory, Inventory referenceInventory) {
        for (Artifact artifact : inventory.getArtifacts()) {
            String id = artifact.getId();
            for (Artifact a : referenceInventory.getArtifacts()) {
                int index;
                String aId = a.getId();
                if (aId == null || a.getVersion() == null || (index = aId.indexOf(a.getVersion())) <= 0) continue;
                String prefix = aId.substring(0, index);
                String suffix = aId.substring(index + a.getVersion().length());
                if (!id.startsWith(prefix) || !id.endsWith(suffix)) continue;
                int startIndex = prefix.length();
                int endIndex = id.length() - suffix.length();
                if (a != artifact) {
                    if (StringUtils.isEmpty(artifact.getComponent())) {
                        artifact.setComponent(a.getComponent());
                    }
                    if (StringUtils.isEmpty(artifact.getVersion()) && startIndex < endIndex) {
                        artifact.setVersion(id.substring(startIndex, endIndex));
                    }
                    if (StringUtils.isEmpty(artifact.getGroupId())) {
                        artifact.setGroupId(a.getGroupId());
                    }
                    if (StringUtils.isEmpty(a.get("Public"))) {
                        artifact.set("Public", a.get("Public"));
                    }
                    if (!a.createCompareStringRepresentation().equals(artifact.createCompareStringRepresentation())) {
                        if (StringUtils.notEmpty(a.getLicense())) {
                            artifact.set("Inherited License", a.getLicense());
                            LOG.debug("Inherited license from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                        }
                        if (StringUtils.notEmpty(a.get("Notice Parameter"))) {
                            artifact.set("Inherited Notice Parameter", a.get("Notice Parameter"));
                            LOG.debug("Inherited notice parameter from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                        }
                        if (StringUtils.notEmpty(a.get("Analysis"))) {
                            artifact.set("Inherited Analysis", a.get("Analysis"));
                            LOG.debug("Inherited analysis from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                        }
                        if (StringUtils.notEmpty(a.get("Protocol of Research"))) {
                            artifact.set("Inherited Protocol of Research", a.get("Protocol of Research"));
                            LOG.debug("Inherited protocol of research from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                        }
                    }
                }
                if (StringUtils.notEmpty(a.get("Protocol of Research - OLD"))) {
                    artifact.set("Inherited Protocol of Research", a.get("Protocol of Research - OLD"));
                    LOG.debug("Inherited protocol of research from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                }
                if (StringUtils.notEmpty(a.get("Risk Log - Aufgaben zur Kl\u00e4rung"))) {
                    artifact.set("Inherited Protocol of Research", a.get("Risk Log - Aufgaben zur Kl\u00e4rung"));
                    LOG.debug("Inherited protocol of research from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
                }
                if (!StringUtils.notEmpty(a.get("Protokoll"))) continue;
                artifact.set("Inherited Protocol of Research", a.get("Protokoll"));
                LOG.debug("Inherited protocol of research from {} to {}.", (Object)a.deriveQualifier(), (Object)artifact.deriveQualifier());
            }
        }
        for (Artifact artifact : inventory.getArtifacts()) {
            String artifactId;
            if (!StringUtils.isEmpty(artifact.getVersion()) || !StringUtils.notEmpty(artifact.getId()) || !(artifactId = artifact.getId()).contains("_")) continue;
            artifact.setArtifactId(artifactId.substring(0, artifactId.lastIndexOf("_")));
            artifact.setVersion(artifactId.substring(artifactId.lastIndexOf("_") + 1, artifactId.length() - 4));
        }
    }

    public static void removeEmptyAttributes(Inventory inventory) {
        Set attributes = InventoryUtils.collectArtifactAttributes((Inventory)inventory);
        for (String attribute : new ArrayList(attributes)) {
            Optional<String> first = inventory.getArtifacts().stream().map(a -> a.get(attribute)).filter(StringUtils::hasText).findFirst();
            if (first.isPresent()) continue;
            InventoryUtils.removeArtifactAttribute((String)attribute, (Inventory)inventory);
            attributes.remove(attribute);
        }
    }

    public static void mergeReferenceArtifactAttributes(InventoryResource sourceInventoryResource, InventoryResource referenceInventoryResource, boolean includeIdMatches) {
        Inventory referenceInventory = referenceInventoryResource.getInventory();
        for (Artifact artifact : sourceInventoryResource.getInventory().getArtifacts()) {
            Artifact referenceArtifact = InventoryUtils.matchIdentifiedArtifact(artifact, referenceInventory, includeIdMatches);
            if (referenceArtifact == null) continue;
            System.out.println("Merging artifact: " + artifact.getId());
            artifact.merge(referenceArtifact);
        }
    }

    public static Artifact matchIdentifiedArtifact(Artifact artifact, Inventory referenceInventory, boolean includeIdMatches) {
        List allWithId;
        Artifact referenceMatch = referenceInventory.findArtifactByIdAndChecksum(artifact.getId(), artifact.getChecksum());
        if (referenceMatch == null && StringUtils.hasText(artifact.getGroupId())) {
            artifact.deriveArtifactId();
            if (StringUtils.hasText(artifact.getArtifactId())) {
                referenceMatch = referenceInventory.findArtifact(artifact.getGroupId(), artifact.getArtifactId());
            }
        }
        if (referenceMatch == null && includeIdMatches && (allWithId = referenceInventory.findAllWithId(artifact.getId())).size() != 0) {
            referenceMatch = (Artifact)allWithId.get(0);
            if (allWithId.size() > 1) {
                LOG.warn("Multiple artifacts in reference inventory matching id-only: [{}]. Picking first match.", (Object)artifact.getId());
            }
        }
        return referenceMatch;
    }

    static {
        filterFullList = new HashSet<String>();
        filterFullList.add("(c) MethodHandle mh MethodHandle");
        filterFullList.add("(c) ECFieldElement A1");
        filterFullList.add("(c) Nat224.isOne");
        filterFullList.add("(c) Epsi (c)");
        filterFullList.add("(c) Ia\u001aIu (c) Y");
        filterFullList.add("(c) IoIof (c)");
        filterFullList.add("(c) iu.&apos;e iuiu.be");
        filterFullList.add("(c) KE- (c) K");
        filterFullList.add("(c) m (c) D");
        filterFullList.add("(c) \u0004I (c) I\n(c) \u0005a1/2 (c) I");
        filterFullList.add("(c) \u0000\u0002\u0003K\u0001IoIo\u0000\u0002\u0003K\u0001I (c) I");
        filterFullList.add("(c) X\"\u0000zE (c) ID");
        filterFullList.add("?");
        filterFullList.add("Apache Maven");
        filterFullList.add("A. (c) B. (c)");
        filterFullList.add("[(c) AIQAEBnI L]");
        filterFullList.add("(c) deg (c) A]");
        filterFullList.add("A9 (c)");
        filterFullList.add("|C/!23th'yuyPy*y,y1yoy th1/4th1/2y3/4th?yAuAn\u0006A1/2* (c) Y");
        filterFullList.add("$', RegexOptions.None, abac', Pass. Group");
        filterFullList.add("$? (c) Y");
        filterFullList.add("$?1/2P u,O / !- http://www.wretch.cc/blog/fsj&article_id");
        filterFullList.add("(c) (c) (c) (c) (c) (c) (c) (c) A989 A98A");
        filterFullList.add("(c) A");
        filterFullList.add("(c) and G G G");
        filterFullList.add("(c) COMMA");
        filterFullList.add("(c) CSTYLED");
        filterFullList.add("(c) CTRLC");
        filterFullList.add("(c) QUIT");
        filterFullList.add("(c) UNDEFINED");
        filterFullList.add("(r)+-u,o 1/4AAEEIIOO\u0013xUUThssaaaceeeiiiiddnnooouoooAoUoynyd@iiiieeecaeaaassThUUxOONIIEEAEAAAAou-a!3+- (c) Y");
        filterFullList.add(",$?o2Y$?1$? <$?E'O$?1$?e3/4UoU$?I!$?EI$?I http://www.w3.org/TR/NOTE-sgml-xml'>");
        filterFullList.add("(c). (c)");
        filterFullList.add("(c). (R). End");
        filterFullList.add("(c). .It Ar");
        filterFullList.add("(c). A");
        filterFullList.add("(c). C");
        filterFullList.add("(c). C1B");
        filterFullList.add("(c). cipher/blowfish-arm.S Ditto");
        filterFullList.add("(c). D.");
        filterFullList.add("(c). END T2");
        filterFullList.add("(c). Explicitly");
        filterFullList.add("(c). FAILED");
        filterFullList.add("(c). Genera");
        filterFullList.add("(c). I1 CONSTANT");
        filterFullList.add("(c). inline UBool");
        filterFullList.add("(c). Instead group");
        filterFullList.add("(c). intel/eu Fix");
        filterFullList.add("(c). Looping");
        filterFullList.add("(c). LxuGAU");
        filterFullList.add("(c). Op1");
        filterFullList.add("(c). Seemingly");
        filterFullList.add("(c). Set");
        filterFullList.add("(c). Similarly");
        filterFullList.add("(c). TESTS");
        filterFullList.add("(c). Therefore");
        filterFullList.add("(c). Thus");
        filterFullList.add("(c). trans-common.c Forward");
        filterFullList.add("(c). Try");
        filterFullList.add("(c). UnicodeString");
        filterFullList.add("(c). We'll");
        filterFullList.add("(c). xT6,g MxtE99");
        filterFullList.add("(c).all Sections (First).all then Group");
        filterFullList.add("(c)1 a (c) I");
        filterFullList.add("(c)1 e (c) I");
        filterFullList.add("Copyright $y. $z Free Software Foundation");
        filterFullList.add("Copyright $year Free Software Foundation, Inc.");
        filterFullList.add("(c) 1947 Editions Gallimard");
        filterFullList.add("(c) 2/I Capture group");
        filterFullList.add("(c) <2014>");
        filterFullList.add("(c) <2015>");
        filterFullList.add("(c) A F0");
        filterFullList.add("(c) A M1Nj");
        filterFullList.add("(c) ASSERT valid, Failure");
        filterFullList.add("(c) Attribut BIND");
        filterFullList.add("(c) BasicBlock Entry");
        filterFullList.add("(c) BasicBlock EntryBB");
        filterFullList.add("(c) BLANK Fortran");
        filterFullList.add("(c) Bob Smith");
        filterFullList.add("(c) BOOL F1");
        filterFullList.add("(c) Borrowed pragma Assert");
        filterFullList.add("(c) BranchInst BI BranchInst::Create(Exit, Exit, False, Entry)");
        filterFullList.add("(c) C (c) 0BA11AB");
        filterFullList.add("(c) C . C");
        filterFullList.add("(c) C C.Next");
        filterFullList.add("(c) C EOF. Modern");
        filterFullList.add("(c) C Fz");
        filterFullList.add("(c) C Scope");
        filterFullList.add("(c) C Temp");
        filterFullList.add("(c) C/ (c) PS");
        filterFullList.add("(c) CAEC/$?eEC/AIUxIC http://www.w3.org/XML");
        filterFullList.add("(c) CMD Coding Method Delimiter E CNL Cursor Next Line E Pn");
        filterFullList.add("(c) co");
        filterFullList.add("(c) Col Col");
        filterFullList.add("(c) Communication Foundation");
        filterFullList.add("(c) Constant NullV2I32Ptr");
        filterFullList.add("(c) Constant One");
        filterFullList.add("(c) Constant PosDividendC");
        filterFullList.add("(c) Constant PosDivisorC");
        filterFullList.add("(c) ConstantInt C2");
        filterFullList.add("(c) CopFILE (c)");
        filterFullList.add("(c) CopFILESV (c)");
        filterFullList.add("(c) DaI (c)");
        filterFullList.add("(c) Di3jSS (c)");
        filterFullList.add("(c) Dingsbums GmbH");
        filterFullList.add("(c) Frobby Inc.");
        filterFullList.add("(c) E AIUeIACIy");
        filterFullList.add("(c) Ee-EaEuE OIuI");
        filterFullList.add("(c) EFa4 (c)");
        filterFullList.add("(c) EO*eUxICEI http://www.w3.org/TR/NOTE-sgml-xml'");
        filterFullList.add("(c) ErrMsg CodeView Error");
        filterFullList.add("(c) ErrMsg DIA Error");
        filterFullList.add("(c) ErrMsg MSF Error");
        filterFullList.add("(c) ErrMsg Native PDB Error");
        filterFullList.add("(c) ErrMsg PDB Error");
        filterFullList.add("(c) ErrMsg Stream Error");
        filterFullList.add("(c) ExifDataType dt ExifEntry");
        filterFullList.add("(c) expose one performance counter group");
        filterFullList.add("(c) EYe3ee (c)");
        filterFullList.add("(c) E|ESSE|E (c) I");
        filterFullList.add("(c) FcChar16 numbers FcCharSetNumbers");
        filterFullList.add("(c) FcFontSet new FcFontSetCreate");
        filterFullList.add("(c) FE Found M88RS2000");
        filterFullList.add("(c) FE Found Stv0288 6LME2510");
        filterFullList.add("(c) FE Found Stv0299 6LME2510");
        filterFullList.add("(c) Firmware Status");
        filterFullList.add("(c) FOR NON-MODEL NUMBERS");
        filterFullList.add("(c) FRM Changing");
        filterFullList.add("(c) FRM Could");
        filterFullList.add("(c) FRM Firmware Cold Reset");
        filterFullList.add("(c) FRM Firmware Download Completed - Resetting Device");
        filterFullList.add("(c) FRM Firmware Download Completed - Resetting Device 6LME2510");
        filterFullList.add("(c) FRM Firmware Download Failed");
        filterFullList.add("(c) FRM Starting Firmware Download 6LME2510");
        filterFullList.add("(c) From FuncId");
        filterFullList.add("(c) FunctionType FnTy");
        filterFullList.add("(c) FunctionType FTy");
        filterFullList.add("(c) GlobalVariable Handle");
        filterFullList.add("(c) group");
        filterFullList.add("(c) I Ci Es @ AEuAI");
        filterFullList.add("(c) I ISSE\"I\"IaD (c) I");
        filterFullList.add("(c) I Write/Read Mangled Y");
        filterFullList.add("(c) I\"I (c) I");
        filterFullList.add("(c) I\"I (c) ISSI");
        filterFullList.add("(c) I\"I\"I (c) I");
        filterFullList.add("(c) I\"I\"I\"EaI\"I (c) I");
        filterFullList.add("(c) I$?iAT g3eCXMLdT g*e http://www.w3.org/XML");
        filterFullList.add("(c) Ia VXefBNgIOADLL EoCh3eAC/eae$?A*BeuA Internet ExploreaWindows Media PlayerIWIT");
        filterFullList.add("(c) IaeH, ANH");
        filterFullList.add("(c) IaI (c)");
        filterFullList.add("(c) IAvP VADLL");
        filterFullList.add("(c) IDi (c)");
        filterFullList.add("(c) Ie$?R\u007fO (c) R");
        filterFullList.add("(c) INT Interrupt Service Started 6LME2510");
        filterFullList.add("(c) INT Unable");
        filterFullList.add("(c) intermediateCerts.Add");
        filterFullList.add("(c) Interrupt Service Stopped");
        filterFullList.add("(c) Interrupt Service Stopped 6LME2510");
        filterFullList.add("(c) Ioiia (c)");
        filterFullList.add("(c) ISALPHA (c) ISDIGIT");
        filterFullList.add("(c) isALPHANUMERIC (c) UNDEFINED");
        filterFullList.add("(c) IsDigit (c)");
        filterFullList.add("(c) isdigit (c) C");
        filterFullList.add("(c) ISLETTER (c) DIGIT");
        filterFullList.add("(c) IsNetbiosSplChar (c)");
        filterFullList.add("(c) ISSE\"ISSI I (c) E");
        filterFullList.add("(c) ISSIaI (c)");
        filterFullList.add("(c) ISSI|E N (c) I");
        filterFullList.add("(c) isSPACE (c) UNDEFINED");
        filterFullList.add("(c) isWORDCHAR (c) UNDEFINED");
        filterFullList.add("(c) It's OK");
        filterFullList.add("(c) I|ESSE|E (c) ESSE");
        filterFullList.add("(c) K97I V3m");
        filterFullList.add("(c) l (c) L");
        filterFullList.add("(c) L'attribut BIND");
        filterFullList.add("(c) Last Free");
        filterFullList.add("(c) LIMITED");
        filterFullList.add("(c) LLVMContextDispose (c)");
        filterFullList.add("(c) mc_latency_mclk.full");
        filterFullList.add("(c) MEM Error");
        filterFullList.add("(c) Metadata Ops MD");
        filterFullList.add("(c) MidLetter or MidNumLet");
        filterFullList.add("(c) Mnemonic C's");
        filterFullList.add("(c) Na o Io io Ks ks Ps");
        filterFullList.add("(c) Object o Hello");
        filterFullList.add("(c) Offset C- Offset");
        filterFullList.add("(c) OkRaR (c)");
        filterFullList.add("(c) Old Old");
        filterFullList.add("(c) OR'OR'OR (c) O SR");
        filterFullList.add("(c) OR'OR'OR (c) OO");
        filterFullList.add("(c) OR'OR'OR c'OR co'OR (c) O SR");
        filterFullList.add("(c) Outchar OO");
        filterFullList.add("(c) oY X2 PAdeg\"ao+-!ap!C! degN|O$?U+-,N !!A\"A1/2DdegN|O!G ??? http://phorum.vb...");
        filterFullList.add("(c) oY X2 PAdeg\"ao+-!ap!C! degN|O$?U+-,N !!A\"A1/2DdegN|O!G ??? http://phorum.vb... / property og:url content http://www.wretch.cc/blog/fsj/3269525");
        filterFullList.add("(c) p type(b) bv");
        filterFullList.add("(c) P2 (B) P3");
        filterFullList.add("(c) Page i/o Todo/Under");
        filterFullList.add("(c) Pas de branchement Pas d'appel");
        filterFullList.add("(c) PointerType InitPtrType InitValue");
        filterFullList.add("(c) pragma mangle, clock$UNIX2003");
        filterFullList.add("(c) r (c) R");
        filterFullList.add("(c) R Value");
        filterFullList.add("(c) RaAERR (c)");
        filterFullList.add("(c) readpng2$ (c) PROGHDRS");
        filterFullList.add("(c) Remove (PROTO) Remove (.PHONY) Remove C and PROTO");
        filterFullList.add("(c) Scale 1 Offset");
        filterFullList.add("(c) SE0o OS");
        filterFullList.add("(c) SelectInst SelI");
        filterFullList.add("(c) SmallVector MDs");
        filterFullList.add("(c) SmallVector ToErase");
        filterFullList.add("(c) SmallVector Types FnPtrTy, FnPtrTy, PromiseType");
        filterFullList.add("(c) State UNQUOTED");
        filterFullList.add("(c) StringWriter sw HtmlTextWriter");
        filterFullList.add("(c) t (c) T");
        filterFullList.add("(c) Temp. (F) Summary");
        filterFullList.add("(c) Th (c)");
        filterFullList.add("(c) TitlecaseLetter E");
        filterFullList.add("(c) TUN Found");
        filterFullList.add("(c) TUN Found Frontend TDA10086");
        filterFullList.add("(c) Type ArgTys Int32Ty, Int32Ty, Int32Ty FunctionType FnTy");
        filterFullList.add("(c) Type ArgTys Int32Ty, Int32Ty, Int32Ty Type FnTy");
        filterFullList.add("(c) Type AtExitFuncArgs VoidStar FunctionType AtExitFuncTy");
        filterFullList.add("(c) Type DoubleTy");
        filterFullList.add("(c) Type FloatTy");
        filterFullList.add("(c) Type FnTy");
        filterFullList.add("(c) Type I1Ty");
        filterFullList.add("(c) Type I32PtrTy");
        filterFullList.add("(c) Type I32Ty");
        filterFullList.add("(c) Type Int16Ty");
        filterFullList.add("(c) Type Int32PtrTy");
        filterFullList.add("(c) Type Int32Ty");
        filterFullList.add("(c) Type Int64PtrTy");
        filterFullList.add("(c) Type Int64Ty");
        filterFullList.add("(c) Type Int8Ty");
        filterFullList.add("(c) Type V8x8Ty");
        filterFullList.add("(c) u (c) P");
        filterFullList.add("(c) u (c) U");
        filterFullList.add("(c) U3269 CIRCLED");
        filterFullList.add("(c) Unlock (c)");
        filterFullList.add("(c) Value A");
        filterFullList.add("(c) Value AllocA");
        filterFullList.add("(c) Value Alloca");
        filterFullList.add("(c) Value AllocaA");
        filterFullList.add("(c) Value Elt0");
        filterFullList.add("(c) Value RHS");
        filterFullList.add("(c) Value Sd");
        filterFullList.add("(c) various MONO");
        filterFullList.add("(c) VectorType Int8PtrVecTy");
        filterFullList.add("(c) x (c) O");
        filterFullList.add("(c) X1 ... X1");
        filterFullList.add("(c) Xhadcnt 1 Xcnt");
        filterFullList.add("(c) YPe A");
        filterFullList.add("(c) Yu C");
        filterFullList.add("(c) Yu L");
        filterFullList.add("(c) z (c) Z");
        filterFullList.add("(c) ZA'-x'E1/2 JU Co");
        filterFullList.add("(c) | (c) PSF");
        filterFullList.add("(c) | (c) SS");
        filterFullList.add("(c), (bv)- bv_len");
        filterFullList.add("(c), (bv)- bv_len (dst)- bv_len (dst)- bv_val");
        filterFullList.add("(c), (c)");
        filterFullList.add("(c), AnsiChar Array");
        filterFullList.add("(c), FcCacheDirs (c)");
        filterFullList.add("(c), FcCharSetLeaves (c)");
        filterFullList.add("AMDGPUMangledLibFunc (c) From");
        filterFullList.add("AttrOf (c) ChAttrOf (c)");
        filterFullList.add("AttrOf (c), GetPair (c)");
        filterFullList.add("BeeYeaaODIUUOxOEdeaodioonooithyua (c) (c)");
        filterFullList.add("Bind (c)");
        filterFullList.add("BuildProjectForSingleTaskItem '$ (c) CheckItems");
        filterFullList.add("BuildProjectForSingleTaskItem '$(D)$ (c) CheckItems");
        filterFullList.add("C. copyright D. (c)");
        filterFullList.add("CharOf (c) ChCharOf (c)");
        filterFullList.add("Chars (c) Chars");
        filterFullList.add("Context (c) LineToUnit");
        filterFullList.add("Conventions, Example, Copyright, Top");
        filterFullList.add("Copr GbE SKU");
        filterFullList.add("Copr. Self-extracting PKZIP");
        filterFullList.add("CopyrightText Copyright (c)");
        filterFullList.add("CreateChangedMethodDecl (c), CreateChangingMethodDecl (c)");
        filterFullList.add("Emit (c) First");
        filterFullList.add("EventWatcher (c) BindingContext");
        filterFullList.add("EventWatcher (c) ContextMenu");
        filterFullList.add("EventWatcher (c) ContextMenuStrip");
        filterFullList.add("EventWatcher (c) Font");
        filterFullList.add("EventWatcher (c) Image");
        filterFullList.add("EventWatcher (c) Region");
        filterFullList.add("Fix (c)");
        filterFullList.add("Fix copyright Make");
        filterFullList.add("Foo (c) Bar");
        filterFullList.add("Found bind (c)");
        filterFullList.add("GetColumnName (c), GetColumnTSqlType (c)");
        filterFullList.add("GvQ3O4A (c) W2");
        filterFullList.add("H-c copyright H-a");
        filterFullList.add("IaeH, ANH (c) IaeH");
        filterFullList.add("IAo3eAAAE (c) (c)");
        filterFullList.add("IdI WAOd ACfgAC/ (c) IpublicE");
        filterFullList.add("Info. xref");
        filterFullList.add("InitCache (c) TransferBatch");
        filterFullList.add("Interface (c)");
        filterFullList.add("IsHighSurrogate (c) IsLowSurrogate (c)");
        filterFullList.add("Kind (c) Reference");
        filterFullList.add("len (c) Explicit");
        filterFullList.add("LxuG (c)");
        filterFullList.add("MemTotal (c) Bytes");
        filterFullList.add("Name copyright Type");
        filterFullList.add("NonPod (c), Inter");
        filterFullList.add("O4 (c) WCn");
        filterFullList.add("Omitted (c)");
        filterFullList.add("OutCopFILE (c) CopFILE (c)");
        filterFullList.add("Power (c) State");
        filterFullList.add("ReadOnlyCollection (c) Array");
        filterFullList.add("Result (c) First");
        filterFullList.add("Result (c) Last");
        filterFullList.add("rr");
        filterFullList.add("Scope (c) Ctyp");
        filterFullList.add("Sloc (c) Ix");
        filterFullList.add("Specifies Copyright Filename");
        filterFullList.add("TextSyndicationContent copyright ExtensibleSyndicationObject");
        filterFullList.add("ToolStripControlHost (c) ToolStrip");
        filterFullList.add("UnicodeString src (c) UnicodeString");
        filterFullList.add("UnicodeString srcStr (c) UnicodeString");
        filterFullList.add("UnicodeString str (c) UErrorCode");
        filterFullList.add("Unlock (c) Unlock");
        filterFullList.add("(c) $? (c) Y");
        filterFullList.add("(c) (3) public benefit corporation");
        filterFullList.add("(c) (c) (c) (c) (c) (c) (c) (c) (c) A989 A98A");
        filterFullList.add("(c) (c) A");
        filterFullList.add("(c) (c) and G G G");
        filterFullList.add("(c) (c) COMMA");
        filterFullList.add("(c) (c) CSTYLED");
        filterFullList.add("(c) (c) CTRLC");
        filterFullList.add("(c) (c) QUIT");
        filterFullList.add("(c) (c) UNDEFINED");
        filterFullList.add("(c) . (c)");
        filterFullList.add("(c) . (R). End");
        filterFullList.add("(c) . .It Ar");
        filterFullList.add("(c) . A");
        filterFullList.add("(c) . C");
        filterFullList.add("(c) . C1B");
        filterFullList.add("(c) . cipher/blowfish-arm.S Ditto");
        filterFullList.add("(c) . D.");
        filterFullList.add("(c) . END T2");
        filterFullList.add("(c) . Explicitly");
        filterFullList.add("(c) . FAILED");
        filterFullList.add("(c) . Genera");
        filterFullList.add("(c) . I1 CONSTANT");
        filterFullList.add("(c) . inline UBool");
        filterFullList.add("(c) . Instead group");
        filterFullList.add("(c) . intel/eu Fix");
        filterFullList.add("(c) . Looping");
        filterFullList.add("(c) . LxuGAU");
        filterFullList.add("(c) . Op1");
        filterFullList.add("(c) . Seemingly");
        filterFullList.add("(c) . Set");
        filterFullList.add("(c) . Similarly");
        filterFullList.add("(c) . TESTS");
        filterFullList.add("(c) . Therefore");
        filterFullList.add("(c) . Thus");
        filterFullList.add("(c) . trans-common.c Forward");
        filterFullList.add("(c) . Try");
        filterFullList.add("(c) . UnicodeString");
        filterFullList.add("(c) . We'll");
        filterFullList.add("(c) . xT6,g MxtE99");
        filterFullList.add("(c) .all Sections (First).all then Group");
        filterFullList.add("(c) 1 a (c) I");
        filterFullList.add("(c) 1 e (c) I");
        filterFullList.add("(c) \"|C/!23th'yuyPy*y,y1yoy th1/4th1/2y3/4th?yAuAn\u0006A1/2* (c) Y");
        filterFullList.add("(c) $', RegexOptions.None, abac', Pass. Group");
        filterFullList.add("c) $? (c) Y");
        filterFullList.add("(c) $?1/2P u,O / !- http://www.wretch.cc/blog/fsj&article_id");
        filterFullList.add("(c) (r)+-u,o 1/4AAEEIIOO\u0013xUUThssaaaceeeiiiiddnnooouoooAoUoynyd@iiiieeecaeaaassThUUxOONIIEEAEAAAAou-a!3+- (c) Y");
        filterFullList.add("(c) ,$?o2Y$?1$? <$?E'O$?1$?e3/4UoU$?I!$?EI$?I http://www.w3.org/TR/NOTE-sgml-xml'>");
        filterFullList.add("(c) d (c) D");
        filterFullList.add("(c) e (c) E");
        filterFullList.add("(c) i (c) I");
        filterFullList.add("(c) e+-RcEEex$?I$?ReAEAE3/4Rceekcee$?R\u007fO (c) R");
        filterFullList.add("(c) U,AE:IF\u0014q BVhF'$");
        filterFullList.add("(c) iX3/4\bOiMPSAi-Tss5Edeg (c) NU");
        INTERNAL_COLUMNS = new HashSet();
        INTERNAL_COLUMNS.add("Analysis");
        INTERNAL_COLUMNS.add(Artifact.Attribute.ROOT_PATHS.getKey());
        INTERNAL_COLUMNS.add("Protocol of Research");
        INTERNAL_COLUMNS.add("Source Project");
        INTERNAL_COLUMNS.add("Source Inventory");
        INTERNAL_COLUMNS.add("Inventory Source");
        INTERNAL_COLUMNS.add(INVENTORY_KEY_LICENSE_DIFF_SRC_BIN);
        INTERNAL_COLUMNS.add("Task");
        INTERNAL_COLUMNS.add("Tasks");
        INTERNAL_COLUMNS.add("Validation Mode");
        INTERNAL_COLUMNS.add("License Text");
        INTERNAL_COLUMNS.add("MANIFEST.MF/JAR (Bundled License Information)");
        INTERNAL_COLUMNS.add("Notice.txt");
        INTERNAL_COLUMNS.add("Review Remark");
        INTERNAL_COLUMNS.add("Notice Parameter");
        INTERNAL_COLUMNS.add("Derived ArtifactId (POM)");
        INTERNAL_COLUMNS.add("Derived Component (POM)");
        INTERNAL_COLUMNS.add("Derived GroupId (POM)");
        INTERNAL_COLUMNS.add("Derived Version (POM)");
        INTERNAL_COLUMNS.add("Filtered Terms");
        INTERNAL_COLUMNS.add("Identified Terms");
        INTERNAL_COLUMNS.add("Comment");
        INTERNAL_COLUMNS.add("Copyright Notice");
        INTERNAL_COLUMNS.add("Header Text Copy");
        INTERNAL_COLUMNS.add("Ignored Terms");
        INTERNAL_COLUMNS.add("Latest Version");
        INTERNAL_COLUMNS.add("Content Checksum (MD5)");
        INTERNAL_COLUMNS.add("Content MD5");
        INTERNAL_COLUMNS.add("Archive Path");
        INTERNAL_COLUMNS.add("Derived Notice Parameter");
        INTERNAL_COLUMNS.add("Diff - Derived License / Scancode");
        INTERNAL_COLUMNS.add("Extracted Copyrights (ScanCode)");
        INTERNAL_COLUMNS.add("Extracted Authors (ScanCode)");
        INTERNAL_COLUMNS.add(INVENTORY_KEY_LICENSE_DIFF);
        INTERNAL_COLUMNS.add("License Expressions (ScanCode)");
        INTERNAL_COLUMNS.add("POM - Derived ArtifactId (POM)");
        INTERNAL_COLUMNS.add("POM - Derived Component (POM)");
        INTERNAL_COLUMNS.add("POM - Derived GroupId (POM)");
        INTERNAL_COLUMNS.add("POM - Derived Licenses (POM)");
        INTERNAL_COLUMNS.add("POM - Derived Licenses (ScanCode)");
        INTERNAL_COLUMNS.add("POM - Derived POM Licenses");
        INTERNAL_COLUMNS.add("POM - Derived Version (POM)");
        INTERNAL_COLUMNS.add("POM - Extracted Authors (ScanCode)");
        INTERNAL_COLUMNS.add("POM - Extracted Copyrights (ScanCode)");
        INTERNAL_COLUMNS.add("POM - Identified Terms");
        INTERNAL_COLUMNS.add("Source - Derived ArtifactId (POM)");
        INTERNAL_COLUMNS.add("Source - Derived Component (POM)");
        INTERNAL_COLUMNS.add("Source - Derived GroupId (POM)");
        INTERNAL_COLUMNS.add("Source - Derived License (POM)");
        INTERNAL_COLUMNS.add("Source - Derived Licenses (POM)");
        INTERNAL_COLUMNS.add("Source - Derived Licenses (ScanCode)");
        INTERNAL_COLUMNS.add("Source - Derived Version (POM)");
        INTERNAL_COLUMNS.add("Source - Extracted Authors (ScanCode)");
        INTERNAL_COLUMNS.add("Source - Extracted Copyrights (ScanCode)");
        INTERNAL_COLUMNS.add("Source - Filtered Terms");
        INTERNAL_COLUMNS.add("Source - Identified Terms");
        INTERNAL_COLUMNS.add("Source - Ignored Terms");
    }
}

