/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SegmentationUtils {
    public Map<String, List<String>> getLicenseFileMap(File metascanResultJson, boolean segmentAsNumber) throws IOException {
        HashMap<String, List<String>> licenseFileMap = new HashMap<String, List<String>>();
        JSONArray files = new JSONArray(FileUtils.readFileToString((File)metascanResultJson, (Charset)StandardCharsets.UTF_8));
        for (int i = 0; i < files.length(); ++i) {
            JSONObject file = files.optJSONObject(i);
            if (file == null) continue;
            String fileName = file.optString("file");
            JSONObject segments = file.optJSONObject("segments");
            if (segments == null) continue;
            for (String segment : segments.keySet()) {
                JSONArray resolvedLicensesObject = segments.optJSONObject(segment).optJSONArray("resolvedLicenses");
                if (resolvedLicensesObject == null) continue;
                ArrayList<String> resolvedLicenses = new ArrayList<String>();
                for (int j = 0; j < resolvedLicensesObject.length(); ++j) {
                    resolvedLicenses.add(resolvedLicensesObject.optString(j));
                }
                for (String license : resolvedLicenses) {
                    String asNumber = "/" + fileName + "/" + segment.substring(segment.indexOf("-") + 1);
                    if (!licenseFileMap.containsKey(license)) {
                        ArrayList<String> fileList = new ArrayList<String>();
                        if (segmentAsNumber) {
                            fileList.add(asNumber);
                        } else {
                            fileList.add("/" + fileName + "/" + segment);
                        }
                        licenseFileMap.put(license, fileList);
                        continue;
                    }
                    if (segmentAsNumber) {
                        ((List)licenseFileMap.get(license)).add(asNumber);
                        continue;
                    }
                    ((List)licenseFileMap.get(license)).add("/" + fileName + "/" + segment);
                }
            }
        }
        return licenseFileMap;
    }
}

