/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;

public abstract class SnakeYamlParser {
    public static Yaml createDefaultYaml() {
        return new Yaml();
    }

    public static Yaml createNoTimestampYaml() {
        return new Yaml((BaseConstructor)new NoTimestampParserConstructor());
    }

    public static LinkedHashMap<String, Object> parseYamlAsMap(Yaml yaml, File file) throws IOException {
        return SnakeYamlParser.parseYamlAsMap(yaml, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static LinkedHashMap<String, Object> parseYamlAsMap(Yaml yaml, InputStream inputStream) {
        return (LinkedHashMap)yaml.load(inputStream);
    }

    public static Object parseYaml(Yaml yaml, File file) throws IOException {
        return SnakeYamlParser.parseYaml(yaml, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static Object parseYaml(Yaml yaml, InputStream inputStream) {
        return yaml.load(inputStream);
    }

    public static List<Object> parseYamlAsList(Yaml yaml, File file) throws IOException {
        return SnakeYamlParser.parseYamlAsList(yaml, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static List<Object> parseYamlAsList(Yaml yaml, InputStream inputStream) {
        return (List)yaml.load(inputStream);
    }

    public static class NoTimestampParserConstructor
    extends Constructor {
        public NoTimestampParserConstructor() {
            super(new LoaderOptions());
            this.yamlConstructors.put(Tag.TIMESTAMP, new SafeConstructor.ConstructYamlStr((SafeConstructor)this));
        }
    }
}

