/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.SimpleIntPair;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class StringStats {
    private static final Pattern PATTERN_WHITESPACES = Pattern.compile("[\\r\\n\\s]+");
    private static final Pattern PATTERN_TEMPLATE_DELIMITER = Pattern.compile("\\.\\\\\" ");
    private static final Pattern PATTERN_DNL_SEPARATOR = Pattern.compile(" dnl ");
    private static final Pattern PATTERN_HYPHEN_LOWERCASE = Pattern.compile("([a-z]{2}) - ([a-z]{2})");
    private static final Pattern PATTERN_HYPHEN_UPPERCASE = Pattern.compile("([A-Z]{2}) - ([A-Z]{2})");
    private static final Pattern PATTERN_COMMA = Pattern.compile(" , ");
    private static final Pattern PATTERN_SIMPLE_WILDCARD = Pattern.compile("\\*");
    private static final Pattern PATTERN_WILDCARD_ORIGINAL = Pattern.compile("\\*\\{|}\\*");
    private static final Pattern FAILURE_PATTERN = Pattern.compile("(\\*\\{.*)|(.*}\\*)");
    public static final String QUOTES = "\"'`\u00b4\u2018\u2019\u201c\u201d";
    public static final String SEPARATORS = "():;,.\\!?=+-_[]{}<>";
    public static final String COMMENT_NO_WILDCARD = "\\/|#";
    public static final String COMMENT_WITH_WILDCARD = "\\*/|#";
    public static final String MARKER = "##MARKER##";
    public static final String PREFIX_REGEXP = "^";
    public static final SimpleIntPair PAIR_NO_MATCH = SimpleIntPair.of(-1, -1);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int[] FAILURE_INT = new int[]{-1};
    private final String originalString;
    private final boolean isImmutable;
    private String normalizedString;
    private String normalizedStringLowerCase;
    private final transient Map<String, SimpleIntPair> indexOfCache = new HashMap<String, SimpleIntPair>();
    private static final Map<String, StringStats> STRINGSTAT_PERM_CACHE = Collections.synchronizedMap(new HashMap());
    private static final Map<String, StringStats> STRINGSTAT_TEMP_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private StringStats(String originalString, boolean isMatch, boolean isSubmatch) {
        this.originalString = originalString.trim();
        this.isImmutable = isMatch || isSubmatch;
        this.normalizedString = this.normalizeInternal(this.originalString, isMatch, isSubmatch);
        this.normalizedStringLowerCase = this.normalizedString.toLowerCase();
    }

    public static StringStats normalize(String originalString, boolean isMatch, boolean isSubmatch) {
        Map<String, StringStats> cache = isSubmatch ? STRINGSTAT_TEMP_CACHE : (isMatch ? STRINGSTAT_PERM_CACHE : null);
        if (cache != null) {
            StringStats cached = cache.get(originalString);
            if (cached != null) {
                return cached;
            }
            StringStats newInstance = new StringStats(originalString, isMatch, isSubmatch);
            cache.put(originalString, newInstance);
            return newInstance;
        }
        return new StringStats(originalString, isMatch, isSubmatch);
    }

    private String normalizeInternal(String originalString, boolean isMatch, boolean isSubmatch) {
        int i;
        String normalized = originalString.trim();
        normalized = PATTERN_TEMPLATE_DELIMITER.matcher(normalized).replaceAll("");
        for (int i2 = 0; i2 < SEPARATORS.length(); ++i2) {
            char character = SEPARATORS.charAt(i2);
            normalized = normalized.replace(String.valueOf(character), " " + character + " ");
        }
        String enumerators = "\u2022\u00b0";
        for (i = 0; i < "\u2022\u00b0".length(); ++i) {
            normalized = normalized.replace("\u2022\u00b0".substring(i, i + 1), "-");
        }
        for (i = 0; i < QUOTES.length(); ++i) {
            normalized = normalized.replace(QUOTES.substring(i, i + 1), "");
        }
        String comments = isMatch ? COMMENT_NO_WILDCARD : COMMENT_WITH_WILDCARD;
        for (int i3 = 0; i3 < comments.length(); ++i3) {
            normalized = normalized.replace("" + comments.charAt(i3), " ");
        }
        if (!isSubmatch) {
            normalized = " " + normalized + " ";
        }
        normalized = PATTERN_DNL_SEPARATOR.matcher(normalized).replaceAll(" ");
        normalized = PATTERN_WHITESPACES.matcher(normalized).replaceAll(" ");
        normalized = PATTERN_HYPHEN_LOWERCASE.matcher(normalized).replaceAll("$1$2");
        normalized = PATTERN_HYPHEN_UPPERCASE.matcher(normalized).replaceAll("$1$2");
        normalized = PATTERN_COMMA.matcher(normalized).replaceAll(" ");
        normalized = PATTERN_WHITESPACES.matcher(normalized).replaceAll(" ");
        return normalized;
    }

    public final boolean contains(StringStats value, boolean caseSensitive) {
        return this.indexOf(value, caseSensitive).getLeft() > -1;
    }

    public final SimpleIntPair indexOf(StringStats value, boolean caseSensitive) {
        String searchString = value.getNormalizedString(!caseSensitive);
        String originalSearchString = value.getOriginalString();
        String cacheKey = caseSensitive ? searchString : searchString + "-false";
        SimpleIntPair cachedIndex = this.indexOfCache.get(cacheKey);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        String originalString = value.getOriginalString();
        if (originalString.startsWith(PREFIX_REGEXP)) {
            String replacedString = this.normalizedString.replaceFirst(originalString.substring(1), MARKER);
            int minIndex = replacedString.indexOf(MARKER);
            int replacedLength = this.normalizedString.length() - (replacedString.length() - MARKER.length());
            return this.cacheAndReturn(cacheKey, SimpleIntPair.of(minIndex, minIndex + replacedLength));
        }
        String baseString = this.getNormalizedString(!caseSensitive);
        if (originalSearchString.contains("*{")) {
            List<int[]> matches = this.matchRegexp(value);
            if (matches.isEmpty()) {
                return PAIR_NO_MATCH;
            }
            return this.cacheAndReturn(cacheKey, SimpleIntPair.of(matches.get(0)[0], matches.get(0)[1]));
        }
        if (searchString.contains("*")) {
            String[] searchStringElements = PATTERN_SIMPLE_WILDCARD.split(searchString);
            int minIndex = Integer.MAX_VALUE;
            int maxIndex = 0;
            int startIndex = 0;
            for (String searchStringElement : searchStringElements) {
                int index = baseString.indexOf(searchStringElement, startIndex);
                if (index == -1) {
                    return this.cacheAndReturn(cacheKey, PAIR_NO_MATCH);
                }
                startIndex = maxIndex = index + searchStringElement.length();
                if (minIndex != Integer.MAX_VALUE) continue;
                minIndex = index;
            }
            return this.cacheAndReturn(cacheKey, minIndex == Integer.MAX_VALUE ? PAIR_NO_MATCH : SimpleIntPair.of(minIndex, maxIndex));
        }
        int index = baseString.indexOf(searchString);
        return this.cacheAndReturn(cacheKey, index == -1 ? PAIR_NO_MATCH : SimpleIntPair.of(index, index + searchString.length()));
    }

    private SimpleIntPair cacheAndReturn(String cacheKey, SimpleIntPair indexPair) {
        this.indexOfCache.put(cacheKey, indexPair);
        return indexPair;
    }

    public String toString() {
        return this.normalizedString;
    }

    public int[] allMatchesOriginalString(StringStats matchStats) {
        return this.matchIndexes(matchStats, matchStats.getOriginalString());
    }

    public int[] allMatches(StringStats matchStats) {
        return this.matchIndexes(matchStats, matchStats.getNormalizedString());
    }

    public int[] matchIndexes(StringStats matchStats, String matchString) {
        int index;
        if (StringUtils.isEmpty(matchString)) {
            return EMPTY_INT_ARRAY;
        }
        if (matchString.contains("*")) {
            if (matchString.contains("* {")) {
                List<int[]> ints = this.matchRegexp(matchStats);
                int[] matches = new int[ints.size()];
                for (int i = 0; i < matches.length; ++i) {
                    matches[i] = ints.get(i)[0];
                }
                return matches;
            }
            throw new IllegalStateException("Plain wildcard not supported in match string " + matchStats.getOriginalString() + ". Use *{...}* pattern instead.");
        }
        String string = this.normalizedString;
        int length = matchString.length();
        int maxIndex = string.length() - length;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int fromIndex = 0;
        do {
            if ((index = string.indexOf(matchString, fromIndex)) == -1) continue;
            indexes.add(index);
            fromIndex = index + length;
        } while (index != -1 && fromIndex <= maxIndex);
        if (indexes.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        if (indexes.size() == 1) {
            int[] ints = new int[]{(Integer)indexes.get(0)};
            return ints;
        }
        int[] indexArray = new int[indexes.size()];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = (Integer)indexes.get(i);
        }
        return indexArray;
    }

    public List<int[]> matchRegexp(StringStats matchStats) {
        String originalSearchString = matchStats.getOriginalString();
        if (FAILURE_PATTERN.matcher(originalSearchString).matches()) {
            return Collections.singletonList(FAILURE_INT);
        }
        if (originalSearchString.contains("*{")) {
            String[] searchStringElements = PATTERN_WILDCARD_ORIGINAL.split(originalSearchString);
            int i = 0;
            ArrayList<int[]> results = new ArrayList<int[]>();
            for (String searchStringElement : searchStringElements) {
                if (i % 2 == 0) {
                    int[] matches = this.allMatches(StringStats.normalize(searchStringElement, true, true));
                    if (matches.length == 0) {
                        return new ArrayList<int[]>();
                    }
                    results.add(matches);
                }
                ++i;
            }
            List<int[]> matches = this.checkTriplet(searchStringElements, results, 0, new ArrayList<int[]>());
            matches.removeIf(ints -> ints[1] == 0);
            return matches;
        }
        return null;
    }

    private List<int[]> checkTriplet(String[] searchStringElements, List<int[]> indexes, int currentElement, List<int[]> tuples) {
        String searchStringLeft = searchStringElements[currentElement];
        String searchStringRight = searchStringElements[currentElement + 2];
        String normalizedLeft = StringStats.normalize(searchStringLeft, true, true).getNormalizedString();
        String normalizedRight = StringStats.normalize(searchStringRight, true, true).getNormalizedString();
        int halfWaysIndex = currentElement / 2;
        int[] indexLeft = indexes.get(halfWaysIndex);
        int[] indexRight = indexes.get(1 + halfWaysIndex);
        String regexp = searchStringElements[currentElement + 1];
        for (int indexCurrent : indexLeft) {
            for (int indexNext : indexRight) {
                int[] tuple;
                if (indexCurrent >= indexNext || indexCurrent + normalizedLeft.length() + 500 < indexNext || indexCurrent + normalizedLeft.length() > indexNext) continue;
                String toBeMatched = this.getNormalizedString().substring(indexCurrent + normalizedLeft.length(), indexNext);
                if (!(toBeMatched = toBeMatched.trim()).matches(regexp)) continue;
                if (currentElement == 0) {
                    tuple = new int[2];
                    tuple[0] = indexCurrent;
                    tuples.add(tuple);
                }
                if (currentElement == searchStringElements.length - 3) {
                    tuple = tuples.get(tuples.size() - 1);
                    tuple[1] = indexNext + normalizedRight.length();
                    continue;
                }
                this.checkTriplet(searchStringElements, indexes, currentElement + 2, tuples);
            }
        }
        return tuples;
    }

    public void update(String normalizedString) {
        if (this.isImmutable) {
            throw new IllegalStateException("Cannot modify immutable StringStats.");
        }
        this.normalizedString = normalizedString;
        this.normalizedStringLowerCase = normalizedString.toLowerCase();
    }

    public final String getNormalizedString(boolean lowercase) {
        return lowercase ? this.normalizedStringLowerCase : this.normalizedString;
    }

    public static StringStats normalize(String originalString, boolean isMatch) {
        return StringStats.normalize(originalString, isMatch, false);
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public String getNormalizedString() {
        return this.normalizedString;
    }

    public String getNormalizedStringLowerCase() {
        return this.normalizedStringLowerCase;
    }
}

