/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version;

import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import java.util.Arrays;
import java.util.Comparator;

public enum VersionModifier {
    DEV(-6, "development", "dev"),
    ALPHA(-5, "alpha"),
    BETA(-4, "beta"),
    MILESTONE(-3, "milestone"),
    RELEASE_CANDIDATE(-2, "release candidate", "rc"),
    GENERAL_AVAILABILITY(-1, "general availability", "ga"),
    STABLE(-1, "stable"),
    SNAPSHOT(-1, "snapshot"),
    NEUTRAL(0, "neutral_token"),
    REVISION(1, "revision", "rev"),
    PATCH(1, "patch"),
    UPDATE(2, "update"),
    TRIAL(2, "trial");

    private final int value;
    private final String[] names;
    public static final VersionToken NEUTRAL_TOKEN;
    public static final VersionModifier LOWEST_MODIFIER;

    private VersionModifier(int value, String ... names) {
        this.value = value;
        this.names = names;
    }

    public int getValue() {
        return this.value;
    }

    public String[] getNames() {
        return this.names;
    }

    public static VersionModifier fromStringName(String modifier) {
        for (VersionModifier versionModifier : VersionModifier.values()) {
            for (String name : versionModifier.getNames()) {
                if (!name.equalsIgnoreCase(modifier)) continue;
                return versionModifier;
            }
        }
        return null;
    }

    static {
        NEUTRAL_TOKEN = new VersionToken(VersionModifier.NEUTRAL.names[0], VersionTokenType.VERSION_MODIFIER);
        LOWEST_MODIFIER = Arrays.stream(VersionModifier.values()).min(Comparator.comparingInt(VersionModifier::getValue)).orElse(null);
    }
}

