/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation;

import com.metaeffekt.artifact.analysis.dashboard.Dashboard;
import com.metaeffekt.artifact.analysis.utils.JsonSchemaValidator;
import com.metaeffekt.artifact.analysis.utils.SnakeYamlParser;
import com.metaeffekt.artifact.analysis.version.curation.ConditionalCuratedVersionPartsExtractor;
import com.metaeffekt.artifact.analysis.version.curation.ExtractedCuratedVersionParts;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.networknt.schema.SpecVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONArray;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalCuratedVersionPartsExtractorCollection {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalCuratedVersionPartsExtractorCollection.class);
    private static final Map<String, ConditionalCuratedVersionPartsExtractorCollection> GLOBAL_NATIVE_MATCHERS = new LinkedHashMap<String, ConditionalCuratedVersionPartsExtractorCollection>();
    private final List<ConditionalCuratedVersionPartsExtractor> entries;

    public ConditionalCuratedVersionPartsExtractorCollection(List<ConditionalCuratedVersionPartsExtractor> entries) {
        this.entries = entries;
    }

    public ConditionalCuratedVersionPartsExtractorCollection() {
        this.entries = new ArrayList<ConditionalCuratedVersionPartsExtractor>();
    }

    public List<ConditionalCuratedVersionPartsExtractor> getEntries() {
        return this.entries;
    }

    public List<ConditionalCuratedVersionPartsExtractor> getMatchingExtractors(String version, VersionContext context) {
        ArrayList<ConditionalCuratedVersionPartsExtractor> matchingExtractors = new ArrayList<ConditionalCuratedVersionPartsExtractor>();
        for (ConditionalCuratedVersionPartsExtractor entry : this.entries) {
            if (!entry.matches(version, context)) continue;
            matchingExtractors.add(entry);
        }
        return matchingExtractors;
    }

    public JSONArray toJson() {
        JSONArray json = new JSONArray();
        for (ConditionalCuratedVersionPartsExtractor entry : this.entries) {
            json.put((Object)entry.toJson());
        }
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static ConditionalCuratedVersionPartsExtractorCollection fromYaml(List<Object> yaml) {
        ConditionalCuratedVersionPartsExtractorCollection matcher = new ConditionalCuratedVersionPartsExtractorCollection();
        if (yaml == null || yaml.isEmpty()) {
            return matcher;
        }
        for (Object entry : yaml) {
            if (entry instanceof Map) {
                try {
                    matcher.getEntries().add(ConditionalCuratedVersionPartsExtractor.fromYaml((Map)entry));
                }
                catch (Exception e) {
                    LOG.error("Error while parsing curated version extractor entry: " + entry, (Throwable)e);
                }
                continue;
            }
            throw new IllegalArgumentException("Unexpected entry type: " + entry.getClass() + " (" + entry + ")");
        }
        return matcher;
    }

    public static ConditionalCuratedVersionPartsExtractorCollection fromYamlFile(File file) throws IOException {
        ConditionalCuratedVersionPartsExtractorCollection.assertCuratedVersionsFileValid(file);
        List<Object> yamlData = SnakeYamlParser.parseYamlAsList(SnakeYamlParser.createNoTimestampYaml(), file);
        return ConditionalCuratedVersionPartsExtractorCollection.fromYaml(yamlData);
    }

    public static List<ConditionalCuratedVersionPartsExtractor> findExtractors(String version, VersionContext context) {
        ArrayList<ConditionalCuratedVersionPartsExtractor> results = new ArrayList<ConditionalCuratedVersionPartsExtractor>();
        for (ConditionalCuratedVersionPartsExtractorCollection matcher : GLOBAL_NATIVE_MATCHERS.values()) {
            results.addAll(matcher.getMatchingExtractors(version, context));
        }
        return results;
    }

    public static Optional<ConditionalCuratedVersionPartsExtractor> findFirstExtractor(String version, VersionContext context) {
        for (ConditionalCuratedVersionPartsExtractorCollection matcher : GLOBAL_NATIVE_MATCHERS.values()) {
            List<ConditionalCuratedVersionPartsExtractor> matchingExtractors = matcher.getMatchingExtractors(version, context);
            if (matchingExtractors.isEmpty()) continue;
            return Optional.of(matchingExtractors.get(0));
        }
        return Optional.empty();
    }

    public static void assertCuratedVersionsFileValid(File file) {
        JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/curated-versions-matching.json", SpecVersion.VersionFlag.V201909, "Curated versions Matching", CentralSecurityPolicyConfiguration.JSON_SCHEMA_VALIDATION_ERRORS_DEFAULT);
    }

    public static void registerGlobalMatcher(String name, ConditionalCuratedVersionPartsExtractorCollection matcher) {
        GLOBAL_NATIVE_MATCHERS.put(name, matcher);
    }

    public static void registerGlobalMatcher(File file) {
        if (file.isDirectory()) {
            for (File child : Objects.requireNonNull(file.listFiles())) {
                ConditionalCuratedVersionPartsExtractorCollection.registerGlobalMatcher(child);
            }
            return;
        }
        try {
            ConditionalCuratedVersionPartsExtractorCollection matcher = ConditionalCuratedVersionPartsExtractorCollection.fromYamlFile(file);
            ConditionalCuratedVersionPartsExtractorCollection.registerGlobalMatcher(file.getAbsolutePath(), matcher);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load curated version matcher from file: " + file.getAbsolutePath(), e);
        }
    }

    public static void unregisterGlobalMatcher(String name) {
        if (GLOBAL_NATIVE_MATCHERS.remove(name) != null) {
            LOG.warn("Unregistered the global matcher [{}]", (Object)name);
        }
    }

    public static void unregisterGlobalMatcher(File file) {
        ConditionalCuratedVersionPartsExtractorCollection.unregisterGlobalMatcher(file.getAbsolutePath());
    }

    public static Optional<ExtractedCuratedVersionParts> applyFirstStep(Optional<ConditionalCuratedVersionPartsExtractor> extractor, String version, VersionContext context) {
        if (extractor == null || !extractor.isPresent()) {
            return Optional.empty();
        }
        ExtractedCuratedVersionParts result = extractor.get().applyFirstStep(version, context);
        return Optional.ofNullable(result);
    }

    private static InputStream getFileFromResourceAsStream(String filename) {
        return Dashboard.class.getClassLoader().getResourceAsStream(filename);
    }

    static {
        InputStream stream = ConditionalCuratedVersionPartsExtractorCollection.getFileFromResourceAsStream("enrichment/version/curated-versions.yaml");
        List<Object> yamlData = SnakeYamlParser.parseYamlAsList(SnakeYamlParser.createNoTimestampYaml(), stream);
        ConditionalCuratedVersionPartsExtractorCollection matcher = ConditionalCuratedVersionPartsExtractorCollection.fromYaml(yamlData);
        ConditionalCuratedVersionPartsExtractorCollection.registerGlobalMatcher("resources-curated-versions", matcher);
    }
}

