/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import us.springett.parsers.cpe.Cpe;

public class VersionContext {
    private final Collection<String> vulnerabilities;
    private final Collection<String> eolIds;
    private final Collection<String> ghsaProducts;
    private final Collection<Cpe> cpes;
    private final Collection<Artifact> artifacts;
    public static final VersionContext EMPTY = new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public VersionContext(Collection<String> vulnerabilities, Collection<String> eolIds, Collection<String> ghsaProducts, Collection<Cpe> cpes, Collection<Artifact> artifacts) {
        this.vulnerabilities = vulnerabilities;
        this.eolIds = eolIds;
        this.ghsaProducts = ghsaProducts;
        this.cpes = cpes;
        this.artifacts = artifacts;
    }

    public Collection<String> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public Collection<String> getEolIds() {
        return this.eolIds;
    }

    public Collection<String> getGhsaProducts() {
        return this.ghsaProducts;
    }

    public Collection<Cpe> getCpes() {
        return this.cpes;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.vulnerabilities != null && !this.vulnerabilities.isEmpty()) {
            jsonObject.put("vulnerabilities", this.vulnerabilities);
        }
        if (this.cpes != null && !this.cpes.isEmpty()) {
            jsonObject.put("cpes", (Object)CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(this.cpes));
        }
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            jsonObject.put("artifacts", (Collection)this.artifacts.stream().map(Artifact::getId).collect(Collectors.toList()));
        }
        if (this.eolIds != null && !this.eolIds.isEmpty()) {
            jsonObject.put("eolIds", this.eolIds);
        }
        if (this.ghsaProducts != null && !this.ghsaProducts.isEmpty()) {
            jsonObject.put("ghsaProducts", this.ghsaProducts);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static VersionContext fromVulnerability(String vulnerability) {
        return new VersionContext(Collections.singleton(vulnerability), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static VersionContext fromEolId(String eolId) {
        return new VersionContext(Collections.emptyList(), Collections.singleton(eolId), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static VersionContext fromCpe(Cpe cpe) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), cpe == null ? Collections.emptyList() : Collections.singleton(cpe), Collections.emptyList());
    }

    public static VersionContext fromArtifact(Artifact artifact) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), artifact == null ? Collections.emptyList() : Collections.singleton(artifact));
    }

    public static VersionContext fromGhsaProduct(String ghsaProduct) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), ghsaProduct == null ? Collections.emptyList() : Collections.singleton(ghsaProduct), Collections.emptyList(), Collections.emptyList());
    }

    public static VersionContext fromVulnerabilities(Collection<String> vulnerabilities) {
        return new VersionContext(vulnerabilities, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static VersionContext fromCpes(Collection<Cpe> cpes) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), cpes, Collections.emptyList());
    }

    public static VersionContext fromArtifacts(Collection<Artifact> artifacts) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), artifacts);
    }

    public static VersionContext fromArtifactAndCpe(Artifact artifact, Cpe cpe) {
        return new VersionContext(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singleton(cpe), Collections.singleton(artifact));
    }
}

