/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation.functions;

import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunction;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CuratedVersionFunctionSegmentsCount
extends CuratedVersionFunction {
    private final int segments;
    private final String delimiter;
    private final String expandValue;
    private final boolean reduce;
    private final boolean expand;

    protected CuratedVersionFunctionSegmentsCount(LinkedHashMap<String, Object> yaml) {
        super(yaml);
        this.segments = this.getIntPropertyOrThrow(yaml, "segments");
        this.delimiter = this.getStringProperty(yaml, "delimiter", ".");
        this.expandValue = this.getStringProperty(yaml, "expandValue", "0");
        this.reduce = this.getBooleanProperty(yaml, "reduce", false);
        this.expand = this.getBooleanProperty(yaml, "expand", true);
    }

    @Override
    protected VersionToken applyToPart(VersionToken token) {
        if (token == null) {
            return null;
        }
        if (token.isDateNumberOrSemver()) {
            String initialValue = token.getValue();
            List segments = Arrays.stream(initialValue.split(Pattern.quote(this.delimiter))).collect(Collectors.toList());
            if (segments.size() == this.segments) {
                return token;
            }
            if (segments.size() > this.segments) {
                if (this.reduce) {
                    String reducedValue = String.join((CharSequence)this.delimiter, segments.subList(0, this.segments));
                    return new VersionToken(reducedValue, VersionTokenType.NUMBER_OR_SEMVER);
                }
                return token;
            }
            if (this.expand) {
                while (segments.size() < this.segments) {
                    segments.add(this.expandValue);
                }
                return new VersionToken(String.join((CharSequence)this.delimiter, segments), VersionTokenType.NUMBER_OR_SEMVER);
            }
            return token;
        }
        return token;
    }
}

